/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.AppManagementBaseFactory;
import com.ibm.websphere.management.application.AppManagementHelper;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskInfo;
import com.ibm.websphere.management.application.client.RedeploymentController;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.DefaultTaskProvider;
import com.ibm.ws.management.application.ExtensionHelper;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.client.EJBBindingFileHelper;
import com.ibm.ws.management.application.client.FinderQueryForCMP1XHelper;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeploymentController;
import com.ibm.ws.management.bla.util.UtilHelper;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class AppManagementFactory
extends AppManagementBaseFactory {
    private static TraceComponent tc = Tr.register(AppManagementFactory.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");

    public static AppDeploymentController readArchive(String ear, Hashtable preferences) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readArchive");
        }
        AppDeploymentController ctrl = AppManagementFactory.readArchive(ear, preferences, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readArchive");
        }
        return ctrl;
    }

    public static AppDeploymentController readArchive(String ear, Hashtable preferences, Vector taskI) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readArchive");
        }
        if (AppManagementHelper.isSystemAppV6(ear) || AppUtils.isSystemAppOption(preferences) || AppUtils.isSkipPrepOption(preferences)) {
            return null;
        }
        AppDeploymentInfo info = AppInstallHelper.getAppDeploymentInfo(ear, preferences);
        Vector taskInfo = AppManagementFactory.collectInstallTaskInfo(info, preferences, true);
        AppDeploymentController ctrl = null;
        ctrl = preferences.get("jsr88") == null ? new AppDeploymentController(info, preferences, taskInfo) : new J2EEDeploymentController(info, preferences, taskInfo);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readArchive");
        }
        return ctrl;
    }

    private static Vector collectInstallTaskInfo(AppDeploymentInfo info, Hashtable preferences, boolean bCreate) throws AppDeploymentException {
        Vector<AppDeploymentTaskInfo> taskInfo;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "collectInstallTaskInfo");
            }
            taskInfo = new Vector<AppDeploymentTaskInfo>();
            DefaultTaskProvider taskprovider = new DefaultTaskProvider();
            if (bCreate) {
                taskprovider.provideClientDeploymentTasks(taskInfo, info, preferences);
            } else {
                taskprovider.provideClientDeploymentTasksForEdit(taskInfo, info, preferences);
            }
            if (preferences.get("jsr88") != null) {
                AppDeploymentTaskInfo tInfo = new AppDeploymentTaskInfo("FinderQueryForCMP1X", new FinderQueryForCMP1XHelper(), null);
                taskInfo.addElement(tInfo);
                tInfo = new AppDeploymentTaskInfo("EJBBindingFile", new EJBBindingFileHelper(), null);
                taskInfo.addElement(tInfo);
            }
            if (preferences.get("configservice") == null) {
                if (AdminServiceFactory.getAdminService() != null && ConfigServiceFactory.getConfigService() != null) {
                    preferences.put("configservice", ConfigServiceFactory.getConfigService());
                } else if (preferences.get("adminclient") != null) {
                    try {
                        ConfigServiceProxy cs = new ConfigServiceProxy((AdminClient)preferences.get("adminclient"));
                        preferences.put("configservice", cs);
                    }
                    catch (Throwable th) {
                        if (!tc.isDebugEnabled()) break block11;
                        Tr.debug(tc, "Exception creating config service: " + th);
                    }
                }
            }
        }
        ExtensionHelper.processClientInstallExtensions(info, preferences, taskInfo, bCreate);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "collectInstallTaskInfo");
        }
        return taskInfo;
    }

    public static AppDeploymentController readPartialArchive(EARFile earFile, Hashtable prefs) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readPartialArchive");
        }
        AppDeploymentInfo info = AppInstallHelper.getPartialDeploymentInfo(earFile, prefs);
        Vector taskInfo = AppManagementFactory.collectInstallTaskInfo(info, prefs, false);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The task info has: " + taskInfo.size() + " tasks.");
        }
        AppDeploymentController ctrl = new AppDeploymentController(info, prefs, taskInfo);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Created AppDeploymentController: " + ctrl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readPartialArchive");
        }
        return ctrl;
    }

    public static AppDeploymentController readTasks(Vector tasks, Hashtable prefs, String uniqueModuleURI) throws AppDeploymentException {
        Hashtable<String, String> myPrefs;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readTasks");
        }
        if ((myPrefs = prefs) == null) {
            myPrefs = new Hashtable<String, String>();
        }
        if (uniqueModuleURI == null) {
            myPrefs.put("EditAppOnly", "");
        } else {
            myPrefs.put("EditModuleOnly", uniqueModuleURI);
        }
        Vector taskInfo = AppManagementFactory.getTaskInfoForTasks(tasks, myPrefs, null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Got " + taskInfo.size() + " taskInfo objectes for " + tasks.size() + " tasks.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The final set of taskInfo: " + taskInfo);
        }
        AppDeploymentController ctrl = new AppDeploymentController(tasks, taskInfo, myPrefs);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readTasks");
        }
        return ctrl;
    }

    public static AppDeploymentController writeTasks(EARFile earFile, Vector tasks, Hashtable prefs, String uniqueModuleURI) throws AppDeploymentException {
        Hashtable<String, String> myPrefs;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeTasks");
        }
        if ((myPrefs = prefs) == null) {
            myPrefs = new Hashtable<String, String>();
        }
        if (uniqueModuleURI == null) {
            myPrefs.put("EditAppOnly", "");
        } else {
            myPrefs.put("EditModuleOnly", uniqueModuleURI);
        }
        AppDeploymentInfo info = null;
        try {
            info = AppInstallHelper.getPartialDeploymentInfo(earFile, myPrefs);
        }
        catch (Throwable ex) {
            if (ex instanceof AppDeploymentException) {
                throw (AppDeploymentException)ex;
            }
            throw new AppDeploymentException(AppUtils.getMessage(AppUtils.getBundle(prefs), "ADMA0065E", new Object[]{earFile}), ex);
        }
        Vector taskInfo = AppManagementFactory.getTaskInfoForTasks(tasks, myPrefs, info);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Got " + taskInfo.size() + " taskInfo objectes for " + tasks.size() + " tasks.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The final set of taskInfo: " + taskInfo);
        }
        AppDeploymentController ctrl = new AppDeploymentController(info, tasks, myPrefs, taskInfo);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeTasks");
        }
        return ctrl;
    }

    private static Vector getTaskInfoForTasks(Vector tasks, Hashtable prefs, AppDeploymentInfo info) throws AppDeploymentException {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTaskInfoForTask");
        }
        Hashtable tbl = new Hashtable();
        ExtensionHelper.processTaskInfoToTaskMapping(tasks, tbl);
        Vector defaultInfo = new Vector();
        DefaultTaskProvider taskprovider = new DefaultTaskProvider();
        taskprovider.provideClientDeploymentTasksForEdit(defaultInfo, info, prefs);
        Vector<Object> taskInfo = new Vector<Object>();
        Vector<AppDeploymentTask> removeList = new Vector<AppDeploymentTask>();
        for (i = 0; i < tasks.size(); ++i) {
            AppDeploymentTask task = (AppDeploymentTask)tasks.elementAt(i);
            if (tbl.get(task) != null) {
                taskInfo.add(tbl.get(task));
                continue;
            }
            AppDeploymentTaskInfo ti = AppManagementFactory.getDefaultTaskInfoForTask(task, defaultInfo, prefs);
            if (ti != null) {
                taskInfo.add(ti);
                continue;
            }
            Tr.warning(tc, AppUtils.getMessage(AppUtils.getBundle(prefs), "ADMA0079W", new Object[]{task.getName()}));
            removeList.addElement(task);
        }
        for (i = 0; i < removeList.size(); ++i) {
            tasks.remove(removeList.elementAt(i));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTaskInfoForTask");
        }
        return taskInfo;
    }

    private static AppDeploymentTaskInfo getDefaultTaskInfoForTask(AppDeploymentTask task, Vector defInfo, Hashtable prefs) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultTaskInfoForTask: " + task);
        }
        for (int i = 0; i < defInfo.size(); ++i) {
            AppDeploymentTaskInfo info = (AppDeploymentTaskInfo)defInfo.elementAt(i);
            if (!info.name.equals(task.getName())) continue;
            return info;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning a null TaskInfo");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultTaskInfoForTask: " + task);
        }
        return null;
    }

    public static AppDeploymentController readArchiveForRedeployment(String ear, Hashtable preferences, Vector oldAppTasks) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readArchiveForRedeployment");
        }
        preferences.put("contenttype", "app");
        AppDeploymentController ctrl = AppManagementFactory.readArchiveForUpdate(ear, null, "update", preferences, oldAppTasks);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readArchiveForRedeployment");
        }
        return ctrl;
    }

    public static AppDeploymentController readArchiveForUpdate(String ear, String moduleURI, String op, Hashtable preferences, Vector oldAppTasks) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readArchiveForUpdate");
        }
        if (preferences == null) {
            return null;
        }
        String cType = (String)preferences.get("contenttype");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cType: " + cType);
        }
        if (!"modulefile".equals(cType) && !"app".equals(cType)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Only app or modulefile can return a controller");
            }
            return null;
        }
        if (!("add".equals(op) || "addupdate".equals(op) || "update".equals(op))) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Invalid op: " + op + " for update");
            }
            return null;
        }
        AppDeploymentInfo info = AppInstallHelper.getAppDeploymentInfoForUpdate(ear, moduleURI, preferences, cType.equals("app"));
        Vector taskInfo = AppManagementFactory.collectInstallTaskInfo(info, preferences, true);
        AppDeploymentController ctrl = null;
        if (oldAppTasks == null || preferences.get("redeploy.ignore.old") != null || "add".equals(op)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "old tasks null or op=add so treat this like install");
            }
            ctrl = new AppDeploymentController(info, preferences, taskInfo);
        } else {
            Vector<AppDeploymentTask> tasksWOBindings = null;
            if (preferences.get("usedefaultbindings") != null && preferences.get("redeploy.ignore.new") == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Need to get tasks before dfltbndg.... 3-way");
                }
                Object dfltbndg = preferences.get("usedefaultbindings");
                preferences.remove("usedefaultbindings");
                Vector cp = new Vector(taskInfo);
                AppDeploymentController c = new AppDeploymentController(info, preferences, cp);
                tasksWOBindings = new Vector<AppDeploymentTask>();
                AppDeploymentTask task = c.getFirstTask();
                while (task != null) {
                    tasksWOBindings.addElement(task);
                    task = c.getNextTask();
                }
                if (dfltbndg != null) {
                    preferences.put("usedefaultbindings", dfltbndg);
                }
            }
            ctrl = new RedeploymentController(info, preferences, taskInfo, oldAppTasks, tasksWOBindings);
        }
        String cRoot = (String)preferences.get("contextroot");
        if (cRoot != null) {
            ctrl.getAppOptions().put("contextroot", cRoot);
        }
        ctrl.getAppOptions().put("contenttype", cType);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding to cType and cRoot to options:" + cType + " , " + cRoot);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readArchiveForUpdate");
        }
        return ctrl;
    }

    public static AppDeploymentController readArchive(String assetID, String workspaceID, Hashtable preferences) throws AppDeploymentException {
        String earPath;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readArchive", new Object[]{assetID, workspaceID, preferences});
        }
        if ((earPath = AppInstallHelper.copyAsset(assetID, workspaceID)).endsWith(".war") || earPath.endsWith(".jar") || earPath.endsWith(".rar")) {
            try {
                String tempPath;
                File file;
                ObjectName on = UtilHelper.completeObjectName(assetID, "assetname");
                String moduleName = on.getKeyProperty("assetname");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "moduleName: " + moduleName);
                }
                if ((file = new File(tempPath = AppUtils.getTempDir() + moduleName.substring(0, moduleName.lastIndexOf(".")) + ".ear")).exists()) {
                    file.delete();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "tempPath: " + tempPath);
                }
                earPath = AppInstallHelper.createEarWrapper(earPath, tempPath, moduleName, "/" + moduleName);
            }
            catch (MalformedObjectNameException mone) {
                throw new AppDeploymentException(null, mone);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "final earPath: " + earPath);
        }
        AppDeploymentController ctrl = AppManagementFactory.readArchive(earPath, preferences);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readArchive");
        }
        return ctrl;
    }
}

