/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trl.util.xml;

import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ErrorHandlerImpl
implements ErrorHandler {
    int errorCount = 0;

    ErrorHandlerImpl() {
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void warning(SAXParseException ex) {
        System.err.println("[Warning] " + this.getLocationString(ex) + ": " + ex.getMessage());
    }

    public void error(SAXParseException ex) {
        System.err.println("[Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
        ++this.errorCount;
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        System.err.println("[Fatal Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
        ++this.errorCount;
        throw ex;
    }

    private String getLocationString(SAXParseException ex) {
        StringBuffer str = new StringBuffer();
        String systemId = ex.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            str.append(systemId);
        }
        str.append(':');
        str.append(ex.getLineNumber());
        str.append(':');
        str.append(ex.getColumnNumber());
        return str.toString();
    }
}

