/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trl.soapimpl;

import com.ibm.trl.util.xml.DOMConverter;
import com.ibm.trl.util.xml.DOMHandler;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.NoSuchElementException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ObjectStore {
    public static final String ELEM_JOBJ = "JavaObject";
    public static final String NS_PREFIX_JOBJ = "jobj";
    public static final String NS_URI_JOBJ = "urn:trl-soap:JavaObject";
    public static final String ENC_STYLE_JOBJ = "urn:trl-soap:SerializedJavaObject";
    private Object lock = new Object();
    private Element objectStore = null;
    private Object cache = null;

    public ObjectStore(Document factory, Object object) throws IOException {
        this.storeObject(factory, object);
    }

    public ObjectStore(Element objectStore) throws NoSuchElementException {
        this.objectStore = objectStore;
        this.checkObjectStore(objectStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeObject(Document fac, Object object) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.writeObject(object);
        out.flush();
        Element elem = fac.createElementNS(NS_URI_JOBJ, "jobj:JavaObject");
        elem.setAttribute("xmlns:jobj", NS_URI_JOBJ);
        elem.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV:encodingStyle", ENC_STYLE_JOBJ);
        elem.appendChild(fac.createTextNode(Base64.encode((byte[])bout.toByteArray())));
        Object object2 = this.lock;
        synchronized (object2) {
            this.objectStore = elem;
            this.cache = object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object loadObject() throws ClassNotFoundException {
        if (this.cache != null) {
            return this.cache;
        }
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            ObjectInputStream in = null;
            try {
                in = new ObjectInputStream(new ByteArrayInputStream(Base64.decode((String)DOMHandler.getNodeValue(this.objectStore))));
                Object object3 = in.readObject();
                if (object3 instanceof Throwable) {
                    ((Throwable)object3).fillInStackTrace();
                }
                object2 = this.cache = object3;
            }
            catch (IOException e) {
                throw new UnknownError(e.getMessage());
            }
            return object2;
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    private void checkObjectStore(Element objectStore) throws NoSuchElementException {
        if (objectStore == null) {
            throw new NoSuchElementException("ObjectStore is null");
        }
        if (!NS_URI_JOBJ.equals(objectStore.getNamespaceURI()) || !ELEM_JOBJ.equals(objectStore.getLocalName())) {
            throw new NoSuchElementException("Unexpected element: " + DOMConverter.toString(objectStore));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getElement() {
        Element element = this.objectStore;
        synchronized (element) {
            return this.objectStore;
        }
    }
}

