/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trl.soapimpl;

import com.ibm.trl.soap.SOAPException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Stack;

public final class EnvelopeWriter
extends PrintWriter {
    private static final int E_ENVELOPE = 0;
    private static final int E_HEADER = 1;
    private static final int E_BODY = 2;
    private static final Integer[] INTEGERS = new Integer[]{new Integer(0), new Integer(1), new Integer(2)};
    private static final String[] QNAMES = new String[]{"SOAP-ENV:Envelope", "SOAP-ENV:Header", "SOAP-ENV:Body"};
    private static final String[] NAMESPACES = new String[]{" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/1999/XMLSchema/\" xmlns:xsi=\"http://www.w3.org/1999/XMLSchema/instance/\"", "", ""};
    private boolean dirty = false;
    private Stack stack = new Stack();

    public EnvelopeWriter(Writer out) {
        super(out);
    }

    public EnvelopeWriter(Writer out, boolean auto) {
        super(out, auto);
    }

    public EnvelopeWriter(OutputStream out) {
        super(out);
    }

    public EnvelopeWriter(OutputStream out, boolean auto) {
        super(out, auto);
    }

    public void startEnvelope() {
        if (this.dirty) {
            throw new UnknownError("startEnvelope() should be called first");
        }
        this.stack.push(new Integer(0));
    }

    public void startHeader() {
        if (this.dirty) {
            this.dirty = false;
        } else {
            this.delayedStartTag();
        }
        this.stack.push(new Integer(1));
    }

    public void startBody() {
        if (this.dirty) {
            this.dirty = false;
        } else {
            this.delayedStartTag();
        }
        this.stack.push(new Integer(2));
    }

    public void endTag() throws SOAPException {
        if (this.stack.size() == 0) {
            throw new SOAPException("No more unclosed tag");
        }
        int type = -1;
        type = (Integer)this.stack.pop();
        switch (type) {
            case 0: 
            case 1: 
            case 2: {
                super.print(this.dirty ? "</" + QNAMES[type] + '>' : '<' + QNAMES[type] + NAMESPACES[type] + "/>");
                break;
            }
            default: {
                throw new SOAPException("Unexpected type: " + type);
            }
        }
    }

    private void delayedStartTag() {
        int type = -1;
        type = (Integer)this.stack.peek();
        switch (type) {
            case 0: 
            case 1: 
            case 2: {
                String value = "<" + QNAMES[type] + NAMESPACES[type] + '>';
                super.write(value, 0, value.length());
                break;
            }
            default: {
                throw new UnknownError("Unexpected type: " + type);
            }
        }
    }

    public void write(int value) {
        if (!this.dirty) {
            this.delayedStartTag();
            this.dirty = true;
        }
        super.write(value);
    }

    public void write(char[] value, int offset, int length) {
        if (!this.dirty) {
            this.delayedStartTag();
            this.dirty = true;
        }
        super.write(value, offset, length);
    }

    public void write(String value, int offset, int length) {
        if (!this.dirty) {
            this.delayedStartTag();
            this.dirty = true;
        }
        super.write(value, offset, length);
    }
}

