/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse.attributes;

import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.attributes.AttrInfo;
import com.ibm.toad.cfparse.utils.CPUtils;
import com.ibm.toad.cfparse.utils.DataIOUtils;
import com.ibm.toad.utils.D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;

public final class LocalVariableAttrInfo
extends AttrInfo {
    private int d_numVars;
    private int[] d_varTable;

    LocalVariableAttrInfo(ConstantPool constantPool, int n, int n2) {
        super(constantPool, n, n2);
    }

    protected void sort(int[] nArray) {
        super.sort(nArray);
        for (int i = 0; i < this.d_varTable.length; ++i) {
            if (i % 5 != 2 && i % 5 != 3) continue;
            this.d_varTable[i] = nArray[this.d_varTable[i]];
        }
    }

    protected BitSet uses() {
        BitSet bitSet = super.uses();
        for (int i = 0; i < this.d_varTable.length; ++i) {
            if (i % 5 != 2 && i % 5 != 3) continue;
            bitSet.set(this.d_varTable[i]);
        }
        return bitSet;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.d_len = DataIOUtils.readUnsignedIntAsInt(dataInputStream);
        this.d_numVars = dataInputStream.readUnsignedShort();
        D.azzert(this.d_len == 2 + this.d_numVars * 10, "d_len != 2 + (d_numVars * 10)\n" + this.d_len + " != 2 + (" + this.d_numVars + "* 10)\n");
        this.d_varTable = new int[this.d_numVars * 5];
        for (int i = 0; i < this.d_varTable.length; ++i) {
            this.d_varTable[i] = dataInputStream.readUnsignedShort();
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.d_idxName);
        DataIOUtils.writeUnsignedInt(dataOutputStream, this.d_len);
        dataOutputStream.writeShort(this.d_numVars);
        for (int i = 0; i < this.d_varTable.length; ++i) {
            dataOutputStream.writeShort(this.d_varTable[i]);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.sindent() + "Attribute: " + this.d_cp.getAsString(this.d_idxName) + ": \n");
        int n = 0;
        while (n < this.d_varTable.length) {
            int n2 = this.d_varTable[n++];
            int n3 = this.d_varTable[n++];
            int n4 = this.d_varTable[n++];
            int n5 = this.d_varTable[n++];
            int n6 = this.d_varTable[n++];
            String string = CPUtils.internal2java(this.d_cp.getAsString(n5));
            stringBuffer.append(this.sindent() + "  " + string + " " + this.d_cp.getAsString(n4) + " pc=" + n2 + " length=" + n3 + " slot=" + n6 + "\n");
        }
        return stringBuffer.toString();
    }

    public int length() {
        return this.d_numVars;
    }

    public int getStartPC(int n) {
        if (n < 0 || n >= this.d_numVars) {
            return -1;
        }
        int n2 = this.d_varTable[5 * n];
        return n2;
    }

    public int getEndPC(int n) {
        if (n < 0 || n >= this.d_numVars) {
            return -1;
        }
        int n2 = this.d_varTable[5 * n];
        int n3 = this.d_varTable[5 * n + 1];
        return n2 + n3;
    }

    public String getVarType(int n) {
        if (n < 0 || n >= this.d_numVars) {
            return "";
        }
        int n2 = this.d_varTable[5 * n + 3];
        return CPUtils.internal2java(this.d_cp.getAsString(n2));
    }

    public String getVarName(int n) {
        if (n < 0 || n >= this.d_numVars) {
            return "";
        }
        int n2 = this.d_varTable[5 * n + 2];
        return this.d_cp.getAsString(n2);
    }

    public int getVarNum(int n) {
        if (n < 0 || n >= this.d_numVars) {
            return -1;
        }
        int n2 = this.d_varTable[5 * n + 4];
        return n2;
    }
}

