/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse;

import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.MethodInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;

public final class MethodInfoList {
    private ConstantPool d_cp;
    private int d_numMethods;
    private MethodInfo[] d_methods;

    MethodInfoList(ConstantPool constantPool) {
        this.d_cp = constantPool;
        this.d_numMethods = 0;
        this.d_methods = null;
    }

    public void sort(int[] nArray) {
        for (int i = 0; i < this.d_numMethods; ++i) {
            this.d_methods[i].sort(nArray);
        }
    }

    public BitSet uses() {
        BitSet bitSet = new BitSet(this.d_cp.length());
        for (int i = 0; i < this.d_numMethods; ++i) {
            bitSet.or(this.d_methods[i].uses());
        }
        return bitSet;
    }

    void read(DataInputStream dataInputStream) throws IOException {
        this.d_numMethods = dataInputStream.readUnsignedShort();
        this.d_methods = new MethodInfo[this.d_numMethods];
        for (int i = 0; i < this.d_numMethods; ++i) {
            this.d_methods[i] = new MethodInfo(this.d_cp);
            this.d_methods[i].read(dataInputStream);
        }
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.d_numMethods);
        for (int i = 0; i < this.d_numMethods; ++i) {
            this.d_methods[i].write(dataOutputStream);
        }
    }

    private void resize() {
        MethodInfo[] methodInfoArray = new MethodInfo[this.d_numMethods + 10];
        if (this.d_methods != null) {
            System.arraycopy(this.d_methods, 0, methodInfoArray, 0, this.d_numMethods);
        }
        this.d_methods = methodInfoArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("METHODS:\n");
        if (this.d_numMethods == 0) {
            stringBuffer.append("  <none>\n");
        } else {
            for (int i = 0; i < this.d_numMethods; ++i) {
                stringBuffer.append("  " + this.d_methods[i]);
            }
        }
        return stringBuffer.toString();
    }

    public int length() {
        return this.d_numMethods;
    }

    public String getMethodName(int n) {
        if (n < 0 || n > this.d_numMethods) {
            return null;
        }
        return this.d_methods[n].getName();
    }

    public MethodInfo get(int n) {
        return this.d_methods[n];
    }

    public void remove(int n) {
        if (n < 0 || n > this.d_numMethods - 1) {
            return;
        }
        for (int i = n; i < this.d_numMethods - 1; ++i) {
            this.d_methods[i] = this.d_methods[i + 1];
        }
        --this.d_numMethods;
    }

    public MethodInfo add(String string) {
        if (this.d_methods == null || this.d_numMethods == this.d_methods.length) {
            this.resize();
        }
        this.d_methods[this.d_numMethods] = new MethodInfo(this.d_cp, string);
        ++this.d_numMethods;
        return this.d_methods[this.d_numMethods - 1];
    }
}

