/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.commonarchive.impl;

import com.ibm.ejs.models.base.bindings.ejbbnd.EJBBindingsHelper;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.dsextensions.DataSourceExtensionsEJBHelper;
import com.ibm.ejs.models.base.dsextensions.DataSourceExtensionsType;
import com.ibm.ejs.models.base.extensions.ejbext.EJBJarExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EjbExtensionsHelper;
import com.ibm.etools.commonarchive.CommonarchivePackage;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.util.FinderHelperMetaDataConverter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.BindingType;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DeploymentDescriptorLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.ejb.EJBJar;

public class EJBJarFileImpl
extends org.eclipse.jst.j2ee.commonarchivecore.internal.impl.EJBJarFileImpl
implements EJBJarFile {
    public static final String className = EJBJarFileImpl.class.getName();
    public static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    private static boolean _useContextClassLoaderAsDefault = true;
    protected EJBJarBinding bindings = null;
    protected EJBJarExtension extensions = null;
    protected DataSourceExtensionsType dsExtensions = null;

    protected void checkAddValid(String aUri) throws DuplicateObjectException {
        String methodName = "checkAddValid";
        super.checkAddValid(aUri);
        if (File.separatorChar == '\\') {
            aUri = aUri.replace('\\', '/');
        }
        if (aUri.equals(this.getBindingsUri())) {
            if (this.clearBindings()) {
                logger.logp(Level.FINER, className, methodName, "Cleared bindings [ {0} ]", aUri);
            }
        } else if (aUri.equals(this.getExtensionsUri())) {
            if (this.clearExtensions()) {
                logger.logp(Level.FINER, className, methodName, "Cleared extensions [ {0} ]", aUri);
            }
        } else if (aUri.equals(this.getWebServicesClientBindingsUri())) {
            if (this.clearWebServicesClientBindings()) {
                logger.logp(Level.FINER, className, methodName, "Cleared webservices client bindings [ {0} ]", aUri);
            }
        } else if (aUri.equals(this.getWebServicesClientExtensionsUri()) && this.clearWebServicesClientExtensions()) {
            logger.logp(Level.FINER, className, methodName, "Cleared webservices client extensions [ {0} ]", aUri);
        }
    }

    public boolean clearBindings() {
        boolean result;
        String methodName = "clearBinding";
        logger.logp(Level.FINER, className, methodName, "ENTER");
        EJBJarBinding priorBinding = this.basicClearBindings();
        boolean didDiscardPriorBindings = this.discard(priorBinding);
        Resource priorBindingsResource = this.removeBindingsResource();
        boolean didDiscardPriorBindingsResource = this.discard(priorBindingsResource);
        boolean bl = result = didDiscardPriorBindings || didDiscardPriorBindingsResource;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", new Boolean(result));
        }
        return result;
    }

    public boolean clearExtensions() {
        boolean result;
        String methodName = "clearExtension";
        logger.logp(Level.FINER, className, methodName, "ENTER");
        EJBJarExtension priorExtension = this.basicClearExtensions();
        boolean didDiscardPriorExtensions = this.discard(priorExtension);
        Resource priorExtensionsResource = this.removeExtensionsResource();
        boolean didDiscardPriorExtensionsResource = this.discard(priorExtensionsResource);
        boolean bl = result = didDiscardPriorExtensions || didDiscardPriorExtensionsResource;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", new Boolean(result));
        }
        return result;
    }

    public boolean clearWebServicesClientBindings() {
        String methodName = "clearWebServicesClientBindings";
        logger.logp(Level.FINER, className, methodName, "ENTER");
        Resource priorBindingsResource = this.removeWebServicesClientBindingsResource();
        boolean didDiscardPriorBindingsResource = this.discard(priorBindingsResource);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", new Boolean(didDiscardPriorBindingsResource));
        }
        return didDiscardPriorBindingsResource;
    }

    public boolean clearWebServicesClientExtensions() {
        String methodName = "clearWebServicesClientExtensions";
        logger.logp(Level.FINER, className, methodName, "ENTER");
        Resource priorExtensionsResource = this.removeWebServicesClientExtensionsResource();
        boolean didDiscardPriorExtensionsResource = this.discard(priorExtensionsResource);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", new Boolean(didDiscardPriorExtensionsResource));
        }
        return didDiscardPriorExtensionsResource;
    }

    protected EJBJarBinding basicClearBindings() {
        String methodName = "basicClearBinding";
        EJBJarBinding useBinding = this.basicGetBindings();
        if (useBinding != null) {
            logger.logp(Level.FINER, className, methodName, "Bindings detected; clearing");
            this.setBindingsGen(null);
        } else {
            logger.logp(Level.FINER, className, methodName, "No bindings detected");
        }
        return useBinding;
    }

    protected Resource removeBindingsResource() {
        return this.removeResource(this.getBindingsUri());
    }

    protected EJBJarExtension basicClearExtensions() {
        String methodName = "basicClearExtension";
        EJBJarExtension useExtension = this.basicGetExtensions();
        if (useExtension != null) {
            logger.logp(Level.FINER, className, methodName, "Extensions detected; clearing");
            this.setExtensionsGen(null);
        } else {
            logger.logp(Level.FINER, className, methodName, "No extensions detected");
        }
        return useExtension;
    }

    protected Resource removeExtensionsResource() {
        return this.removeResource(this.getExtensionsUri());
    }

    protected Resource removeWebServicesClientBindingsResource() {
        return this.removeResource(this.getWebServicesClientBindingsUri());
    }

    protected Resource removeWebServicesClientExtensionsResource() {
        return this.removeResource(this.getWebServicesClientExtensionsUri());
    }

    public void preSave(SaveStrategy aStrategy) throws SaveFailureException {
        String methodName = "preSave";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        super.preSave(aStrategy);
        this.setModified(this.getBindingsUri());
        this.setModified(this.getExtensionsUri());
        this.setModified(this.getWebServicesClientBindingsUri());
        this.setModified(this.getWebServicesClientExtensionsUri());
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public String getWebServicesClientBindingsUri() {
        return "META-INF/ibm-webservicesclient-bnd.xmi";
    }

    public String getWebServicesClientExtensionsUri() {
        return "META-INF/ibm-webservicesclient-ext.xmi";
    }

    public static synchronized boolean isUseContextClassLoaderAsDefault() {
        return _useContextClassLoaderAsDefault;
    }

    public static synchronized void setUseContextClassLoaderAsDefault(boolean value) {
        _useContextClassLoaderAsDefault = value;
    }

    protected ClassLoader getDefaultClassLoader() {
        if (EJBJarFileImpl.isUseContextClassLoaderAsDefault()) {
            return Thread.currentThread().getContextClassLoader();
        }
        return super.getDefaultClassLoader();
    }

    protected EJBJarFileImpl() {
    }

    protected EClass eStaticClass() {
        return CommonarchivePackage.eINSTANCE.getEJBJarFile();
    }

    public EJBJarBinding basicGetBindings() {
        return this.bindings;
    }

    public void setBindingsGen(EJBJarBinding newBindings) {
        EJBJarBinding oldBindings = this.bindings;
        this.bindings = newBindings;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldBindings, (Object)this.bindings));
        }
    }

    public EJBJarExtension basicGetExtensions() {
        return this.extensions;
    }

    public void setExtensionsGen(EJBJarExtension newExtensions) {
        EJBJarExtension oldExtensions = this.extensions;
        this.extensions = newExtensions;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldExtensions, (Object)this.extensions));
        }
    }

    public void setExtensions(EJBJarExtension l) {
        this.setExtensionsGen(l);
        this.replaceRoot(this.getMofResourceMakeIfNecessary(this.getExtensionsUri()), l);
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 6: {
                    if (this.eContainer != null) {
                        msgs = this.eBasicRemoveFromContainer(msgs);
                    }
                    return this.eBasicSetContainer(otherEnd, 6, msgs);
                }
                case 7: {
                    return ((InternalEList)this.getFiles()).basicAdd(otherEnd, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 6: {
                    return this.eBasicSetContainer(null, 6, msgs);
                }
                case 7: {
                    return ((InternalEList)this.getFiles()).basicRemove(otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        if (this.eContainerFeatureID >= 0) {
            switch (this.eContainerFeatureID) {
                case 6: {
                    return this.eContainer.eInverseRemove(this, 7, Container.class, msgs);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(msgs);
        }
        return this.eContainer.eInverseRemove(this, -1 - this.eContainerFeatureID, null, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getURI();
            }
            case 1: {
                return new Long(this.getLastModified());
            }
            case 2: {
                return new Long(this.getSize());
            }
            case 3: {
                return this.isDirectoryEntry() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return this.getOriginalURI();
            }
            case 5: {
                if (resolve) {
                    return this.getLoadingContainer();
                }
                return this.basicGetLoadingContainer();
            }
            case 6: {
                return this.getContainer();
            }
            case 7: {
                return this.getFiles();
            }
            case 8: {
                return this.getTypes();
            }
            case 9: {
                if (resolve) {
                    return this.getDeploymentDescriptor();
                }
                return this.basicGetDeploymentDescriptor();
            }
            case 10: {
                if (resolve) {
                    return this.getBindings();
                }
                return this.basicGetBindings();
            }
            case 11: {
                if (resolve) {
                    return this.getExtensions();
                }
                return this.basicGetExtensions();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setURI((String)newValue);
                return;
            }
            case 1: {
                this.setLastModified((Long)newValue);
                return;
            }
            case 2: {
                this.setSize((Long)newValue);
                return;
            }
            case 3: {
                this.setDirectoryEntry((Boolean)newValue);
                return;
            }
            case 4: {
                this.setOriginalURI((String)newValue);
                return;
            }
            case 5: {
                this.setLoadingContainer((Container)newValue);
                return;
            }
            case 6: {
                this.setContainer((Container)newValue);
                return;
            }
            case 7: {
                this.getFiles().clear();
                this.getFiles().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.getTypes().clear();
                this.getTypes().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.setDeploymentDescriptor((EJBJar)newValue);
                return;
            }
            case 10: {
                this.setBindings((EJBJarBinding)newValue);
                return;
            }
            case 11: {
                this.setExtensions((EJBJarExtension)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setURI(URI_EDEFAULT);
                return;
            }
            case 1: {
                this.unsetLastModified();
                return;
            }
            case 2: {
                this.unsetSize();
                return;
            }
            case 3: {
                this.unsetDirectoryEntry();
                return;
            }
            case 4: {
                this.setOriginalURI(ORIGINAL_URI_EDEFAULT);
                return;
            }
            case 5: {
                this.setLoadingContainer(null);
                return;
            }
            case 6: {
                this.setContainer(null);
                return;
            }
            case 7: {
                this.getFiles().clear();
                return;
            }
            case 8: {
                this.getTypes().clear();
                return;
            }
            case 9: {
                this.setDeploymentDescriptor(null);
                return;
            }
            case 10: {
                this.setBindings(null);
                return;
            }
            case 11: {
                this.setExtensions(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return URI_EDEFAULT == null ? this.uri != null : !URI_EDEFAULT.equals(this.uri);
            }
            case 1: {
                return this.isSetLastModified();
            }
            case 2: {
                return this.isSetSize();
            }
            case 3: {
                return this.isSetDirectoryEntry();
            }
            case 4: {
                return ORIGINAL_URI_EDEFAULT == null ? this.originalURI != null : !ORIGINAL_URI_EDEFAULT.equals(this.originalURI);
            }
            case 5: {
                return this.loadingContainer != null;
            }
            case 6: {
                return this.getContainer() != null;
            }
            case 7: {
                return this.files != null && !this.files.isEmpty();
            }
            case 8: {
                return this.types != null && !this.types.isEmpty();
            }
            case 9: {
                return this.deploymentDescriptor != null;
            }
            case 10: {
                return this.bindings != null;
            }
            case 11: {
                return this.extensions != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public EJBJarBinding getBindings() throws ResourceLoadException, DeploymentDescriptorLoadException {
        EJBJarBinding theBindings = this.bindings;
        try {
            if (theBindings == null && this.getDeploymentDescriptor() != null) {
                this.setBindings(EJBBindingsHelper.getEJBJarBinding(this.getDeploymentDescriptor()));
            }
        }
        catch (DeploymentDescriptorLoadException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwResourceLoadException(this.getBindingsUri(), e);
        }
        return this.bindings;
    }

    public String getBindingsUri() {
        int version;
        if (this.isModuleVersionSet()) {
            version = this.getModuleVersion();
        } else {
            EJBJar ejbJar = this.getDeploymentDescriptor();
            version = ejbJar.getJ2EEVersionID();
        }
        if (version >= 30) {
            return "META-INF/ibm-ejb-jar-bnd.xml";
        }
        return "META-INF/ibm-ejb-jar-bnd.xmi";
    }

    public EJBJarExtension getExtensions() throws ResourceLoadException, DeploymentDescriptorLoadException {
        EJBJarExtension theExtensions = this.extensions;
        try {
            if (theExtensions == null && this.getDeploymentDescriptor() != null) {
                this.setExtensions(EjbExtensionsHelper.getEJBJarExtension(this.getDeploymentDescriptor()));
            }
        }
        catch (DeploymentDescriptorLoadException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwResourceLoadException(this.getExtensionsUri(), e);
        }
        return this.extensions;
    }

    public String getExtensionsUri() {
        int version;
        if (this.isModuleVersionSet()) {
            version = this.getModuleVersion();
        } else {
            EJBJar ejbJar = this.getDeploymentDescriptor();
            version = ejbJar.getJ2EEVersionID();
        }
        if (version >= 30) {
            return "META-INF/ibm-ejb-jar-ext.xml";
        }
        return "META-INF/ibm-ejb-jar-ext.xmi";
    }

    public EObject getStandardBindings() throws ResourceLoadException {
        return this.getBindings();
    }

    public EObject getStandardExtensions() throws ResourceLoadException {
        return this.getExtensions();
    }

    public void setBindings(EJBJarBinding l) {
        this.setBindingsGen(l);
        this.replaceRoot(this.getMofResourceMakeIfNecessary(this.getBindingsUri()), l);
    }

    public EList getExtendedDSPropertySet(String resRefOrModuleName) {
        try {
            if (this.dsExtensions == null && this.getDeploymentDescriptor() != null) {
                this.dsExtensions = DataSourceExtensionsEJBHelper.getEJBDSext(this.getDeploymentDescriptor());
            }
        }
        catch (DeploymentDescriptorLoadException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwResourceLoadException(DataSourceExtensionsEJBHelper.DATASOURCEFILEURI, e);
        }
        return this.dsExtensions.getExtendedDSPropertySet(resRefOrModuleName);
    }

    public void setExtendedDSPropertySet(String name, Properties values) {
        try {
            if (this.dsExtensions == null && this.getDeploymentDescriptor() != null) {
                this.dsExtensions = DataSourceExtensionsEJBHelper.getEJBDSext(this.getDeploymentDescriptor());
            }
        }
        catch (DeploymentDescriptorLoadException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwResourceLoadException(DataSourceExtensionsEJBHelper.DATASOURCEFILEURI, e);
        }
        this.dsExtensions.setExtendedDSPropertySet(name, values);
    }

    public void setExtendedDSPropertySet(String resourceName, String name, String value) {
        try {
            if (this.dsExtensions == null && this.getDeploymentDescriptor() != null) {
                this.dsExtensions = DataSourceExtensionsEJBHelper.getEJBDSext(this.getDeploymentDescriptor());
            }
        }
        catch (DeploymentDescriptorLoadException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwResourceLoadException(DataSourceExtensionsEJBHelper.DATASOURCEFILEURI, e);
        }
        this.dsExtensions.setExtendedDSPropertySet(resourceName, name, value);
    }

    public void reflectFinderDescriptorsIfNecessary() {
        if (!this.getDeploymentDescriptor().containsContainerManagedBeans() || this.getExtensions().containsFinderDescriptors()) {
            return;
        }
        new FinderHelperMetaDataConverter(this).reflectMetaData();
    }

    public Resource getExtensionsResource() throws FileNotFoundException, ResourceLoadException {
        return this.getMofResource(this.getExtensionsUri());
    }

    public Resource getBindingsResource() throws FileNotFoundException, ResourceLoadException {
        return this.getMofResource(this.getBindingsUri());
    }

    public boolean isAnnotationsSupported() {
        if (super.isAnnotationsSupported()) {
            return true;
        }
        boolean extMetadataComplete = EjbExtensionsHelper.singleton().isMetadataComplete(this);
        return !extMetadataComplete;
    }

    public EObject getBindingsInfo() {
        return EJBBindingsHelper.peekEJBJarBinding(this);
    }

    public BindingType getBindingType(String refName) {
        EJBJarBinding moduleBinding = (EJBJarBinding)this.getBindingsInfo();
        if (moduleBinding != null) {
            if (moduleBinding.getResourceRefBinding(refName) != null) {
                return BindingType.RESOURCE_REF_TYPE;
            }
            if (moduleBinding.getResourceEnvRefBinding(refName) != null) {
                return BindingType.RESOURCE_ENV_REF_TYPE;
            }
            if (moduleBinding.getEjbRefBinding(refName) != null) {
                return BindingType.EJB_REF_TYPE;
            }
            if (moduleBinding.getMessageDestinationBinding(refName) != null) {
                return BindingType.MESSAGE_DESTINATION_TYPE;
            }
            if (moduleBinding.getMessageDestinationRefBinding(refName) != null) {
                return BindingType.MESSAGE_DESTINATION_REF_TYPE;
            }
            if (moduleBinding.getServiceRefBinding(refName) != null) {
                return BindingType.SERVICE_REF_TYPE;
            }
            if (moduleBinding.getInterceptorBinding(refName) != null) {
                return BindingType.INTERCEPTOR_TYPE;
            }
        }
        return null;
    }
}

