/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Stack;

public class TraceStream
extends PrintStream {
    protected static Hashtable traceStreamTable = new Hashtable();
    public static TraceStream out = TraceStream.getTraceStream("System.out");
    public static TraceStream err = TraceStream.getTraceStream("System.err");
    protected boolean isAtStartOfLine = true;
    protected Stack indentationStack = new Stack();
    protected int currentStreamIndex = 0;
    protected long logStartTime = System.currentTimeMillis();

    public TraceStream(PrintStream printStream) {
        super(printStream);
    }

    public void enter(Object tag, Object object) {
        if (!this.isAtStartOfLine) {
            super.println();
        }
        if (this.currentStreamIndex == 0) {
            super.print("Logging started: <b>" + DateFormat.getDateTimeInstance().format(new Date(this.logStartTime)) + "</b>");
            super.println();
        }
        IndentationStackRecord parentIndentationStackRecord = this.indentationStack.empty() ? null : (IndentationStackRecord)this.indentationStack.peek();
        IndentationStackRecord indentationStackRecord = new IndentationStackRecord(++this.currentStreamIndex, tag, object);
        this.indentationStack.push(indentationStackRecord);
        this.printLinePrefixHelper("<ol> <li> <pre> <!-- ", " --> ", '{');
        super.print("<b>+");
        super.print(indentationStackRecord.startTime - this.logStartTime);
        super.print("</b> ");
        super.print(indentationStackRecord.toForwardLinkAndBackwardAnchor());
        if (parentIndentationStackRecord != null) {
            super.print(parentIndentationStackRecord.toOutwardLink());
        }
        super.println();
        this.printLinePrefixHelper("<!--        --> <!-- ", " -->   ", '.');
        this.printWithHTMLIndentationHelper(indentationStackRecord.object.toString(), '.', false);
        super.print("\t\t\t\t\t</pre></li>");
        super.println();
        this.isAtStartOfLine = true;
    }

    public static TraceStream getTraceStream(String fileNameSpecification) {
        TraceStream result = null;
        if (fileNameSpecification != null) {
            try {
                result = (TraceStream)traceStreamTable.get(fileNameSpecification);
                if (result == null) {
                    if (fileNameSpecification.equals("out") || fileNameSpecification.equals("System.out") || fileNameSpecification.equals("1")) {
                        result = new TraceStream(new PrintStream(System.out));
                    } else if (fileNameSpecification.equals("err") || fileNameSpecification.equals("System.err") || fileNameSpecification.equals("2")) {
                        result = new TraceStream(new PrintStream(System.err));
                    } else {
                        FileOutputStream fileOutputStream = new FileOutputStream(fileNameSpecification);
                        result = new TraceStream(new PrintStream(fileOutputStream));
                    }
                    traceStreamTable.put(fileNameSpecification, result);
                }
            }
            catch (Exception exception) {
                System.err.println("The TraceStream.getTraceStream(\"" + fileNameSpecification + "\") caused an exception:");
                exception.printStackTrace();
            }
        }
        return result;
    }

    public void leave() {
        this.leave(this);
    }

    public void leave(char[] result) {
        this.leave(result + "", false);
    }

    public void leave(char[] result, boolean hilight) {
        this.leave(result + "", hilight);
    }

    public void leave(char result) {
        this.leave(result + "", false);
    }

    public void leave(char result, boolean hilight) {
        this.leave(result + "", hilight);
    }

    public void leave(double result) {
        this.leave(result + "", false);
    }

    public void leave(double result, boolean hilight) {
        this.leave(result + "", hilight);
    }

    public void leave(float result) {
        this.leave(result + "", false);
    }

    public void leave(float result, boolean hilight) {
        this.leave(result + "", hilight);
    }

    public void leave(int result) {
        this.leave(result + "", false);
    }

    public void leave(int result, boolean hilight) {
        this.leave(result + "", hilight);
    }

    public void leave(long result) {
        this.leave(result + "", false);
    }

    public void leave(long result, boolean hilight) {
        this.leave(result + "", hilight);
    }

    public void leave(Object result) {
        this.leave(result, false);
    }

    public void leave(Object result, boolean hilight) {
        if (!this.isAtStartOfLine) {
            this.println();
        }
        IndentationStackRecord indentationStackRecord = (IndentationStackRecord)this.indentationStack.peek();
        this.printLinePrefixHelper("     <li> <pre> <!-- ", " --> ", '}');
        long time2 = System.currentTimeMillis();
        super.print("<b>+");
        super.print(time2 - this.logStartTime);
        super.print(" [");
        super.print(time2 - indentationStackRecord.startTime);
        super.print("]</b> ");
        super.print(indentationStackRecord.toBackwardLinkAndFowardAnchor());
        super.println();
        this.printLinePrefixHelper("<!--        --> <!-- ", " -->   ", '.');
        this.printWithHTMLIndentationHelper(indentationStackRecord.object.toString(), '.', false);
        if (result == this) {
            super.print("\t\t\t\t\t</pre></li></li></ol>");
            super.println();
        } else {
            super.println();
            this.printLinePrefixHelper("<ul><li><!----> <!-- ", " -->   ", '-');
            this.printWithHTMLIndentationHelper(result == null ? "null" : result.toString(), '-', hilight);
            super.print("\t\t\t\t\t</li></ul></pre></li></ol>");
            super.println();
        }
        this.isAtStartOfLine = true;
        this.indentationStack.pop();
    }

    public void leave(String result) {
        this.leave((Object)result, false);
    }

    public void leave(String result, boolean hilight) {
        this.leave((Object)result, hilight);
    }

    public void leave(boolean result) {
        this.leave(result + "", false);
    }

    public void leave(boolean result, boolean hilight) {
        this.leave(result + "", hilight);
    }

    public void print(char[] s) {
        if (this.isAtStartOfLine) {
            this.printLinePrefix();
        }
        if (s != null) {
            for (int i = 0; i < s.length; ++i) {
                this.printEncoded(s[i]);
            }
        }
        super.print(s);
    }

    public void print(char c) {
        if (this.isAtStartOfLine) {
            this.printLinePrefix();
        }
        this.printEncoded(c);
    }

    public void print(double d) {
        if (this.isAtStartOfLine) {
            this.printLinePrefix();
        }
        super.print(d);
    }

    public void print(float f) {
        if (this.isAtStartOfLine) {
            this.printLinePrefix();
        }
        super.print(f);
    }

    public void print(int i) {
        if (this.isAtStartOfLine) {
            this.printLinePrefix();
        }
        super.print(i);
    }

    public void print(long l) {
        if (this.isAtStartOfLine) {
            this.printLinePrefix();
        }
        super.print(l);
    }

    public void print(Object o) {
        if (this.isAtStartOfLine) {
            this.printLinePrefix();
        }
        this.printEncoded(o);
    }

    public void print(String s) {
        if (this.isAtStartOfLine) {
            this.printLinePrefix();
        }
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                this.printEncoded(s.charAt(i));
            }
        }
    }

    public void print(boolean b) {
        if (this.isAtStartOfLine) {
            this.printLinePrefix();
        }
        super.print(b);
    }

    protected void printEncoded(char character) {
        switch (character) {
            case '<': {
                super.print("&lt;");
                break;
            }
            case '&': {
                super.print("&amp;");
                break;
            }
            default: {
                super.print(character);
            }
        }
    }

    protected void printEncoded(Object object) {
        String string = object == null ? "null" : object.toString();
        this.print(string);
    }

    protected void printEnquoted(char quoteCharacter, String string) {
        super.print(quoteCharacter);
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char character = string.charAt(i);
            if (character == quoteCharacter) {
                super.print('\\');
                super.print(quoteCharacter);
                continue;
            }
            super.print(character);
        }
        super.print(quoteCharacter);
    }

    protected void printLinePrefix() {
        this.printLinePrefixHelper("<ul> <li> <pre> <!-- ", this.indentationStack.size() % 2 == 0 ? " | --> " : "   --> ", '>');
        this.isAtStartOfLine = false;
    }

    protected void printLinePrefixHelper(String prefix, String suffix, char marker) {
        super.print(prefix);
        int size = this.indentationStack.size();
        for (int i = 0; i < size; ++i) {
            super.print(i % 2 == 0 ? " |" : "  ");
        }
        super.print(suffix);
        super.print(marker);
        super.print(' ');
    }

    protected void printLineSuffix() {
        super.print("\t\t\t\t\t</pre></li></ul>");
    }

    public void println() {
        if (this.isAtStartOfLine) {
            this.printLinePrefix();
        }
        this.printLineSuffix();
        super.println();
        this.isAtStartOfLine = true;
    }

    public void println(char[] s) {
        this.print(s);
        this.println();
    }

    public void println(char c) {
        this.print(c);
        this.println();
    }

    public void println(char prefix, String string) {
        this.println(prefix, string, false, true);
    }

    public void println(char prefix, String string, boolean hilight) {
        this.println(prefix, string, hilight, true);
    }

    public void println(char prefix, String string, boolean hilight, boolean format) {
        if (format) {
            if (!this.isAtStartOfLine) {
                this.println();
            }
            this.printLinePrefixHelper("<ul> <li> <pre> <!-- ", " -->   ", prefix);
            this.printWithHTMLIndentationHelper(string, prefix, hilight);
            this.printLineSuffix();
            super.println();
        } else {
            if (hilight) {
                if (this.isAtStartOfLine) {
                    this.printLinePrefix();
                }
                super.print("<font color=\"#FF0000\">");
            }
            this.print(string);
            if (hilight) {
                super.print("</font>");
            }
            this.println();
        }
    }

    public void println(double d) {
        this.print(d);
        this.println();
    }

    public void println(float f) {
        this.print(f);
        this.println();
    }

    public void println(int i) {
        this.print(i);
        this.println();
    }

    public void println(long l) {
        this.print(l);
        this.println();
    }

    public void println(Object o) {
        this.print(o);
        this.println();
    }

    public void println(String s) {
        this.print(s);
        this.println();
    }

    public void println(String string, boolean hilight) {
        this.println(hilight ? (char)'!' : '>', string, hilight, false);
    }

    public void println(boolean b) {
        this.print(b);
        this.println();
    }

    protected void printWithHTMLIndentationHelper(String string, char marker, boolean hilight) {
        if (hilight) {
            super.print("<font color=\"#FF0000\">");
        }
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(string));
        tokenizer.quoteChar(34);
        tokenizer.ordinaryChar(32);
        tokenizer.ordinaryChar(47);
        tokenizer.ordinaryChar(45);
        tokenizer.ordinaryChars(48, 57);
        int indent = 0;
        boolean ignoreSpace = false;
        try {
            block13: while (tokenizer.nextToken() != -1) {
                switch (tokenizer.ttype) {
                    case 44: {
                        int i;
                        super.print(',');
                        super.println();
                        this.printLinePrefixHelper("<!--        --> <!-- ", " -->   ", marker);
                        for (i = indent * 2; i > 0; --i) {
                            super.print(" ");
                        }
                        if (indent > 0) {
                            super.print(' ');
                        }
                        ignoreSpace = true;
                        continue block13;
                    }
                    case 32: {
                        if (ignoreSpace) continue block13;
                        super.print(' ');
                        continue block13;
                    }
                    case 40: 
                    case 91: 
                    case 123: {
                        int i;
                        super.println();
                        this.printLinePrefixHelper("<!--        --> <!-- ", " -->   ", marker);
                        for (i = ++indent * 2; i > 0; --i) {
                            super.print(" ");
                        }
                        super.print((char)tokenizer.ttype);
                        break;
                    }
                    case 41: 
                    case 93: 
                    case 125: {
                        --indent;
                        super.print((char)tokenizer.ttype);
                        break;
                    }
                    case 34: {
                        this.printEnquoted('\"', tokenizer.sval);
                        break;
                    }
                    case 38: {
                        super.print("&amp;");
                        break;
                    }
                    case 60: {
                        super.print("&lt;");
                        break;
                    }
                    case -2: {
                        super.print(tokenizer.nval);
                        break;
                    }
                    case -3: {
                        super.print(tokenizer.sval);
                        break;
                    }
                    default: {
                        super.print((char)tokenizer.ttype);
                    }
                }
                ignoreSpace = false;
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        if (hilight) {
            super.print("\t\t</font>");
        }
    }

    protected static class IndentationStackRecord {
        public int streamIndex;
        public Object tag;
        public Object object;
        public long startTime;

        public IndentationStackRecord(int streamIndex, Object tag, Object object) {
            this.streamIndex = streamIndex;
            this.tag = tag;
            this.object = object;
            this.startTime = System.currentTimeMillis();
        }

        public String toForwardLinkAndBackwardAnchor() {
            String hexStreamIndex = Integer.toHexString(this.streamIndex);
            return this.tag + " " + this.object.getClass().getName() + "@" + Integer.toHexString(this.object.hashCode()) + " <a name=\"++" + hexStreamIndex + "\" href=\"#--" + hexStreamIndex + "\">FORWARD</a>";
        }

        public String toBackwardLinkAndFowardAnchor() {
            String hexStreamIndex = Integer.toHexString(this.streamIndex);
            return this.tag + " " + this.object.getClass().getName() + "@" + Integer.toHexString(this.object.hashCode()) + " <a href=\"#++" + hexStreamIndex + "\" name=\"--" + hexStreamIndex + "\">BACKWARD</a>";
        }

        public String toOutwardLink() {
            String hexStreamIndex = Integer.toHexString(this.streamIndex);
            return " <a href=\"#++" + hexStreamIndex + "\">OUTWARD</a>";
        }

        public String toString() {
            return "IndentationStackRecord (streamIndex: " + this.streamIndex + ", tag: " + this.tag + ", object: " + this.object + ")";
        }
    }
}

