/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.CB390TraceEventListener;
import com.ibm.ejs.ras.ComponentManager;
import com.ibm.ejs.ras.Dumpable;
import com.ibm.ejs.ras.ExtendedTraceLogger;
import com.ibm.ejs.ras.MalformedTraceStringException;
import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.MessageEvent6;
import com.ibm.ejs.ras.RasEvent6;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.RasProperties;
import com.ibm.ejs.ras.StreamEvent6;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceEvent6;
import com.ibm.ejs.ras.TraceLogger;
import com.ibm.ejs.ras.WsHandlerManager;
import com.ibm.ejs.ras.WsHandlerManagerImpl;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.ws.bootstrap.WSLauncher;
import com.ibm.ws.bootstrap.WsLogManager;
import com.ibm.ws.logging.LoggerHelper;
import com.ibm.ws.logging.WsHandler;
import com.ibm.ws.logging.WsHandlerWrapper;
import com.ibm.ws.logging.WsLogger;
import com.ibm.ws.logging.WsLoggerFactoryImpl;
import com.ibm.ws.logging.cbe.CBEWsHandlerAdapter;
import com.ibm.ws.logging.object.WsLogRecord;
import com.ibm.ws.logging.object.WsLogRecordFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryContext;

public class Tr {
    private static final String ENTRY = "Entry";
    private static final String EXIT = "Exit";
    private static ComponentManager compMgr;
    private static WsHandlerManager svHandlerManager;
    private static Logger trLogger;
    private static Object[] svNullParamArray;
    private static TraceLogger svStartupListener;
    private static OutputStream svSystemOut;
    private static OutputStream svSystemErr;
    private static Logger svRootLogger;
    private static Vector svInternalQueue;
    protected static boolean distTracesOnzOS;
    protected static boolean zWASTraceHandlerRegistered;

    private Tr() {
    }

    public static void init() {
    }

    public static Logger getLogger(String name, String group, String resourceBundleName) {
        Logger logger = resourceBundleName == null ? Logger.getLogger(name) : Logger.getLogger(name, resourceBundleName);
        if (group != null && logger instanceof WsLogger) {
            LoggerHelper.addLoggerToGroup(logger, group);
        }
        return logger;
    }

    public static TraceComponent register(String name) {
        return compMgr.register(name);
    }

    public static TraceComponent register(Class aClass) {
        return compMgr.register(aClass.getName());
    }

    public static TraceComponent register(String name, String group) {
        if (group == null || group.equals("")) {
            return compMgr.register(name);
        }
        return compMgr.register(name, group);
    }

    public static TraceComponent register(Class aClass, String group) {
        if (group == null || group.equals("")) {
            return compMgr.register(aClass.getName());
        }
        return compMgr.register(aClass.getName(), group);
    }

    public static TraceComponent register(String name, String group, String resourceBundleName) {
        TraceComponent tc = null;
        tc = group == null || group.equals("") ? compMgr.register(name) : compMgr.register(name, group);
        tc.setResourceBundleName(resourceBundleName);
        return tc;
    }

    public static TraceComponent register(Class aClass, String group, String resourceBundleName) {
        TraceComponent tc = null;
        tc = group == null || group.equals("") ? compMgr.register(aClass.getName()) : compMgr.register(aClass.getName(), group);
        tc.setResourceBundleName(resourceBundleName);
        return tc;
    }

    public static void registerDumpable(TraceComponent tc, Dumpable d) {
        compMgr.registerDumpable(tc, d);
    }

    static ComponentManager getComponentManager() {
        return compMgr;
    }

    static synchronized void addWsHandler(WsHandler handler) {
        svHandlerManager.addWsHandler(handler, false);
    }

    public static final void audit(TraceComponent tc, String msgKey) {
        if (tc.ivServiceEnabled) {
            Tr.fireMessageEvent(1, tc, null, msgKey, null);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void audit(TraceComponent tc, String msgKey, Object objs) {
        if (tc.ivServiceEnabled) {
            if (objs == null) {
                objs = svNullParamArray;
            }
            Tr.fireMessageEvent(1, tc, null, msgKey, objs);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void debug(TraceComponent tc, String msg) {
        if (tc.ivDebugEnabled) {
            Tr.fireTraceEvent(2, tc, null, msg, null);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void debug(TraceComponent tc, String msg, Object objs) {
        if (tc.isDebugEnabled()) {
            if (objs == null) {
                objs = svNullParamArray;
            }
            Tr.fireTraceEvent(2, tc, null, msg, objs);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void dump(TraceComponent tc, String msg) {
        if (tc.isDebugEnabled()) {
            Tr.fireTraceEvent(3, tc, null, msg, null);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void dump(TraceComponent tc, String msg, Object objs) {
        if (tc.isDebugEnabled()) {
            if (objs == null) {
                objs = svNullParamArray;
            }
            Tr.fireTraceEvent(3, tc, null, msg, objs);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void error(TraceComponent tc, String msgKey) {
        if (tc.ivErrorEnabled) {
            Tr.fireMessageEvent(4, tc, null, msgKey, null);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void error(TraceComponent tc, String msgKey, Object objs) {
        if (tc.ivErrorEnabled) {
            if (objs == null) {
                objs = svNullParamArray;
            }
            Tr.fireMessageEvent(4, tc, null, msgKey, objs);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void event(TraceComponent tc, String msg) {
        if (tc.ivEventEnabled) {
            Tr.fireTraceEvent(5, tc, null, msg, null);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void event(TraceComponent tc, String msg, Object objs) {
        if (tc.ivEventEnabled) {
            if (objs == null) {
                objs = svNullParamArray;
            }
            Tr.fireTraceEvent(5, tc, null, msg, objs);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void entry(TraceComponent tc, String methodName) {
        if (tc.ivEntryEnabled) {
            Tr.fireTraceEvent(6, tc, methodName, ENTRY, null);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void entry(TraceComponent tc, String methodName, Object objs) {
        if (tc.ivEntryEnabled) {
            if (objs == null) {
                objs = svNullParamArray;
            }
            Tr.fireTraceEvent(6, tc, methodName, ENTRY, objs);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void exit(TraceComponent tc, String methodName) {
        if (tc.ivEntryEnabled) {
            Tr.fireTraceEvent(7, tc, methodName, EXIT, null);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void exit(TraceComponent tc, String methodName, Object objs) {
        if (tc.ivEntryEnabled) {
            if (objs == null) {
                objs = svNullParamArray;
            }
            Tr.fireTraceEvent(7, tc, methodName, EXIT, objs);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void fatal(TraceComponent tc, String msgKey) {
        Tr.fireMessageEvent(8, tc, null, msgKey, null);
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void fatal(TraceComponent tc, String msgKey, Object objs) {
        if (objs == null) {
            objs = svNullParamArray;
        }
        Tr.fireMessageEvent(8, tc, null, msgKey, objs);
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void info(TraceComponent tc, String msgKey) {
        if (tc.ivInfoEnabled) {
            Tr.fireMessageEvent(11, tc, null, msgKey, null);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void info(TraceComponent tc, String msgKey, Object objs) {
        if (tc.ivInfoEnabled) {
            if (objs == null) {
                objs = svNullParamArray;
            }
            Tr.fireMessageEvent(11, tc, null, msgKey, objs);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    static final void systemErr(StreamEvent6 event2) {
        Tr.logToWsHandlers(event2);
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    static final void systemOut(StreamEvent6 event2) {
        Tr.logToWsHandlers(event2);
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void service(TraceComponent tc, String msgKey) {
        if (tc.ivServiceEnabled) {
            if (RasHelper.isServer()) {
                Tr.fireMessageEvent(9, tc, null, msgKey, null);
            } else {
                Tr.fireMessageEvent(1, tc, null, msgKey, null);
            }
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void service(TraceComponent tc, String msgKey, Object objs) {
        if (tc.ivServiceEnabled) {
            if (objs == null) {
                objs = svNullParamArray;
            }
            if (RasHelper.isServer()) {
                Tr.fireMessageEvent(9, tc, null, msgKey, objs);
            } else {
                Tr.fireMessageEvent(1, tc, null, msgKey, objs);
            }
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void uncondEvent(TraceComponent tc, String msg) {
        Tr.fireTraceEvent(12, tc, null, msg, null);
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void uncondEvent(TraceComponent tc, String msg, Object objs) {
        if (objs == null) {
            objs = svNullParamArray;
        }
        Tr.fireTraceEvent(12, tc, null, msg, objs);
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void uncondFormattedEvent(TraceComponent tc, String msgKey) {
        Tr.fireMessageEvent(11, tc, null, msgKey, null);
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void uncondFormattedEvent(TraceComponent tc, String msgKey, Object objs) {
        if (objs == null) {
            objs = svNullParamArray;
        }
        Tr.fireMessageEvent(11, tc, null, msgKey, objs);
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void warning(TraceComponent tc, String msgKey) {
        if (tc.ivWarningEnabled) {
            Tr.fireMessageEvent(10, tc, null, msgKey, null);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void warning(TraceComponent tc, String msgKey, Object objs) {
        if (tc.ivWarningEnabled) {
            if (objs == null) {
                objs = svNullParamArray;
            }
            Tr.fireMessageEvent(10, tc, null, msgKey, objs);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static void logJrasEvent(MessageEvent6 event2) {
        if (event2 != null) {
            Tr.fireEvent(event2);
        }
    }

    public static void logJrasEvent(TraceEvent6 event2) {
        if (event2 != null) {
            Tr.fireEvent(event2);
        }
    }

    static synchronized void createServerStartupListener() {
        if (svStartupListener != null) {
            return;
        }
        try {
            svStartupListener = new TraceLogger(svSystemOut, true);
            svHandlerManager.addWsHandler(svStartupListener, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static synchronized void removeWsHandler(WsHandler handler) {
        svHandlerManager.removeWsHandler(handler);
    }

    static synchronized void replaceWsHandler(WsHandler newOne, WsHandler old) {
        if (svStartupListener != null) {
            svHandlerManager.removeWsHandler(svStartupListener);
            svStartupListener = null;
        }
        svHandlerManager.replaceWsHandler(newOne, old);
    }

    static synchronized void addJmxListener(WsHandler handler) {
        svHandlerManager.addWsHandler(handler, true);
    }

    static synchronized void setWsHandlerManager(WsHandlerManager handlerManager) {
        svHandlerManager = handlerManager;
    }

    static OutputStream getSystemOut() {
        return svSystemOut;
    }

    static OutputStream getSystemErr() {
        return svSystemErr;
    }

    static synchronized void queueInternalEvent(RasEvent6 event2) {
        if (svInternalQueue == null) {
            svInternalQueue = new Vector();
        }
        svInternalQueue.addElement(event2);
    }

    private static synchronized void dispatchInternalEvents() {
        if (svInternalQueue == null) {
            return;
        }
        Vector v = svInternalQueue;
        svInternalQueue = null;
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            RasEvent6 event2 = (RasEvent6)v.elementAt(i);
            if (event2 instanceof MessageEvent6) {
                Tr.logJrasEvent((MessageEvent6)event2);
                continue;
            }
            Tr.logJrasEvent((TraceEvent6)event2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processTraceSettings() {
        InputStream s;
        String fileName;
        block26: {
            File file;
            fileName = RasHelper.getSystemProperty("traceSettingsFile");
            if (fileName == null || fileName.equals("")) {
                return;
            }
            fileName = fileName.trim();
            s = null;
            s = RasHelper.getResourceAsStream(fileName);
            if (s == null && (file = new File(fileName)).exists()) {
                s = new FileInputStream(file);
            }
            if (s == null) break block26;
            System.out.println("Processing Trace Settings File: " + fileName);
            Properties props = new Properties();
            props.load(s);
            Enumeration<Object> anenum = props.keys();
            String outputFileName = null;
            while (anenum.hasMoreElements()) {
                String key = (String)anenum.nextElement();
                if (key.equalsIgnoreCase("traceFileName")) {
                    outputFileName = props.getProperty(key);
                    continue;
                }
                String string = props.getProperty(key);
                String traceString = key + "=" + string;
                try {
                    ManagerAdmin.checkTraceString(traceString);
                    compMgr.processTraceString(traceString, false);
                }
                catch (MalformedTraceStringException mtse) {
                    System.out.println("Error processing Trace String: " + mtse.getMessage());
                }
            }
            if (distTracesOnzOS || outputFileName != null) {
                if (outputFileName.equalsIgnoreCase("zwas:stdout")) {
                    if (!zWASTraceHandlerRegistered) {
                        svHandlerManager.addWsHandler(new CB390TraceEventListener(), false);
                        zWASTraceHandlerRegistered = true;
                    }
                } else {
                    void var6_14;
                    OutputStream os2 = null;
                    if (distTracesOnzOS || outputFileName.equalsIgnoreCase("stdout")) {
                        os2 = svSystemOut;
                    } else {
                        try {
                            RasHelper.validateFileName(outputFileName.trim());
                            os2 = RasHelper.createFileOutputStream(outputFileName, false);
                        }
                        catch (RasException rasException) {
                            System.out.println("Unable to open specified file " + outputFileName);
                            rasException.printStackTrace(System.out);
                            os2 = svSystemOut;
                        }
                    }
                    Object var6_10 = null;
                    if (RasProperties.svTraceFormat.equalsIgnoreCase("loganalyzer")) {
                        ExtendedTraceLogger extendedTraceLogger = new ExtendedTraceLogger(os2);
                    } else if (RasProperties.svTraceFormat.equalsIgnoreCase("advanced")) {
                        TraceLogger traceLogger = new TraceLogger(os2, false);
                    } else {
                        TraceLogger traceLogger = new TraceLogger(os2, true);
                    }
                    svHandlerManager.addWsHandler((WsHandler)var6_14, false);
                }
            }
            Tr.getComponentManager().checkAndSetORBRasLogging();
        }
        Object var10_17 = null;
        if (s == null) return;
        try {
            s.close();
            return;
        }
        catch (Exception e2) {}
        return;
        {
            catch (Throwable t) {
                System.out.println("caught exception trying to open trace properties file " + fileName);
                t.printStackTrace(System.out);
                Object var10_18 = null;
                if (s == null) return;
                try {
                    s.close();
                    return;
                }
                catch (Exception e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_19 = null;
            if (s == null) throw throwable;
            try {
                s.close();
                throw throwable;
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static void fireMessageEvent(int type, TraceComponent tc, String methodName, String msg, Object objs) {
        if (tc == null) {
            return;
        }
        MessageEvent6 event2 = new MessageEvent6(type, tc, null, msg, objs);
        Tr.fireEvent(event2);
    }

    public static void fireTraceEvent(int type, TraceComponent tc, String methodName, String msg, Object objs) {
        if (tc == null) {
            return;
        }
        TraceEvent6 event2 = new TraceEvent6(type, tc, methodName, msg, objs);
        Tr.fireEvent(event2);
    }

    private static void fireEvent(MessageEvent6 event2) {
        Tr.logToJSR47Logger(event2);
        if (!WSLauncher.isZOS() && event2.ivType == 8 && ComponentManager.svTraceEnabled) {
            String logRootDir = null;
            try {
                logRootDir = RasProperties.getDefaultLoggingDirectory() + File.separator;
            }
            catch (RasException re2) {
                logRootDir = "." + File.separator;
            }
            String serverName = null;
            int index = RasHelper.getServerName().lastIndexOf(92);
            serverName = index != -1 ? RasHelper.getServerName().substring(index + 1) : RasHelper.getServerName();
            SimpleDateFormat sdf = new SimpleDateFormat("yy.MM.dd HH:mm:ss:SSS z");
            Date date = new Date(event2.ivTimeStamp);
            String ts = sdf.format(date);
            String dumpFilename = logRootDir + serverName + "FatalError" + ts + ".log";
            ManagerAdmin.dumpRingBuffer(dumpFilename);
        }
    }

    private static void fireEvent(TraceEvent6 event2) {
        Tr.logToJSR47Logger(event2);
    }

    private static void logToJSR47Logger(MessageEvent6 event2) {
        WsLogRecord lr = WsLogRecordFactory.createWsLogRecord(event2);
        if (lr != null) {
            trLogger.log(lr.getImpl());
        }
    }

    private static void logToJSR47Logger(TraceEvent6 event2) {
        WsLogRecord lr = WsLogRecordFactory.createWsLogRecord(event2);
        if (lr != null) {
            trLogger.log(lr.getImpl());
        }
    }

    private static void logToWsHandlers(StreamEvent6 event2) {
        WsLogRecord lr = WsLogRecordFactory.createWsLogRecord(event2);
        if (lr != null) {
            Logger rootLogger = svRootLogger;
            Handler[] handlers = rootLogger.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                if (!(handlers[i] instanceof WsHandlerWrapper)) continue;
                handlers[i].publish(lr.getImpl());
            }
        }
    }

    static {
        svNullParamArray = new Object[]{null};
        svStartupListener = null;
        svSystemOut = null;
        svSystemErr = null;
        svRootLogger = null;
        svInternalQueue = null;
        distTracesOnzOS = false;
        zWASTraceHandlerRegistered = false;
        distTracesOnzOS = Boolean.getBoolean("com.ibm.ws.dist.trace.format.on.zos");
        LogManager o = LogManager.getLogManager();
        if (o instanceof WsLogManager) {
            ((WsLogManager)o).initWsLoggerFactory(WsLoggerFactoryImpl.getInstance());
            if (RasHelper.isServer()) {
                ((WsLogManager)o).disableReset();
            }
        }
        EventFactoryContext.getInstance().setEventFactoryHomeType("com.ibm.websphere.logging.cbe.WsTemplateEventFactoryHomeImpl");
        svSystemOut = System.out;
        svSystemErr = System.err;
        compMgr = new ComponentManager();
        svRootLogger = Logger.getLogger("");
        if (WsLogManager.isConfigureByLoggingProperties()) {
            trLogger = svRootLogger;
        } else {
            trLogger = Logger.getAnonymousLogger();
            trLogger.setLevel(Level.ALL);
        }
        svHandlerManager = RasHelper.getSystemProperty("com.ibm.websphere.os400.express.AdminWrapperTracing") != null ? new WsHandlerManagerImpl(trLogger) : new WsHandlerManagerImpl();
        if (WSLauncher.isZOS() && RasHelper.isServer() && !distTracesOnzOS) {
            String errorLogFormat = RasHelper.getSystemProperty("com.ibm.ws.logging.zOS.errorLog.format");
            boolean isErrorLogCBEFormat = errorLogFormat != null && errorLogFormat.equals("CBE-XML-1.0.1");
            WsHandler zHandler = isErrorLogCBEFormat ? new CBEWsHandlerAdapter(new CB390TraceEventListener(), true, WsLevel.DETAIL, WsLevel.ALL) : new CB390TraceEventListener();
            svHandlerManager.addWsHandler(zHandler, false);
            zWASTraceHandlerRegistered = true;
        }
        RasProperties.loadProperties();
        Tr.processTraceSettings();
    }
}

