/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.LogRolloverListener;
import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.StreamEvent6;
import com.ibm.ejs.ras.SystemStream;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.WrappingFileOutputStream;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.ws.logging.LevelConstants;
import com.ibm.ws.logging.TraceLogFormatter;
import com.ibm.ws.logging.WsHandler;
import com.ibm.ws.logging.object.WsLogRecord;
import com.ibm.ws.logging.object.WsLogRecordFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.LogRecord;

public class SystemOutStream
extends SystemStream
implements WsHandler,
LogRolloverListener {
    private static String svSystemOut = "SystemOut";
    private static TraceComponent svTc = Tr.register(svSystemOut, null, "com.ibm.ejs.resources.RasMessages");
    private static SystemOutStream svSos;
    private static WrappingFileOutputStream svFile;
    private boolean ivSuppressStacks;

    public static synchronized void replaceSystemOutStream(String fileName, int rolloverType, int maxBackups, long rolloverSize, int baseHour, int rolloverPeriod, boolean suppress, boolean formatOutput, String formatType, boolean suppressStacks) throws RasException {
        RasHelper.printHeader(System.out);
        NullOutputStream nos = new NullOutputStream();
        if (fileName == null || fileName.equalsIgnoreCase("console")) {
            SystemOutStream sos = new SystemOutStream(nos, System.out, suppress, formatOutput, formatType, suppressStacks);
            RasHelper.setSystemOut(sos);
            Tr.replaceWsHandler(sos, svSos);
            svSos = sos;
            return;
        }
        if (fileName.equalsIgnoreCase("none")) {
            PrintStream ps = new PrintStream(nos);
            RasHelper.setSystemOut(ps);
            Tr.replaceWsHandler(null, svSos);
            svSos = null;
            return;
        }
        try {
            String name = RasHelper.generateOutputFileName(fileName, svSystemOut, svTc);
            svFile = new WrappingFileOutputStream(name, rolloverType, maxBackups, rolloverSize, baseHour, rolloverPeriod);
            if (svFile != null) {
                try {
                    svFile.write(RasHelper.printHeader(null));
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            PrintStream ps = new PrintStream(svFile);
            SystemOutStream sos = new SystemOutStream(nos, ps, suppress, formatOutput, formatType, suppressStacks);
            svFile.addRolloverListener(sos);
            RasHelper.setSystemOut(sos);
            Tr.replaceWsHandler(sos, svSos);
            svSos = sos;
            ManagerAdmin.initialTraceHeader();
        }
        catch (RasException re2) {
            Tr.error(svTc, "MSG_STREAM_REPLACEMENT_FAILED", new Object[]{"System.Out", re2});
            throw re2;
        }
        catch (Throwable t) {
            Tr.error(svTc, "MSG_STREAM_REPLACEMENT_FAILED", new Object[]{"System.Out", t});
            throw new RasException("Redirection of System.out to file " + fileName + " failed", t);
        }
    }

    static synchronized String rolloverLogFileImmediate(String fileName) throws RasException {
        if (svFile == null) {
            throw new RasException("System.out currently not redirected to a log file");
        }
        try {
            return svFile.rolloverImmediate(fileName);
        }
        catch (IOException ioe) {
            throw new RasException(ioe);
        }
    }

    static void initialize() {
        if (svSos != null) {
            svSos.printHeader();
        }
    }

    private SystemOutStream(OutputStream dummy, PrintStream stream, boolean suppress, boolean format, String formatType, boolean suppressStacks) {
        super(dummy, stream, suppress, format, formatType);
        this.ivSuppressStacks = suppressStacks;
    }

    public void logRolled() {
        this.printHeader();
    }

    public void processEvent(LogRecord event2) {
        if (event2 == null) {
            return;
        }
        if (event2.getLevel().intValue() < WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[8]]) {
            return;
        }
        WsLogRecord wsLogRecord = WsLogRecordFactory.getWsLogRecordIfConvertible(event2);
        if (wsLogRecord != null && wsLogRecord.getExtension("service_log_only") != null) {
            return;
        }
        this.logMessage(event2);
    }

    private synchronized void logMessage(LogRecord event2) {
        this.writeWebSphereEvent(this.formatMessage(event2));
    }

    private String formatMessage(LogRecord event2) {
        if ("advanced".equals(this.ivFormatType)) {
            return TraceLogFormatter.formatAdvanced(event2);
        }
        return TraceLogFormatter.formatBasic(event2);
    }

    StreamEvent6 createEvent(String data) {
        StreamEvent6 event2 = new StreamEvent6(13, svTc, data);
        return event2;
    }

    StreamEvent6 createEvent(byte[] data) {
        StreamEvent6 event2 = new StreamEvent6(13, svTc, data);
        return event2;
    }

    StreamEvent6 createEvent(char[] data) {
        StreamEvent6 event2 = new StreamEvent6(13, svTc, data);
        return event2;
    }

    void dispatchEvent(StreamEvent6 event2) {
        Tr.systemOut(event2);
    }

    void printHeader() {
        if (this.ivStream == null) {
            return;
        }
        byte[] bytes = RasHelper.printHeader(null);
        try {
            if (svFile != null) {
                svFile.write(bytes);
            } else {
                this.ivStream.write(bytes);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        svFile = null;
    }

    private static class NullOutputStream
    extends OutputStream {
        NullOutputStream() {
        }

        public void write(int b) throws IOException {
        }

        public void write(byte[] b, int off, int len) throws IOException {
        }
    }
}

