/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.LogRolloverListener;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.StreamEvent6;
import com.ibm.ejs.ras.SystemStream;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.WrappingFileOutputStream;
import com.ibm.ws.bootstrap.WsLogManager;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.LogManager;

public class SystemErrStream
extends SystemStream
implements LogRolloverListener {
    private static final String svSystemErr = "SystemErr";
    private static TraceComponent svTc = Tr.register("SystemErr", null, "com.ibm.ejs.resources.RasMessages");
    private static WrappingFileOutputStream svFile = null;

    public static synchronized void replaceSystemErrStream(String fileName, int rolloverType, int maxBackups, long rolloverSize, int baseHour, int rolloverPeriod, boolean suppress, boolean format) throws RasException {
        try {
            LogManager lm = LogManager.getLogManager();
            if (lm instanceof WsLogManager) {
                lm.readConfiguration();
            }
        }
        catch (IOException ex) {
            throw new RasException("Redirection of System.err to file " + fileName + " failed", ex);
        }
        RasHelper.printErrHeader(System.err);
        NullOutputStream nos = new NullOutputStream();
        if (fileName == null || fileName.equalsIgnoreCase("console")) {
            SystemErrStream ses = new SystemErrStream(nos, System.err, suppress, format);
            RasHelper.setSystemErr(ses);
            return;
        }
        if (fileName.equalsIgnoreCase("none")) {
            PrintStream ps = new PrintStream(nos);
            RasHelper.setSystemErr(ps);
            return;
        }
        try {
            String name = RasHelper.generateOutputFileName(fileName, svSystemErr, svTc);
            svFile = new WrappingFileOutputStream(name, rolloverType, maxBackups, rolloverSize, baseHour, rolloverPeriod);
            PrintStream ps = new PrintStream(svFile);
            SystemErrStream ses = new SystemErrStream(nos, ps, suppress, format);
            svFile.addRolloverListener(ses);
            RasHelper.setSystemErr(ses);
            File tmpErrFile = new File(name);
            if (tmpErrFile.length() == 0L) {
                RasHelper.printErrHeader(svFile);
            } else if (!RasHelper.containsRasHeader(name)) {
                SystemErrStream.rolloverLogFileImmediate(null);
            } else if (WsLogManager.getErrorHeaderControl().equals("full")) {
                RasHelper.printErrHeader(svFile);
            }
        }
        catch (RasException re2) {
            Tr.error(svTc, "MSG_STREAM_REPLACEMENT_FAILED", new Object[]{"System.Err", re2});
            throw re2;
        }
        catch (Throwable t) {
            Tr.error(svTc, "MSG_STREAM_REPLACEMENT_FAILED", new Object[]{"System.Err", t});
            throw new RasException("Redirection of System.out to file " + fileName + " failed", t);
        }
    }

    static synchronized String rolloverLogFileImmediate(String fileName) throws RasException {
        if (svFile == null) {
            throw new RasException("System.err currently not redirected to a log file");
        }
        try {
            String archiveFileName = svFile.rolloverImmediate(fileName);
            return archiveFileName;
        }
        catch (IOException ioe) {
            throw new RasException(ioe);
        }
    }

    SystemErrStream(OutputStream nos, PrintStream stream, boolean suppress, boolean format) {
        super(nos, stream, suppress, format, "basic");
    }

    StreamEvent6 createEvent(String data) {
        return new StreamEvent6(14, svTc, data);
    }

    StreamEvent6 createEvent(byte[] data) {
        return new StreamEvent6(14, svTc, data);
    }

    StreamEvent6 createEvent(char[] data) {
        return new StreamEvent6(14, svTc, data);
    }

    void dispatchEvent(StreamEvent6 event2) {
        Tr.systemErr(event2);
    }

    public void logRolled() {
        RasHelper.printErrHeader(svFile);
    }

    private static class NullOutputStream
    extends OutputStream {
        NullOutputStream() {
        }

        public void write(int b) throws IOException {
        }

        public void write(byte[] b, int off, int len) throws IOException {
        }
    }
}

