/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.RasProperties;
import com.ibm.ejs.ras.SharedLogBase;
import com.ibm.ejs.ras.SharedLogConstants;
import com.ibm.ejs.ras.SharedLogHeader;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.ws.logging.object.WsLogRecord;
import com.ibm.ws.logging.object.WsLogRecordFactory;
import com.ibm.ws.logging.object.WsLogRecordHelper;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;

class SharedLogReader
extends SharedLogBase {
    private static String svClassName = "com.ibm.ejs.ras.SharedLogReader";
    private static String rbName = "com.ibm.ejs.resources.RasMessages";
    private TraceComponent tc = Tr.register(SharedLogReader.class, null, rbName);
    private static final int svReadBufferSize = 1000;
    private boolean ivUsable = false;
    private int ivFirstMessage = -1;
    private boolean ivWrapped = false;
    private File ivFile = null;
    private RandomAccessFile ivRandomAccessFile = null;
    private SharedLogHeader ivHeader = null;
    private int ivCurMessage = -1;
    private byte[] ivBlockSizeBuffer;
    ByteArrayInputStream ivBlockSizeBais;
    DataInputStream ivBlockSizeDis;
    private int ivTrueFileSize;
    private WsLogRecord ivFileSizeMismatch = null;
    private int ivMessagesToProcess = 0;
    private boolean ivLogProcessingComplete = false;

    SharedLogReader(String fileName, boolean holdsLock) throws RasException {
        String normalizedName = this.locateFile(fileName);
        this.copySharedLog(normalizedName, holdsLock);
        try {
            Level level = WsLevel.DETAIL;
            this.ivBlockSizeBuffer = new byte[4];
            this.ivBlockSizeBais = new ByteArrayInputStream(this.ivBlockSizeBuffer);
            this.ivBlockSizeDis = new DataInputStream(this.ivBlockSizeBais);
            this.ivRandomAccessFile = this.createRandomAccessFile(this.ivFile.getPath(), "r");
            this.ivHeader = new SharedLogHeader(this.ivRandomAccessFile);
            this.ivTrueFileSize = (int)this.ivRandomAccessFile.length();
            if (!this.ivHeader.ivFileWrapped) {
                if (this.ivTrueFileSize != this.ivHeader.ivFreeSpace) {
                    this.ivFileSizeMismatch = WsLogRecordFactory.createWsLogRecord(null, Level.SEVERE, "MSG_ACTIVITY_LOG_CORRUPTED", null, svClassName, "SharedLogReader", rbName, null, null, null, null, null, null, Level.ALL.intValue(), this.tc.getName());
                    if (this.tc.isEventEnabled()) {
                        Tr.event(this.tc, "Ctor the free space size of " + this.ivHeader.ivFreeSpace + " did not match the physical file size " + this.ivTrueFileSize);
                    }
                }
            } else if (this.ivTrueFileSize != this.ivHeader.ivMaxSize) {
                this.ivFileSizeMismatch = WsLogRecordFactory.createWsLogRecord(null, Level.SEVERE, "MSG_ACTIVITY_LOG_CORRUPTED", null, svClassName, "SharedLogReader", rbName, null, null, null, null, null, null, Level.ALL.intValue(), this.tc.getName());
                if (this.tc.isEventEnabled()) {
                    Tr.event(this.tc, "Ctor - the file size of " + this.ivHeader.ivMaxSize + " did not match the physical file size " + this.ivTrueFileSize);
                }
            }
            this.ivMessagesToProcess = this.countMessages(this.ivRandomAccessFile, this.ivHeader);
            this.ivFirstMessage = this.findFirstMessage(this.ivRandomAccessFile, this.ivHeader);
            if (this.tc.isEventEnabled()) {
                String a = Integer.toHexString(this.ivFirstMessage);
                Tr.event(this.tc, "Ctor Message processing will begin at location " + a);
            }
            this.ivCurMessage = this.ivFirstMessage;
            this.ivUsable = true;
        }
        catch (Throwable t) {
            this.ivUsable = false;
            this.deleteTemporaryFile(this.ivRandomAccessFile, this.ivFile);
            throw new RasException(t);
        }
    }

    WsLogRecord getNextMessage() throws IOException {
        if (!this.ivUsable || this.ivCurMessage == -1) {
            return null;
        }
        try {
            if (this.ivLogProcessingComplete) {
                if (this.ivFileSizeMismatch != null) {
                    WsLogRecord e = this.ivFileSizeMismatch;
                    this.ivFileSizeMismatch = null;
                    return e;
                }
                if (this.ivMessagesToProcess != 0) {
                    Integer i = new Integer(this.ivMessagesToProcess);
                    this.ivMessagesToProcess = 0;
                    WsLogRecord e = WsLogRecordFactory.createWsLogRecord(null, Level.SEVERE, "MSG_CORRUPT_MESSAGE_COUNT", new Object[]{i}, svClassName, "getNextMessage", rbName, null, null, null, null, null, null, Level.ALL.intValue(), this.tc.getName());
                    return e;
                }
                this.ivUsable = false;
                return null;
            }
            byte[] msg = this.retrieveMessage(this.ivRandomAccessFile, this.ivHeader, this.ivCurMessage);
            if (msg != null) {
                this.ivCurMessage = this.incrementAndWrapLocation(this.ivHeader, this.ivCurMessage, msg.length + 12);
                if (this.ivCurMessage <= this.ivFirstMessage) {
                    this.ivWrapped = true;
                }
            } else {
                this.ivCurMessage = this.findNextMessage(this.ivRandomAccessFile, this.ivHeader, this.ivCurMessage);
                if (this.ivCurMessage != -1) {
                    if (this.ivCurMessage <= this.ivFirstMessage) {
                        this.ivWrapped = true;
                    }
                    if (!this.ivWrapped || this.ivCurMessage < this.ivFirstMessage) {
                        msg = this.retrieveMessage(this.ivRandomAccessFile, this.ivHeader, this.ivCurMessage);
                        this.ivCurMessage = this.incrementAndWrapLocation(this.ivHeader, this.ivCurMessage, msg.length + 12);
                        if (this.ivCurMessage <= this.ivFirstMessage) {
                            this.ivWrapped = true;
                        }
                    }
                }
            }
            if (msg == null) {
                this.ivLogProcessingComplete = true;
                this.deleteTemporaryFile(this.ivRandomAccessFile, this.ivFile);
                if (this.ivFileSizeMismatch != null) {
                    WsLogRecord e = this.ivFileSizeMismatch;
                    this.ivFileSizeMismatch = null;
                    return e;
                }
                if (this.ivMessagesToProcess != 0) {
                    Integer i = new Integer(this.ivMessagesToProcess);
                    this.ivMessagesToProcess = 0;
                    WsLogRecord e = WsLogRecordFactory.createWsLogRecord(null, Level.SEVERE, "MSG_CORRUPT_MESSAGE_COUNT", new Object[]{i}, svClassName, "getNextMessage", rbName, null, null, null, null, null, null, Level.ALL.intValue(), this.tc.getName());
                    return e;
                }
                this.ivUsable = false;
                return null;
            }
            if (this.ivWrapped && this.ivCurMessage >= this.ivFirstMessage) {
                this.ivLogProcessingComplete = true;
                this.deleteTemporaryFile(this.ivRandomAccessFile, this.ivFile);
            }
            --this.ivMessagesToProcess;
            WsLogRecord event2 = this.getMessageEventFromByteArray(msg);
            return event2;
        }
        catch (IOException ioe) {
            this.ivUsable = false;
            this.deleteTemporaryFile(this.ivRandomAccessFile, this.ivFile);
            throw ioe;
        }
        catch (Throwable t) {
            this.ivUsable = false;
            this.deleteTemporaryFile(this.ivRandomAccessFile, this.ivFile);
            throw new IOException("Throwable occurred in SharedLogReader" + RasHelper.throwableToString(t));
        }
    }

    private WsLogRecord getMessageEventFromByteArray(byte[] eventData) throws IOException {
        ByteArrayInputStream myBais = new ByteArrayInputStream(eventData);
        DataInputStream myDis = new DataInputStream(myBais);
        return WsLogRecordHelper.readEventFromStream(myDis);
    }

    private byte[] retrieveMessage(RandomAccessFile file, SharedLogHeader header, int location) throws IOException {
        if (this.tc.isDebugEnabled()) {
            Tr.debug(this.tc, "retrieveMessage - retrieving message at location " + Integer.toHexString(location));
        }
        if (!this.checkForPattern(file, header, location, svEntryHeader)) {
            return null;
        }
        int nextFieldLocation = this.incrementAndWrapLocation(header, location, svEntryHeader.length);
        int blockSize = this.readBlockSize(file, header, nextFieldLocation);
        if (blockSize == 0) {
            return null;
        }
        if (!this.checkForPattern(file, header, nextFieldLocation = this.incrementAndWrapLocation(header, nextFieldLocation, 4 + blockSize), svEntryTrailer)) {
            return null;
        }
        byte[] messageData = new byte[blockSize];
        location = this.incrementAndWrapLocation(header, location, 8);
        this.fillBuffer(file, header, location, messageData);
        return messageData;
    }

    private int findFirstMessage(RandomAccessFile file, SharedLogHeader header) throws IOException {
        if (this.ivTrueFileSize - SharedLogHeader.DATA_AREA_OFFSET <= 12) {
            return -1;
        }
        if (!header.ivFileWrapped) {
            return this.findNextMessage(file, header, SharedLogHeader.DATA_AREA_OFFSET);
        }
        return this.findNextMessage(file, header, this.ivHeader.ivFreeSpace);
    }

    private int findNextMessage(RandomAccessFile file, SharedLogHeader header, int location) throws IOException {
        int bytesToProcess = this.ivTrueFileSize - SharedLogHeader.DATA_AREA_OFFSET;
        byte[] buffer = new byte[1003];
        int fullChunks = bytesToProcess / 1000;
        int partialChunkSize = bytesToProcess % 1000;
        if (partialChunkSize < 3) {
            partialChunkSize += 1000;
            --fullChunks;
        }
        int curLocation = location;
        for (int i = fullChunks; i > 0; --i) {
            this.fillBuffer(file, header, curLocation, buffer);
            int messageLocation = this.findMessageInBuffer(file, header, buffer, curLocation);
            if (messageLocation != -1) {
                return messageLocation;
            }
            curLocation = this.incrementAndWrapLocation(header, curLocation, 1000);
        }
        buffer = new byte[partialChunkSize];
        this.fillBuffer(file, header, curLocation, buffer);
        return this.findMessageInBuffer(file, header, buffer, curLocation);
    }

    private int findMessageInBuffer(RandomAccessFile file, SharedLogHeader header, byte[] buffer, int location) throws IOException {
        boolean bufferExhausted = false;
        int bufferOffset = -1;
        while (!bufferExhausted) {
            if ((bufferOffset = this.findFirstPatternInBuffer(buffer, svEntryHeader, bufferOffset + 1)) == -1) {
                return -1;
            }
            int physicalLocation = this.incrementAndWrapLocation(header, location, bufferOffset);
            if (!this.checkForMessage(file, header, physicalLocation)) continue;
            return physicalLocation;
        }
        return -1;
    }

    private int findFirstPatternInBuffer(byte[] buffer, byte[] pattern, int start) {
        int patternLength = pattern.length;
        int last = buffer.length - patternLength;
        if (last < start) {
            return -1;
        }
        for (int i = start; i <= last; ++i) {
            if (buffer[i] != pattern[0]) continue;
            boolean patternMatches = true;
            int j = i + 1;
            for (int k = 1; k < patternLength && patternMatches; ++k) {
                if (buffer[j] != pattern[k]) {
                    patternMatches = false;
                }
                ++j;
            }
            if (!patternMatches) continue;
            return i;
        }
        return -1;
    }

    private boolean checkForMessage(RandomAccessFile file, SharedLogHeader header, int location) throws IOException {
        if (this.tc.isDebugEnabled()) {
            Tr.debug(this.tc, "checkForMessage checking location " + Integer.toHexString(location));
        }
        if (!this.checkForPattern(file, header, location, svEntryHeader)) {
            if (this.tc.isEventEnabled()) {
                String a = Integer.toHexString(location);
                Tr.event(this.tc, "checkForMessage did not find a valid header at location " + a);
            }
            return false;
        }
        int nextLocation = this.incrementAndWrapLocation(header, location, svEntryHeader.length);
        int blockSize = this.readBlockSize(file, header, nextLocation);
        if (blockSize == 0) {
            if (this.tc.isEventEnabled()) {
                String a = Integer.toHexString(nextLocation);
                Tr.event(this.tc, "checkForMessage found invalid blocksize at location " + a);
            }
            return false;
        }
        if (!this.checkForPattern(file, header, nextLocation = this.incrementAndWrapLocation(header, nextLocation, 4 + blockSize), svEntryTrailer)) {
            if (this.tc.isEventEnabled()) {
                String a = Integer.toHexString(location);
                Tr.event(this.tc, "checkForMessage message at location " + a + " is corrupted");
            }
            return false;
        }
        return true;
    }

    private void fillBuffer(RandomAccessFile file, SharedLogHeader header, int start, byte[] buffer) throws IOException {
        if (this.tc.isDebugEnabled()) {
            String a = Integer.toHexString(buffer.length);
            String b = Integer.toHexString(start);
            Tr.debug(this.tc, "fillBuffer - reading " + a + " bytes from " + b);
        }
        file.seek(start);
        int bytesToRead = buffer.length;
        if (this.ivTrueFileSize - start >= bytesToRead) {
            file.readFully(buffer, 0, bytesToRead);
        } else {
            String b;
            String a;
            int firstHalfSize = this.ivTrueFileSize - start;
            int secondHalfSize = bytesToRead - firstHalfSize;
            if (this.tc.isDebugEnabled()) {
                a = Integer.toHexString(firstHalfSize);
                b = Integer.toHexString(start);
                Tr.debug(this.tc, "fillBuffer - firstHalf reading " + a + " bytes from location " + b);
            }
            file.readFully(buffer, 0, firstHalfSize);
            file.seek(SharedLogHeader.DATA_AREA_OFFSET);
            if (this.tc.isDebugEnabled()) {
                a = Integer.toHexString(secondHalfSize);
                b = Integer.toHexString(SharedLogHeader.DATA_AREA_OFFSET);
                Tr.debug(this.tc, "fillBuffer - 2nd read " + a + " bytes from location " + b);
            }
            file.readFully(buffer, firstHalfSize, secondHalfSize);
        }
    }

    private boolean checkForPattern(RandomAccessFile file, SharedLogHeader header, int location, byte[] pattern) throws IOException {
        byte[] buffer = new byte[pattern.length];
        this.fillBuffer(file, header, location, buffer);
        int length = pattern.length;
        for (int i = length - 1; i >= 0; --i) {
            if (buffer[i] == pattern[i]) continue;
            if (this.tc.isDebugEnabled()) {
                String a = RasHelper.byteArrayToHexString(pattern);
                String b = Integer.toHexString(location);
                String c = RasHelper.byteArrayToHexString(buffer);
                Tr.debug(this.tc, "checkForPattern - checking for pattern " + a + " at location " + b + " failed, found pattern " + c);
            }
            return false;
        }
        return true;
    }

    private synchronized int readBlockSize(RandomAccessFile file, SharedLogHeader header, int location) throws IOException {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "readBlockSize", "reading blockSize from location " + Integer.toHexString(location));
        }
        int blockSize = -1;
        this.fillBuffer(file, header, location, this.ivBlockSizeBuffer);
        this.ivBlockSizeBais.reset();
        blockSize = this.ivBlockSizeDis.readInt();
        if (blockSize < 1 || blockSize + 12 > header.ivMaxSize) {
            blockSize = 0;
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "readBlockSize", "returning blockSize = " + Integer.toHexString(blockSize));
        }
        return blockSize;
    }

    private final int incrementAndWrapLocation(SharedLogHeader header, int location, int offset) {
        int newLocation = location + offset;
        if (newLocation >= this.ivTrueFileSize) {
            return newLocation - this.ivTrueFileSize + SharedLogHeader.DATA_AREA_OFFSET;
        }
        return newLocation;
    }

    private int countMessages(RandomAccessFile file, SharedLogHeader header) throws Exception {
        int headers = this.countPatternOccurrencesInFile(file, header, SharedLogConstants.svEntryHeader);
        int trailers = this.countPatternOccurrencesInFile(file, header, SharedLogConstants.svEntryTrailer);
        if (this.tc.isEventEnabled()) {
            Tr.event(this.tc, "countMessages counted " + headers + " headers in the file");
            Tr.event(this.tc, "countMessages counted " + trailers + " trailers in the file");
        }
        if (headers <= trailers) {
            return headers;
        }
        return trailers;
    }

    private int countPatternOccurrencesInFile(RandomAccessFile file, SharedLogHeader header, byte[] pattern) throws IOException {
        int bytesToProcess = this.ivTrueFileSize - SharedLogHeader.DATA_AREA_OFFSET;
        int curLocation = !header.ivFileWrapped ? SharedLogHeader.DATA_AREA_OFFSET : header.ivFreeSpace;
        int patternLength = pattern.length;
        if (bytesToProcess < patternLength) {
            return 0;
        }
        int bufferSize = 1000;
        if (patternLength >= 1000) {
            bufferSize = 3 * patternLength;
        }
        int fullChunks = bytesToProcess / bufferSize;
        int partialChunkSize = bytesToProcess % bufferSize;
        byte[] buffer = new byte[bufferSize + patternLength - 1];
        if (partialChunkSize < patternLength) {
            partialChunkSize += bufferSize;
            --fullChunks;
        }
        int result = 0;
        for (int i = fullChunks; i > 0; --i) {
            this.fillBuffer(file, header, curLocation, buffer);
            result += this.countPatternOccurrencesInBuffer(buffer, pattern);
            curLocation = this.incrementAndWrapLocation(header, curLocation, bufferSize);
        }
        if (partialChunkSize != 0) {
            buffer = new byte[partialChunkSize];
            this.fillBuffer(file, header, curLocation, buffer);
            result += this.countPatternOccurrencesInBuffer(buffer, pattern);
        }
        return result;
    }

    private int countPatternOccurrencesInBuffer(byte[] buffer, byte[] pattern) {
        int patternLength = pattern.length;
        int last = buffer.length - patternLength;
        int start = 0;
        if (last < start) {
            return 0;
        }
        int result = 0;
        for (int i = start; i <= last; ++i) {
            if (buffer[i] != pattern[0]) continue;
            boolean patternMatches = true;
            int j = i + 1;
            for (int k = 1; k < patternLength && patternMatches; ++k) {
                if (buffer[j] != pattern[k]) {
                    patternMatches = false;
                }
                ++j;
            }
            if (!patternMatches) continue;
            ++result;
        }
        return result;
    }

    private String locateFile(String fileName) throws RasException {
        if (fileName == null) {
            throw new RasException("Null passed as the file name");
        }
        File logFile = new File(fileName);
        if (logFile.isAbsolute()) {
            if (!RasHelper.fileExists(logFile)) {
                throw new RasException("File " + fileName + " does not exist");
            }
            return logFile.getPath();
        }
        logFile = new File(RasProperties.getDefaultLoggingDirectory() + File.separator + fileName);
        if (RasHelper.fileExists(logFile)) {
            return logFile.getPath();
        }
        logFile = new File("." + File.separator + fileName);
        if (RasHelper.fileExists(logFile)) {
            return logFile.getPath();
        }
        throw new RasException("File " + fileName + " does not exist");
    }

    private void copySharedLog(String fileName, boolean holdsLock) throws RasException {
        File lockFile = new File(fileName + ".lck");
        boolean acquiredLock = false;
        try {
            if (holdsLock) {
                this.ivFile = this.copyLogFile(fileName);
            } else {
                SharedLogReader.acquireHostLock(lockFile);
                acquiredLock = true;
                this.ivFile = this.copyLogFile(fileName);
                SharedLogReader.releaseHostLock(lockFile);
                acquiredLock = false;
            }
        }
        catch (Throwable t) {
            if (acquiredLock) {
                SharedLogReader.releaseHostLock(lockFile);
            }
            throw new RasException("Exception copying shared log file", t);
        }
    }
}

