/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

class SharedLogHeader {
    public static final int svHeaderVersion = 1;
    static String svEyeCatcher = "Websphere Activity Log";
    static String svUnknownOs = "Unknown OS";
    static String svUnknownHost = "Unknown Host";
    static final int HEADER_MIN_SIZE = 12;
    static final int HEADER_MAX_SIZE = 4096;
    private static ByteArrayOutputStream baos = null;
    private static DataOutputStream dos = null;
    private static ByteArrayInputStream bais = null;
    private static DataInputStream dis = null;
    private static byte[] readBuffer = null;
    static int svHeaderLength = -1;
    private static final int LENGTH_OFFSET = 0;
    static final int HEADER_OFFSET = 4;
    static int DATA_AREA_OFFSET;
    int ivHeaderVersion;
    int ivMaxSize;
    int ivFreeSpace;
    boolean ivFileWrapped;
    String ivEyeCatcher;
    String ivOsVersionId;
    String ivHostName;

    SharedLogHeader(RandomAccessFile file, int maxLength) throws IOException {
        baos = new ByteArrayOutputStream();
        dos = new DataOutputStream(baos);
        this.ivHeaderVersion = 1;
        this.ivMaxSize = maxLength;
        this.ivFreeSpace = -1;
        this.ivFileWrapped = false;
        this.ivEyeCatcher = svEyeCatcher;
        this.ivOsVersionId = RasHelper.getSystemProperty("os.name");
        if (this.ivOsVersionId == null) {
            this.ivOsVersionId = svUnknownOs;
        }
        try {
            this.ivHostName = RasHelper.getHostName();
        }
        catch (RasException pae) {
            this.ivHostName = svUnknownHost;
        }
        byte[] externalizedHeader = this.externalizeHeader();
        if (externalizedHeader.length > 4096) {
            this.ivOsVersionId = svUnknownOs;
            this.ivHostName = svUnknownHost;
            externalizedHeader = this.externalizeHeader();
            if (externalizedHeader.length > 4096) {
                throw new IOException("Cannot create Header, size is too large");
            }
        }
        svHeaderLength = externalizedHeader.length;
        DATA_AREA_OFFSET = this.ivFreeSpace = 4 + svHeaderLength;
        readBuffer = new byte[svHeaderLength];
        bais = new ByteArrayInputStream(readBuffer);
        dis = new DataInputStream(bais);
        file.seek(0L);
        file.writeInt(svHeaderLength);
        this.writeHeader(file);
    }

    SharedLogHeader(RandomAccessFile file) throws IOException {
        if (svHeaderLength == -1) {
            file.seek(0L);
            int length = file.readInt();
            if (length < 12 || length > 4096) {
                throw new IOException("Header size is invalid - log file is corrupted");
            }
            svHeaderLength = length;
            DATA_AREA_OFFSET = 4 + svHeaderLength;
            readBuffer = new byte[svHeaderLength];
            bais = new ByteArrayInputStream(readBuffer);
            dis = new DataInputStream(bais);
            baos = new ByteArrayOutputStream();
            dos = new DataOutputStream(baos);
        }
        file.seek(4L);
        file.readFully(readBuffer);
        bais.reset();
        this.ivHeaderVersion = dis.readInt();
        this.ivMaxSize = dis.readInt();
        this.ivFreeSpace = dis.readInt();
        this.ivFileWrapped = dis.readBoolean();
        this.ivEyeCatcher = dis.readUTF();
        this.ivOsVersionId = dis.readUTF();
        this.ivHostName = dis.readUTF();
    }

    private byte[] externalizeHeader() throws IOException {
        baos.reset();
        dos.writeInt(this.ivHeaderVersion);
        dos.writeInt(this.ivMaxSize);
        dos.writeInt(this.ivFreeSpace);
        dos.writeBoolean(this.ivFileWrapped);
        dos.writeUTF(this.ivEyeCatcher);
        dos.writeUTF(this.ivOsVersionId);
        dos.writeUTF(this.ivHostName);
        return baos.toByteArray();
    }

    void writeHeader(RandomAccessFile file) throws IOException {
        byte[] externalizedHeader = this.externalizeHeader();
        file.seek(4L);
        file.write(externalizedHeader);
    }
}

