/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.CBuffLogger;
import com.ibm.ejs.ras.ComponentManager;
import com.ibm.ejs.ras.ExtendedMalformedTraceStringException;
import com.ibm.ejs.ras.ExtendedTraceLogger;
import com.ibm.ejs.ras.MalformedTraceStringException;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.RasProperties;
import com.ibm.ejs.ras.SharedLogWriter;
import com.ibm.ejs.ras.SystemErrStream;
import com.ibm.ejs.ras.SystemOutStream;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceElement;
import com.ibm.ejs.ras.TraceLogger;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.ras.WrappingFileOutputStream;
import com.ibm.ejs.ras.WsHandlerManager;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.websphere.ras.TraceElementState;
import com.ibm.ws.bootstrap.WSLauncher;
import com.ibm.ws.bootstrap.WsLogManager;
import com.ibm.ws.logging.LevelConstants;
import com.ibm.ws.logging.WsHandler;
import com.ibm.ws.logging.ZRasHelper;
import com.ibm.ws.logging.cbe.CBEWsHandlerAdapter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import java.util.logging.LogRecord;

public class ManagerAdmin {
    private static String classname = ManagerAdmin.class.getName();
    private static TraceComponent svTc = Tr.register(classname, null, "com.ibm.ejs.resources.RasMessages");
    static final byte DUMP = 0;
    public static final byte DEBUG = 1;
    public static final byte ENTRY_EXIT = 2;
    public static final byte EVENT = 4;
    public static final byte ALL = 7;
    public static final String BASIC = "basic";
    public static final String ADVANCED = "advanced";
    public static final String LOGANALYZER = "loganalyzer";
    public static final String SPECIFIED_FILE = "SPECIFIED_FILE";
    public static final String stdout = "stdout";
    public static final String file = "named file";
    public static final String ringBuffer = "ringbuffer";
    public static final String nullOutput = "null";
    public static final int RING_BUFFER_MIN_SIZE = 1;
    public static final int RING_BUFFER_DEFAULT_SIZE = 8;
    public static final int SERVICE_LOG_MIN_SIZE = 2;
    public static final int SERVICE_LOG_DEFAULT_SIZE = 1024;
    public static final int SERVICE_LOG_MAX_SIZE = 0x100000;
    public static final String none = "NONE";
    public static final String audit = "AUDIT";
    public static final String service = "SERVICE";
    public static final String warning = "WARNING";
    public static final String sysOut = "SystemOut";
    public static final String sysErr = "SystemErr";
    static final String enabled = "enabled";
    static final String disabled = "disabled";
    private static final String svBundle = "com.ibm.ejs.resources.RasMessages";
    private static final long MEGABYTE = 0x100000L;
    private static boolean svTracingToFile;
    static boolean svTraceEnabled;
    private static CBuffLogger svCbuff;
    private static TraceLogger svTraceFileListener;
    private static String svTraceFileName;
    private static long svRolloverSize;
    private static int svMaxBackups;
    private static WrappingFileOutputStream svTraceFileStream;
    private static boolean svHeaderPrinted;
    private static boolean svTraceConfigured;
    private static boolean svLoggingConfigured;
    private static boolean svThinClient;
    private static boolean svTCSet;

    private ManagerAdmin() {
    }

    public static String getRuntimeConfig() {
        StringBuffer sb = new StringBuffer();
        sb.append("<TraceRuntime ");
        sb.append("tracingToFile=\"").append(svTracingToFile ? "true" : "false").append("\" ");
        sb.append("traceEnabled=\"").append(svTraceEnabled ? "true" : "false").append("\" ");
        sb.append("traceFileName=\"").append(svTraceFileName == null ? nullOutput : svTraceFileName).append("\" ");
        sb.append("rolloverSize=\"").append(svRolloverSize / 0x100000L).append("\" ");
        sb.append("maxBackups=\"").append(svMaxBackups).append("\" ");
        sb.append("traceFormat=\"").append(RasProperties.getTraceFormatProperty()).append("\" ");
        sb.append("/>");
        return sb.toString();
    }

    public static synchronized void configureMessageLogging(boolean serviceLogEnabled, String serviceLogName, int serviceLogSize, String messageFilterLevel, boolean enableCorrelationId) {
        if (!RasHelper.isServer()) {
            return;
        }
        if (svLoggingConfigured) {
            return;
        }
        svLoggingConfigured = true;
        RasProperties.setMessageFilterLevelProperty(messageFilterLevel);
        RasProperties.setUnitOfWorkProperty(enableCorrelationId);
        if (WSLauncher.isZOS() && !ManagerAdmin.isThinClient()) {
            ZRasHelper.initNative();
        } else if (!serviceLogEnabled) {
            Tr.audit(svTc, "MSG_SHARED_LOG_DISABLED");
        } else {
            try {
                RasProperties.setActivityLogName(serviceLogName);
                RasProperties.setActivityLogSize(serviceLogSize);
                try {
                    SharedLogWriter activityLog = SharedLogWriter.getInstance();
                    if (activityLog != null) {
                        Tr.addWsHandler(new CBEWsHandlerAdapter(activityLog, true, WsLevel.DETAIL, WsLevel.DETAIL));
                    }
                }
                catch (Throwable t) {}
            }
            catch (RasException re2) {
                Tr.error(svTc, "MSG_SHARED_LOG_CTOR_FAILED", new Object[]{serviceLogName, re2});
            }
        }
    }

    public static synchronized void configureServerTrace(String traceSpec, String traceOutput, String fileName, long rollover, int maxBackups, int ringBufferSize, String traceFormat) {
        if (!RasHelper.isServer()) {
            return;
        }
        if (svTraceConfigured) {
            return;
        }
        svTraceConfigured = true;
        if (!WsLogManager.isConfigureByLoggingProperties()) {
            Tr.getComponentManager().processTraceString(traceSpec, true);
        }
        traceFormat = RasProperties.setTraceFormatProperty(traceFormat);
        svTraceEnabled = ComponentManager.svTraceEnabled;
        if (traceOutput.equals(file)) {
            ManagerAdmin.addServerTraceFileListener(fileName, rollover, maxBackups);
        } else if (traceOutput.equals(ringBuffer)) {
            ManagerAdmin.addServerRingBufferListener(ringBufferSize);
        }
        Tr.getComponentManager().checkAndSetORBRasLogging();
    }

    protected static void initialTraceHeader() {
        Tr.info(svTc, "MSG_INITIAL_TRACE_STATE", Tr.getComponentManager().getTraceSpecification());
        if (!TraceNLS.isMessageIdConversionEnabled()) {
            Tr.info(svTc, "DEPRECATED_MESSAGE_IDS");
        }
    }

    public static synchronized void configureClientTrace(String traceSpec, String traceOutput, String fileName, boolean truncateTraceFile, String traceFormat, boolean enableCorrelationId) {
        ManagerAdmin.configureClientTrace(traceSpec, traceOutput, fileName, truncateTraceFile, traceFormat, enableCorrelationId, true);
    }

    public static synchronized void configureClientTrace(String traceSpec, String traceOutput, String fileName, boolean truncateTraceFile, String traceFormat, boolean enableCorrelationId, boolean printHeader) {
        block9: {
            if (RasHelper.isServer()) {
                return;
            }
            if (svTraceConfigured) {
                return;
            }
            svTraceConfigured = true;
            if (!WsLogManager.isConfigureByLoggingProperties()) {
                Tr.getComponentManager().processTraceString(traceSpec, true);
            }
            traceFormat = RasProperties.setTraceFormatProperty(traceFormat);
            RasProperties.setUnitOfWorkProperty(enableCorrelationId);
            try {
                if (traceOutput.equals(file)) {
                    ManagerAdmin.openClientTraceFile(fileName, truncateTraceFile, printHeader);
                } else {
                    TraceLogger tl = ManagerAdmin.createListener(Tr.getSystemOut());
                    if (printHeader) {
                        tl.printHeader();
                    }
                    Tr.addWsHandler(tl);
                    svTracingToFile = false;
                }
            }
            catch (Throwable t) {
                TraceLogger tl = ManagerAdmin.createListener(Tr.getSystemOut());
                if (printHeader) {
                    tl.printHeader();
                }
                Tr.addWsHandler(tl);
                svTracingToFile = false;
                if (traceOutput == null || !traceOutput.equals(file)) break block9;
                Tr.error(svTc, "MSG_OPEN_TRACE_FILE_FAILED", new Object[]{fileName, t});
                Tr.info(svTc, "MSG_TRACE_TO_SYSOUT");
            }
        }
        Tr.getComponentManager().checkAndSetORBRasLogging();
        Tr.info(svTc, "MSG_INITIAL_TRACE_STATE", Tr.getComponentManager().getTraceSpecification());
    }

    public static void addJmxListener(WsHandler listener) throws RasException {
        if (listener == null) {
            throw new RasException("A null JMX listener is not allowed");
        }
        Tr.addJmxListener(listener);
    }

    public static void setWsHandlerManager(WsHandlerManager wsHandlerManager) {
        Tr.setWsHandlerManager(wsHandlerManager);
    }

    public static String getTraceFileName() {
        if (svTracingToFile) {
            return svTraceFileName;
        }
        return null;
    }

    public static boolean containsRASHeader(String filename) {
        if (filename == null) {
            return false;
        }
        return RasHelper.containsRasHeader(filename);
    }

    public static String getTraceSpecification() {
        return Tr.getComponentManager().getTraceSpecification();
    }

    public static String getTraceSpecification(String component2) {
        return Tr.getComponentManager().getTraceSpecification(component2);
    }

    public static void setTraceState(String traceString) {
        Tr.getComponentManager().processTraceString(traceString, true);
        ManagerAdmin.processTraceStateChanged();
        Tr.info(svTc, "MSG_TRACE_STATE_CHANGED", Tr.getComponentManager().getTraceSpecification());
        if (svCbuff != null) {
            Tr.info(svTc, "MSG_RING_BUFFER_STATUS", String.valueOf(svCbuff.getSize() * 1024));
        }
    }

    public static void appendTraceString(String traceString) {
        Tr.getComponentManager().processTraceString(traceString, false);
        ManagerAdmin.processTraceStateChanged();
        Tr.info(svTc, "MSG_TRACE_STATE_CHANGED", Tr.getComponentManager().getTraceSpecification());
        if (svCbuff != null) {
            Tr.info(svTc, "MSG_RING_BUFFER_STATUS", String.valueOf(svCbuff.getSize() * 1024));
        }
    }

    public static synchronized int getRingBufferSize() {
        if (svCbuff == null) {
            return 0;
        }
        return svCbuff.getSize();
    }

    public static synchronized void setRingBufferSize(int size) {
        if (svCbuff == null) {
            return;
        }
        svCbuff.setSize(size);
        Tr.info(svTc, "MSG_RING_BUFFER_STATUS", String.valueOf(svCbuff.getSize() * 1024));
    }

    public static void dumpRingBuffer(String fileToWriteTo) {
        if (svCbuff == null) {
            try {
                ManagerAdmin.dumpEmptyBuffer(fileToWriteTo);
            }
            catch (RasException ex) {
                Tr.warning(svTc, "MSG_UNABLE_TO_DUMP_RING_BUFFER", new Object[]{fileToWriteTo, nullOutput, ex, ""});
            }
            return;
        }
        try {
            svCbuff.dump(fileToWriteTo, false);
        }
        catch (RasException re2) {
            String defaultDumpFileName = null;
            try {
                defaultDumpFileName = RasHelper.getDefaultDumpFileName();
                svCbuff.dump(defaultDumpFileName, true);
                Tr.info(svTc, "MSG_DUMPED_TO_DEFAULT_LOCATION", new Object[]{fileToWriteTo, defaultDumpFileName});
            }
            catch (RasException re22) {
                Tr.warning(svTc, "MSG_UNABLE_TO_DUMP_RING_BUFFER", new Object[]{fileToWriteTo, defaultDumpFileName, re2, re22});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpEmptyBuffer(String fileToWriteTo) throws RasException {
        OutputStream fs = null;
        try {
            RasHelper.validateFileName(fileToWriteTo.trim());
            fs = RasHelper.createFileOutputStream(fileToWriteTo, false);
            TraceLogger logger = null;
            logger = RasProperties.svTraceFormat.equals(LOGANALYZER) ? new ExtendedTraceLogger(fs) : (RasProperties.svTraceFormat.equals(ADVANCED) ? new TraceLogger(fs, false) : new TraceLogger(fs, true));
            logger.printHeader();
            LogRecord lr = new LogRecord(WsLevel.FINE, "Ring Buffer tracing has been disabled. Nothing to dump.");
            lr.setLoggerName(ManagerAdmin.svTc.ivName);
            logger.processEvent(lr);
        }
        finally {
            try {
                fs.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void clearRingBuffer() {
        if (svCbuff != null) {
            svCbuff.clear();
        }
    }

    public static String[] listAllRegisteredComponents() {
        return Tr.getComponentManager().getComponents();
    }

    public static String[] listAllRegisteredGroups() {
        return Tr.getComponentManager().getGroups();
    }

    public static String[] listComponentsInGroup(String group) {
        return Tr.getComponentManager().getGroupComponents(group);
    }

    public static TraceElementState[] getTracedComponents() {
        Vector elements = Tr.getComponentManager().getTracedComponents();
        int size = elements.size();
        TraceElementState[] results = new TraceElementState[size];
        for (int i = 0; i < size; ++i) {
            TraceElementState tes;
            TraceElement te = (TraceElement)elements.elementAt(i);
            results[i] = tes = new TraceElementState(te);
        }
        return results;
    }

    public static TraceElementState[] getTracedGroups() {
        Vector elements = Tr.getComponentManager().getTracedGroups();
        int size = elements.size();
        TraceElementState[] results = new TraceElementState[size];
        for (int i = 0; i < size; ++i) {
            TraceElementState tes;
            TraceElement te = (TraceElement)elements.elementAt(i);
            results[i] = tes = new TraceElementState(te);
        }
        return results;
    }

    public static void processDumpString(String dumpString) {
        Tr.getComponentManager().processDumpString(dumpString);
    }

    public static synchronized void setTraceOutputToFile(String fileName, long rollover, int maxBackups, String traceFormat) throws RasException {
        if (!svTraceConfigured) {
            throw new RasException("Trace must be configured before it can be changed");
        }
        traceFormat = RasProperties.setTraceFormatProperty(traceFormat);
        if (svTracingToFile) {
            ManagerAdmin.removeServerTraceFileListener();
        } else {
            ManagerAdmin.removeServerRingBufferListener();
        }
        ManagerAdmin.addServerTraceFileListener(fileName, rollover, maxBackups);
        svHeaderPrinted = false;
    }

    public static synchronized void setTraceOutputToRingBuffer(int ringBufferSize, String traceFormat) throws RasException {
        if (!svTraceConfigured) {
            throw new RasException("Trace must be configured before it can be changed");
        }
        traceFormat = RasProperties.setTraceFormatProperty(traceFormat);
        if (svTracingToFile) {
            ManagerAdmin.removeServerTraceFileListener();
            ManagerAdmin.addServerRingBufferListener(ringBufferSize);
        } else {
            ManagerAdmin.setRingBufferSize(ringBufferSize);
        }
    }

    public static void checkTraceString(String traceString) throws MalformedTraceStringException {
        Object msg = null;
        if ((traceString = RasHelper.peelQuotes(traceString)) == null) {
            return;
        }
        if (traceString.equals("")) {
            throw new ExtendedMalformedTraceStringException(svBundle, "EXCEPTION_EMPTY_STRING_TRACESTRING", null, "Empty string is not part of trace string grammar");
        }
        String[] components = RasHelper.split(traceString, 58);
        String comp = null;
        for (int i = 0; i < components.length; ++i) {
            String typeList;
            if (components[i].equals("")) {
                throw new ExtendedMalformedTraceStringException(svBundle, "EXCEPTION_EMPTY_STRING_SUBTRACESTRING", null, "empty string encountered - remove extra colon");
            }
            int endCompNameIndex = components[i].indexOf(61);
            if (endCompNameIndex == -1) {
                throw new ExtendedMalformedTraceStringException(svBundle, "EXCEPTION_NO_VALUE_PAIRS", new Object[]{components[i]}, "No type=state value pair(s) found at ''{0}''");
            }
            comp = components[i].substring(0, endCompNameIndex);
            if (comp.equals("")) {
                throw new ExtendedMalformedTraceStringException(svBundle, "EXCEPTION_NO_COMPONENT_NAME", new Object[]{components[i]}, "No component name found at ''{0}''");
            }
            if ((typeList = components[i].substring(++endCompNameIndex)).equals("")) {
                throw new ExtendedMalformedTraceStringException(svBundle, "EXCEPTION_NO_VALUE_PAIRS", new Object[]{components[i]}, "No type=state value pair(s) found at ''{0}''");
            }
            String[] types2 = RasHelper.split(typeList, 44);
            for (int j = 0; j < types2.length; ++j) {
                int level_number;
                String type;
                if (types2[j].equals("")) {
                    throw new ExtendedMalformedTraceStringException(svBundle, "EXCEPTION_MISSING_VALUE_PAIR", new Object[]{components[i]}, "Missing type=state value pair at ''{0}'', remove extra comma");
                }
                String[] pieces = RasHelper.split(types2[j], 61);
                if (pieces.length > 2) {
                    throw new ExtendedMalformedTraceStringException(svBundle, "EXCEPTION_INVALID_VALUE_PAIR", new Object[]{types2[j], components[i]}, "Invalid type=state value pair - ''{0}'' at ''{1}''");
                }
                if (pieces.length == 1) {
                    // empty if block
                }
                if ((type = pieces[0]).equals("")) {
                    throw new ExtendedMalformedTraceStringException(svBundle, "EXCEPTION_MISSING_TYPE", new Object[]{components[i]}, "Missing type value at ''{0}''");
                }
                for (level_number = 0; level_number < LevelConstants.NAMES.length && !type.toLowerCase().equals(LevelConstants.NAMES[level_number]); ++level_number) {
                }
                if (level_number == LevelConstants.NAMES.length) {
                    throw new ExtendedMalformedTraceStringException(svBundle, "EXCEPTION_INVALID_TYPE", new Object[]{type, components[i]}, "Invalid type value - ''{0}'' at ''{1}''");
                }
                if (pieces.length != 2) continue;
                String state = pieces[1];
                if (state.equals("")) {
                    throw new ExtendedMalformedTraceStringException(svBundle, "EXCEPTION_MISSING_STATE", new Object[]{components[i]}, "Missing state value at ''{0}''");
                }
                if (state.equalsIgnoreCase(enabled) || state.equalsIgnoreCase(disabled)) continue;
                throw new ExtendedMalformedTraceStringException(svBundle, "EXCEPTION_INVALID_STATE", new Object[]{state, components[i]}, "Invalid state value - ''{0}'' at ''{1}''");
            }
        }
    }

    public static synchronized void setMessageFilterLevel(String messageFilterLevel) {
        RasProperties.setMessageFilterLevelProperty(messageFilterLevel);
    }

    public static synchronized String getMessageFilterLevel() {
        return RasProperties.getMessageFilterLevelProperty();
    }

    public static String rolloverLogFileImmediate(String streamName, String fileName) throws RasException {
        if (streamName == null) {
            throw new RasException("invalid stream indicator of null specified");
        }
        if (streamName.equals(sysOut)) {
            return SystemOutStream.rolloverLogFileImmediate(fileName);
        }
        if (streamName.equals(sysErr)) {
            return SystemErrStream.rolloverLogFileImmediate(fileName);
        }
        throw new RasException("specified stream name of " + streamName + " is invalid or unsupported");
    }

    public static boolean isLogFileWriteable(String fileName) {
        try {
            RasHelper.validateFileName(fileName.trim());
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static TraceLogger createListener(OutputStream stream) {
        if (RasProperties.svTraceFormat.equalsIgnoreCase(LOGANALYZER)) {
            return new ExtendedTraceLogger(stream);
        }
        if (RasProperties.svTraceFormat.equalsIgnoreCase(ADVANCED)) {
            return new TraceLogger(stream, false);
        }
        return new TraceLogger(stream, true);
    }

    private static synchronized void addServerRingBufferListener(int size) {
        if (svCbuff != null) {
            return;
        }
        svCbuff = size < 1 ? new CBuffLogger(8) : new CBuffLogger(size);
        Tr.addWsHandler(svCbuff);
        svTracingToFile = false;
        Tr.info(svTc, "MSG_RING_BUFFER_STATUS", String.valueOf(svCbuff.getSize() * 1024));
    }

    private static synchronized void removeServerRingBufferListener() {
        if (svCbuff == null) {
            return;
        }
        Tr.removeWsHandler(svCbuff);
        svCbuff = null;
    }

    private static synchronized void addServerTraceFileListener(String fileName, long rollover, int maxBackups) {
        try {
            svTraceFileName = RasHelper.generateOutputFileName(fileName, "TraceFile", svTc);
        }
        catch (Throwable t) {
            Tr.error(svTc, "MSG_OPEN_TRACE_FILE_FAILED", new Object[]{fileName, t});
            Tr.info(svTc, "MSG_TRACE_TO_RING_BUFFER");
            ManagerAdmin.addServerRingBufferListener(8);
            svTracingToFile = false;
            return;
        }
        svRolloverSize = rollover;
        svMaxBackups = maxBackups;
        svTracingToFile = true;
        if (svTraceEnabled) {
            ManagerAdmin.openServerTraceFile();
        }
    }

    private static synchronized void removeServerTraceFileListener() {
        if (svTraceFileListener != null) {
            Tr.removeWsHandler(svTraceFileListener);
            svTraceFileListener = null;
        }
        ManagerAdmin.closeServerTraceFile();
    }

    private static synchronized void openServerTraceFile() {
        try {
            svTraceFileStream = new WrappingFileOutputStream(svTraceFileName, svMaxBackups, svRolloverSize);
            svTraceFileListener = ManagerAdmin.createListener(svTraceFileStream);
            svTraceFileStream.addRolloverListener(svTraceFileListener);
            if (!svHeaderPrinted) {
                svTraceFileListener.printHeader();
                svHeaderPrinted = true;
            }
            Tr.addWsHandler(svTraceFileListener);
        }
        catch (Throwable t) {
            Tr.error(svTc, "MSG_OPEN_TRACE_FILE_FAILED", new Object[]{svTraceFileName, t});
            Tr.info(svTc, "MSG_TRACE_TO_RING_BUFFER");
            ManagerAdmin.addServerRingBufferListener(8);
            svTracingToFile = false;
            svTraceFileListener = null;
            ManagerAdmin.closeServerTraceFile();
        }
    }

    private static synchronized void closeServerTraceFile() {
        if (svTraceFileStream != null) {
            try {
                svTraceFileStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            svTraceFileStream = null;
        }
    }

    private static synchronized void openClientTraceFile(String fileName, boolean truncate, boolean printHeader) throws RasException, IOException {
        svTraceFileName = fileName.trim();
        RasHelper.validateFileName(svTraceFileName);
        FileOutputStream stream = RasHelper.createFileOutputStream(svTraceFileName, !truncate);
        svTraceFileListener = ManagerAdmin.createListener(stream);
        if (printHeader) {
            svTraceFileListener.printHeader();
        }
        Tr.addWsHandler(svTraceFileListener);
        svTracingToFile = true;
    }

    private static synchronized void processTraceStateChanged() {
        if (svTraceEnabled == ComponentManager.svTraceEnabled) {
            return;
        }
        if (!svTraceConfigured) {
            return;
        }
        if (RasHelper.isServer() && svTracingToFile) {
            if (svTraceEnabled) {
                Tr.event(svTc, "Writing the trace output to the trace file has been turned off.");
                ManagerAdmin.removeServerTraceFileListener();
            } else {
                Tr.event(svTc, "Writing the trace output to the trace file has been turned on.");
                ManagerAdmin.openServerTraceFile();
            }
        }
        svTraceEnabled = ComponentManager.svTraceEnabled;
    }

    public static Vector parseLoggingSpecString(String loggingSpec, boolean reset) {
        return Tr.getComponentManager().parseLoggingSpec(loggingSpec, reset);
    }

    public static synchronized boolean isThinClient() {
        if (svTCSet) {
            return svThinClient;
        }
        svThinClient = Boolean.getBoolean("com.ibm.websphere.thinclient");
        svTCSet = true;
        return svThinClient;
    }

    static {
        svTraceEnabled = false;
        svCbuff = null;
        svTraceFileListener = null;
        svTraceFileName = null;
        svTraceFileStream = null;
        svHeaderPrinted = false;
        svTraceConfigured = false;
        svLoggingConfigured = false;
        svThinClient = false;
        svTCSet = false;
    }
}

