/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.Dumpable;
import com.ibm.ejs.ras.Group;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceElement;
import com.ibm.ejs.ras.TraceEnableEvent;
import com.ibm.ws.bootstrap.WsLogManager;
import com.ibm.ws.logging.LevelConstants;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.LogManager;

class ComponentManager {
    private static final char ELEMENT_DELIMITER = '=';
    private static final char LEVEL_DELIMITER = ',';
    private static final char COMPONENT_DELIMITER = ':';
    private static final String FLAG_LEVEL_ENABLED = "enabled";
    private static final String FLAG_LEVEL_DISABLED = "disabled";
    private static final String LOGGING_SPEC_TOKENS = new String(new char[]{'=', ',', ':'});
    static boolean svTraceEnabled = false;
    private static Hashtable traceTypeMap = new Hashtable();
    private Hashtable components = new Hashtable();
    private Hashtable groups = new Hashtable();
    private Hashtable dumpables;
    private Vector traceEnableEvents = new Vector();
    private static LogManager wslm;

    ComponentManager() {
        this.dumpables = new Hashtable();
    }

    synchronized String[] getGroups() {
        String[] result = null;
        result = new String[this.groups.size()];
        Enumeration vEnum = this.groups.keys();
        int i = 0;
        while (vEnum.hasMoreElements()) {
            result[i++] = (String)vEnum.nextElement();
        }
        return result;
    }

    synchronized String[] getGroupComponents(String group) {
        Group g;
        String[] result = new String[]{};
        if (group != null && (g = (Group)this.groups.get(group)) != null) {
            result = g.getComponents();
        }
        return result;
    }

    synchronized String getTraceSpecification(String component2) {
        String result = null;
        if (component2 != null) {
            TraceElement e = (TraceElement)this.groups.get(component2);
            if (e == null) {
                e = (TraceElement)this.components.get(component2);
            }
            if (e != null) {
                result = e.getTraceSpecification();
            }
        }
        return result;
    }

    synchronized String getTraceSpecification() {
        StringBuffer b = new StringBuffer(16);
        int size = this.traceEnableEvents.size();
        if (size == 0) {
            return "*=" + LevelConstants.NAMES[16];
        }
        for (int i = 0; i < size; ++i) {
            TraceEnableEvent te = (TraceEnableEvent)this.traceEnableEvents.elementAt(i);
            if (i != 0) {
                b.append(":");
            }
            b.append(te.getComponentName());
            b.append("=").append(LevelConstants.NAMES[te.getType()]);
        }
        return new String(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processTraceString(String string, boolean reset) {
        if ((string = RasHelper.peelQuotes(string)) == null) {
            string = "";
        }
        LogManager logManager = wslm;
        synchronized (logManager) {
            ComponentManager componentManager = this;
            synchronized (componentManager) {
                this.processLoggingSpecString(string, reset);
            }
        }
    }

    synchronized void processDumpString(String s) {
        int i;
        if (s == null) {
            this.processNullDumpString();
            return;
        }
        if ((s = RasHelper.peelQuotes(s)) == null) {
            return;
        }
        String[] strComponents = RasHelper.split(s, 58);
        Vector<TraceComponent> debugReenables = new Vector<TraceComponent>();
        Enumeration traceComps = this.components.elements();
        while (traceComps.hasMoreElements()) {
            TraceComponent tc = (TraceComponent)traceComps.nextElement();
            if (!tc.ivDebugEnabled) continue;
            tc.ivDebugEnabled = false;
            debugReenables.addElement(tc);
        }
        for (i = 0; i < strComponents.length; ++i) {
            boolean enabled = true;
            String currentComponent = strComponents[i];
            if (currentComponent.endsWith("=disabled")) {
                enabled = false;
                currentComponent = RasHelper.split(currentComponent, 61)[0];
            }
            TraceEnableEvent e = new TraceEnableEvent(enabled, 0, currentComponent);
            this.fireTraceEnableEvent(e);
        }
        for (i = 0; i < strComponents.length; ++i) {
            String currentComponent = RasHelper.split(strComponents[i], 61)[0];
            Enumeration vEnum = this.dumpables.keys();
            while (vEnum.hasMoreElements()) {
                String dumpableComponent = (String)vEnum.nextElement();
                if (!this.componentEnabled(currentComponent, dumpableComponent)) continue;
                Vector v = (Vector)this.dumpables.get(dumpableComponent);
                for (int j = 0; j < v.size(); ++j) {
                    Dumpable d = (Dumpable)v.elementAt(j);
                    d.dump();
                }
            }
        }
        for (i = 0; i < strComponents.length; ++i) {
            String currentComponent = RasHelper.split(strComponents[i], 61)[0];
            TraceEnableEvent e = new TraceEnableEvent(false, 0, currentComponent);
            this.fireTraceEnableEvent(e);
        }
        for (i = 0; i < debugReenables.size(); ++i) {
            TraceComponent tc = (TraceComponent)debugReenables.elementAt(i);
            tc.ivDebugEnabled = true;
        }
        Enumeration vEnum = this.dumpables.elements();
        while (vEnum.hasMoreElements()) {
            Vector v = (Vector)vEnum.nextElement();
            for (int i2 = 0; i2 < v.size(); ++i2) {
                Dumpable d = (Dumpable)v.elementAt(i2);
                d.resetDump();
            }
        }
    }

    TraceComponent register(String name) {
        return this.register(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TraceComponent register(String name, String groupName) {
        LogManager logManager = wslm;
        synchronized (logManager) {
            return this.registerComponentAndGroup(name, groupName);
        }
    }

    private synchronized TraceComponent registerComponentAndGroup(String name, String groupName) {
        TraceComponent result = null;
        Group group = null;
        boolean addedComponent = false;
        boolean addedGroup = false;
        if (name != null) {
            result = (TraceComponent)this.components.get(name);
            if (result == null) {
                result = new TraceComponent(name);
                this.components.put(name, result);
                addedComponent = true;
            }
            if (groupName != null) {
                group = (Group)this.groups.get(groupName);
                if (group == null) {
                    group = new Group(groupName);
                    this.groups.put(groupName, group);
                    addedGroup = true;
                }
                group.addComponent(result);
            }
        }
        int size = this.traceEnableEvents.size();
        TraceEnableEvent te = null;
        String eventName = null;
        if (!WsLogManager.isConfigureByLoggingProperties()) {
            for (int i = 0; i < size; ++i) {
                te = (TraceEnableEvent)this.traceEnableEvents.elementAt(i);
                eventName = te.getComponentName();
                if (addedComponent && this.componentEnabled(eventName, name)) {
                    result.applyTraceEnableEvent(te);
                }
                if (groupName == null || !this.componentEnabled(eventName, groupName) || eventName.equals("*")) continue;
                group.applyTraceEnableEvent(te);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void registerDumpable(TraceComponent tc, Dumpable d) {
        String componentName = tc.getName();
        Hashtable hashtable = this.dumpables;
        synchronized (hashtable) {
            Vector<Dumpable> v = (Vector<Dumpable>)this.dumpables.get(componentName);
            if (v == null) {
                v = new Vector<Dumpable>();
                this.dumpables.put(componentName, v);
            }
            if (!v.contains(d)) {
                v.addElement(d);
            }
        }
    }

    synchronized String[] getComponents() {
        String[] result = new String[this.components.size()];
        Enumeration vEnum = this.components.keys();
        int i = 0;
        while (vEnum.hasMoreElements()) {
            result[i++] = (String)vEnum.nextElement();
        }
        return result;
    }

    synchronized Vector getTracedGroups() {
        Vector<Group> result = new Vector<Group>();
        Enumeration vEnum = this.groups.keys();
        while (vEnum.hasMoreElements()) {
            Group g = (Group)this.groups.get(vEnum.nextElement());
            if (g.getLevel() >= 8) continue;
            result.addElement(g);
        }
        return result;
    }

    synchronized Vector getTracedComponents() {
        Vector<TraceComponent> result = new Vector<TraceComponent>();
        Enumeration vEnum = this.components.keys();
        while (vEnum.hasMoreElements()) {
            TraceComponent tc = (TraceComponent)this.components.get(vEnum.nextElement());
            if (tc.getLevel() >= 8) continue;
            result.addElement(tc);
        }
        return result;
    }

    private void fireTraceEnableEvent(TraceEnableEvent event2) {
        String componentName = event2.getComponentName();
        Enumeration enumGroup = this.groups.keys();
        while (enumGroup.hasMoreElements()) {
            Group gr = (Group)this.groups.get(enumGroup.nextElement());
            if (!this.componentEnabled(componentName, gr.getName())) continue;
            gr.applyTraceEnableEvent(event2);
        }
        Enumeration vEnum = this.components.keys();
        while (vEnum.hasMoreElements()) {
            TraceComponent tc = (TraceComponent)this.components.get(vEnum.nextElement());
            if (!this.componentEnabled(componentName, tc.getName())) continue;
            tc.applyTraceEnableEvent(event2);
        }
        int size = this.traceEnableEvents.size();
        int index = 0;
        for (int i = 0; i < size; ++i) {
            boolean remove = false;
            TraceEnableEvent cachedEvent = (TraceEnableEvent)this.traceEnableEvents.elementAt(index);
            if (this.componentEnabled(componentName, cachedEvent.getComponentName())) {
                remove = true;
            }
            if (remove) {
                this.traceEnableEvents.removeElementAt(index);
                continue;
            }
            ++index;
        }
        boolean add = true;
        boolean tracingEnabled = false;
        size = this.traceEnableEvents.size();
        for (int i = 0; i < size; ++i) {
            TraceEnableEvent cachedEvent = (TraceEnableEvent)this.traceEnableEvents.elementAt(i);
            if (this.componentEnabled(cachedEvent.getComponentName(), componentName)) {
                boolean bl = add = cachedEvent.getType() != event2.getType();
            }
            if (tracingEnabled || cachedEvent.getType() >= 8) continue;
            tracingEnabled = true;
        }
        if (add) {
            this.traceEnableEvents.addElement(event2);
            if (!tracingEnabled && event2.getType() < 8) {
                tracingEnabled = true;
            }
        }
        TraceComponent.anyTracingEnabled = svTraceEnabled = tracingEnabled;
    }

    private boolean componentEnabled(String component1Name, String component2Name) {
        if (component1Name.equals(component2Name)) {
            return true;
        }
        int length = component1Name.length();
        if (component1Name.lastIndexOf(42) == length - 1) {
            return component1Name.regionMatches(0, component2Name, 0, length - 1);
        }
        return false;
    }

    private void processNullDumpString() {
        Dumpable d;
        Vector v;
        Enumeration vEnum = this.dumpables.elements();
        while (vEnum.hasMoreElements()) {
            v = (Vector)vEnum.nextElement();
            for (int j = 0; j < v.size(); ++j) {
                d = (Dumpable)v.elementAt(j);
                d.dump();
            }
        }
        vEnum = this.dumpables.elements();
        while (vEnum.hasMoreElements()) {
            v = (Vector)vEnum.nextElement();
            for (int i = 0; i < v.size(); ++i) {
                d = (Dumpable)v.elementAt(i);
                d.resetDump();
            }
        }
    }

    static int resolveEnabledLevel(boolean enable, int level) {
        int resolved_level;
        block5: {
            block4: {
                if (enable) break block4;
                if (level >= 16) break block5;
                if (level > 1) {
                    resolved_level = level;
                    while (LevelConstants.DISTINCT_LEVELS[++resolved_level] == LevelConstants.DISTINCT_LEVELS[level]) {
                    }
                } else {
                    resolved_level = 10;
                }
                break block5;
            }
            for (resolved_level = level; resolved_level > 0 && LevelConstants.DISTINCT_LEVELS[resolved_level - 1] == LevelConstants.DISTINCT_LEVELS[resolved_level]; --resolved_level) {
            }
        }
        return resolved_level;
    }

    Vector parseLoggingSpec(String logging_spec, boolean reset_levels) {
        Vector<String[]> configs = new Vector<String[]>();
        String[] component_config = null;
        StringTokenizer tokenizer = new StringTokenizer(logging_spec, LOGGING_SPEC_TOKENS, true);
        String token = null;
        component_config = new String[3];
        int i = 0;
        block7: while (tokenizer.hasMoreTokens() || i != 0) {
            try {
                token = tokenizer.nextToken();
            }
            catch (NoSuchElementException nse) {
                token = String.valueOf(':');
                i = 0;
            }
            switch (token.charAt(0)) {
                case '=': {
                    continue block7;
                }
                case ',': {
                    if (component_config[0] == null || component_config[1] == null || component_config[2] == null) continue block7;
                    configs.add(component_config);
                    String current_component = component_config[0];
                    component_config = new String[3];
                    component_config[0] = current_component;
                    i = 1;
                    continue block7;
                }
                case ':': {
                    if (component_config[0] != null && component_config[1] != null) {
                        if (component_config[2] == null) {
                            component_config[2] = FLAG_LEVEL_ENABLED;
                        }
                        configs.add(component_config);
                        component_config = new String[3];
                        i = 0;
                        continue block7;
                    }
                    if (i >= 3) continue block7;
                    i = 0;
                    continue block7;
                }
            }
            if (i == 0 && token.trim().length() > 0 || i == 1 && traceTypeMap.get(token.toLowerCase()) != null || i == 2 && (token.equals(FLAG_LEVEL_ENABLED) || token.equals(FLAG_LEVEL_DISABLED))) {
                if (i == 2 && token.equals(FLAG_LEVEL_DISABLED)) {
                    component_config[1] = component_config[1] == null ? "off" : LevelConstants.NAMES[ComponentManager.resolveEnabledLevel(false, (Integer)traceTypeMap.get(component_config[1].toLowerCase()))];
                    component_config[i++] = FLAG_LEVEL_ENABLED;
                    continue;
                }
                if (i == 1) {
                    token = LevelConstants.NAMES[ComponentManager.resolveEnabledLevel(true, (Integer)traceTypeMap.get(token.toLowerCase()))];
                }
                component_config[i++] = token;
                continue;
            }
            if (i >= component_config.length) {
                i = 0;
                continue;
            }
            if (i <= 0 || component_config[i - 1] == null) continue;
            ++i;
        }
        if (reset_levels) {
            if (configs.size() > 0) {
                String[] c1 = (String[])configs.elementAt(0);
                if (c1[0] != null && !c1[0].equals("*")) {
                    configs.add(0, new String[]{"*", LevelConstants.NAMES[10], FLAG_LEVEL_ENABLED});
                }
            } else {
                configs.add(0, new String[]{"*", LevelConstants.NAMES[10], FLAG_LEVEL_ENABLED});
            }
        }
        return configs;
    }

    private void processLoggingSpecString(String loggingSpec, boolean reset) {
        String trimLoggingSpec = loggingSpec == null ? null : loggingSpec.trim();
        Vector configs = this.parseLoggingSpec(trimLoggingSpec, reset);
        String[] component_config = null;
        Enumeration config_enum = configs.elements();
        while (config_enum.hasMoreElements()) {
            component_config = (String[])config_enum.nextElement();
            this.fireTraceEnableEvent(new TraceEnableEvent(true, (int)((Integer)traceTypeMap.get(component_config[1].toLowerCase())), component_config[0]));
        }
    }

    private int getLevel(String level_str) {
        Object o;
        if (level_str != null && level_str.length() > 0 && (o = traceTypeMap.get(level_str.toLowerCase())) != null) {
            return (Integer)o;
        }
        return -1;
    }

    synchronized void checkAndSetORBRasLogging() {
        if (RasHelper.getSystemProperty("com.ibm.CORBA.RasManager") != null && RasHelper.getSystemProperty("com.ibm.CORBA.CommTrace") != null) {
            return;
        }
        boolean enable_orbras_logging = false;
        boolean enable_comm_trace = false;
        int size = this.traceEnableEvents.size();
        for (int i = 0; i < size; ++i) {
            TraceEnableEvent te = (TraceEnableEvent)this.traceEnableEvents.elementAt(i);
            if (!this.componentEnabled(te.getComponentName(), "ORBRas")) continue;
            if (te.enabled() && (te.getType() == 1 || te.getType() == 5 || te.getType() == 3)) {
                enable_orbras_logging = true;
                if (te.getType() == 1) {
                    enable_comm_trace = true;
                }
            }
            if (te.enabled() || te.getType() != 1) continue;
            enable_orbras_logging = false;
            enable_comm_trace = false;
        }
        if (enable_orbras_logging) {
            String OrbRasMgr = RasHelper.getSystemProperty("com.ibm.CORBA.RasManager");
            if (OrbRasMgr == null || OrbRasMgr == "") {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        System.setProperty("com.ibm.CORBA.RasManager", "com.ibm.websphere.ras.WsOrbRasManager");
                        return null;
                    }
                });
            }
            String CommTrace = RasHelper.getSystemProperty("com.ibm.CORBA.CommTrace");
            if (enable_comm_trace && (CommTrace == null || CommTrace == "")) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        System.setProperty("com.ibm.CORBA.CommTrace", "true");
                        return null;
                    }
                });
            }
        }
    }

    static {
        for (int i = 0; i < 17; ++i) {
            traceTypeMap.put(LevelConstants.NAMES[i], new Integer(i));
        }
        wslm = LogManager.getLogManager();
    }
}

