/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.MessageDataObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.zip.InflaterInputStream;

public class ByteBufferParser {
    private static final int EYE_CATCHER_VALUE = -1430532899;
    static final int SERVICE_RC_SIZE = 20;
    private int eofStream;
    private int isLogStreamOpen = 1;
    private int messageReturnCode;
    private int messageReasonCode;
    private byte[] service = new byte[20];
    private int remDropped;
    private long endTime;
    private int msgCount;
    MessageDataObject[] mdObject = null;

    public int getEofStream() {
        return this.eofStream;
    }

    public void setEofStream(int eofStream) {
        this.eofStream = eofStream;
    }

    public int getIsLogStreamOpen() {
        return this.isLogStreamOpen;
    }

    public void setIsLogStreamOpen(int isLogStreamOpen) {
        this.isLogStreamOpen = isLogStreamOpen;
    }

    public int getMessageReturnCode() {
        return this.messageReturnCode;
    }

    public void setMessageReturnCode(int messageReturnCode) {
        this.messageReturnCode = messageReturnCode;
    }

    public int getMessageReasonCode() {
        return this.messageReasonCode;
    }

    public void setMessageReasonCode(int messageReasonCode) {
        this.messageReasonCode = messageReasonCode;
    }

    public byte[] getService() {
        return this.service;
    }

    public void setService(byte[] service) {
        this.service = service;
    }

    public int getRemDropped() {
        return this.remDropped;
    }

    public void setRemDropped(int remDropped) {
        this.remDropped = remDropped;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public int getMsgCount() {
        return this.msgCount;
    }

    public void setMsgCount(int msgCount) {
        this.msgCount = msgCount;
    }

    public MessageDataObject[] parseByteBuffer(ByteBuffer bb) throws BufferUnderflowException {
        try {
            this.messageReturnCode = bb.getInt();
            this.messageReasonCode = bb.getInt();
            this.eofStream = bb.getInt();
            byte[] temp = new byte[20];
            bb.get(temp);
            this.service = temp;
            this.remDropped = bb.getInt();
            this.msgCount = bb.getInt();
            this.mdObject = new MessageDataObject[this.msgCount];
            int tmpMsgLen = 0;
            for (int i = 0; i < this.msgCount; ++i) {
                this.mdObject[i] = new MessageDataObject();
                this.mdObject[i].setDropCounts(bb.getInt());
                tmpMsgLen = bb.getInt();
                byte[] tmpMessage = new byte[tmpMsgLen - 8];
                long timeStamp = bb.getLong();
                this.mdObject[i].setMsgTimeStamps(timeStamp);
                boolean zipped = false;
                if (-1430532899 != bb.getInt()) {
                    // empty if block
                }
                int versionId = bb.getInt();
                bb.get(tmpMessage, 0, tmpMsgLen - 8);
                bb.get();
                if (versionId == 1) {
                    zipped = true;
                    this.mdObject[i].setEBCDIC(false);
                } else {
                    zipped = false;
                    this.mdObject[i].setEBCDIC(true);
                }
                if (zipped) {
                    try {
                        tmpMessage = ByteBufferParser.unzip(tmpMessage);
                        tmpMsgLen = tmpMessage.length;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.mdObject[i].setMsgLen(tmpMsgLen);
                this.mdObject[i].setMsg(tmpMessage);
            }
        }
        catch (BufferUnderflowException bue) {
            bue.printStackTrace();
        }
        catch (OutOfMemoryError ome) {
            ome.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return this.mdObject;
    }

    private static byte[] unzip(byte[] b) throws IOException {
        int BUFFER_SIZE = 1024;
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        InflaterInputStream is = new InflaterInputStream(bais);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int totalbytesread = 0;
        int bufferspace = 1024;
        int bytesread = 0;
        byte[] tempBytes = new byte[1024];
        while (bytesread >= 0) {
            bytesread = is.read(tempBytes, 0, 1024);
            if (bytesread <= 0) continue;
            baos.write(tempBytes, 0, bytesread);
            totalbytesread += bytesread;
            bufferspace -= bytesread;
        }
        baos.flush();
        return baos.toByteArray();
    }
}

