/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.models.base.bindings.commonbnd.impl;

import com.ibm.ejs.models.base.bindings.clientbnd.ApplicationClientBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.BasicAuthData;
import com.ibm.ejs.models.base.bindings.commonbnd.CommonbndFactory;
import com.ibm.ejs.models.base.bindings.commonbnd.CommonbndPackage;
import com.ibm.ejs.models.base.bindings.commonbnd.EjbRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.MessageDestinationBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.MessageDestinationRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.Property;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceEnvRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.impl.BasicAuthDataImpl;
import com.ibm.ejs.models.base.bindings.commonbnd.impl.EjbRefBindingImpl;
import com.ibm.ejs.models.base.bindings.commonbnd.impl.MessageDestinationBindingImpl;
import com.ibm.ejs.models.base.bindings.commonbnd.impl.MessageDestinationRefBindingImpl;
import com.ibm.ejs.models.base.bindings.commonbnd.impl.PropertyImpl;
import com.ibm.ejs.models.base.bindings.commonbnd.impl.ResourceEnvRefBindingImpl;
import com.ibm.ejs.models.base.bindings.commonbnd.impl.ResourceRefBindingImpl;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.InterceptorBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.common.EJBLocalRef;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.common.MessageDestination;
import org.eclipse.jst.j2ee.common.MessageDestinationRef;
import org.eclipse.jst.j2ee.common.ResourceEnvRef;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Interceptor;
import org.eclipse.jst.j2ee.ejb.Interceptors;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.internal.emf.utilities.EncoderDecoder;
import org.eclipse.wst.common.internal.emf.utilities.EncoderDecoderRegistry;

public class CommonbndFactoryImpl
extends EFactoryImpl
implements CommonbndFactory {
    private static final String className = CommonbndFactoryImpl.class.getName();
    private static final Logger logger = Logger.getLogger("com.ibm.ejs.models.base.bindings.applicationbnd.serialization", "com.ibm.ejs.models.base.bindings.applicationbnd.serialization.messages");

    public static CommonbndFactory init() {
        try {
            CommonbndFactory theCommonbndFactory = (CommonbndFactory)EPackage.Registry.INSTANCE.getEFactory("commonbnd.xmi");
            if (theCommonbndFactory != null) {
                return theCommonbndFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log(exception);
        }
        return new CommonbndFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createBasicAuthData();
            }
            case 2: {
                return this.createResourceRefBinding();
            }
            case 3: {
                return this.createEjbRefBinding();
            }
            case 4: {
                return this.createResourceEnvRefBinding();
            }
            case 5: {
                return this.createMessageDestinationRefBinding();
            }
            case 6: {
                return this.createProperty();
            }
            case 7: {
                return this.createMessageDestinationBinding();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 8: {
                return this.createPasswordFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 8: {
                return this.convertPasswordToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public static CommonbndFactory getActiveFactory() {
        return (CommonbndFactory)CommonbndFactoryImpl.getPackage().getEFactoryInstance();
    }

    public BasicAuthData createBasicAuthData() {
        BasicAuthDataImpl basicAuthData = new BasicAuthDataImpl();
        return basicAuthData;
    }

    public ResourceRefBinding createResourceRefBinding() {
        ResourceRefBindingImpl resourceRefBinding = new ResourceRefBindingImpl();
        return resourceRefBinding;
    }

    public ResourceRefBinding createResourceRefXMLBinding() {
        ResourceRefBindingImpl resourceRefBinding = new ResourceRefBindingImpl(){

            public EObject eResolveProxy(InternalEObject proxy) {
                if (proxy instanceof ResourceRef) {
                    EObject eContainer = this.eContainer();
                    ResourceRef ref = (ResourceRef)((Object)proxy);
                    String name = ref.getName();
                    if (name != null && name.length() > 0) {
                        ApplicationClient appClient;
                        EObject binding;
                        EList resourceRefs = null;
                        if (eContainer instanceof EnterpriseBeanBinding) {
                            binding = (EnterpriseBeanBinding)eContainer;
                            EnterpriseBean ejb = binding.getEnterpriseBean();
                            resourceRefs = ejb.getResourceRefs();
                        } else if (eContainer instanceof InterceptorBinding) {
                            EJBJarBinding ejbJarBinding;
                            binding = (InterceptorBinding)eContainer;
                            if (binding != null && (ejbJarBinding = (EJBJarBinding)binding.eContainer()) != null) {
                                String className = binding.getClassName();
                                Interceptor interceptor = CommonbndFactoryImpl.this.getInterceptorByClassName(ejbJarBinding.getEjbJar(), className);
                                if (interceptor != null) {
                                    resourceRefs = interceptor.getResourceRefs();
                                }
                            }
                        } else if (eContainer instanceof WebAppBinding) {
                            binding = (WebAppBinding)eContainer;
                            WebApp webApp = binding.getWebapp();
                            if (webApp != null) {
                                resourceRefs = webApp.getResourceRefs();
                            }
                        } else if (eContainer instanceof ApplicationClientBinding && (appClient = (binding = (ApplicationClientBinding)eContainer).getApplicationClient()) != null) {
                            resourceRefs = appClient.getResourceRefs();
                        }
                        if (resourceRefs != null) {
                            for (ResourceRef resourceRef : resourceRefs) {
                                if (!name.equals(resourceRef.getName())) continue;
                                return resourceRef;
                            }
                        }
                    }
                }
                return super.eResolveProxy(proxy);
            }
        };
        return resourceRefBinding;
    }

    public EjbRefBinding createEjbRefBinding() {
        EjbRefBindingImpl ejbRefBinding = new EjbRefBindingImpl();
        return ejbRefBinding;
    }

    public EjbRefBinding createEjbRefXMLBinding() {
        return new EjbRefBindingImpl(){
            public static final String localClassName = "EjbRefBindingImpl(anon)";

            public EObject eResolveProxy(InternalEObject proxy) {
                EObject binding;
                String methodName = "eResolveProxy";
                logger.logp(Level.FINEST, localClassName, methodName, "ENTRY");
                if (proxy == null) {
                    logger.logp(Level.WARNING, localClassName, methodName, "Proxy is null!");
                    EObject result = super.eResolveProxy(proxy);
                    logger.logp(Level.FINEST, localClassName, methodName, "RETURN [ {0} ]", result);
                    return result;
                }
                if (!(proxy instanceof EjbRef)) {
                    logger.logp(Level.WARNING, localClassName, methodName, "Proxy is not an EjbRef!");
                    EObject result = super.eResolveProxy(proxy);
                    logger.logp(Level.FINEST, localClassName, methodName, "RETURN [ {0} ]", result);
                    return result;
                }
                EjbRef ref = (EjbRef)((Object)proxy);
                String name = ref.getName();
                if (name == null || name.length() == 0) {
                    logger.logp(Level.WARNING, localClassName, methodName, "Null or empty name!");
                    EObject result = super.eResolveProxy(proxy);
                    logger.logp(Level.FINEST, localClassName, methodName, "RETURN [ {0} ]", result);
                    return result;
                }
                logger.logp(Level.FINEST, localClassName, methodName, "EjbRef name [ {0} ]", name);
                EObject eContainer = this.eContainer();
                if (eContainer == null) {
                    logger.logp(Level.FINEST, localClassName, methodName, "Null container for EJBRef [ {0} ]", name);
                    EObject result = super.eResolveProxy(proxy);
                    logger.logp(Level.FINEST, localClassName, methodName, "RETURN [ {0} ]", result);
                    return result;
                }
                logger.logp(Level.FINEST, localClassName, methodName, "Parent binding type [ {0} ]", eContainer.getClass().getName());
                EList ejbRefs = null;
                EList ejbLocalRefs = null;
                if (eContainer instanceof EnterpriseBeanBinding) {
                    binding = (EnterpriseBeanBinding)eContainer;
                    EnterpriseBean ejb = binding.getEnterpriseBean();
                    if (ejb != null) {
                        logger.logp(Level.FINEST, localClassName, methodName, "EnterpriseBeanBinding case - EnterpriseBean [ {0} ]", ejb);
                        ejbRefs = ejb.getEjbRefs();
                        ejbLocalRefs = ejb.getEjbLocalRefs();
                    } else {
                        logger.logp(Level.FINEST, localClassName, methodName, "EnterpriseBeanBinding case with no EnterpriseBean!");
                    }
                } else if (eContainer instanceof InterceptorBinding) {
                    binding = (InterceptorBinding)eContainer;
                    EJBJarBinding ejbJarBinding = (EJBJarBinding)binding.eContainer();
                    if (ejbJarBinding != null) {
                        String bindingClassName = binding.getClassName();
                        logger.logp(Level.FINEST, localClassName, methodName, "InterceptorBinding case - binding class [ {0} ]", className);
                        Interceptor interceptor = CommonbndFactoryImpl.this.getInterceptorByClassName(ejbJarBinding.getEjbJar(), bindingClassName);
                        if (interceptor != null) {
                            logger.logp(Level.FINEST, localClassName, methodName, "InterceptorBinding case - Interceptor [ {0} ]", interceptor);
                            ejbRefs = interceptor.getEjbRefs();
                            ejbLocalRefs = interceptor.getEjbLocalRefs();
                        } else {
                            logger.logp(Level.FINEST, localClassName, methodName, "InterceptorBinding case with no interceptor!");
                        }
                    } else {
                        logger.logp(Level.FINEST, localClassName, methodName, "InterceptorBinding case with no parent EJBJar binding!");
                    }
                } else if (eContainer instanceof WebAppBinding) {
                    binding = (WebAppBinding)eContainer;
                    WebApp webApp = binding.getWebapp();
                    if (webApp != null) {
                        logger.logp(Level.FINEST, localClassName, methodName, "WebAppBinding case - WebApp [ {0} ]", webApp);
                        ejbRefs = webApp.getEjbRefs();
                        ejbLocalRefs = webApp.getEjbLocalRefs();
                    } else {
                        logger.logp(Level.FINEST, localClassName, methodName, "WebAppBinding case with no WebApp!");
                    }
                } else if (eContainer instanceof ApplicationClientBinding) {
                    binding = (ApplicationClientBinding)eContainer;
                    ApplicationClient appClient = binding.getApplicationClient();
                    if (appClient != null) {
                        logger.logp(Level.FINEST, localClassName, methodName, "AppClientBinding case - ApplicationClient [ {0} ]", appClient);
                        ejbRefs = appClient.getEjbReferences();
                    } else {
                        logger.logp(Level.FINEST, localClassName, methodName, "AppClientBinding case with no ApplicationClient!");
                    }
                } else {
                    logger.logp(Level.WARNING, localClassName, methodName, "Unrecognized parent binding type!");
                }
                EjbRef matchingRef = null;
                EJBLocalRef matchingLocalRef = null;
                if (ejbRefs != null) {
                    logger.logp(Level.FINEST, localClassName, methodName, "Scanning count of [ {0} ] EJBRefs", new Integer(ejbRefs.size()));
                    for (EjbRef ejbRef : ejbRefs) {
                        String ejbRefName = ejbRef.getName();
                        if (name.equals(ejbRefName)) {
                            if (matchingRef == null) {
                                logger.logp(Level.FINEST, localClassName, methodName, "Found ejb ref match for [ {0} ]", name);
                                matchingRef = ejbRef;
                                continue;
                            }
                            logger.logp(Level.WARNING, localClassName, methodName, "Found duplicate ejb ref match for [ {0} ]", name);
                            continue;
                        }
                        logger.logp(Level.FINEST, localClassName, methodName, "No match on [ {0} ]", ejbRefName);
                    }
                } else {
                    logger.logp(Level.FINEST, localClassName, methodName, "No EJBRefs collection was set");
                }
                if (ejbLocalRefs != null) {
                    logger.logp(Level.FINEST, localClassName, methodName, "Scanning count of [ {0} ] EJBLocalRefs", new Integer(ejbLocalRefs.size()));
                    for (EJBLocalRef ejbLocalRef : ejbLocalRefs) {
                        String ejbLocalRefName = ejbLocalRef.getName();
                        if (name.equals(ejbLocalRefName)) {
                            if (matchingLocalRef == null) {
                                logger.logp(Level.FINEST, localClassName, methodName, "Found ejb local ref match for [ {0} ]", name);
                                matchingLocalRef = ejbLocalRef;
                                continue;
                            }
                            logger.logp(Level.WARNING, localClassName, methodName, "Found duplicate ejb local ref match for [ {0} ]", name);
                            continue;
                        }
                        logger.logp(Level.FINEST, localClassName, methodName, "No match on [ {0} ]", ejbLocalRefName);
                    }
                } else {
                    logger.logp(Level.FINEST, localClassName, methodName, "No EJBLocalRefs collection was set");
                }
                if (matchingRef != null) {
                    if (matchingLocalRef != null) {
                        logger.logp(Level.WARNING, localClassName, methodName, "Found both ejb ref and ejb local ref match for [ {0} ]", name);
                    }
                    logger.logp(Level.FINEST, localClassName, methodName, "RETURN EJBRef [ {0} ]", matchingRef);
                    return matchingRef;
                }
                if (matchingLocalRef != null) {
                    logger.logp(Level.FINEST, localClassName, methodName, "RETURN EJBLocal ref [ {0} ]", matchingLocalRef);
                    return matchingLocalRef;
                }
                logger.logp(Level.WARNING, localClassName, methodName, "No matching ref for name [ {0} ]", name);
                EObject result = super.eResolveProxy(proxy);
                logger.logp(Level.FINEST, localClassName, methodName, "RETURN - EJB case using default resolver [ {0} ]", result);
                return result;
            }
        };
    }

    public ResourceEnvRefBinding createResourceEnvRefBinding() {
        ResourceEnvRefBindingImpl resourceEnvRefBinding = new ResourceEnvRefBindingImpl();
        return resourceEnvRefBinding;
    }

    public ResourceEnvRefBinding createResourceEnvRefXMLBinding() {
        ResourceEnvRefBindingImpl resourceEnvRefBinding = new ResourceEnvRefBindingImpl(){

            public EObject eResolveProxy(InternalEObject proxy) {
                if (proxy instanceof ResourceEnvRef) {
                    EObject eContainer = this.eContainer();
                    ResourceEnvRef ref = (ResourceEnvRef)((Object)proxy);
                    String name = ref.getName();
                    if (name != null && name.length() > 0) {
                        ApplicationClient appClient;
                        EObject binding;
                        EList resourceEnvRefs = null;
                        if (eContainer instanceof EnterpriseBeanBinding) {
                            binding = (EnterpriseBeanBinding)eContainer;
                            EnterpriseBean ejb = binding.getEnterpriseBean();
                            resourceEnvRefs = ejb.getResourceEnvRefs();
                        } else if (eContainer instanceof InterceptorBinding) {
                            EJBJarBinding ejbJarBinding;
                            binding = (InterceptorBinding)eContainer;
                            if (binding != null && (ejbJarBinding = (EJBJarBinding)binding.eContainer()) != null) {
                                String className = binding.getClassName();
                                Interceptor interceptor = CommonbndFactoryImpl.this.getInterceptorByClassName(ejbJarBinding.getEjbJar(), className);
                                if (interceptor != null) {
                                    resourceEnvRefs = interceptor.getResourceEnvRefs();
                                }
                            }
                        } else if (eContainer instanceof WebAppBinding) {
                            binding = (WebAppBinding)eContainer;
                            WebApp webApp = binding.getWebapp();
                            if (webApp != null) {
                                resourceEnvRefs = webApp.getResourceEnvRefs();
                            }
                        } else if (eContainer instanceof ApplicationClientBinding && (appClient = (binding = (ApplicationClientBinding)eContainer).getApplicationClient()) != null) {
                            resourceEnvRefs = appClient.getResourceEnvRefs();
                        }
                        if (resourceEnvRefs != null) {
                            for (ResourceEnvRef resourceEnvRef : resourceEnvRefs) {
                                if (!name.equals(resourceEnvRef.getName())) continue;
                                return resourceEnvRef;
                            }
                        }
                    }
                }
                return super.eResolveProxy(proxy);
            }
        };
        return resourceEnvRefBinding;
    }

    public MessageDestinationRefBinding createMessageDestinationRefBinding() {
        MessageDestinationRefBindingImpl messageDestinationRefBinding = new MessageDestinationRefBindingImpl();
        return messageDestinationRefBinding;
    }

    public MessageDestinationRefBinding createMessageDestinationRefXMLBinding() {
        MessageDestinationRefBindingImpl messageDestinationRefBinding = new MessageDestinationRefBindingImpl(){

            public EObject eResolveProxy(InternalEObject proxy) {
                if (proxy instanceof MessageDestinationRef) {
                    EObject eContainer = this.eContainer();
                    MessageDestinationRef ref = (MessageDestinationRef)((Object)proxy);
                    String name = ref.getName();
                    if (name != null && name.length() > 0) {
                        ApplicationClient appClient;
                        EObject binding;
                        EList msgDestRefs = null;
                        if (eContainer instanceof EnterpriseBeanBinding) {
                            binding = (EnterpriseBeanBinding)eContainer;
                            EnterpriseBean ejb = binding.getEnterpriseBean();
                            msgDestRefs = ejb.getMessageDestinationRefs();
                        } else if (eContainer instanceof InterceptorBinding) {
                            EJBJarBinding ejbJarBinding;
                            binding = (InterceptorBinding)eContainer;
                            if (binding != null && (ejbJarBinding = (EJBJarBinding)binding.eContainer()) != null) {
                                String className = binding.getClassName();
                                Interceptor interceptor = CommonbndFactoryImpl.this.getInterceptorByClassName(ejbJarBinding.getEjbJar(), className);
                                if (interceptor != null) {
                                    msgDestRefs = interceptor.getMessageDestinationRefs();
                                }
                            }
                        } else if (eContainer instanceof WebAppBinding) {
                            binding = (WebAppBinding)eContainer;
                            WebApp webApp = binding.getWebapp();
                            if (webApp != null) {
                                msgDestRefs = webApp.getMessageDestinationRefs();
                            }
                        } else if (eContainer instanceof ApplicationClientBinding && (appClient = (binding = (ApplicationClientBinding)eContainer).getApplicationClient()) != null) {
                            msgDestRefs = appClient.getMessageDestinationRefs();
                        }
                        if (msgDestRefs != null) {
                            for (MessageDestinationRef msgDstRef : msgDestRefs) {
                                if (!name.equals(msgDstRef.getName())) continue;
                                return msgDstRef;
                            }
                        }
                    }
                }
                return super.eResolveProxy(proxy);
            }
        };
        return messageDestinationRefBinding;
    }

    public Property createProperty() {
        PropertyImpl property = new PropertyImpl();
        return property;
    }

    public MessageDestinationBinding createMessageDestinationBinding() {
        MessageDestinationBindingImpl messageDestinationBinding = new MessageDestinationBindingImpl();
        return messageDestinationBinding;
    }

    public MessageDestinationBinding createMessageDestinationXMLBinding() {
        MessageDestinationBindingImpl messageDestinationBinding = new MessageDestinationBindingImpl(){

            public EObject eResolveProxy(InternalEObject proxy) {
                if (proxy instanceof MessageDestination) {
                    EJBJarBinding ejbJarBinding;
                    EJBJar ejbJar;
                    EObject eContainer = this.eContainer();
                    MessageDestination msgDst = (MessageDestination)((Object)proxy);
                    String name = msgDst.getName();
                    if (eContainer instanceof EJBJarBinding && (ejbJar = (ejbJarBinding = (EJBJarBinding)eContainer).getEjbJar()) != null) {
                        EList messageDestinations = ejbJar.getAssemblyDescriptor().getMessageDestinations();
                        for (MessageDestination destination : messageDestinations) {
                            String messageDestinationName = destination.getName();
                            if (!name.equals(messageDestinationName)) continue;
                            return destination;
                        }
                    }
                }
                return super.eResolveProxy(proxy);
            }
        };
        return messageDestinationBinding;
    }

    protected Interceptor getInterceptorByClassName(EJBJar ejbJar, String className) {
        if (ejbJar != null) {
            Interceptors interceptors = ejbJar.getInterceptors();
            EList interceptorsList = interceptors.getInterceptorList();
            for (Interceptor interceptor : interceptorsList) {
                JavaClass interceptorClass = interceptor.getInterceptorClass();
                String interceptorClassName = interceptorClass.getName();
                if (!className.equals(interceptorClassName)) continue;
                return interceptor;
            }
        }
        return null;
    }

    public String createPasswordFromString(EDataType eDataType, String initialValue) {
        return this.getDefaultEncoderDecoder().decode(initialValue);
    }

    public String convertPasswordToString(EDataType eDataType, Object instanceValue) {
        return this.getDefaultEncoderDecoder().encode((String)instanceValue);
    }

    public EncoderDecoder getDefaultEncoderDecoder() {
        return EncoderDecoderRegistry.getDefaultRegistry().getDefaultEncoderDecoder();
    }

    public CommonbndPackage getCommonbndPackage() {
        return (CommonbndPackage)this.getEPackage();
    }

    public static CommonbndPackage getPackage() {
        return CommonbndPackage.eINSTANCE;
    }
}

