/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityUtilityImpl;

import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ISecurityLocalObjectGSSUPImpl.WSSecurityContextImpl;
import com.ibm.ISecurityLocalObjectTokenBaseImpl.Krb5WSSecurityContextImpl;
import com.ibm.ISecurityLocalObjectTokenBaseImpl.WSSecurityContextAdminRSAPropImpl;
import com.ibm.ISecurityLocalObjectTokenBaseImpl.WSSecurityContextLTPAImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.auth.WSSecurityContext;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityObjectLocator;

public final class WSSecurityContextFactory {
    private String configuredOID = null;
    private static final TraceComponent tc = Tr.register(WSSecurityContextFactory.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");

    public static WSSecurityContextFactory getInstance() {
        return new WSSecurityContextFactory();
    }

    public WSSecurityContext createContext(String in_OID) {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        boolean ltpaSupported = csiv2.getBoolean("com.ibm.websphere.security.krb.allowLTPAAuth");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "OID = " + in_OID + " ltpaSupported = " + ltpaSupported);
        }
        if (this.verifyOid(in_OID)) {
            if (OID.compareOIDs(in_OID, csiv2.getString("com.ibm.CSI.WSSecurityContextActiveOID"))) {
                try {
                    Class<?> wrapperclass = Class.forName(csiv2.getString("com.ibm.CSI.WSSecurityContextActiveClass"));
                    Object wrapperObj = wrapperclass.newInstance();
                    WSSecurityContext custom = null;
                    custom = (WSSecurityContext)wrapperObj;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Instantiating WSSecurityContext instance: " + csiv2.getString("com.ibm.CSI.WSSecurityContextActiveClass"));
                    }
                    return custom;
                }
                catch (Exception e) {
                    Manager.Ffdc.log(e, this, "com.ibm.ISecurityUtilityImpl.WSSecurityContextFactory.createContext", "85", this);
                    Tr.error(tc, "security.JSAS0438E", new Object[]{csiv2.getString("com.ibm.CSI.WSSecurityContextActiveClass"), e.toString(), e});
                    return null;
                }
            }
            if (OID.compareOIDs(in_OID, "oid:2.23.130.1.1.1")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Instantiating GSSUP WSSecurityContext instance: com.ibm.ISecurityLocalObjectGSSUPImpl.WSSecurityContextImpl");
                }
                return new WSSecurityContextImpl();
            }
            if (OID.compareOIDs(in_OID, "oid:1.3.18.0.2.30.2") && ltpaSupported) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Instantiating LTPA WSSecurityContext instance: com.ibm.ISecurityLocalObjectTokenBaseImpl.WSSecurityContextLTPAImpl");
                }
                return new WSSecurityContextLTPAImpl();
            }
            if (OID.compareOIDs(in_OID, "oid:1.3.18.0.2.30.6")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Instantiating AdminPropToken WSSecurityContext instance: com.ibm.ISecurityLocalObjectTokenBaseImpl.WSSecurityContextAdminRSAPropImpl");
                }
                return new WSSecurityContextAdminRSAPropImpl();
            }
            if (OID.compareOIDs(in_OID, "oid:1.2.840.113554.1.2.2")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Instantiating KRB5 WSSecurityContext instance: com.ibm.ISecurityLocalObjectTokenBaseImpl.Krb5WSSecurityContextImpl");
                }
                return new Krb5WSSecurityContextImpl();
            }
            Tr.debug(tc, "JSAS0625E: Cannot instantiate WSSecurityContext instance for OID: " + in_OID);
            return null;
        }
        return null;
    }

    private WSSecurityContextFactory() {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        this.configuredOID = VaultImpl.getAuthenticationTarget().authTargetToOid(csiv2.getInteger("com.ibm.CORBA.authenticationTarget"));
    }

    private boolean verifyOid(String in_OID) {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        boolean ltpaSupported = csiv2.getBoolean("com.ibm.websphere.security.krb.allowLTPAAuth");
        if (OID.compareOIDs(in_OID, "oid:2.23.130.1.1.1")) {
            return true;
        }
        if (OID.compareOIDs(in_OID, this.configuredOID)) {
            return true;
        }
        if (OID.compareOIDs(in_OID, "oid:1.3.18.0.2.30.2") && ltpaSupported) {
            return true;
        }
        if (OID.compareOIDs(in_OID, "oid:1.3.18.0.2.30.6")) {
            return true;
        }
        if (OID.compareOIDs(in_OID, csiv2.getString("com.ibm.CSI.WSSecurityContextActiveOID"))) {
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.error(tc, "security.JSAS0626E", new Object[]{in_OID, this.configuredOID});
        }
        return false;
    }
}

