/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityUtilityImpl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import java.io.UnsupportedEncodingException;
import org.omg.CORBA.INTERNAL;

public class StringBytesConversion {
    private static final byte[] emptyByteArray = new byte[0];
    private static final String emptyString = new String("");
    private static final String stringConversionCode = "UTF8";
    private static final TraceComponent tc = Tr.register(StringBytesConversion.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");

    private StringBytesConversion() {
    }

    public static byte[] getConvertedBytes(String in_String) {
        if (in_String == null) {
            return null;
        }
        if (in_String.length() == 0) {
            return emptyByteArray;
        }
        try {
            return in_String.getBytes(stringConversionCode);
        }
        catch (UnsupportedEncodingException e) {
            Manager.Ffdc.log(e, StringBytesConversion.class, "com.ibm.ISecurityUtilityImpl.StringBytesConversion.getConvertedBytes", "101");
            Tr.error(tc, "security.JSAS0622E", new Object[]{e});
            throw new INTERNAL();
        }
    }

    public static String getConvertedString(byte[] in_Bytes) {
        if (in_Bytes == null) {
            return null;
        }
        if (in_Bytes.length == 0) {
            return emptyString;
        }
        try {
            return new String(in_Bytes, stringConversionCode);
        }
        catch (UnsupportedEncodingException e) {
            Manager.Ffdc.log(e, StringBytesConversion.class, "com.ibm.ISecurityUtilityImpl.StringBytesConversion.getConvertedString", "124");
            Tr.error(tc, "security.JSAS0622E", new Object[]{e});
            throw new INTERNAL();
        }
    }
}

