/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityUtilityImpl;

import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;

public class RealmSecurityName {
    private static final TraceComponent tc = Tr.register(RealmSecurityName.class, "SASRas", "com.ibm.ISecurityUtilityImpl.sec");
    public static final String emptyString = new String("");
    public static final String realmDelimiter = "/";
    public static final String kerberosRealmDelimiter = "@";

    private RealmSecurityName() {
    }

    public static String getService(String in_RealmSecurityName) {
        if (in_RealmSecurityName == null) {
            return emptyString;
        }
        int realmDelimiterIndex = (in_RealmSecurityName = in_RealmSecurityName.trim()).indexOf(realmDelimiter);
        if (realmDelimiterIndex < 0) {
            return emptyString;
        }
        return in_RealmSecurityName.substring(0, realmDelimiterIndex);
    }

    public static String getRealm(String in_RealmSecurityName) {
        if (in_RealmSecurityName == null) {
            return emptyString;
        }
        in_RealmSecurityName = in_RealmSecurityName.trim();
        int kerberosRealmDelimiterIndex = in_RealmSecurityName.indexOf(kerberosRealmDelimiter);
        int realmDelimiterIndex = in_RealmSecurityName.indexOf(realmDelimiter);
        if (realmDelimiterIndex < 0) {
            return null;
        }
        return in_RealmSecurityName.substring(0, realmDelimiterIndex);
    }

    public static String getRealm(String in_RealmSecurityName, String performClientAuthMechOID, String targetAuthMechOID) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealm", new Object[]{in_RealmSecurityName, performClientAuthMechOID, targetAuthMechOID});
        }
        String realm = "";
        if (in_RealmSecurityName == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, realm);
            }
            return realm;
        }
        in_RealmSecurityName = in_RealmSecurityName.trim();
        int kerberosRealmDelimiterIndex = in_RealmSecurityName.lastIndexOf(kerberosRealmDelimiter);
        if (OID.compareOIDs(performClientAuthMechOID, "oid:1.2.840.113554.1.2.2") || OID.compareOIDs(performClientAuthMechOID, "oid:2.23.130.1.1.1") && OID.compareOIDs(targetAuthMechOID, "oid:1.2.840.113554.1.2.2") && kerberosRealmDelimiterIndex > 1) {
            realm = in_RealmSecurityName.substring(kerberosRealmDelimiterIndex + 1, in_RealmSecurityName.length());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, realm);
            }
            return realm;
        }
        int realmDelimiterIndex = in_RealmSecurityName.indexOf(realmDelimiter);
        if (realmDelimiterIndex < 0) {
            return null;
        }
        realm = in_RealmSecurityName.substring(0, realmDelimiterIndex);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, realm);
        }
        return realm;
    }

    public static String getRealmOrReturnSecurityName(String in_RealmSecurityName, String performClientAuthMechOID, String targetAuthMechOID) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealmOrReturnSecurityName", new Object[]{in_RealmSecurityName, performClientAuthMechOID, targetAuthMechOID});
        }
        String realm = "";
        if (in_RealmSecurityName == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, realm);
            }
            return realm;
        }
        in_RealmSecurityName = in_RealmSecurityName.trim();
        int kerberosRealmDelimiterIndex = in_RealmSecurityName.lastIndexOf(kerberosRealmDelimiter);
        if (OID.compareOIDs(performClientAuthMechOID, "oid:1.2.840.113554.1.2.2") || OID.compareOIDs(performClientAuthMechOID, "oid:2.23.130.1.1.1") && OID.compareOIDs(targetAuthMechOID, "oid:1.2.840.113554.1.2.2") && kerberosRealmDelimiterIndex > 1) {
            realm = in_RealmSecurityName.substring(kerberosRealmDelimiterIndex + 1, in_RealmSecurityName.length());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, realm);
            }
            return realm;
        }
        int realmDelimiterIndex = in_RealmSecurityName.indexOf(realmDelimiter);
        if (realmDelimiterIndex < 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, in_RealmSecurityName);
            }
            return in_RealmSecurityName;
        }
        realm = in_RealmSecurityName.substring(0, realmDelimiterIndex);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, realm);
        }
        return realm;
    }

    public static String getRealm(String in_Realm, String in_SecurityName) {
        if (in_Realm == null) {
            return emptyString;
        }
        return in_Realm.trim();
    }

    public static String getRealmSecurityName(String in_RealmSecurityName) {
        if (in_RealmSecurityName == null) {
            return emptyString;
        }
        return in_RealmSecurityName;
    }

    public static String getRealmSecurityName(String in_Realm, String in_SecurityName) {
        in_Realm = in_Realm == null ? emptyString : in_Realm.trim();
        in_SecurityName = in_SecurityName == null ? emptyString : in_SecurityName.trim();
        return in_Realm + realmDelimiter + in_SecurityName;
    }

    public static String getSecurityName(String in_RealmSecurityName) {
        if (in_RealmSecurityName == null) {
            return emptyString;
        }
        int realmDelimiterIndex = (in_RealmSecurityName = in_RealmSecurityName.trim()).indexOf(realmDelimiter);
        if (realmDelimiterIndex < 0) {
            return in_RealmSecurityName;
        }
        return in_RealmSecurityName.substring(realmDelimiterIndex + 1);
    }

    public static String getSecurityName(String in_Realm, String in_SecurityName) {
        if (in_SecurityName == null) {
            return emptyString;
        }
        return in_SecurityName.trim();
    }
}

