/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityUtilityImpl;

import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ISecurityLocalObjectTokenBaseImpl.SecurityContextImpl;
import com.ibm.ISecurityUtilityImpl.MechanismAmbiguityException;
import com.ibm.ISecurityUtilityImpl.VaultConstants;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityObjectLocator;

public class MechanismFactory {
    private CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
    private VaultImpl vault = null;
    private static final TraceComponent tc = Tr.register(MechanismFactory.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
    public static final String BasicAuthOverSSL = "1.1";
    public static final String BasicAuthOverSSLtoLTPA = "1.1.1";
    public static final String BasicAuthOverSSLtoLocalOS = "1.1.2";
    public static final String BasicAuthOverSSLtoDCE = "1.1.3";
    public static final String BasicAuthOverSSLtoCustom = "1.1.4";
    public static final String MutualSSL = "1.2";
    public static final String LTPAoverSSL = "1.3";
    public static final String LocalOSoverSSL = "1.4";
    public static final String GSSUPOverSSL = "1.5";
    public static final String GSSUPOverSSLtoLTPA = "1.5.1";
    public static final String GSSUPOverSSLtoLocalOS = "1.5.2";
    public static final String GSSUPOverSSLtoDCE = "1.5.3";
    public static final String GSSUPOverSSLtoCustom = "1.5.4";
    public static final String GSSUPOverSSLtoKRB5 = "1.5.5";
    public static final String Kerberos5overSSL = "1.6";
    public static final String CustomoverSSL = "1.7";
    public static final String RSAPropOverSSL = "1.8";
    public static final String BasicAuthOverIPSec = "2.1";
    public static final String MutualIPSec = "2.2";
    public static final String DCEKerberos = "3.1";
    public static final String ClientCerttoDCEKerberos = "3.2";
    public static final String Kerberos5 = "4.1";
    public static final String ClientCerttoKerberos5 = "4.2";
    public static final String ClientCerttoCustom = "4.3";
    public static final String LTPAoverTCP = "5.1";
    public static final String LocalOSoverTCP = "5.2";
    public static final String BasicAuthOverTCPtoLTPA = "5.3";
    public static final String BasicAuthOverTCPtoLocalOS = "5.4";
    public static final String BasicAuthOverTCPtoDCE = "5.5";
    public static final String BasicAuthOverTCP = "5.6";
    public static final String GSSUPOverTCPtoLTPA = "5.7.1";
    public static final String GSSUPOverTCPtoLocalOS = "5.7.2";
    public static final String GSSUPOverTCPtoDCE = "5.7.3";
    public static final String GSSUPOverTCP = "5.7.4";
    public static final String GSSUPOverTCPtoCustom = "5.7.5";
    public static final String GSSUPOverTCPtoKRB5 = "5.7.6";
    public static final String Kerberos5overTCP = "5.8";
    public static final String CustomoverTCP = "5.9";
    public static final String RSAPropOverTCP = "5.10";
    public static final String UnauthenticatedOverSSL = "6.1";

    public VaultImpl getVault() {
        if (this.vault == null) {
            this.vault = VaultImpl.getInstance();
        }
        return this.vault;
    }

    public String getMechanismTypeIdentity() throws MechanismAmbiguityException {
        return this.getMechanismTypeIdentity("oid:2.23.130.1.1.1");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getMechanismTypeIdentity(String referenceOID) throws MechanismAmbiguityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMechanismTypeIdentity", new Object[]{referenceOID, this});
        }
        String mechanismTypeIdentity = null;
        String mechanismTypeIdentityString = null;
        if (this.csiv2.getBoolean("com.ibm.CSI.claimTransportAssocSSLTLSRequired") || this.csiv2.getBoolean("com.ibm.CSI.claimTransportAssocSSLTLSSupported")) {
            int authTarget = this.csiv2.getInteger("com.ibm.CORBA.authenticationTarget");
            if (referenceOID.compareTo("oid:1.3.18.0.2.30.6") == 0) {
                mechanismTypeIdentity = RSAPropOverSSL;
                mechanismTypeIdentityString = "RSAPropOverSSL";
            } else if (authTarget == 1 && referenceOID.compareTo("oid:1.3.18.0.2.30.2") == 0) {
                mechanismTypeIdentity = LTPAoverSSL;
                mechanismTypeIdentityString = "LTPAoverSSL";
            } else if (authTarget == 1 && referenceOID.compareTo("oid:2.23.130.1.1.1") == 0) {
                mechanismTypeIdentity = GSSUPOverSSLtoLTPA;
                mechanismTypeIdentityString = "GSSUPOverSSLtoLTPA";
            } else if (authTarget == 2) {
                mechanismTypeIdentity = GSSUPOverSSLtoLocalOS;
                mechanismTypeIdentityString = "GSSUPOverSSLtoLocalOS";
            } else if (authTarget == 4) {
                mechanismTypeIdentity = GSSUPOverSSL;
                mechanismTypeIdentityString = "GSSUPOverSSL";
            } else if (authTarget == 9) {
                mechanismTypeIdentity = GSSUPOverSSLtoCustom;
                mechanismTypeIdentityString = "GSSUPOverSSLtoCustom";
            } else if (authTarget == 6) {
                if (this.csiv2.getBoolean("com.ibm.websphere.security.krb.allowLTPAAuth") && referenceOID.compareTo("oid:1.3.18.0.2.30.2") == 0) {
                    mechanismTypeIdentity = LTPAoverSSL;
                    mechanismTypeIdentityString = "LTPAoverSSL";
                } else if (this.csiv2.getBoolean("com.ibm.websphere.security.krb.allowLTPAAuth") && referenceOID.compareTo("oid:2.23.130.1.1.1") == 0) {
                    mechanismTypeIdentity = GSSUPOverSSLtoKRB5;
                    mechanismTypeIdentityString = "GSSUPOverSSLtoKRB5";
                } else {
                    mechanismTypeIdentity = GSSUPOverSSLtoKRB5;
                    mechanismTypeIdentityString = "GSSUPOverSSLtoKRB5";
                }
            } else {
                if (authTarget != 7) throw new MechanismAmbiguityException();
                mechanismTypeIdentity = GSSUPOverSSL;
                mechanismTypeIdentityString = "GSSUPOverSSL";
            }
        } else {
            int authTarget = this.csiv2.getInteger("com.ibm.CORBA.authenticationTarget");
            if (referenceOID.compareTo("oid:1.3.18.0.2.30.6") == 0) {
                mechanismTypeIdentity = RSAPropOverTCP;
                mechanismTypeIdentityString = "RSAPropOverTCP";
            } else if (authTarget == 1 && referenceOID.compareTo("oid:1.3.18.0.2.30.2") == 0) {
                mechanismTypeIdentity = LTPAoverTCP;
                mechanismTypeIdentityString = "LTPAoverTCP";
            } else if (authTarget == 1 && referenceOID.compareTo("oid:2.23.130.1.1.1") == 0) {
                mechanismTypeIdentity = GSSUPOverTCPtoLTPA;
                mechanismTypeIdentityString = "GSSUPOverTCPtoLTPA";
            } else if (authTarget == 2) {
                mechanismTypeIdentity = GSSUPOverTCPtoLocalOS;
                mechanismTypeIdentityString = "GSSUPOverTCPtoLocalOS";
            } else if (authTarget == 4) {
                mechanismTypeIdentity = GSSUPOverTCP;
                mechanismTypeIdentityString = "GSSUPOverTCP";
            } else if (authTarget == 9) {
                mechanismTypeIdentity = GSSUPOverTCPtoCustom;
                mechanismTypeIdentityString = "GSSUPOverTCPtoCustom";
            } else if (authTarget == 6) {
                if (this.csiv2.getBoolean("com.ibm.websphere.security.krb.allowLTPAAuth") && referenceOID.compareTo("oid:1.3.18.0.2.30.2") == 0) {
                    mechanismTypeIdentity = LTPAoverTCP;
                    mechanismTypeIdentityString = "LTPAoverTCP";
                } else {
                    mechanismTypeIdentity = GSSUPOverTCPtoKRB5;
                    mechanismTypeIdentityString = "GSSUPOverTCPtoKRB5";
                }
            } else {
                if (authTarget != 7) throw new MechanismAmbiguityException();
                mechanismTypeIdentity = GSSUPOverTCP;
                mechanismTypeIdentityString = "GSSUPOverTCP";
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning mechanism type: " + mechanismTypeIdentityString);
        }
        if (!tc.isEntryEnabled()) return mechanismTypeIdentity;
        Tr.exit(tc, "getMechanismTypeIdentity", mechanismTypeIdentity);
        return mechanismTypeIdentity;
    }

    public com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl getSecurityContext(VaultImpl in_vault, WSCredential creds, String in_connectionKey) throws MechanismAmbiguityException {
        com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl the_SC;
        block6: {
            the_SC = null;
            try {
                if (creds.isBasicAuth()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Returning GSSUP SecurityContext.");
                    }
                    the_SC = OID.compareOIDs(creds.getOID(), "oid:2.23.130.1.1.1") ? new com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl(this.getVault(), in_connectionKey) : new SecurityContextImpl(this.getVault(), in_connectionKey);
                    break block6;
                }
                if (creds.isForwardable()) {
                    Tr.debug(tc, "Returning TokenBase SecurityContext.");
                    the_SC = new SecurityContextImpl(this.getVault(), in_connectionKey);
                    break block6;
                }
                throw new MechanismAmbiguityException("Non-forwardable credentials cannot establish a SecurityContext.");
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityUtilityImpl.MechanismFactory.getSecurityContext", "335", this);
                if (e instanceof MechanismAmbiguityException) {
                    throw (MechanismAmbiguityException)e;
                }
                the_SC = new SecurityContextImpl(this.getVault(), in_connectionKey);
            }
        }
        return the_SC;
    }

    public com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl getSecurityContext(VaultImpl in_vault, String mechType, String in_connectionKey) throws MechanismAmbiguityException {
        return this.getSecurityContext(mechType, in_connectionKey);
    }

    public com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl getSecurityContext(String mechType, String in_connectionKey) throws MechanismAmbiguityException {
        com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl the_SC = null;
        if (mechType.equals(VaultConstants.LTPA_MECH_TYPE)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning Token Base SecurityContext.");
            }
            the_SC = new SecurityContextImpl(this.getVault(), in_connectionKey, mechType);
        } else if (mechType.equals(VaultConstants.CUSTOM_MECH_TYPE)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning Token Base SecurityContext.");
            }
            the_SC = new SecurityContextImpl(this.getVault(), in_connectionKey, mechType);
        } else if (mechType.equals(VaultConstants.KRB5_MECH_TYPE)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning Token Base SecurityContext.");
            }
            the_SC = new SecurityContextImpl(this.getVault(), in_connectionKey, mechType);
        } else if (mechType.equals(VaultConstants.RSA_PROP_MECH_TYPE)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning Token Base SecurityContext.");
            }
            the_SC = new SecurityContextImpl(this.getVault(), in_connectionKey, mechType);
        } else if (mechType.equals(VaultConstants.CLIENT_CERT_MECH_TYPE)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning TokenBase SecurityContext.");
            }
            the_SC = new SecurityContextImpl(this.getVault(), in_connectionKey, mechType);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning GSSUP SecurityContext.");
            }
            the_SC = new com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl(this.getVault(), in_connectionKey);
        }
        return the_SC;
    }
}

