/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectTokenBaseImpl;

import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSEncodeDecodeException;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ISecurityLocalObjectGSSUPImpl.WSSecurityContextImpl;
import com.ibm.ISecurityUtilityImpl.CSIUtil;
import com.ibm.ISecurityUtilityImpl.WSSecurityContextFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSSecurityContext;
import com.ibm.websphere.security.auth.WSSecurityContextException;
import com.ibm.websphere.security.auth.WSSecurityContextResult;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.rsatoken.RSAPropagationManager;
import com.ibm.ws.security.auth.rsatoken.RSATokenThreadManager;
import com.ibm.ws.security.config.AuthMechanismConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.security.auth.Subject;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.Security.OpaqueHolder;
import org.omg.SecurityLevel2.CredentialsHolder;

public final class WSSecurityContextAdminRSAPropImpl
implements WSSecurityContext {
    private static final TraceComponent tc = Tr.register(WSSecurityContextAdminRSAPropImpl.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");

    public byte[] initSecContext(WSCredential cred, String targetServerName, String realm) throws WSSecurityContextException {
        Subject subject = SubjectHelper.createSubjectFromWSCredential(cred);
        String authMechOid = null;
        try {
            authMechOid = cred.getOID();
        }
        catch (Exception e) {
            // empty catch block
        }
        return this.initSecContext(subject, targetServerName, realm, authMechOid);
    }

    public byte[] initSecContext(Subject subject, String serverName, String realm) throws WSSecurityContextException {
        String authMechOid = null;
        WSCredential cred = SubjectHelper.getWSCredentialFromSubject(subject);
        try {
            if (cred != null) {
                authMechOid = cred.getOID();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return this.initSecContext(subject, serverName, realm, authMechOid);
    }

    public byte[] initSecContext(Subject subject, String serverName, String realm, String authMechOid) throws WSSecurityContextException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initSecContext", new Object[]{subject, serverName, realm, authMechOid, this});
        }
        CSIUtil csiUtil = new CSIUtil();
        OpaqueHolder outToken = new OpaqueHolder();
        WSCredential cred = SubjectHelper.getWSCredentialFromSubject(subject);
        if (cred != null) {
            try {
                X509Certificate cert = RSATokenThreadManager.getInstance().getTargetCertificate();
                byte[] client_auth_token = null;
                if (authMechOid.compareTo("oid:2.23.130.1.1.1") == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Encountered GSSUP credential. Calling GSSUP.initSecContext()");
                    }
                    WSSecurityContextImpl gssWSSecC = new WSSecurityContextImpl();
                    client_auth_token = gssWSSecC.initSecContext(subject, serverName, realm, authMechOid);
                } else if (cert != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Using target certificate SubjectDN \"" + cert.getSubjectDN() + "\" for target host " + serverName + " has serial number \"" + cert.getSerialNumber() + "\".");
                    }
                    outToken.value = RSAPropagationManager.getInstance().createRSAPropagationToken(cert, subject);
                    client_auth_token = csiUtil.create_gss_initial_context_token("oid:1.3.18.0.2.30.6", outToken);
                } else {
                    AuthMechanismConfig activeAuthMech = SecurityObjectLocator.getSecurityConfig().getActiveAuthMechanism();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Target certificate is null, falling back to the active auth mechanism: " + activeAuthMech.getType());
                    }
                    WSSecurityContext context = WSSecurityContextFactory.getInstance().createContext(activeAuthMech.getString("OID"));
                    client_auth_token = context.initSecContext(subject, serverName, realm);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Forming client_authentication_token in initSecContext using: username = " + cred.getSecurityName() + ", server = " + serverName + ", realm = " + realm);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "initSecContext", client_auth_token);
                }
                return client_auth_token;
            }
            catch (WSSecurityContextException e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.WSSecurityContextAdminRSAPropImpl.initSecContext", "190", this);
                Tr.audit(tc, "Error creating client_auth_token in initSecContext, reason: " + e.toString());
                throw e;
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.WSSecurityContextAdminRSAPropImpl.initSecContext", "198", this);
                Tr.audit(tc, "Exception getting attributes from WSCredential, error string from exception: " + e.getMessage());
                int major = 13;
                int minor = 0;
                throw new WSSecurityContextException(major, minor, "initSecContext: Exception getting attributes from WSCredential, error string from exception: " + e.getMessage(), e);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, SecurityMessages.getMsgOrUseDefault("JSAS0020W", "JSAS0020W: Unable to get credentials."));
        }
        int major = 7;
        int minor = 0;
        throw new WSSecurityContextException(major, minor, "initSecContext: " + SecurityMessages.getMsgOrUseDefault("JSAS0020W", "JSAS0020W: Unable to get credentials."));
    }

    public WSSecurityContextResult acceptSecContext(byte[] gssInitToken) throws WSSecurityContextException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "acceptSecContext", new Object[]{gssInitToken, this});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "acceptSecContext");
        }
        return this.acceptSecContext(gssInitToken, null);
    }

    public WSSecurityContextResult acceptSecContext(byte[] gssInitToken, Map appContext) throws WSSecurityContextException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "acceptSecContext", new Object[]{gssInitToken, this});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "acceptSecContext");
        }
        return this.acceptSecContext(gssInitToken, appContext, null);
    }

    public WSSecurityContextResult acceptSecContext(byte[] gssInitToken, Map appContext, String authMechOid) throws WSSecurityContextException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "acceptSecContext", new Object[]{gssInitToken, authMechOid, this});
        }
        Object cred = null;
        boolean method2 = false;
        CSIUtil csiUtil = new CSIUtil();
        Object privileges = null;
        CredentialsHolder credsHolder = new CredentialsHolder();
        OpaqueHolder continuation_data = new OpaqueHolder();
        OpaqueHolder auth_specific_data = new OpaqueHolder();
        OpaqueHolder receivedToken = new OpaqueHolder();
        byte[] authFailReason = new byte[]{100};
        String oidStr = null;
        Object authStat = null;
        try {
            oidStr = GSSFactory.getMechOIDFromGSSToken(gssInitToken);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "gssInitToken OID: " + oidStr);
            }
            if (gssInitToken == null || oidStr == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "acceptSecContext(null token or oid)");
                }
                return new WSSecurityContextResult(null, ContextManagerFactory.getInstance().createUnauthenticatedSubject());
            }
            if (!OID.compareOIDs(oidStr, "oid:1.3.18.0.2.30.6")) {
                WSSecurityContext context = WSSecurityContextFactory.getInstance().createContext(oidStr);
                if (context != null) {
                    return context.acceptSecContext(gssInitToken, appContext, oidStr);
                }
                throw new WSSecurityContextException(7, 16, "The OID \"" + oidStr + "\" does not have an associated WSSecurityContext implementation.");
            }
            csiUtil.parse_gss_initial_context_token(gssInitToken, receivedToken);
        }
        catch (WSSecurityContextException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.WSSecurityContextAdminRSAPropImpl.acceptSecContext", "305", this);
            Tr.debug(tc, "Error parsing client_auth_token in acceptSecContext, reason: " + ex.toString(), new Object[]{ex});
            throw ex;
        }
        catch (GSSEncodeDecodeException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.WSSecurityContextAdminRSAPropImpl.acceptSecContext", "311", this);
            Tr.debug(tc, "Error parsing client_auth_token in acceptSecContext, reason: " + ex.toString(), new Object[]{ex});
            int major = 18;
            int minor = 0;
            throw new WSSecurityContextException(major, minor, "Error parsing client_auth_token in acceptSecContext, reason: " + ex.toString());
        }
        catch (BAD_OPERATION ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.WSSecurityContextAdminRSAPropImpl.acceptSecContext", "319", this);
            Tr.debug(tc, "Corba BAD_OPERATION exception occurred, reason: " + ex.getMessage(), new Object[]{ex});
            int major = 14;
            int minor = 0;
            throw new WSSecurityContextException(major, minor, "Corba BAD_OPERATION exception occurred, reason: " + ex.getMessage());
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.WSSecurityContextAdminRSAPropImpl.acceptSecContext", "327", this);
            Tr.debug(tc, "Java exception occurred.", new Object[]{e});
            int major = 13;
            int minor = 0;
            throw new WSSecurityContextException(major, minor, "Java exception occurred.");
        }
        Subject subject = null;
        if (receivedToken.value != null) {
            try {
                subject = RSAPropagationManager.getInstance().validateRSAPropagationToken(receivedToken.value);
            }
            catch (WSLoginFailedException le) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSLoginFailedException occurred in acceptSecContext: " + le.getMessage(), new Object[]{le});
                }
                Manager.Ffdc.log(le, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.WSSecurityContextImpl.acceptSecContext", "347", this);
                throw new WSSecurityContextException(0, 0, le.getMessage(), le);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred in acceptSecContext: " + e.getMessage(), new Object[]{e});
                }
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.WSSecurityContextImpl.acceptSecContext", "355", this);
                throw new WSSecurityContextException(0, 0, e.getMessage(), e);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to parse the gss initial context token.");
            }
            int major = 18;
            int minor = 0;
            throw new WSSecurityContextException(major, minor, "Failed to parse the gss initial context token.");
        }
        if (subject != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "acceptSecContext");
            }
            return new WSSecurityContextResult(null, subject);
        }
        int major = 4;
        int minor = 0;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Validation failed in acceptSecContext, reason: Major[" + major + "], Minor[" + minor + "], Message[" + "Subject is null, Token is probably expired." + "]");
        }
        throw new WSSecurityContextException(major, minor, "Validation failed in acceptSecContext, reason: Major[" + major + "], Minor[" + minor + "], Message[" + "Subject is null, Token is probably expired." + "]");
    }

    public void completeSecContext(byte[] final_token) {
    }

    public void dispose() {
    }
}

