/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectTokenBaseImpl;

import com.ibm.CORBA.iiop.ExtendedClientRequestInfo;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.IExtendedSecurityReplaceablePriv.SessionEntryHolder;
import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ISecurityLocalObjectBaseL13Impl.PrincipalAuthFailReason;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ISecurityUtilityImpl.CSIUtil;
import com.ibm.ISecurityUtilityImpl.MechanismAmbiguityException;
import com.ibm.ISecurityUtilityImpl.MechanismFactory;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ISecurityUtilityImpl.WSSecurityContextFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSSecurityContext;
import com.ibm.websphere.security.auth.WSSecurityContextException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertPathValidatorException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CSI.AuthorizationElement;
import org.omg.CSI.CompleteEstablishContext;
import org.omg.CSI.ContextError;
import org.omg.CSI.EstablishContext;
import org.omg.CSI.SASContextBody;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.RequestInfo;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.Security.AssociationStatus;
import org.omg.Security.AuthenticationStatus;
import org.omg.Security.OpaqueHolder;

public class SecurityContextImpl
extends com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl {
    private static final long serialVersionUID = -1426189254434020015L;
    private static final TraceComponent tc = Tr.register(SecurityContextImpl.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
    private CSIv2Config csiv2;
    private ORB orb;
    private VaultImpl vault;
    private String mechType;

    public SecurityContextImpl() {
        this.orb = null;
        this.vault = null;
        this.mechType = null;
    }

    public SecurityContextImpl(VaultImpl in_vault, String in_connectionKey) {
        block4: {
            super(in_vault, in_connectionKey);
            this.orb = null;
            this.vault = null;
            this.mechType = null;
            this.csiv2 = SecurityObjectLocator.getCSIv2Config();
            if (in_vault != null) {
                this.vault = in_vault;
                this.orb = in_vault.getORB();
                MechanismFactory mechFactory = in_vault.getMechanismFactory();
                try {
                    if (mechFactory != null) {
                        this._mechanismType = mechFactory.getMechanismTypeIdentity(this.csiv2.getString("com.ibm.CSI.WSSecurityContextActiveOID"));
                    }
                }
                catch (MechanismAmbiguityException mae) {
                    Manager.Ffdc.log(mae, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.SecurityContextImpl.SecurityContextImpl", "130", this);
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug(tc, "MechanismAmbiguityException occurred in getMechanismTypeIdentity.", new Object[]{mae});
                }
            }
        }
    }

    public SecurityContextImpl(VaultImpl in_vault, String in_connectionKey, String in_MechType) {
        super(in_vault, in_connectionKey);
        this.orb = null;
        this.vault = null;
        this.mechType = null;
        this.csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (in_vault != null) {
            this.vault = in_vault;
            this._mechanismType = in_MechType;
        }
    }

    public synchronized AssociationStatus csi_continue_security_context(ClientRequestInfo info, com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl secCtx) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "csi_continue_security_context", new Object[]{info, secCtx, this});
        }
        String logMsg = null;
        ServiceContext sc = null;
        CSIUtil csiUtil = new CSIUtil();
        SASContextBody msg = null;
        switch (info.reply_status()) {
            case 0: 
            case 2: 
            case 3: 
            case 4: {
                sc = csiUtil.get_sc_from_reply((RequestInfo)info);
                if (sc != null) {
                    msg = csiUtil.get_message_from_sc(sc);
                }
                if (msg != null && msg.discriminator() == 1) {
                    CompleteEstablishContext cec = msg.complete_msg();
                    csiUtil.print_cec_message(cec, "csi_continue_security_context");
                    WSSecurityContext wsSecContext = null;
                    wsSecContext = csiUtil.getCurrent().getWSSecurityContext();
                    if (wsSecContext == null) break;
                    try {
                        wsSecContext.completeSecContext(cec.final_context_token);
                        wsSecContext.dispose();
                        wsSecContext = null;
                    }
                    catch (WSSecurityContextException ex1) {
                        Manager.Ffdc.log(ex1, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.SecurityContextImpl.csi_continue_security_context", "203", this);
                        logMsg = "Caught WSSecurityContextException in WSSecurityContext.completeSecContext(), reason: " + ex1.toString();
                        Tr.debug(tc, logMsg);
                        PrincipalAuthFailReason.map_auth_fail_to_minor_code(ex1.getMajor(), StringBytesConversion.getConvertedBytes(logMsg));
                    }
                    break;
                }
                if (msg == null || msg.discriminator() != 4) break;
                ContextError ce = msg.error_msg();
                csiUtil.print_ce_message(ce, "csi_continue_security_context");
                break;
            }
            case 1: {
                try {
                    Any exception = info.received_exception();
                    SystemException ex = ((ExtendedClientRequestInfo)info).getSystemException();
                    String detailed_message = csiUtil.read_detailed_message((RequestInfo)info);
                    if (tc.isDebugEnabled()) {
                        logMsg = "A SYSTEM_EXCEPTION has been received: " + exception.type().id() + ", Minor code: " + Long.toHexString(ex.minor);
                        Tr.debug(tc, logMsg);
                    }
                }
                catch (BadKind bk) {
                    Manager.Ffdc.log(bk, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.SecurityContextImpl.csi_continue_security_context", "238", this);
                }
                sc = csiUtil.get_sc_from_reply((RequestInfo)info);
                if (sc == null) {
                    return AssociationStatus.SecAssocFailure;
                }
                msg = csiUtil.get_message_from_sc(sc);
                if (msg == null || msg.discriminator() != 4) break;
                ContextError ce = msg.error_msg();
                csiUtil.print_ce_message(ce, "csi_continue_security_context");
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "csi_continue_security_context", AssociationStatus.SecAssocSuccess);
        }
        return AssociationStatus.SecAssocSuccess;
    }

    public synchronized void csi_initialize(byte[] chan_bindings, byte[] in_token, X509Certificate[] cert_chain, OpaqueHolder out_token) throws WSLoginFailedException {
        this.csi_initialize(chan_bindings, in_token, cert_chain, out_token, null);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void csi_initialize(byte[] chan_bindings, byte[] in_token, X509Certificate[] cert_chain, OpaqueHolder out_token, final Map appContext) throws WSLoginFailedException {
        if (SecurityContextImpl.tc.isEntryEnabled()) {
            Tr.entry(SecurityContextImpl.tc, "csi_initialize", new Object[]{chan_bindings, in_token, cert_chain, out_token, this});
        }
        logMsg = null;
        continuation_data = new OpaqueHolder();
        authFailReason = new byte[]{100};
        authStat = null;
        subject = null;
        ctxMgr = ContextManagerFactory.getInstance();
        _realm = ctxMgr.getDefaultRealm();
        if (SecurityContextImpl.tc.isDebugEnabled()) {
            logMsg = "Setting identityName: " + this.getIdentityName();
            Tr.debug(SecurityContextImpl.tc, logMsg);
        }
        try {
            block37: {
                block38: {
                    if (!this.getIdentityName().equals("ClientAuthenticationToken")) break block38;
                    wsSecContext = null;
                    try {
                        block40: {
                            block39: {
                                wsFactory = WSSecurityContextFactory.getInstance();
                                wsSecContext = wsFactory.createContext(GSSFactory.getMechOIDFromGSSToken(in_token));
                                in_oid = GSSFactory.getMechOIDFromGSSToken(in_token);
                                _gFactory = new GSSFactory(GSSFactory.getMechOIDFromGSSToken(in_token));
                                gssInitToken = _gFactory.decodeGSSToken(in_token);
                                if (SecurityContextImpl.tc.isDebugEnabled()) {
                                    Tr.debug(SecurityContextImpl.tc, "calling plugin acceptSecContext(gssInitToken, in_oid) " + in_oid);
                                }
                                wsresult = null;
                                wsresult = wsSecContext.acceptSecContext(gssInitToken, appContext, in_oid);
                                if (wsresult == null || wsresult.getSubject() == null) break block39;
                                subject = wsresult.getSubject();
                                if (wsresult.getFinalToken() != null) {
                                    this.setFinalToken(wsresult.getFinalToken());
                                }
                                this._contextState = 3;
                                this._principalAuthFailReason = (byte)100;
                                this._clientSubject = subject;
                                this._targetSubject = null;
                                this._mechanismType = this.mechType;
                                if (SecurityContextImpl.tc.isDebugEnabled()) {
                                    logMsg = "Authentication success";
                                    Tr.debug(SecurityContextImpl.tc, logMsg);
                                }
                                break block40;
                            }
                            if (SecurityContextImpl.tc.isDebugEnabled()) {
                                logMsg = "Subject returned from acceptSecContext is NULL.";
                                Tr.debug(SecurityContextImpl.tc, logMsg);
                            }
                            this._principalAuthFailReason = (byte)7;
                            this._principalAuthFailDetail = StringBytesConversion.getConvertedBytes(logMsg);
                            this._contextState = 4;
                            var20_35 = null;
                            if (authStat != AuthenticationStatus.SecAuthFailure) ** GOTO lbl86
                            ** GOTO lbl83
                        }
                        authStat = AuthenticationStatus.SecAuthSuccess;
                        ** GOTO lbl95
                    }
                    catch (WSSecurityContextException ex1) {
                        authStat = AuthenticationStatus.SecAuthFailure;
                        authFailReason[0] = (byte)ex1.getMajor();
                        logMsg = "Caught WSSecurityContextException in WSSecurityContext.acceptSecContext(), reason: " + ex1.toString();
                        Tr.debug(SecurityContextImpl.tc, logMsg, new Object[]{ex1});
                        throw ex1;
                    }
                    catch (Exception ex1) {
                        authStat = AuthenticationStatus.SecAuthFailure;
                        authFailReason[0] = 13;
                        logMsg = "Caught Java exception in WSSecurityContext.acceptSecContext(), reason: " + ex1.toString();
                        Tr.debug(SecurityContextImpl.tc, logMsg, new Object[]{ex1});
                        throw ex1;
                    }
                    {
                        catch (Throwable var19_41) {
                            var20_37 = null;
                            if (authStat == AuthenticationStatus.SecAuthFailure) {
                                Tr.debug(SecurityContextImpl.tc, logMsg);
                                authStat = AuthenticationStatus.SecAuthFailure;
                                continuation_data.value = StringBytesConversion.getConvertedBytes(logMsg);
                            }
                            try {
                                wsSecContext.dispose();
                                wsSecContext = null;
                                throw var19_41;
                            }
                            catch (WSSecurityContextException ex1) {
                                authStat = AuthenticationStatus.SecAuthFailure;
                                authFailReason[0] = (byte)ex1.getMajor();
                                logMsg = "Caught WSSecurityContextException in WSSecurityContext.acceptSecContext(), reason: " + ex1.toString();
                                Tr.debug(SecurityContextImpl.tc, logMsg, new Object[]{ex1});
                            }
                            throw var19_41;
                        }
lbl83:
                        // 1 sources

                        Tr.debug(SecurityContextImpl.tc, logMsg);
                        authStat = AuthenticationStatus.SecAuthFailure;
                        continuation_data.value = StringBytesConversion.getConvertedBytes(logMsg);
lbl86:
                        // 2 sources

                        ** try [egrp 3[TRYBLOCK] [7 : 544->557)] { 
lbl87:
                        // 1 sources

                        wsSecContext.dispose();
                        return;
lbl89:
                        // 1 sources

                        catch (WSSecurityContextException ex1) {
                            authStat = AuthenticationStatus.SecAuthFailure;
                            authFailReason[0] = (byte)ex1.getMajor();
                            logMsg = "Caught WSSecurityContextException in WSSecurityContext.acceptSecContext(), reason: " + ex1.toString();
                            Tr.debug(SecurityContextImpl.tc, logMsg, new Object[]{ex1});
                        }
                        return;
lbl95:
                        // 1 sources

                        var20_36 = null;
                        if (authStat == AuthenticationStatus.SecAuthFailure) {
                            Tr.debug(SecurityContextImpl.tc, logMsg);
                            authStat = AuthenticationStatus.SecAuthFailure;
                            continuation_data.value = StringBytesConversion.getConvertedBytes(logMsg);
                        }
                        try {}
                        catch (WSSecurityContextException ex1) {}
                        authStat = AuthenticationStatus.SecAuthFailure;
                        authFailReason[0] = (byte)ex1.getMajor();
                        logMsg = "Caught WSSecurityContextException in WSSecurityContext.acceptSecContext(), reason: " + ex1.toString();
                        Tr.debug(SecurityContextImpl.tc, logMsg, new Object[]{ex1});
                        break block37;
                        wsSecContext.dispose();
                        wsSecContext = null;
                    }
                }
                if (this.getIdentityName().equals("ClientCertificate") && cert_chain != null) {
                    if (SecurityContextImpl.tc.isDebugEnabled()) {
                        logMsg = "ClientCertificate == " + cert_chain[0].toString();
                        Tr.debug(SecurityContextImpl.tc, logMsg);
                    }
                    identityName = this.getIdentityName();
                    identityValue = this.getIdentityValue();
                    cert_chain_final = cert_chain;
                    action = new PrivilegedExceptionAction(){

                        public Object run() throws WSLoginFailedException, CredentialDestroyedException, CredentialExpiredException {
                            Subject subject = ctxMgr.login(_realm, cert_chain_final, SecurityContextImpl.this.csiv2.getString("com.ibm.CSI.rmiInboundLoginConfig"), null, null, appContext);
                            if (subject != null) {
                                WSCredential credential = SubjectHelper.getWSCredentialFromSubject(subject);
                                if (identityName != null) {
                                    credential.set("wssecurity.identity_name", identityName);
                                    credential.set("wssecurity.identity_value", identityValue);
                                }
                                return subject;
                            }
                            return null;
                        }
                    };
                    try {
                        subject = (Subject)AccessController.doPrivileged(action);
                        this._contextState = 3;
                        this._principalAuthFailReason = (byte)100;
                        this._clientSubject = subject;
                        this._targetSubject = null;
                        this._mechanismType = this.mechType;
                        if (!SecurityContextImpl.tc.isDebugEnabled()) ** GOTO lbl159
                        logMsg = "Authentication success";
                        Tr.debug(SecurityContextImpl.tc, logMsg);
                    }
                    catch (PrivilegedActionException e) {
                        if (SecurityContextImpl.tc.isDebugEnabled() == false) throw e.getException();
                        logMsg = "Exception occurred: " + e.getException().getMessage();
                        Tr.debug(SecurityContextImpl.tc, logMsg, new Object[]{e.getException()});
                        throw e.getException();
                    }
                } else if (this.getIdentityName().startsWith("ITT")) {
                    userId = StringBytesConversion.getConvertedString(in_token);
                    if (userId == null || userId.length() < 1) {
                        if (SecurityContextImpl.tc.isDebugEnabled()) {
                            logMsg = "IdentityAssertion Security name == NULL.";
                            Tr.debug(SecurityContextImpl.tc, logMsg);
                        }
                        this._contextState = 4;
                        this._principalAuthFailReason = 1;
                        return;
                    }
                    if (SecurityContextImpl.tc.isDebugEnabled()) {
                        logMsg = "IdentityAssertion Security name == " + userId;
                        Tr.debug(SecurityContextImpl.tc, logMsg);
                    }
                    identityName = this.getIdentityName();
                    identityValue = this.getIdentityValue();
                    _userid = userId;
                    action = new PrivilegedExceptionAction(){

                        public Object run() throws WSLoginFailedException, CredentialDestroyedException, CredentialExpiredException {
                            Subject subject = ctxMgr.login(_realm, _userid, SecurityContextImpl.this.csiv2.getString("com.ibm.CSI.rmiInboundLoginConfig"), null, null, null);
                            if (subject != null) {
                                WSCredential credential = SubjectHelper.getWSCredentialFromSubject(subject);
                                if (credential != null && identityName != null) {
                                    credential.set("wssecurity.identity_name", identityName);
                                    credential.set("wssecurity.identity_value", identityValue);
                                }
                                return subject;
                            }
                            return null;
                        }
                    };
                    try {
                        subject = (Subject)AccessController.doPrivileged(action);
                    }
                    catch (PrivilegedActionException e) {
                        if (SecurityContextImpl.tc.isDebugEnabled() == false) throw e.getException();
                        logMsg = "Exception occurred: " + e.getException().getMessage();
                        Tr.debug(SecurityContextImpl.tc, logMsg);
                        throw e.getException();
                    }
                }
            }
            if (subject == null) throw new WSLoginFailedException("Subject is null.  Authentication Failed.");
            this._contextState = 3;
            this._principalAuthFailReason = (byte)100;
            this._clientSubject = subject;
            this._targetSubject = null;
            this._mechanismType = this.mechType;
            if (SecurityContextImpl.tc.isDebugEnabled() == false) return;
            logMsg = "Authentication success";
            Tr.debug(SecurityContextImpl.tc, logMsg);
            return;
        }
        catch (WSLoginFailedException e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.SecurityContextImpl.csi_initialize", "602", new Object[]{this});
            this._contextState = 4;
            this._principalAuthFailReason = 0;
            this._principalAuthFailDetail = continuation_data.value;
            if (SecurityContextImpl.tc.isDebugEnabled() == false) throw e;
            logMsg = "Authentication failed";
            Tr.debug(SecurityContextImpl.tc, logMsg);
            throw e;
        }
        catch (WSSecurityContextException e) {
            if (SecurityContextImpl.isCertPathValidatorException(e)) {
                this._principalAuthFailReason = (byte)19;
                if (SecurityContextImpl.tc.isDebugEnabled()) {
                    logMsg = "RSA certificate validation failed";
                    Tr.debug(SecurityContextImpl.tc, logMsg);
                }
            } else {
                this._principalAuthFailReason = 0;
                if (SecurityContextImpl.tc.isDebugEnabled()) {
                    logMsg = "Authentication failed";
                    Tr.debug(SecurityContextImpl.tc, logMsg);
                }
            }
            if (!SecurityMessages.suppressFFDCforKrbSkewError(e)) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl.csi_initialize", "639", new Object[]{this});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl.csi_initialize", "641", new Object[]{this});
            this._contextState = 4;
            this._principalAuthFailDetail = continuation_data.value;
            throw new WSLoginFailedException(e.getMessage(), e);
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl.csi_initialize", "649", new Object[]{this});
            this._contextState = 4;
            this._principalAuthFailReason = 0;
            this._principalAuthFailDetail = continuation_data.value;
            if (SecurityContextImpl.tc.isDebugEnabled() == false) throw new WSLoginFailedException(e.getMessage(), e);
            logMsg = "Authentication failed";
            Tr.debug(SecurityContextImpl.tc, logMsg);
            throw new WSLoginFailedException(e.getMessage(), e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized boolean csi_client_preprotect(ClientRequestInfo info, com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl secCtx) {
        if (SecurityContextImpl.tc.isEntryEnabled()) {
            Tr.entry(SecurityContextImpl.tc, "csi_client_preprotect", new Object[]{info, secCtx, this});
        }
        logMsg = "";
        sc = null;
        secNameHolder = new StringHolder();
        credTokenHolder = new OpaqueHolder();
        csiUtil = new CSIUtil();
        subject = null;
        wsCred = null;
        client_subject = this.getClientSubject();
        entryHolder = new SessionEntryHolder();
        ae = new AuthorizationElement[]{new AuthorizationElement(0, new byte[0])};
        it = secCtx.getIdentityToken();
        csiv2EffectivePolicy = this.vault.get_effective_policy(info.request_id());
        clientSessionKey = csiv2EffectivePolicy.getClientSessionKey();
        username = "";
        password = "";
        realm = "";
        client_auth_token = null;
        useServerTokenForTrust = false;
        stateful_context_id = 0L;
        sessionMgr = this.vault.getSessionManager();
        performTargetMechList = csiv2EffectivePolicy.getPerformClientAuthTargetList();
        if (csiv2EffectivePolicy.isStateful()) {
            stateful_context_id = csiv2EffectivePolicy.getStatefulContextID();
            if (SecurityContextImpl.tc.isDebugEnabled()) {
                logMsg = "Effective policy indicates stateful request, client_context_id: " + stateful_context_id;
                Tr.debug(SecurityContextImpl.tc, logMsg);
            }
        } else if (SecurityContextImpl.tc.isDebugEnabled()) {
            logMsg = "Effective policy indicates stateless request.";
            Tr.debug(SecurityContextImpl.tc, logMsg);
        }
        if (secCtx.getTokenType().equals("ClientAuthOnly")) {
            if (csiv2EffectivePolicy != null) {
                realm = csiv2EffectivePolicy.getTargetSecurityName();
            }
            if (realm == null || realm.equals("")) {
                realm = RealmSecurityName.getRealm(secNameHolder.value);
            }
            subject = this.getClientSubject();
        } else if (secCtx.getTokenType().equals("ClientAuthAndIdentityOnly")) {
            try {
                if (SecurityContextImpl.tc.isDebugEnabled()) {
                    logMsg = "Forming Client Authentication Token";
                    Tr.debug(SecurityContextImpl.tc, logMsg);
                }
                csiv2 = SecurityObjectLocator.getCSIv2Config();
                alternatePerformTrustedId = csiv2.getString("com.ibm.CSI.alternateIdentityAssertionPerformTrustedId");
                alternatePerformTrustedPassword = csiv2.getString("com.ibm.CSI.alternateIdentityAssertionPerformTrustedPassword");
                if (alternatePerformTrustedId != null && !alternatePerformTrustedId.equals("") && alternatePerformTrustedPassword != null && !alternatePerformTrustedPassword.equals("")) {
                    if (SecurityContextImpl.tc.isDebugEnabled()) {
                        logMsg = "Alternate ID/Password has been specified.  Sending alternate Userid/Password for trusted identity.";
                        Tr.debug(SecurityContextImpl.tc, logMsg);
                    }
                    username = alternatePerformTrustedId;
                    realm = ContextManagerFactory.getInstance().getDefaultRealm();
                    password = alternatePerformTrustedPassword;
                    subject = SubjectHelper.createBasicAuthSubject(realm, username, password);
                }
                if (!csiv2.getBoolean("com.ibm.ws.security.isUseRegistryServerId")) {
                    if (SecurityContextImpl.tc.isDebugEnabled()) {
                        logMsg = "UserRegistry server ID is not set and alternate ID/Password is not specified.  Sending server's LTPA token for trusted identity.";
                        Tr.debug(SecurityContextImpl.tc, logMsg);
                    }
                    subject = ContextManagerFactory.getInstance().getServerSubject();
                    useServerTokenForTrust = true;
                }
                username = csiv2.getString("com.ibm.CORBA.loginUserid");
                realm = RealmSecurityName.getRealm(csiv2.getString("com.ibm.CORBA.principalName"));
                password = csiv2.getString("com.ibm.CORBA.loginPassword");
                if (password == null || password.equals("")) {
                    if (SecurityContextImpl.tc.isDebugEnabled()) {
                        logMsg = "Alternate ID/Password is not specified.  Sending server's token for trusted identity.";
                        Tr.debug(SecurityContextImpl.tc, logMsg);
                    }
                    subject = ContextManagerFactory.getInstance().getServerSubject();
                    useServerTokenForTrust = true;
                }
                if (SecurityContextImpl.tc.isDebugEnabled()) {
                    logMsg = "Alternate ID/Password is not specified.  Sending server's token for trusted identity.";
                    Tr.debug(SecurityContextImpl.tc, logMsg);
                }
                if (performTargetMechList.contains(4)) {
                    if (SecurityContextImpl.tc.isDebugEnabled()) {
                        Tr.debug(SecurityContextImpl.tc, "Basic auth is enabled for the target server, creating a basic auth subject using the server's id and password.");
                    }
                    subject = SubjectHelper.createBasicAuthSubject(realm, username, password);
                }
                if (SecurityContextImpl.tc.isDebugEnabled()) {
                    Tr.debug(SecurityContextImpl.tc, "Basic auth is disabled for the target server, creating a token subject");
                }
                subject = ContextManagerFactory.getInstance().getServerSubject();
                useServerTokenForTrust = true;
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.SecurityContextImpl.csi_client_preprotect", "774", new Object[]{this});
                if (SecurityContextImpl.tc.isDebugEnabled()) {
                    logMsg = "Cannot get server's credentials (userid/password/realm) from security configuration";
                    Tr.debug(SecurityContextImpl.tc, logMsg, new Object[]{e});
                }
                if (csiv2EffectivePolicy.isStateful() && stateful_context_id != 0L) {
                    sessionMgr.csi_client_session_status_update(stateful_context_id, clientSessionKey, 7);
                }
                throw new NO_PERMISSION(logMsg, 1229066386, CompletionStatus.COMPLETED_NO);
            }
        } else if (SecurityContextImpl.tc.isDebugEnabled()) {
            logMsg = "No Client Authentication Token will be put in the request";
            Tr.debug(SecurityContextImpl.tc, logMsg);
        }
        if (subject != null) {
            try {
                wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
                if (wsCred != null && wsCred.isForwardable()) {
                    block70: {
                        wsFactory = WSSecurityContextFactory.getInstance();
                        wsSecContext = null;
                        performClientAuthMechOid = csiv2EffectivePolicy.getPerformClientAuthMechOID();
                        if (wsCred.isBasicAuth()) {
                            if (!OID.compareOIDs(performClientAuthMechOid, "oid:2.23.130.1.1.1") && !performTargetMechList.contains(4)) {
                                throw new INTERNAL("Target server does not allow basicAuth (GSSUP)", 1229066387, CompletionStatus.COMPLETED_NO);
                            }
                            wsSecContext = wsFactory.createContext("oid:2.23.130.1.1.1");
                        } else if (OID.compareOIDs(wsCred.getOID(), "oid:1.3.18.0.2.30.2") && OID.compareOIDs(performClientAuthMechOid, "oid:1.2.840.113554.1.2.2")) {
                            targetMechOIDList = csiv2EffectivePolicy.getPerformClientAuthMechOIDList();
                            if (SecurityContextImpl.tc.isDebugEnabled()) {
                                Tr.debug(SecurityContextImpl.tc, "csi_client_preprotect oid list", targetMechOIDList);
                            }
                            foundLTPA = false;
                            if (targetMechOIDList != null) {
                                targetMechList = csiv2EffectivePolicy.getPerformClientAuthMechList();
                                for (i = 0; i < targetMechOIDList.size() && !foundLTPA; ++i) {
                                    targetAuthMechOID = (String)targetMechOIDList.get(i);
                                    if (!OID.compareOIDs(targetAuthMechOID, "oid:1.3.18.0.2.30.2")) continue;
                                    if (SecurityContextImpl.tc.isDebugEnabled()) {
                                        Tr.debug(SecurityContextImpl.tc, "csi_client_preprotect found LTPA oid in target");
                                    }
                                    foundLTPA = true;
                                    csiv2EffectivePolicy.setPerformClientAuthMechOID(targetAuthMechOID);
                                    targetAuthMech = (String)targetMechList.get(i);
                                    csiv2EffectivePolicy.setPerformClientAuthMech(targetAuthMech);
                                    performClientAuthMechOid = targetAuthMechOID;
                                    targetSecurityNameList = csiv2EffectivePolicy.getTargetSecurityNameList();
                                    csiv2EffectivePolicy.setTargetSecurityName((String)targetSecurityNameList.get(i));
                                }
                            }
                            if (!foundLTPA) {
                                throw new INTERNAL("LTPA wsCredential can not go outbound with Kerberos authentication mechanism", 1229066387, CompletionStatus.COMPLETED_NO);
                            }
                        }
                        if (OID.compareOIDs(wsCred.getOID(), "oid:1.2.840.113554.1.2.2") && OID.compareOIDs(performClientAuthMechOid, "oid:2.23.130.1.1.1") && SubjectHelper.getPrincipalFromSubject(subject) == null) {
                            throw new INTERNAL("The authenticationTarget setting in the client security properties file is set to BasicAuth, but the Kerberos credential in the subject cannot go outbound with BasicAuth (GSSUP).  Review this setting and consider changing it to KRB5", 1229066387, CompletionStatus.COMPLETED_NO);
                        }
                        if (OID.compareOIDs(wsCred.getOID(), "oid:1.2.840.113554.1.2.2") && OID.compareOIDs(performClientAuthMechOid, "oid:1.2.840.113554.1.2.2") && SubjectHelper.getGSSCredentialFromSubject(subject) == null) {
                            targetMechOIDList = csiv2EffectivePolicy.getPerformClientAuthMechOIDList();
                            if (SecurityContextImpl.tc.isDebugEnabled()) {
                                Tr.debug(SecurityContextImpl.tc, "wsCredOid and performClientAuthMechOid are Kerberos OID, but no GSSCredential in subject.");
                                Tr.debug(SecurityContextImpl.tc, "csi_client_preprotect oid list", targetMechOIDList);
                            }
                            foundLTPA = false;
                            if (targetMechOIDList != null) {
                                targetMechList = csiv2EffectivePolicy.getPerformClientAuthMechList();
                                for (i = 0; i < targetMechOIDList.size() && !foundLTPA; ++i) {
                                    targetAuthMechOID = (String)targetMechOIDList.get(i);
                                    if (!OID.compareOIDs(targetAuthMechOID, "oid:1.3.18.0.2.30.2")) continue;
                                    if (SecurityContextImpl.tc.isDebugEnabled()) {
                                        Tr.debug(SecurityContextImpl.tc, "csi_client_preprotect found LTPA oid in target");
                                    }
                                    foundLTPA = true;
                                    csiv2EffectivePolicy.setPerformClientAuthMechOID(targetAuthMechOID);
                                    targetAuthMech = (String)targetMechList.get(i);
                                    csiv2EffectivePolicy.setPerformClientAuthMech(targetAuthMech);
                                    performClientAuthMechOid = targetAuthMechOID;
                                    targetSecurityNameList = csiv2EffectivePolicy.getTargetSecurityNameList();
                                    csiv2EffectivePolicy.setTargetSecurityName((String)targetSecurityNameList.get(i));
                                }
                            }
                            if (!foundLTPA) {
                                throw new INTERNAL("Kerberos wsCredential without GSSCredential can not go outbound with Kerberos authentication mechanism", 1229066387, CompletionStatus.COMPLETED_NO);
                            }
                        }
                        if (wsSecContext == null) {
                            wsSecContext = csiv2EffectivePolicy.isAdmin() != false ? wsFactory.createContext(performClientAuthMechOid) : (useServerTokenForTrust != false ? wsFactory.createContext(wsCred.getOID()) : wsFactory.createContext(performClientAuthMechOid));
                        }
                        csiUtil.getCurrent().setWSSecurityContext(wsSecContext);
                        targetServerName = null;
                        if ("oid:1.2.840.113554.1.2.2".endsWith(performClientAuthMechOid)) {
                            targetServerName = csiv2EffectivePolicy.getTargetSecurityName();
                            realmDelimiterIndex = targetServerName.indexOf("@");
                            if (realmDelimiterIndex != -1) {
                                realm = targetServerName.substring(realmDelimiterIndex + 1, targetServerName.length());
                            }
                        } else {
                            targetServerName = csiv2EffectivePolicy.getTargetHostName();
                        }
                        if (SecurityContextImpl.tc.isDebugEnabled()) {
                            Tr.debug(SecurityContextImpl.tc, "Calling plugin initSecContext with targetServerName: " + targetServerName + " realm: " + realm + " authMech: " + csiv2EffectivePolicy.getPerformClientAuthMech() + " " + performClientAuthMechOid);
                        }
                        gssInitToken = wsSecContext.initSecContext(subject, targetServerName, realm, performClientAuthMechOid);
                        _gFactory = null;
                        _gFactory = wsCred.isBasicAuth() != false ? new GSSFactory("oid:2.23.130.1.1.1") : new GSSFactory(performClientAuthMechOid);
                        client_auth_token = _gFactory.encodeGSSToken(gssInitToken);
                        if (!WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled()) ** GOTO lbl221
                        if (SecurityContextImpl.tc.isDebugEnabled()) {
                            logMsg = "Adding authorization token to the request.";
                            Tr.debug(SecurityContextImpl.tc, logMsg);
                        }
                        tokenHolder = null;
                        if (client_subject != null) {
                            try {
                                tokenHolder = (TokenHolder)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                    public Object run() throws Exception {
                                        if (tc.isDebugEnabled()) {
                                            String logMsg = "Client subject: " + client_subject;
                                            Tr.debug(tc, logMsg);
                                        }
                                        Iterator<TokenHolder> privateCreds = client_subject.getPrivateCredentials(TokenHolder.class).iterator();
                                        while (privateCreds != null && privateCreds.hasNext()) {
                                            TokenHolder cred = privateCreds.next();
                                            if (!(cred instanceof TokenHolder) || !cred.getName().equals(WSOpaqueTokenHelper.getInstance().getOpaqueTokenName()) || cred.getVersion() != WSOpaqueTokenHelper.getInstance().getOpaqueTokenVersion()) continue;
                                            if (tc.isDebugEnabled()) {
                                                String logMsg = "Returning token holder containing opaque authz token.";
                                                Tr.debug(tc, logMsg);
                                            }
                                            return cred;
                                        }
                                        return null;
                                    }
                                });
                            }
                            catch (PrivilegedActionException e) {
                                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.SecurityContextImpl.csi_client_preprotect", "941", new Object[]{this});
                                if (!SecurityContextImpl.tc.isDebugEnabled()) break block70;
                                logMsg = "Exception getting private/public tokens from Subject.";
                                Tr.debug(SecurityContextImpl.tc, logMsg);
                            }
                        }
                    }
                    if (tokenHolder != null) {
                        ae[0] = new AuthorizationElement(1229066447, tokenHolder.getBytes());
                    }
                    if (!SecurityContextImpl.tc.isDebugEnabled()) ** GOTO lbl221
                    logMsg = "Didn't find an authz token to propagate.";
                    Tr.debug(SecurityContextImpl.tc, "Didn't find an authz token to propagate.");
                }
                if (!SecurityContextImpl.tc.isDebugEnabled()) ** GOTO lbl221
                Tr.debug(SecurityContextImpl.tc, "WSCredential isn't forwardable, identity token insertion is skipped.");
            }
            catch (WSSecurityContextException ex1) {
                Manager.Ffdc.log(ex1, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.SecurityContextImpl.csi_client_preprotect", "968", new Object[]{this});
                logMsg = "Caught WSSecurityContextException in WSSecurityContext.initSecContext(), reason: " + ex1.toString();
                Tr.debug(SecurityContextImpl.tc, logMsg, new Object[]{ex1});
                if (csiv2EffectivePolicy.isStateful() && stateful_context_id != 0L) {
                    sessionMgr.csi_client_session_status_update(stateful_context_id, clientSessionKey, 7);
                }
                PrincipalAuthFailReason.map_auth_fail_to_minor_code(ex1.getMajor(), StringBytesConversion.getConvertedBytes(ex1.toString()));
            }
            catch (Exception ex1) {
                Manager.Ffdc.log(ex1, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.SecurityContextImpl.csi_client_preprotect", "979", new Object[]{this});
                logMsg = "Caught Java exception in WSSecurityContext.initSecContext(), reason:, " + ex1.toString();
                Tr.debug(SecurityContextImpl.tc, logMsg, new Object[]{ex1});
                if (csiv2EffectivePolicy.isStateful() && stateful_context_id != 0L) {
                    sessionMgr.csi_client_session_status_update(stateful_context_id, clientSessionKey, 7);
                }
                throw new INTERNAL(logMsg, 1229066386, CompletionStatus.COMPLETED_NO);
            }
        } else if ((secCtx.getTokenType().equals("ClientAuthOnly") || secCtx.getTokenType().equals("ClientAuthAndIdentityOnly")) && subject == null) {
            if (SecurityContextImpl.tc.isDebugEnabled()) {
                logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0020W", "JSAS0020W: Unable to get credentials.");
                Tr.debug(SecurityContextImpl.tc, logMsg);
            }
            if (csiv2EffectivePolicy.isStateful() && stateful_context_id != 0L) {
                sessionMgr.csi_client_session_status_update(stateful_context_id, clientSessionKey, 7);
            }
            throw new NO_PERMISSION(logMsg, 1229066386, CompletionStatus.COMPLETED_NO);
        }
lbl221:
        // 9 sources

        if (client_auth_token == null) {
            client_auth_token = new byte[]{};
            if (SecurityContextImpl.tc.isDebugEnabled()) {
                logMsg = "Client Authentication Token is null.";
                Tr.debug(SecurityContextImpl.tc, logMsg);
            }
        }
        ec = new EstablishContext(stateful_context_id, ae, it, client_auth_token);
        csiUtil.print_ec_message(ec, "csi_client_preprotect");
        if (ec != null) {
            sc = csiUtil.create_sc_from_ec_message(ec);
            if (csiv2EffectivePolicy.isStateful() && stateful_context_id != 0L) {
                sessionMgr.csi_client_session_ecmessage_update(stateful_context_id, clientSessionKey, ec);
            }
        }
        if (sc != null) {
            info.add_request_service_context(sc, true);
        }
        if (SecurityContextImpl.tc.isEntryEnabled()) {
            Tr.exit(SecurityContextImpl.tc, "csi_client_preprotect", Boolean.TRUE);
        }
        return true;
    }

    public synchronized boolean csi_server_preprotect(ServerRequestInfo info, com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl secCtx) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "csi_server_preprotect", new Object[]{info, secCtx, this});
        }
        ServiceContext sc = null;
        CSIUtil csiUtil = new CSIUtil();
        long client_context_id = this.get_stateful_context_id();
        boolean stateful = false;
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (csiv2.getBoolean("com.ibm.CSI.claimStateful") && client_context_id > 0L) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stateful set to true for CompleteEstablishContext.  ContextID: " + client_context_id);
            }
            stateful = true;
        }
        switch (info.reply_status()) {
            case 0: {
                CompleteEstablishContext cec = null;
                byte[] final_token = new byte[]{};
                if (this.getFinalToken() != null) {
                    final_token = this.getFinalToken();
                }
                cec = new CompleteEstablishContext(client_context_id, stateful, final_token);
                csiUtil.print_cec_message(cec, "csi_server_preprotect");
                sc = csiUtil.create_sc_from_cec_message(cec);
                if (sc == null) break;
                info.add_reply_service_context(sc, true);
                break;
            }
            case 1: {
                try {
                    Any exception = info.sending_exception();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "A SYSTEM_EXCEPTION occurred: " + exception.type().id() + ".  Sending ContextError.");
                    }
                }
                catch (BadKind bk) {
                    Manager.Ffdc.log(bk, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.SecurityContextImpl.csi_server_preprotect", "1108", this);
                }
                byte[] error_token = csiUtil.serializeRootException();
                ContextError ce = null;
                if (secCtx != null) {
                    ce = secCtx.get_minor_code() == 1229079304 ? new ContextError(client_context_id, 4, 1, error_token) : new ContextError(client_context_id, 0, secCtx.get_minor_code(), error_token);
                    csiUtil.print_ce_message(ce, "csi_server_preprotect");
                } else {
                    ce = new ContextError(client_context_id, 0, 0, error_token);
                    csiUtil.print_ce_message(ce, "csi_server_preprotect");
                }
                sc = csiUtil.create_sc_from_ce_message(ce);
                if (sc == null) break;
                info.add_reply_service_context(sc, true);
                break;
            }
            case 2: {
                Any exception = null;
                try {
                    exception = info.sending_exception();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "A USER_EXCEPTION occurred: " + exception.type().id() + ".  Sending CompleteEstablishContext.");
                    }
                }
                catch (BadKind bk) {
                    Manager.Ffdc.log(bk, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.SecurityContextImpl.csi_server_preprotect", "1156", this);
                }
                byte[] final_token = new byte[]{};
                if (this.getFinalToken() != null) {
                    final_token = this.getFinalToken();
                }
                CompleteEstablishContext cec = new CompleteEstablishContext(client_context_id, stateful, final_token);
                csiUtil.print_cec_message(cec, "csi_server_preprotect");
                sc = csiUtil.create_sc_from_cec_message(cec);
                if (sc == null) break;
                info.add_reply_service_context(sc, true);
                break;
            }
            case 3: {
                byte[] final_token = new byte[]{};
                if (this.getFinalToken() != null) {
                    final_token = this.getFinalToken();
                }
                CompleteEstablishContext cec = new CompleteEstablishContext(client_context_id, stateful, final_token);
                csiUtil.print_cec_message(cec, "csi_server_preprotect");
                sc = csiUtil.create_sc_from_cec_message(cec);
                if (sc == null) break;
                info.add_reply_service_context(sc, true);
                break;
            }
            case 4: {
                byte[] final_token = new byte[]{};
                if (this.getFinalToken() != null) {
                    final_token = this.getFinalToken();
                }
                CompleteEstablishContext cec = new CompleteEstablishContext(client_context_id, stateful, final_token);
                csiUtil.print_cec_message(cec, "csi_server_preprotect");
                sc = csiUtil.create_sc_from_cec_message(cec);
                if (sc == null) break;
                info.add_reply_service_context(sc, true);
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "csi_server_preprotect", Boolean.TRUE);
        }
        return true;
    }

    protected Codec getCodec() {
        return this.vault.getCodec();
    }

    public static boolean isCertPathValidatorException(Object obj) {
        WSSecurityException ex2;
        Throwable th2;
        WSSecurityContextException ex1;
        Throwable th1;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCertPathValidatorException", obj);
        }
        boolean ret = false;
        if (obj != null && obj instanceof WSSecurityContextException && (th1 = (ex1 = (WSSecurityContextException)obj).getCause()) != null && th1 instanceof WSSecurityException && (th2 = (ex2 = (WSSecurityException)th1).getCause()) != null && th2 instanceof CertPathValidatorException) {
            ret = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCertPathValidatorException: " + ret);
        }
        return ret;
    }
}

