/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectTokenBaseImpl;

import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ISecurityLocalObjectGSSUPImpl.WSSecurityContextImpl;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ISecurityUtilityImpl.WSSecurityContextFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSSecurityContext;
import com.ibm.websphere.security.auth.WSSecurityContextException;
import com.ibm.websphere.security.auth.WSSecurityContextResult;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.net.InetAddress;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.CredentialExpiredException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class Krb5WSSecurityContextImpl
implements WSSecurityContext {
    private static final TraceComponent tc = Tr.register(Krb5WSSecurityContextImpl.class, "SASRas", "com.ibm.ws.security.auth.kerberos.krbsecurity");
    private static final String KRB5_OID = "1.2.840.113554.1.2.2";
    private static Oid _krb5MechOid = null;
    private static String _defaultRealm = null;
    private boolean _isDisposed = false;
    private boolean _initCalled = false;
    private static final GSSManager _manager = GSSManager.getInstance();

    public byte[] initSecContext(WSCredential cred, String targetHost, String realm) throws WSSecurityContextException {
        Subject subject = SubjectHelper.createSubjectFromWSCredential(cred);
        String authMechOid = null;
        try {
            authMechOid = cred.getOID();
        }
        catch (Exception e) {
            // empty catch block
        }
        return this.initSecContext(subject, targetHost, realm, authMechOid);
    }

    public byte[] initSecContext(Subject subject, String targetHost, String realm) throws WSSecurityContextException {
        String authMechOid = null;
        WSCredential cred = SubjectHelper.getWSCredentialFromSubject(subject);
        try {
            if (cred != null) {
                authMechOid = cred.getOID();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return this.initSecContext(subject, targetHost, realm, authMechOid);
    }

    public byte[] initSecContext(Subject subject, String host, final String realm, String authMechOid) throws WSSecurityContextException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initSecContext(subject, host, realm, authMechOid) " + host + " " + realm + " " + authMechOid);
        }
        byte[] outToken = null;
        GSSCredential gssCred = null;
        KerberosTicket krb5Ticket = null;
        try {
            if (OID.compareOIDs(authMechOid, "oid:2.23.130.1.1.1")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Encountered GSSUP credential. Calling GSSUP.initSecContext()");
                }
                WSSecurityContextImpl gssWSSecC = new WSSecurityContextImpl();
                outToken = gssWSSecC.initSecContext(subject, host, realm, authMechOid);
                if (tc.isEntryEnabled()) {
                    if (outToken == null) {
                        Tr.exit(tc, "initSecContext()", "returns null byte[]");
                    } else {
                        Tr.exit(tc, "initSecContext()", "returns byte[] of length " + outToken.length);
                    }
                }
                return outToken;
            }
            if (subject != null) {
                try {
                    gssCred = SubjectHelper.getGSSCredentialFromSubject(subject);
                    if (gssCred == null) {
                        krb5Ticket = SubjectHelper.getKerberosTicketFromSubject(subject);
                        if (krb5Ticket == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "initSecContext: private creds Set in Subject has no KerberosTicket");
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "initSecContext: found KerberosTicket in subject private creds");
                        }
                    }
                }
                catch (Exception exc) {
                    Manager.Ffdc.log(exc, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.Krb5WSSecurityContextImpl.initSecContext", "216", this);
                    Object[] parms = new Object[]{"getGSSCredential()", exc};
                    Tr.error(tc, "security.auth.kerberos.exception", parms);
                }
            }
            if (!OID.compareOIDs(authMechOid, KRB5_OID) && gssCred == null && krb5Ticket == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "initSecContext: creating context based on OID: " + authMechOid);
                }
                WSSecurityContext context = WSSecurityContextFactory.getInstance().createContext(authMechOid);
                outToken = context.initSecContext(subject, host, realm, authMechOid);
            } else if (OID.compareOIDs(authMechOid, KRB5_OID) && (gssCred != null || krb5Ticket != null) && realm != null && realm.contains(":") && host != null && !host.contains("/")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "initSecContext: creating context for LTPA ");
                }
                WSSecurityContext context = WSSecurityContextFactory.getInstance().createContext("oid:1.3.18.0.2.30.2");
                outToken = context.initSecContext(subject, host, realm, "oid:1.3.18.0.2.30.2");
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "initSecContext: creating Kerberos initial context token.");
                }
                String tRealm = null;
                int lastIndex = host.lastIndexOf("@");
                if (lastIndex != -1) {
                    tRealm = host.substring(lastIndex + 1, host.length());
                    host = host.substring(0, lastIndex);
                }
                if (tRealm == null || tRealm.length() == 0) {
                    tRealm = realm;
                }
                final String targetRealm = tRealm;
                final GSSCredential gssCredFinal = gssCred;
                final String targetHost = host;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Target realm name: " + targetRealm);
                }
                final Subject temp_subject = SubjectHelper.createSubjectFromKRBAuthnToken(subject);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "initSecContext: doAs(subject, ...) " + temp_subject);
                }
                outToken = (byte[])Subject.doAs(temp_subject, new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Unable to fully structure code
                     */
                    public Object run() throws GSSException, WSLoginFailedException, WSSecurityContextException, WSSecurityException, CredentialDestroyedException, CredentialExpiredException {
                        block63: {
                            block61: {
                                block60: {
                                    block59: {
                                        clientCred = gssCredFinal;
                                        subjectCred = null;
                                        clientContext = null;
                                        secExc = null;
                                        outToken2 = null;
                                        cred = SubjectHelper.getWSCredentialFromSubject(temp_subject);
                                        targetKrbSpn = null;
                                        if (targetHost.indexOf("/") != -1) ** GOTO lbl29
                                        gssCred = ContextManagerFactory.getInstance().getServerSpnGSSCred();
                                        if (gssCred != null) {
                                            securityName = gssCred.getName().toString();
                                            serviceName = RealmSecurityName.getService(securityName);
                                            if (Krb5WSSecurityContextImpl.access$000().isDebugEnabled()) {
                                                Tr.debug(Krb5WSSecurityContextImpl.access$000(), "SecurityName: " + securityName);
                                                Tr.debug(Krb5WSSecurityContextImpl.access$000(), "ServiceName: " + serviceName);
                                            }
                                            canonicalHostName = targetHost;
                                            if (serviceName != null && targetHost.equalsIgnoreCase("localhost")) {
                                                canonicalHostName = InetAddress.getLocalHost().getCanonicalHostName();
                                                if (Krb5WSSecurityContextImpl.access$000().isDebugEnabled()) {
                                                    Tr.debug(Krb5WSSecurityContextImpl.access$000(), "canonicalHostName: " + canonicalHostName);
                                                }
                                            }
                                            targetKrbSpn = serviceName + "/" + canonicalHostName;
                                        } else {
                                            parms = new Object[]{cred, targetHost, realm};
                                            Tr.error(Krb5WSSecurityContextImpl.access$000(), "security.auth.kerberos.NoCredFound", parms);
                                            secExc = new WSSecurityContextException(7, 0, null);
                                            throw secExc;
lbl29:
                                            // 1 sources

                                            targetKrbSpn = targetHost.indexOf("@") != -1 ? targetHost.replace("@", "/") : targetHost;
                                        }
                                        targetKrbSpn = targetKrbSpn + "@" + targetRealm;
                                        if (Krb5WSSecurityContextImpl.access$000().isDebugEnabled()) {
                                            Tr.debug(Krb5WSSecurityContextImpl.access$000(), "Target Kerberos Service Principal Name (service/hostname@KerberosRealm): " + targetKrbSpn);
                                        }
                                        if (Krb5WSSecurityContextImpl.access$100(Krb5WSSecurityContextImpl.this)) {
                                            Tr.error(Krb5WSSecurityContextImpl.access$000(), "security.auth.kerberos.instancedisposed", this);
                                            secExc = new WSSecurityContextException(14, 0, null);
                                            throw secExc;
                                        }
                                        Krb5WSSecurityContextImpl.access$202(Krb5WSSecurityContextImpl.this, true);
                                        if (cred != null) {
                                            if (Krb5WSSecurityContextImpl.access$000().isDebugEnabled()) {
                                                Tr.debug(Krb5WSSecurityContextImpl.access$000(), "initSecContext: input cred is non-null, good.");
                                            }
                                            try {
                                                if (cred.isForwardable()) {
                                                    if (Krb5WSSecurityContextImpl.access$000().isDebugEnabled()) {
                                                        Tr.debug(Krb5WSSecurityContextImpl.access$000(), "initSecContext: cred is forwardable, good.");
                                                    }
                                                    break block59;
                                                }
                                                parms = new Object[]{cred, targetKrbSpn, realm};
                                                Tr.warning(Krb5WSSecurityContextImpl.access$000(), "security.auth.kerberos.init.crednotforwardable", parms);
                                            }
                                            catch (Exception exc) {
                                                Manager.Ffdc.log(exc, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.Krb5WSSecurityContextImpl.initSecContext", "343", new Object[]{this});
                                                parms = new Object[]{"isForwardable()", exc};
                                                Tr.warning(Krb5WSSecurityContextImpl.access$000(), "security.auth.kerberos.exception", parms);
                                            }
                                        } else {
                                            parms = new Object[]{targetKrbSpn, realm};
                                            Tr.error(Krb5WSSecurityContextImpl.access$000(), "security.auth.kerberos.init.nullcred", parms);
                                            secExc = new WSSecurityContextException(14, 0, null);
                                            throw secExc;
                                        }
                                    }
                                    if (Krb5WSSecurityContextImpl.access$300() == null) {
                                        try {
                                            Krb5WSSecurityContextImpl.access$302(new Oid("1.2.840.113554.1.2.2"));
                                        }
                                        catch (GSSException exc) {
                                            Manager.Ffdc.log(exc, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.Krb5WSSecurityContextImpl.initSecContext", "361", new Object[]{this});
                                            parms = new Object[]{"Oid(\"1.2.840.113554.1.2.2\")", exc};
                                            Tr.error(Krb5WSSecurityContextImpl.access$000(), "security.auth.kerberos.unexpectedexception", parms);
                                            secExc = Krb5WSSecurityContextImpl.access$400(Krb5WSSecurityContextImpl.this, exc);
                                            throw secExc;
                                        }
                                    }
                                    serverName = null;
                                    try {
                                        serverName = Krb5WSSecurityContextImpl.access$500().createName(targetKrbSpn, GSSName.NT_USER_NAME, Krb5WSSecurityContextImpl.access$300());
                                        if (Krb5WSSecurityContextImpl.access$000().isDebugEnabled()) {
                                            Tr.debug(Krb5WSSecurityContextImpl.access$000(), "GSS target ServerName: " + serverName);
                                        }
                                    }
                                    catch (GSSException exc) {
                                        Manager.Ffdc.log(exc, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.Krb5WSSecurityContextImpl.initSecContext", "380", new Object[]{this});
                                        parms = new Object[]{"createName()", exc};
                                        Tr.error(Krb5WSSecurityContextImpl.access$000(), "security.auth.kerberos.unexpectedexception", parms);
                                        secExc = Krb5WSSecurityContextImpl.access$400(Krb5WSSecurityContextImpl.this, exc);
                                        throw secExc;
                                    }
                                    if (clientCred == null) {
                                        if (Krb5WSSecurityContextImpl.access$000().isDebugEnabled()) {
                                            Tr.debug(Krb5WSSecurityContextImpl.access$000(), "initSecContext: no GSSCredential in cred, using subject creds");
                                        }
                                        if (temp_subject != null) {
                                            princs = null;
                                            princs = temp_subject.getPrincipals(KerberosPrincipal.class);
                                            if (princs == null || princs.isEmpty()) {
                                                if (Krb5WSSecurityContextImpl.access$000().isDebugEnabled()) {
                                                    Tr.debug(Krb5WSSecurityContextImpl.access$000(), "initSecContext: principal Set in Subject has no KerberosPrincipal");
                                                }
                                            } else if (Krb5WSSecurityContextImpl.access$000().isDebugEnabled()) {
                                                Tr.debug(Krb5WSSecurityContextImpl.access$000(), "initSecContext: found Kerberos principal in subject principals");
                                                for (KerberosPrincipal princ : princs) {
                                                    if (princ == null) continue;
                                                    Tr.debug(Krb5WSSecurityContextImpl.access$000(), "initSecContext: Kerberos principal in subject: " + princ.toString());
                                                }
                                            }
                                        } else if (Krb5WSSecurityContextImpl.access$000().isDebugEnabled()) {
                                            Tr.debug(Krb5WSSecurityContextImpl.access$000(), "initSecContext: Unable to retrieve subject, subsequent createCredential will probably fail");
                                        }
                                        try {
                                            clientCred = subjectCred = Krb5WSSecurityContextImpl.access$500().createCredential(null, 0x7FFFFFFF, Krb5WSSecurityContextImpl.access$300(), 1);
                                        }
                                        catch (GSSException exc) {
                                            Manager.Ffdc.log(exc, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.Krb5WSSecurityContextImpl.initSecContext", "430", new Object[]{this});
                                            parms = new Object[]{"createCredential()", exc};
                                            Tr.error(Krb5WSSecurityContextImpl.access$000(), "security.auth.kerberos.unexpectedexception", parms);
                                            secExc = Krb5WSSecurityContextImpl.access$400(Krb5WSSecurityContextImpl.this, exc);
                                            throw secExc;
                                        }
                                    } else if (Krb5WSSecurityContextImpl.access$000().isDebugEnabled()) {
                                        Tr.debug(Krb5WSSecurityContextImpl.access$000(), "initSecContext: found GSSCredential in cred, using it " + clientCred);
                                    }
                                    try {
                                        clientContext = Krb5WSSecurityContextImpl.access$500().createContext(serverName.canonicalize(Krb5WSSecurityContextImpl.access$300()), Krb5WSSecurityContextImpl.access$300(), clientCred, 0x7FFFFFFF);
                                    }
                                    catch (GSSException exc) {
                                        Manager.Ffdc.log(exc, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.Krb5WSSecurityContextImpl.initSecContext", "452", new Object[]{this});
                                        parms = new Object[]{"createContext()", exc};
                                        Tr.error(Krb5WSSecurityContextImpl.access$000(), "security.auth.kerberos.unexpectedexception", parms);
                                        secExc = Krb5WSSecurityContextImpl.access$400(Krb5WSSecurityContextImpl.this, exc);
                                        throw secExc;
                                    }
                                    try {
                                        clientContext.requestCredDeleg(true);
                                    }
                                    catch (GSSException exc) {
                                        Manager.Ffdc.log(exc, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.Krb5WSSecurityContextImpl.initSecContext", "472", new Object[]{this});
                                        parms = new Object[]{"requestCredDeleg(true)", exc};
                                        Tr.error(Krb5WSSecurityContextImpl.access$000(), "security.auth.kerberos.unexpectedexception", parms);
                                        secExc = Krb5WSSecurityContextImpl.access$400(Krb5WSSecurityContextImpl.this, exc);
                                        throw secExc;
                                    }
                                    try {
                                        clientContext.requestReplayDet(true);
                                    }
                                    catch (GSSException exc) {
                                        Manager.Ffdc.log(exc, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.Krb5WSSecurityContextImpl.initSecContext", "483", new Object[]{this});
                                        parms = new Object[]{"requestReplayDet(true)", exc};
                                        Tr.error(Krb5WSSecurityContextImpl.access$000(), "security.auth.kerberos.unexpectedexception", parms);
                                        secExc = Krb5WSSecurityContextImpl.access$400(Krb5WSSecurityContextImpl.this, exc);
                                        throw secExc;
                                    }
                                    inToken2 = null;
                                    len = 0;
                                    try {
                                        outToken2 = clientContext.initSecContext(inToken2, 0, len);
                                    }
                                    catch (GSSException exc) {
                                        Manager.Ffdc.log(exc, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.Krb5WSSecurityContextImpl.initSecContext", "497", new Object[]{this});
                                        parms = new Object[]{"initSecContext()", exc};
                                        Tr.error(Krb5WSSecurityContextImpl.access$000(), "security.auth.kerberos.unexpectedexception", parms);
                                        secExc = Krb5WSSecurityContextImpl.access$400(Krb5WSSecurityContextImpl.this, exc);
                                        throw secExc;
                                    }
                                    if (!clientContext.isEstablished() || !Krb5WSSecurityContextImpl.access$000().isDebugEnabled()) break block60;
                                    Tr.debug(Krb5WSSecurityContextImpl.access$000(), "initSecContext: clientContext established successfully.");
                                }
                                var14_24 = null;
                                if (subjectCred == null) break block61;
                                try {
                                    subjectCred.dispose();
                                }
                                catch (GSSException exc) {
                                    parms = new Object[]{"dispose()", exc};
                                    Tr.error(Krb5WSSecurityContextImpl.access$000(), "security.auth.kerberos.unexpectedexception", parms);
                                }
                            }
                            if (clientContext != null) {
                                try {
                                    clientContext.dispose();
                                }
                                catch (GSSException exc) {
                                    Manager.Ffdc.log(exc, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.Krb5WSSecurityContextImpl.initSecContext", "534", new Object[]{this});
                                    parms = new Object[]{"dispose()", exc};
                                    Tr.error(Krb5WSSecurityContextImpl.access$000(), "security.auth.kerberos.unexpectedexception", parms);
                                }
                            }
                            break block63;
                            {
                                catch (Exception e) {
                                    var14_25 = null;
                                    if (subjectCred != null) {
                                        try {
                                            subjectCred.dispose();
                                        }
                                        catch (GSSException exc) {
                                            parms = new Object[]{"dispose()", exc};
                                            Tr.error(Krb5WSSecurityContextImpl.access$000(), "security.auth.kerberos.unexpectedexception", parms);
                                        }
                                    }
                                    if (clientContext != null) {
                                        try {
                                            clientContext.dispose();
                                        }
                                        catch (GSSException exc) {
                                            Manager.Ffdc.log(exc, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.Krb5WSSecurityContextImpl.initSecContext", "534", new Object[]{this});
                                            parms = new Object[]{"dispose()", exc};
                                            Tr.error(Krb5WSSecurityContextImpl.access$000(), "security.auth.kerberos.unexpectedexception", parms);
                                        }
                                    }
                                }
                            }
                            catch (Throwable var13_33) {
                                var14_26 = null;
                                if (subjectCred != null) {
                                    try {
                                        subjectCred.dispose();
                                    }
                                    catch (GSSException exc) {
                                        parms = new Object[]{"dispose()", exc};
                                        Tr.error(Krb5WSSecurityContextImpl.access$000(), "security.auth.kerberos.unexpectedexception", parms);
                                    }
                                }
                                if (clientContext != null) {
                                    try {
                                        clientContext.dispose();
                                    }
                                    catch (GSSException exc) {
                                        Manager.Ffdc.log(exc, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.Krb5WSSecurityContextImpl.initSecContext", "534", new Object[]{this});
                                        parms = new Object[]{"dispose()", exc};
                                        Tr.error(Krb5WSSecurityContextImpl.access$000(), "security.auth.kerberos.unexpectedexception", parms);
                                    }
                                }
                                throw var13_33;
                            }
                        }
                        return outToken2;
                    }
                });
            }
        }
        catch (PrivilegedActionException e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.Krb5WSSecurityContextImpl.initSecContext", "547", this);
            Tr.debug(tc, "Exception in Subject.doAS()", new Object[]{e.getException()});
            if (e.getException() instanceof WSSecurityContextException) {
                throw (WSSecurityContextException)e.getException();
            }
            throw new WSSecurityContextException(6, 0, e.getException().getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            if (outToken == null) {
                Tr.exit(tc, "initSecContext()", "returns null byte[]");
            } else {
                Tr.exit(tc, "initSecContext()", "returns byte[] of length " + outToken.length);
            }
        }
        return outToken;
    }

    public WSSecurityContextResult acceptSecContext(byte[] token) throws WSSecurityContextException {
        WSSecurityContextResult res = this.acceptSecContext(token, null, null);
        return res;
    }

    public WSSecurityContextResult acceptSecContext(byte[] token, Map appContext) throws WSSecurityContextException {
        WSSecurityContextResult res = this.acceptSecContext(token, appContext, null);
        return res;
    }

    public WSSecurityContextResult acceptSecContext(byte[] token, Map appContext, String authMechOid) throws WSSecurityContextException {
        Object urCred = null;
        Object wsCred = null;
        Object wsServerCred = null;
        byte[] outToken = null;
        WSSecurityContextException secExc = null;
        WSSecurityContextResult res = null;
        Object serverCred = null;
        Object serverContext = null;
        Object theOID = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "acceptSecContext(token, appContext, authMechOid)");
        }
        try {
            String oidStr = GSSFactory.getMechOIDFromGSSToken(token);
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "gssInitToken OID: " + oidStr);
            }
            if (token == null || token.length == 0 || oidStr == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "acceptSecContext(null token or oid)");
                }
                return new WSSecurityContextResult(null, ContextManagerFactory.getInstance().createUnauthenticatedSubject());
            }
            if (!OID.compareOIDs(oidStr, KRB5_OID)) {
                WSSecurityContext context = WSSecurityContextFactory.getInstance().createContext(oidStr);
                return context.acceptSecContext(token, appContext, oidStr);
            }
            ContextManager contextManager = ContextManagerFactory.getInstance();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "token length: " + token.length);
            }
            CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
            Subject subject = contextManager.login(contextManager.getDefaultRealm(), token, csiv2.getString("com.ibm.CSI.rmiInboundLoginConfig"), null, null, appContext, null, authMechOid);
            res = new WSSecurityContextResult(outToken, subject);
            if (res == null) {
                Object[] parms = new Object[]{WSSecurityContextResult.class, "token"};
                Tr.error(tc, "security.auth.kerberos.nullconstructor", parms);
                secExc = new WSSecurityContextException(14, 0, null);
                throw secExc;
            }
        }
        catch (Exception e) {
            if (!SecurityMessages.suppressFFDCforKrbSkewError(e)) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectTokenBaseImpl.Krb5WSSecurityContextImpl.acceptSecContext", "665", this);
            }
            Tr.debug(tc, "Exception accepting initial context token. ", new Object[]{e});
            if (e instanceof WSSecurityContextException) {
                throw (WSSecurityContextException)e;
            }
            throw new WSSecurityContextException(14, 0, e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "acceptSecContext(token, appContext, authMechOid)");
        }
        return res;
    }

    public void completeSecContext(byte[] final_token) throws WSSecurityContextException {
        WSSecurityContextException secExc = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeSecContext()");
        }
        if (this._isDisposed) {
            Tr.error(tc, "security.auth.kerberos.instancedisposed", this);
            secExc = new WSSecurityContextException(14, 0, null);
            throw secExc;
        }
        if (!this._initCalled) {
            Tr.error(tc, "security.auth.kerberos.complete.initnotcalled", this);
            secExc = new WSSecurityContextException(14, 0, null);
            throw secExc;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeSecContext()");
        }
    }

    public void dispose() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dispose()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dispose()");
        }
    }

    public boolean isDisposed() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isDisposed()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isDisposed()", new Boolean(this._isDisposed));
        }
        return this._isDisposed;
    }

    private String getDefaultRealm() throws IllegalArgumentException {
        KerberosPrincipal dummyPrinc = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultRealm()");
        }
        if (_defaultRealm == null) {
            dummyPrinc = new KerberosPrincipal("nobody");
            _defaultRealm = dummyPrinc.getRealm();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultRealm()", _defaultRealm);
        }
        return _defaultRealm;
    }

    private String mapPrinc(String princ, String realm) {
        String mappedPrinc = null;
        if (tc.isEntryEnabled()) {
            if (realm == null) {
                Tr.entry(tc, "mapPrinc()", princ);
            } else {
                Tr.entry(tc, "mapPrinc()", princ + "@" + realm);
            }
        }
        mappedPrinc = realm == null ? princ : princ + "@" + realm;
        if (tc.isEntryEnabled()) {
            if (realm == null) {
                Tr.exit(tc, "mapPrinc()", princ + " -> " + mappedPrinc);
            } else {
                Tr.exit(tc, "mapPrinc()", princ + "@" + realm + " -> " + mappedPrinc);
            }
        }
        return mappedPrinc;
    }

    private GSSName getServerName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerName()");
        }
        GSSName serverName = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerName()", serverName);
        }
        return serverName;
    }

    private WSSecurityContextException mapGssExc(GSSException exc) {
        WSSecurityContextException secExc = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapGssExc()", exc);
        }
        int gssMajor = exc.getMajor();
        int gssMinor = exc.getMinor();
        String gssMinorString = exc.getMinorString();
        int secMajor = this.mapMajor(gssMajor);
        secExc = new WSSecurityContextException(secMajor, gssMinor, gssMinorString);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapGssExc()", secExc);
        }
        return secExc;
    }

    private int mapMajor(int major) {
        int code = 0;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapMajor()", new Integer(major));
        }
        switch (major) {
            case 7: 
            case 8: 
            case 20: {
                code = 5;
                break;
            }
            case 9: {
                code = 7;
                break;
            }
            case 10: {
                code = 6;
                break;
            }
            default: {
                code = 14;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapMajor()", new Integer(code));
        }
        return code;
    }

    static /* synthetic */ TraceComponent access$000() {
        return tc;
    }

    static /* synthetic */ boolean access$100(Krb5WSSecurityContextImpl x0) {
        return x0._isDisposed;
    }

    static /* synthetic */ boolean access$202(Krb5WSSecurityContextImpl x0, boolean x1) {
        x0._initCalled = x1;
        return x0._initCalled;
    }

    static /* synthetic */ Oid access$300() {
        return _krb5MechOid;
    }

    static /* synthetic */ Oid access$302(Oid x0) {
        _krb5MechOid = x0;
        return _krb5MechOid;
    }

    static /* synthetic */ WSSecurityContextException access$400(Krb5WSSecurityContextImpl x0, GSSException x1) {
        return x0.mapGssExc(x1);
    }

    static /* synthetic */ GSSManager access$500() {
        return _manager;
    }
}

