/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectCSIv2UtilityImpl;

import com.ibm.CORBA.iiop.ExtendedClientRequestInfo;
import com.ibm.CORBA.iiop.ExtendedServerRequestInfo;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CSICredentialsManager;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.ClientSessionKey;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.Connection;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.ConnectionTable;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.ServerConnectionKey;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionEntry;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionHashTable;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionTable;
import com.ibm.ISecurityUtilityImpl.CSIUtil;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.orbimpl.transport.ConnectionInformationImpl;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnToken;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Timestamp;
import java.util.Map;
import javax.security.auth.Subject;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.SystemException;
import org.omg.CSI.CompleteEstablishContext;
import org.omg.CSI.ContextError;
import org.omg.CSI.EstablishContext;
import org.omg.CSI.SASContextBody;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.RequestInfo;
import org.omg.PortableInterceptor.ServerRequestInfo;

public class SessionManager
implements AlarmListener {
    private ConnectionTable serverConnTable = null;
    private ConnectionTable clientConnTable = null;
    private long context_generator = 1L;
    private CSIUtil csiUtil = new CSIUtil();
    int sessionCleanupInterval = 300000;
    int sessionDiscardUnusedMillis = 900000;
    int sessionCacheMaxSize = -1;
    int sessionCacheIdleTime = -1;
    private static final TraceComponent tc = Tr.register(SessionManager.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");

    public SessionManager() {
        this.serverConnTable = new ConnectionTable();
        this.clientConnTable = new ConnectionTable();
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        this.sessionCleanupInterval = csiv2.getInteger("com.ibm.CORBA.sessionGCinterval");
        this.sessionDiscardUnusedMillis = csiv2.getInteger("com.ibm.CORBA.sessionGCdiscardunused");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SessionManager cleanup alarm set for sessionGCinterval: " + this.sessionCleanupInterval + " milliseconds, sessionDiscardUnused: " + this.sessionDiscardUnusedMillis + " milliseconds.");
        }
        if (RasHelper.isServer()) {
            boolean sessionCacheLimitEnabled = SecurityObjectLocator.getSecurityConfig().getPropertyBool("com.ibm.websphere.security.util.csiv2SessionCacheLimitEnabled");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Session cache limit is enabled: " + sessionCacheLimitEnabled);
            }
            if (sessionCacheLimitEnabled) {
                String sessionCacheIdleTimeString;
                String sessionCacheMaxSizeString = SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.websphere.security.util.csiv2SessionCacheMaxSize");
                if (sessionCacheMaxSizeString != null) {
                    this.sessionCacheMaxSize = Integer.parseInt(sessionCacheMaxSizeString);
                }
                if (tc.isDebugEnabled() && this.sessionCacheMaxSize > 0) {
                    Tr.debug(tc, "Session Cache Max Size " + this.sessionCacheMaxSize);
                }
                if ((sessionCacheIdleTimeString = SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.websphere.security.util.csiv2SessionCacheIdleTime")) != null) {
                    this.sessionCacheIdleTime = Integer.parseInt(sessionCacheIdleTimeString);
                }
                if (tc.isDebugEnabled() && this.sessionCacheIdleTime > 0) {
                    Tr.debug(tc, "Session Cache Idle Time " + this.sessionCacheIdleTime);
                }
            }
        }
        if (this.sessionCacheMaxSize > 0 && this.sessionCacheIdleTime > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cache max size is defined, disabling the garbage collection for session entries ");
            }
        } else {
            long timeout = System.currentTimeMillis() + (long)this.sessionCleanupInterval;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Next grabage cleanup time: " + new Timestamp(timeout));
            }
            AlarmManager.createDeferrable(this.sessionCleanupInterval, this);
        }
    }

    public SessionEntry csi_server_session_lookup(long stateful_context_id, ServerConnectionKey connKey, SASContextBody msg, boolean internalLookup) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "csi_server_session_lookup", new Object[]{new Long(stateful_context_id), connKey, msg, internalLookup, this});
        }
        Connection connection = null;
        SessionEntry sessionEntry = null;
        int session_state = 5;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Looking for unique server session with hash: " + connKey.get_server_connection_hash() + ":" + stateful_context_id);
        }
        if ((sessionEntry = this.get_server_session_from_connection(stateful_context_id, connection = this.server_connection_lookup(connKey.get_server_connection_hash()))) == null && msg != null && msg.discriminator() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Message is EstablishContext and session not found, adding new session entry.");
            }
            sessionEntry = this.add_server_session_to_connection(stateful_context_id, connection, msg.establish_msg());
        } else {
            if (sessionEntry == null && msg != null && msg.discriminator() == 5) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Message is MessageInContext and session not found, returning null.");
                }
                return null;
            }
            if (sessionEntry != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Session has been found.");
                }
                if ((session_state = sessionEntry.get_session_state()) == 7 && msg != null && msg.discriminator() == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Message type is EstablishContext but session found was already SESSION_REJECTED, deleting session and creating new session.");
                    }
                    this.delete_server_session_from_connection(stateful_context_id, connection);
                    sessionEntry = this.add_server_session_to_connection(stateful_context_id, connection, msg.establish_msg());
                } else if (!internalLookup && msg != null && msg.discriminator() == 0 && !sessionEntry.compare_establish_context_messages(msg.establish_msg())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Message type is EstablishContext but session found had different tokens.  Changing state of session to SESSION_CONFLICTING_EVIDENCE");
                    }
                    sessionEntry.set_session_state(3);
                }
            }
        }
        if (sessionEntry != null) {
            sessionEntry.update_session_usage_timestamp();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "csi_server_session_lookup", sessionEntry);
        }
        return sessionEntry;
    }

    public SessionEntry csi_client_session_lookup(ClientSessionKey clientSessionKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "csi_client_session_lookup", new Object[]{clientSessionKey, this});
        }
        Connection connection = null;
        SessionEntry sessionEntry = null;
        int session_state = 5;
        connection = this.client_connection_lookup(clientSessionKey.get_connection_key());
        sessionEntry = this.get_client_session_from_connection(clientSessionKey, connection);
        if (sessionEntry == null) {
            sessionEntry = this.add_client_session_to_connection(clientSessionKey, connection);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unique client session added with hash: " + clientSessionKey.get_client_session_hash() + ":" + sessionEntry.get_client_context_id());
            }
        } else {
            if (sessionEntry.get_session_state() == 7) {
                this.delete_client_session_from_connection(sessionEntry.get_client_context_id(), connection);
                sessionEntry = this.add_client_session_to_connection(clientSessionKey, connection);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Previous session in SESSION_REJECTED state, adding new unique client session with hash: " + clientSessionKey.get_client_session_hash() + ":" + sessionEntry.get_client_context_id());
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found unique session with hash: " + clientSessionKey.get_client_session_hash() + ":" + sessionEntry.get_client_context_id());
            }
        }
        sessionEntry.update_session_usage_timestamp();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "csi_client_session_lookup", sessionEntry);
        }
        return sessionEntry;
    }

    public void csi_client_session_status_update(long client_context_id, ClientSessionKey clientSessionKey, int session_state) {
        SessionEntry sessionEntry = null;
        if (clientSessionKey != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ContextID: " + client_context_id + ", SessionHash: " + clientSessionKey.get_client_session_hash() + ", SessionState: " + session_state);
            }
            sessionEntry = this.get_client_session_by_context_id(client_context_id, clientSessionKey);
            if (clientSessionKey != null && sessionEntry != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found unique session with hash: " + clientSessionKey.get_client_session_hash() + ":" + sessionEntry.get_client_context_id());
                }
                sessionEntry.set_session_state(session_state);
                this.update_client_session(clientSessionKey, sessionEntry);
            }
        }
    }

    public void csi_client_session_ecmessage_update(long client_context_id, ClientSessionKey clientSessionKey, EstablishContext ec) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Updating session: " + client_context_id + ", clientSessionKey: " + clientSessionKey.get_client_session_hash());
        }
        SessionEntry sessionEntry = null;
        if (clientSessionKey != null) {
            sessionEntry = this.get_client_session_by_context_id(client_context_id, clientSessionKey);
            if (sessionEntry != null) {
                sessionEntry.set_ec_message(ec);
                this.update_client_session(clientSessionKey, sessionEntry);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Did not find a sessionEntry.");
            }
        }
    }

    private SessionEntry get_client_session_from_connection(ClientSessionKey clientSessionKey, Connection conn) {
        long client_context_id = 0L;
        SessionEntry sessionEntry = null;
        if (clientSessionKey != null) {
            SessionHashTable sessionHashTable = conn.getSessionHashTable();
            SessionTable sessionTable = conn.getClientSessionTable();
            client_context_id = sessionHashTable.get_session_hash(clientSessionKey);
            if (client_context_id != 0L) {
                sessionEntry = sessionTable.get_session(client_context_id);
            }
        }
        return sessionEntry;
    }

    private synchronized SessionEntry get_client_session_by_context_id(long client_context_id, ClientSessionKey clientSessionKey) {
        SessionEntry sessionEntry = null;
        Connection conn = null;
        if (clientSessionKey != null && (conn = this.client_connection_lookup(clientSessionKey.get_connection_key())) != null) {
            SessionTable sessionTable = conn.getClientSessionTable();
            if (client_context_id != 0L) {
                sessionEntry = sessionTable.get_session(client_context_id);
            }
        }
        return sessionEntry;
    }

    protected SessionEntry add_server_session_to_connection(long stateful_context_id, Connection conn, EstablishContext ec) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "add_server_session_to_connection");
        }
        SessionEntry sessionEntry = null;
        SessionTable sessionTable = conn.getServerSessionTable();
        if (sessionTable != null) {
            String unique_session_hash;
            int sessionTableSize = sessionTable.size();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server session table size: " + sessionTableSize);
            }
            if (this.sessionCacheMaxSize > 0 && this.sessionCacheIdleTime > 0 && sessionTableSize > this.sessionCacheMaxSize) {
                this.clean_server_sessions(sessionTable, this.sessionCacheIdleTime);
            }
            if ((sessionEntry = new SessionEntry(stateful_context_id, ec, unique_session_hash = conn.get_connection_hash() + ":" + stateful_context_id)) != null) {
                sessionTable.add_session(stateful_context_id, sessionEntry);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Session table is null ");
        }
        return sessionEntry;
    }

    private SessionEntry add_client_session_to_connection(ClientSessionKey clientSessionKey, Connection conn) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "add_client_session_to_connection");
        }
        SessionEntry sessionEntry = null;
        SessionTable sessionTable = conn.getClientSessionTable();
        SessionHashTable sessionHashTable = conn.getSessionHashTable();
        if (sessionHashTable != null && sessionTable != null) {
            int sessionTableSize = sessionTable.size();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Client session table size: " + sessionTableSize);
            }
            if (this.sessionCacheMaxSize > 0 && this.sessionCacheIdleTime > 0 && sessionTableSize > this.sessionCacheMaxSize) {
                this.clean_client_sessions(sessionTable, sessionHashTable, this.sessionCacheIdleTime);
            }
            if ((sessionEntry = new SessionEntry(this.get_next_context_id())) == null) {
                throw new OutOfMemoryError();
            }
            sessionEntry.set_session_state(4);
            sessionEntry.set_client_session_key(clientSessionKey);
            sessionHashTable.add_session_hash(clientSessionKey, sessionEntry.get_client_context_id());
            sessionTable.add_session(sessionEntry.get_client_context_id(), sessionEntry);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Session table, session hash table or both are null ");
        }
        return sessionEntry;
    }

    public void update_client_session(ClientSessionKey clientSessionKey, SessionEntry sessionEntry) {
        Connection conn = null;
        if (clientSessionKey != null && (conn = this.client_connection_lookup(clientSessionKey.get_connection_key())) != null) {
            SessionTable sessionTable = conn.getClientSessionTable();
            sessionTable.add_session(sessionEntry.get_client_context_id(), sessionEntry);
        }
    }

    public synchronized boolean csi_message_stateful_after_postinvoke(ServerRequestInfo info, SecurityContextImpl secCtx) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "csi_message_stateful_after_postinvoke", new Object[]{info, secCtx, this});
        }
        long stateful_context_id = 0L;
        ServerConnectionKey connKey = null;
        SessionEntry sessionEntry = null;
        int session_state = 0;
        boolean stateful = false;
        ConnectionInformationImpl connectionInfo = null;
        connectionInfo = (ConnectionInformationImpl)((ExtendedServerRequestInfo)info).getConnectionData();
        if (secCtx != null) {
            stateful_context_id = secCtx.get_stateful_context_id();
        }
        if (stateful_context_id != 0L && (sessionEntry = this.csi_server_session_get(stateful_context_id, connKey = new ServerConnectionKey(connectionInfo.getConnectionCreationTime(), connectionInfo.getRemoteHost(), connectionInfo.getRemotePort()))) != null) {
            session_state = sessionEntry.get_session_state();
            switch (session_state) {
                case 1: {
                    stateful = true;
                    break;
                }
                default: {
                    stateful = false;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "csi_message_stateful_after_postinvoke", new Boolean(stateful));
        }
        return stateful;
    }

    public long csi_get_context_id_from_service_context(SecurityContextImpl secCtx) {
        if (secCtx != null) {
            return secCtx.get_stateful_context_id();
        }
        return 0L;
    }

    public SessionEntry csi_server_session_get(long stateful_context_id, ServerConnectionKey connKey) {
        Connection connection = null;
        connection = this.server_connection_lookup(connKey.get_server_connection_hash());
        return this.get_server_session_from_connection(stateful_context_id, connection);
    }

    public synchronized void csi_server_session_update(long stateful_context_id, ServerConnectionKey connKey, SessionEntry sessionEntry) {
        Connection connection = null;
        connection = this.server_connection_lookup(connKey.get_server_connection_hash());
        if (sessionEntry != null && connection != null) {
            this.update_server_session_to_connection(stateful_context_id, connection, sessionEntry);
        }
    }

    public void csi_server_session_status_update(long stateful_context_id, ServerConnectionKey connKey, int session_state) {
        Connection connection = null;
        SessionEntry sessionEntry = null;
        connection = this.server_connection_lookup(connKey.get_server_connection_hash());
        sessionEntry = this.get_server_session_from_connection(stateful_context_id, connection);
        if (sessionEntry != null) {
            sessionEntry.set_session_state(session_state);
            this.update_server_session_to_connection(stateful_context_id, connection, sessionEntry);
        }
    }

    protected Connection server_connection_lookup(String connKey) {
        Connection conn = null;
        conn = (Connection)this.serverConnTable.get(connKey);
        if (conn == null) {
            conn = new Connection();
            conn.set_connection_hash(connKey);
            this.serverConnTable.put(connKey, conn);
        }
        return conn;
    }

    protected Connection client_connection_lookup(String connKey) {
        Connection conn = null;
        conn = (Connection)this.clientConnTable.get(connKey);
        if (conn == null) {
            conn = new Connection();
            conn.set_connection_hash(connKey);
            this.clientConnTable.put(connKey, conn);
        }
        return conn;
    }

    public void csi_delete_client_connection(String connectionKey) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "A connection has been broken to " + connectionKey + ".  Removing session entries for this connection.");
        }
        Connection conn = null;
        conn = (Connection)this.clientConnTable.get(connectionKey);
        if (conn != null) {
            conn.getClientSessionTable().clear();
            conn.getSessionHashTable().clear();
            this.clientConnTable.remove(connectionKey);
        }
    }

    public void csi_delete_server_connection(String connectionKey) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "A connection has been broken to " + connectionKey + ".  Removing session entries for this connection.");
        }
        Connection conn = null;
        conn = (Connection)this.serverConnTable.get(connectionKey);
        if (conn != null) {
            conn.getServerSessionTable().clear();
            this.serverConnTable.remove(connectionKey);
        }
    }

    protected SessionEntry get_server_session_from_connection(long stateful_context_id, Connection conn) {
        SessionTable sessionTable = conn.getServerSessionTable();
        if (sessionTable != null) {
            return sessionTable.get_session(stateful_context_id);
        }
        return null;
    }

    protected void delete_server_session_from_connection(long stateful_context_id, Connection conn) {
        SessionTable sessionTable = conn.getServerSessionTable();
        if (sessionTable != null) {
            sessionTable.delete_session(stateful_context_id);
        }
    }

    protected void delete_client_session_from_connection(long stateful_context_id, Connection conn) {
        SessionTable sessionTable = conn.getClientSessionTable();
        if (sessionTable != null) {
            sessionTable.delete_session(stateful_context_id);
        }
    }

    protected void update_server_session_to_connection(long stateful_context_id, Connection conn, SessionEntry sessionEntry) {
        SessionTable sessionTable = conn.getServerSessionTable();
        if (sessionEntry == null) {
            throw new BAD_PARAM();
        }
        sessionTable.add_session(stateful_context_id, sessionEntry);
    }

    private synchronized long get_next_context_id() {
        return this.context_generator++;
    }

    public void csi_client_session_complete(SASContextBody msg, boolean stateful, long stateful_context_id, ClientSessionKey clientSessionKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "csi_client_session_complete", new Object[]{msg, new Boolean(stateful), new Long(stateful_context_id), clientSessionKey, this});
        }
        if (!stateful) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "In stateless mode, no client session was added.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "csi_client_session_complete");
            }
            return;
        }
        CompleteEstablishContext cec = null;
        Object ce = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Client session key used: " + clientSessionKey);
        }
        if (clientSessionKey == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exiting early due to null clientSessionKey.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "csi_client_session_complete");
            }
            return;
        }
        if (msg != null && msg.discriminator() == 1) {
            cec = msg.complete_msg();
            if (cec.context_stateful && cec.client_context_id != 0L) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Marking session complete.");
                }
                this.csi_client_session_status_update(cec.client_context_id, clientSessionKey, 1);
            } else if (cec.client_context_id == 0L && stateful_context_id != 0L) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Marking client session rejected, server negotiated session as stateless.");
                }
                this.csi_client_session_status_update(stateful_context_id, clientSessionKey, 7);
            }
            CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
            if (csiv2.getBoolean("com.ibm.CORBA.authenticationRetryEnabled")) {
                this.csiUtil.getCurrent().clear_retry_count();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "csi_client_session_complete");
        }
    }

    public void csi_client_session_complete_exception(SASContextBody msg, boolean stateful, ClientSessionKey clientSessionKey) throws ForwardRequest {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "csi_client_session_complete_exception", new Object[]{msg, new Boolean(stateful), clientSessionKey, this});
        }
        if (!stateful) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "csi_client_session_complete_exception");
            }
            return;
        }
        CompleteEstablishContext cec = null;
        ContextError ce = null;
        if (msg != null && msg.discriminator() == 1) {
            CSIv2Config csiv2;
            cec = msg.complete_msg();
            if (cec.context_stateful && cec.client_context_id != 0L) {
                this.csi_client_session_status_update(cec.client_context_id, clientSessionKey, 1);
            }
            if ((csiv2 = SecurityObjectLocator.getCSIv2Config()).getBoolean("com.ibm.CORBA.authenticationRetryEnabled")) {
                this.csiUtil.getCurrent().clear_retry_count();
            }
        } else if (msg != null && msg.discriminator() == 4 && (ce = msg.error_msg()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Client context ID: " + ce.client_context_id);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Marking session as rejected.");
            }
            this.csiUtil.deserializeRootException(ce.error_token);
            if (ce.client_context_id != 0L) {
                this.csi_client_session_status_update(ce.client_context_id, clientSessionKey, 7);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "csi_client_session_complete_exception");
        }
    }

    public void retry(ClientRequestInfo info) throws ForwardRequest {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retry", new Object[]{info, this});
        }
        ContextManager contextMgr = ContextManagerFactory.getInstance();
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (csiv2.getBoolean("com.ibm.CORBA.authenticationRetryEnabled") && this.csiUtil.getCurrent().getAuthRetryForJAAS()) {
            int retry_count = this.csiUtil.getCurrent().get_retry_count();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retry count is " + retry_count);
            }
            SystemException ex = null;
            if (retry_count < csiv2.getInteger("com.ibm.CORBA.authenticationRetryCount")) {
                this.csiUtil.getCurrent().increment_retry_count();
                long minor_code = 0L;
                CompletionStatus completed = CompletionStatus.COMPLETED_MAYBE;
                Any exception = null;
                CSICredentialsManager credsMgr = new CSICredentialsManager();
                exception = info.received_exception();
                if (exception != null && (ex = ((ExtendedClientRequestInfo)info).getSystemException()) != null) {
                    minor_code = ex.minor;
                }
                if (minor_code == 1229079302L || minor_code == 1229079301L || minor_code == 1229079303L || minor_code == 1229079304L || minor_code == 1229079306L || minor_code == 1229079305L || this.isReferenceContextErrorRetriable(info) || minor_code == 1229079296L || minor_code == 1229079297L || minor_code == 1229079299L || minor_code == 1229079298L || this.isAcceptContextErrorRetriable(info)) {
                    Subject subject = null;
                    WSCredential wsCred = null;
                    try {
                        subject = credsMgr.getInvocationSubject();
                    }
                    catch (Exception e) {
                        Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionManager.retry", "992", this);
                        Tr.debug(tc, "Exception getting Subject from thread.  " + e.toString());
                    }
                    wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
                    KRBAuthnToken krbAuthnToken = SubjectHelper.getKerberosAuthnTokenFromSubject(subject);
                    if (wsCred != null && wsCred.isBasicAuth()) {
                        int loginSource;
                        if (!(minor_code != 1229079296L && minor_code != 1229079297L && minor_code != 1229079299L && minor_code != 1229079298L && !this.isAcceptContextErrorRetriable(info) || (loginSource = csiv2.getInteger("com.ibm.CORBA.loginSource")) != 1 && loginSource != 6)) {
                            try {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Setting invocation to NULL.");
                                }
                                contextMgr.setInvocationSubject(null);
                            }
                            catch (Exception e) {
                                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionManager.retry", "1018", this);
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Throwing a ForwardRequest exception to retry the request.");
                        }
                        throw new ForwardRequest(info.target());
                    }
                    if (wsCred != null && !wsCred.isBasicAuth() && krbAuthnToken != null && krbAuthnToken.isTokenValid()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "krbAuthnToken is valid. Throwing a ForwardRequest exception to retry the request.");
                        }
                        throw new ForwardRequest(info.target());
                    }
                    if (wsCred != null) {
                        try {
                            if (contextMgr.isServerCred(wsCred)) {
                                try {
                                    try {
                                        final ContextManager contextMgrPriv = contextMgr;
                                        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                                            public Object run() throws Exception {
                                                contextMgrPriv.setInvocationSubject(contextMgrPriv.getServerSubject());
                                                return null;
                                            }
                                        };
                                        AccessController.doPrivileged(action);
                                    }
                                    catch (PrivilegedActionException e) {
                                        Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionManager.retry", "1059", this);
                                        Tr.debug(tc, "Exception refreshing server credential.");
                                        throw e.getException();
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Retrying with refreshed server cred.");
                                    }
                                    throw new ForwardRequest(info.target());
                                }
                                catch (Exception e) {
                                    if (e instanceof ForwardRequest) {
                                        throw (ForwardRequest)e;
                                    }
                                    Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionManager.retry", "1076", this);
                                    Tr.debug(tc, "Caught exception trying to set invocation subject. Reason: " + e.toString(), new Object[]{e});
                                    throw new NO_PERMISSION("Caught exception trying to set invocation subject. Reason: " + e.toString(), 1229079302, CompletionStatus.COMPLETED_NO);
                                }
                            }
                            contextMgr.renew(subject, 0, true);
                            try {
                                final ContextManager contextMgrPriv = contextMgr;
                                final Subject subjectPriv = subject;
                                PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                                    public Object run() throws Exception {
                                        contextMgrPriv.setInvocationSubject(subjectPriv);
                                        return null;
                                    }
                                };
                                AccessController.doPrivileged(action);
                            }
                            catch (PrivilegedActionException e) {
                                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionManager.retry", "1058", this);
                                Tr.debug(tc, "Exception refreshing server credential.");
                                throw e.getException();
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Authentication Failed: " + ex.getMessage());
                            }
                            throw new NO_PERMISSION(ex.getMessage(), ex.minor, CompletionStatus.COMPLETED_NO);
                        }
                        catch (Exception e) {
                            if (e instanceof ForwardRequest) {
                                throw (ForwardRequest)e;
                            }
                            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionManager.retry", "1143", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Authentication Failed: " + ex.getMessage());
                            }
                            throw new NO_PERMISSION(ex.getMessage(), ex.minor, CompletionStatus.COMPLETED_NO);
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retry");
        }
    }

    public boolean isReferenceContextErrorRetriable(ClientRequestInfo info) throws ForwardRequest {
        String logMsg = "";
        String logMethod = "isReferenceContextErrorRetriable";
        SASContextBody msg = null;
        ContextError ce = null;
        ServiceContext sc = this.csiUtil.get_sc_from_reply((RequestInfo)info);
        if (sc != null) {
            msg = this.csiUtil.get_message_from_sc(sc);
        }
        if (msg != null && msg.discriminator() == 4 && (ce = msg.error_msg()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Major/Minor status: " + ce.major_status + "/" + ce.minor_status);
            }
            if (ce.major_status == 4 && ce.minor_status == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Reference ContextError major/minor retriable");
                }
                return true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ContextError major/minor not retriable or not present.");
        }
        return false;
    }

    public boolean isAcceptContextErrorRetriable(ClientRequestInfo info) throws ForwardRequest {
        String logMsg = "";
        String logMethod = "SessionManager.isAcceptContextErrorRetriable";
        SASContextBody msg = null;
        ContextError ce = null;
        ServiceContext sc = this.csiUtil.get_sc_from_reply((RequestInfo)info);
        if (sc != null) {
            msg = this.csiUtil.get_message_from_sc(sc);
        }
        if (msg != null && msg.discriminator() == 4 && (ce = msg.error_msg()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Major/Minor status: " + ce.major_status + "/" + ce.minor_status);
            }
            if (ce.major_status == 1 && ce.minor_status == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Accept ContextError major/minor retriable");
                }
                return true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ContextError major/minor not retriable or not present.");
        }
        return false;
    }

    public void csi_set_connection_cred(ServerConnectionKey connKey, Subject received_subject) {
        Connection connection = null;
        connection = this.server_connection_lookup(connKey.get_server_connection_hash());
        connection.set_client_cert_creds_list(received_subject);
    }

    public Subject csi_lookup_connection_cred(ServerConnectionKey connKey) {
        Connection connection = null;
        connection = this.server_connection_lookup(connKey.get_server_connection_hash());
        return connection.get_client_cert_creds_list();
    }

    public void csi_set_connection_propagation_token_map(ServerConnectionKey connKey, Map tokenMap) {
        Connection connection = null;
        connection = this.server_connection_lookup(connKey.get_server_connection_hash());
        connection.set_client_cert_propagation_token_map(tokenMap);
    }

    public Map csi_lookup_connection_propagation_token_map(ServerConnectionKey connKey) {
        Connection connection = null;
        connection = this.server_connection_lookup(connKey.get_server_connection_hash());
        return connection.get_client_cert_propagation_token_map();
    }

    private void clean_server_sessions(SessionTable sessionTable, int idleTime) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clean_server_sessions");
        }
        Long[] serverSessionKeyArray = null;
        try {
            serverSessionKeyArray = sessionTable.keySet().toArray(new Long[0]);
        }
        catch (ArrayStoreException e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionManager.clean_server_sessions", "1431", this);
        }
        if (serverSessionKeyArray != null) {
            for (int j = 0; j < serverSessionKeyArray.length; ++j) {
                boolean expired;
                SessionEntry entry = (SessionEntry)sessionTable.get(serverSessionKeyArray[j]);
                if (entry == null) continue;
                long delta = System.currentTimeMillis() - entry.get_session_usage_timestamp();
                boolean bl = expired = delta > (long)idleTime;
                if (!expired) continue;
                sessionTable.remove(serverSessionKeyArray[j]);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Server session deleted hash :" + serverSessionKeyArray[j] + ", last used = " + new Timestamp(entry.get_session_usage_timestamp()));
            }
        }
    }

    private void clean_client_sessions(SessionTable sessionTable, SessionHashTable sessionHashTable, int idleTime) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clean_client_sessions");
        }
        Long[] clientSessionKeyArray = null;
        try {
            clientSessionKeyArray = sessionTable.keySet().toArray(new Long[sessionTable.size()]);
        }
        catch (ArrayStoreException e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionManager.clean_client_sessions", "1360", this);
        }
        if (clientSessionKeyArray != null) {
            for (int j = 0; j < clientSessionKeyArray.length; ++j) {
                boolean expired;
                SessionEntry entry = (SessionEntry)sessionTable.get(clientSessionKeyArray[j]);
                if (entry == null) continue;
                long delta = System.currentTimeMillis() - entry.get_session_usage_timestamp();
                boolean bl = expired = delta > (long)idleTime;
                if (!expired) continue;
                sessionHashTable.remove(entry.get_client_session_key().get_client_session_hash());
                sessionTable.remove(clientSessionKeyArray[j]);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Client session deleted:  hash = " + entry.get_client_session_key().get_client_session_hash() + ":" + clientSessionKeyArray[j] + ", last used = " + new Timestamp(entry.get_session_usage_timestamp()));
            }
        }
    }

    protected void clean_session_tables() {
        Connection conn;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "*** BEGIN SESSION CLEANUP AT " + new Timestamp(System.currentTimeMillis()) + " ***");
        }
        String[] connKeyArray = null;
        try {
            connKeyArray = this.clientConnTable.keySet().toArray(new String[this.clientConnTable.size()]);
        }
        catch (ArrayStoreException e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionManager.clean_session_tables", "1327", this);
        }
        if (connKeyArray != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Client connection table size:  " + this.clientConnTable.size());
            }
            for (int i = 0; i < connKeyArray.length; ++i) {
                SessionTable clientSessionTable;
                conn = null;
                conn = (Connection)this.clientConnTable.get(connKeyArray[i]);
                if (conn == null || (clientSessionTable = conn.getClientSessionTable()) == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Client session table size:  " + clientSessionTable.size());
                }
                SessionHashTable sessionHashTable = conn.getSessionHashTable();
                this.clean_client_sessions(clientSessionTable, sessionHashTable, this.sessionDiscardUnusedMillis);
            }
        }
        try {
            connKeyArray = this.serverConnTable.keySet().toArray(new String[this.serverConnTable.size()]);
        }
        catch (ArrayStoreException e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionManager.clean_session_tables", "1400", this);
        }
        if (connKeyArray != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server connection table size:  " + this.serverConnTable.size());
            }
            for (int i = 0; i < connKeyArray.length; ++i) {
                SessionTable serverSessionTable;
                conn = null;
                conn = (Connection)this.serverConnTable.get(connKeyArray[i]);
                if (conn == null || (serverSessionTable = conn.getServerSessionTable()) == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server session table size:  " + serverSessionTable.size());
                }
                this.clean_server_sessions(serverSessionTable, this.sessionDiscardUnusedMillis);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "*** END SESSION CLEANUP AT " + new Timestamp(System.currentTimeMillis()) + " ***");
        }
    }

    public void alarm(Object alarmCtx) {
        if (this.sessionCacheMaxSize > 0 && this.sessionCacheIdleTime > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cache max size is defined, disabling the garbage collection for session entries ");
            }
        } else {
            this.clean_session_tables();
            AlarmManager.createDeferrable(this.sessionCleanupInterval, this);
        }
    }
}

