/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectCSIv2UtilityImpl;

import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSEncodeDecodeException;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ISecurityUtilityImpl.VaultConstants;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityObjectLocator;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public final class GSSFactory {
    private OID _theOID = null;
    private static byte[] asn = new byte[]{96};
    private static byte[] EXPORT_NAME_TAG = new byte[]{4, 1};
    private static final TraceComponent tc = Tr.register(GSSFactory.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");

    public static String getMechOIDFromExportedName(byte[] expName) throws GSSEncodeDecodeException {
        int j;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMechOIDFromExportedName", expName);
        }
        int i = 0;
        if (expName.length < 2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid length for exported target name.");
            }
            throw new GSSEncodeDecodeException(1);
        }
        if (expName[0] != EXPORT_NAME_TAG[0] || expName[1] != EXPORT_NAME_TAG[1]) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid tag for exported target name.");
            }
            throw new GSSEncodeDecodeException(1);
        }
        if (expName.length < (i += 2) + 2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid length for exported target name.");
            }
            throw new GSSEncodeDecodeException(1);
        }
        if (expName.length < (i += 2) + (j = (expName[i] << 8) + (expName[i + 1] << 0))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid length for exported target name.");
            }
            throw new GSSEncodeDecodeException(1);
        }
        byte[] abyte1 = new byte[j];
        System.arraycopy(expName, i, abyte1, 0, abyte1.length);
        try {
            OID oid = new OID(abyte1);
            if (oid != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMechOIDFromExportedName");
                }
                return "oid:" + oid.toString();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMechOIDFromExportedName", null);
            }
            return null;
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, GSSFactory.class, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory.getMechOIDFromExportedName", "139");
            throw new GSSEncodeDecodeException(99, ex.getMessage());
        }
    }

    public static String getMechOIDFromGSSToken(byte[] GToken) throws GSSEncodeDecodeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMechOIDFromGSSToken", GToken);
        }
        if (GToken == null || GToken.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid token form encountered.");
            }
            return null;
        }
        int i = 0;
        int fullTokenLen = 0;
        if (GToken[i] != asn[0]) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid token form encountered.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMechOIDFromGSSToken", null);
            }
            return null;
        }
        if (GToken[++i] == -127) {
            fullTokenLen = GToken[i + 1] & 0xFF;
            i += 2;
        } else if (GToken[i] == -126) {
            fullTokenLen = ((GToken[i + 1] & 0xFF) << 8) + (GToken[i + 2] & 0xFF);
            i += 3;
        } else if (GToken[i] == -125) {
            fullTokenLen = ((GToken[i + 1] & 0xFF) << 16) + ((GToken[i + 2] & 0xFF) << 8) + (GToken[i + 3] & 0xFF);
            i += 4;
        } else if (GToken[i] == -124) {
            fullTokenLen = ((GToken[i + 1] & 0xFF) << 24) + ((GToken[i + 2] & 0xFF) << 16) + ((GToken[i + 3] & 0xFF) << 8) + (GToken[i + 4] & 0xFF);
            i += 5;
        } else {
            fullTokenLen = GToken[i];
            ++i;
        }
        if (fullTokenLen > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Full token length: " + fullTokenLen);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid full token length: " + fullTokenLen);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMechOIDFromGSSToken", null);
            }
            return null;
        }
        if (GToken[i] != 6) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid OID encountered.");
            }
            throw new GSSEncodeDecodeException(2);
        }
        int oidstart = i++;
        int oidLen = 0;
        if (GToken[i] == -127) {
            oidLen = GToken[i + 1] & 0xFF;
            i += 2;
        } else if (GToken[i] == -126) {
            oidLen = ((GToken[i + 1] & 0xFF) << 8) + (GToken[i + 2] & 0xFF);
            i += 3;
        } else if (GToken[i] == -125) {
            oidLen = ((GToken[i + 1] & 0xFF) << 16) + ((GToken[i + 2] & 0xFF) << 8) + (GToken[i + 3] & 0xFF);
            i += 4;
        } else if (GToken[i] == -124) {
            oidLen = ((GToken[i + 1] & 0xFF) << 24) + ((GToken[i + 2] & 0xFF) << 16) + ((GToken[i + 3] & 0xFF) << 8) + (GToken[i + 4] & 0xFF);
            i += 5;
        } else {
            oidLen = GToken[i];
            ++i;
        }
        if (oidLen > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "OID length: " + oidLen);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid OID length: " + oidLen);
            }
            throw new GSSEncodeDecodeException(2);
        }
        byte[] derOID = new byte[oidLen + 2];
        System.arraycopy(GToken, oidstart, derOID, 0, oidLen + 2);
        try {
            OID tmpOID = new OID(derOID);
            if (tmpOID != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMechOIDFromGSSToken");
                }
                return "oid:" + tmpOID.toString();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMechOIDFromGSSToken", null);
            }
            return null;
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, GSSFactory.class, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory.getMechOIDFromGSSToken", "290");
            throw new GSSEncodeDecodeException(99, ex.getMessage());
        }
    }

    public String getOIDName() {
        if (this._theOID != null) {
            return "oid:" + this._theOID.toString();
        }
        return null;
    }

    public GSSFactory(String oidName) {
        try {
            this._theOID = new OID(oidName);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory.GSSFactory", "323", this);
        }
    }

    public GSSFactory(byte[] derOID) {
        try {
            this._theOID = new OID(derOID);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory.GSSFactory", "340", this);
        }
    }

    public String decodeExportedTargetName(byte[] target_name) throws GSSEncodeDecodeException {
        int k;
        int j;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decodeExportedTargetName", new Object[]{target_name, this});
        }
        String exportedName = null;
        int i = 0;
        if (target_name.length < 2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid length for exported target name.");
            }
            throw new GSSEncodeDecodeException(1);
        }
        if (target_name[0] != EXPORT_NAME_TAG[0] || target_name[1] != EXPORT_NAME_TAG[1]) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid tag for exported target name.");
            }
            throw new GSSEncodeDecodeException(1);
        }
        if (target_name.length < (i += 2) + 2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid length for exported target name.");
            }
            throw new GSSEncodeDecodeException(3);
        }
        if (target_name.length < (i += 2) + (j = ((target_name[i] & 0xFF) << 8) + ((target_name[i + 1] & 0xFF) << 0))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid length for exported target name.");
            }
            throw new GSSEncodeDecodeException(3);
        }
        byte[] abyte1 = new byte[j];
        System.arraycopy(target_name, i, abyte1, 0, abyte1.length);
        i += j;
        OID oid = null;
        try {
            oid = new OID(abyte1);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory.decodeExportedTargetName", "406", this);
            throw new GSSEncodeDecodeException(99, ex.getMessage());
        }
        if (oid == null) {
            return exportedName;
        }
        if (this._theOID != null) {
            if (!OID.compareOIDs(this._theOID.toString(), oid.toString())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid OID for this factory: " + oid.toString());
                }
                throw new GSSEncodeDecodeException(2);
            }
        } else {
            this._theOID = oid;
        }
        if (target_name.length < i + 4) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid length for exported target name.");
            }
            throw new GSSEncodeDecodeException(3);
        }
        if (target_name.length < (i += 4) + (k = ((target_name[i] & 0xFF) << 24) + ((target_name[i + 1] & 0xFF) << 16) + ((target_name[i + 2] & 0xFF) << 8) + ((target_name[i + 3] & 0xFF) << 0))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid length for exported target name.");
            }
            throw new GSSEncodeDecodeException(3);
        }
        byte[] abyte2 = new byte[k];
        System.arraycopy(target_name, i, abyte2, 0, k);
        try {
            exportedName = new String(abyte2, "UTF-8");
        }
        catch (UnsupportedEncodingException uEx) {
            Manager.Ffdc.log(uEx, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory.decodeExportedTargetName", "452", this);
            throw new GSSEncodeDecodeException(99, uEx.getMessage());
        }
        if (exportedName != null && tc.isDebugEnabled()) {
            Tr.debug(tc, "Found exported target name: " + exportedName + " mechType: " + GSSFactory.mapOidToMechType(this._theOID.toString()) + " oid:" + this._theOID.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decodeExportedTargetName", exportedName);
        }
        return exportedName;
    }

    public byte[] encodeExportedTargetName(String userScopedName) throws GSSEncodeDecodeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encodeExportedTargetName", new Object[]{userScopedName, this});
        }
        try {
            if (userScopedName == null || userScopedName.length() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid name form encountered.");
                }
                return null;
            }
            byte[] derOID = this._theOID.getDER();
            byte[] uName = userScopedName.getBytes("UTF-8");
            ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
            bytearrayoutputstream.write(EXPORT_NAME_TAG, 0, EXPORT_NAME_TAG.length);
            bytearrayoutputstream.write(derOID.length >>> 8 & 0xFF);
            bytearrayoutputstream.write(derOID.length >>> 0 & 0xFF);
            bytearrayoutputstream.write(derOID, 0, derOID.length);
            bytearrayoutputstream.write(uName.length >>> 24 & 0xFF);
            bytearrayoutputstream.write(uName.length >>> 16 & 0xFF);
            bytearrayoutputstream.write(uName.length >>> 8 & 0xFF);
            bytearrayoutputstream.write(uName.length >>> 0 & 0xFF);
            bytearrayoutputstream.write(uName, 0, uName.length);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "encodeExportedTargetName");
            }
            return bytearrayoutputstream.toByteArray();
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory.encodeExportedTargetName", "517", this);
            throw new GSSEncodeDecodeException(99, ex.getMessage());
        }
    }

    public byte[] decodeGSSToken(byte[] gssToken) throws GSSEncodeDecodeException {
        int tokenLen;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decodeGSSToken", new Object[]{gssToken, this});
        }
        if (gssToken == null || gssToken.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid token form encountered.");
            }
            throw new GSSEncodeDecodeException(5);
        }
        int i = 0;
        int fullTokenLen = 0;
        if (gssToken[i] != asn[0]) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid token form encountered.");
            }
            throw new GSSEncodeDecodeException(5);
        }
        if (gssToken[++i] == -127) {
            fullTokenLen = gssToken[i + 1] & 0xFF;
            i += 2;
        } else if (gssToken[i] == -126) {
            fullTokenLen = ((gssToken[i + 1] & 0xFF) << 8) + (gssToken[i + 2] & 0xFF);
            i += 3;
        } else if (gssToken[i] == -125) {
            fullTokenLen = ((gssToken[i + 1] & 0xFF) << 16) + ((gssToken[i + 2] & 0xFF) << 8) + (gssToken[i + 3] & 0xFF);
            i += 4;
        } else if (gssToken[i] == -124) {
            fullTokenLen = ((gssToken[i + 1] & 0xFF) << 24) + ((gssToken[i + 2] & 0xFF) << 16) + ((gssToken[i + 3] & 0xFF) << 8) + (gssToken[i + 4] & 0xFF);
            i += 5;
        } else {
            fullTokenLen = gssToken[i];
            ++i;
        }
        if (fullTokenLen > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Full token length: " + fullTokenLen);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid full token length: " + fullTokenLen);
            }
            throw new GSSEncodeDecodeException(5);
        }
        if (gssToken[i] != 6) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid OID encountered.");
            }
            throw new GSSEncodeDecodeException(2);
        }
        int oidstart = i++;
        int oidLen = 0;
        if (gssToken[i] == -127) {
            oidLen = gssToken[i + 1] & 0xFF;
            i += 2;
        } else if (gssToken[i] == -126) {
            oidLen = ((gssToken[i + 1] & 0xFF) << 8) + (gssToken[i + 2] & 0xFF);
            i += 3;
        } else if (gssToken[i] == -125) {
            oidLen = ((gssToken[i + 1] & 0xFF) << 16) + ((gssToken[i + 2] & 0xFF) << 8) + (gssToken[i + 3] & 0xFF);
            i += 4;
        } else if (gssToken[i] == -124) {
            oidLen = ((gssToken[i + 1] & 0xFF) << 24) + ((gssToken[i + 2] & 0xFF) << 16) + ((gssToken[i + 3] & 0xFF) << 8) + (gssToken[i + 4] & 0xFF);
            i += 5;
        } else {
            oidLen = gssToken[i];
            ++i;
        }
        if (oidLen > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "OID length: " + oidLen);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid OID length: " + oidLen);
            }
            throw new GSSEncodeDecodeException(2);
        }
        i += oidLen;
        byte[] derOID = new byte[oidLen + 2];
        System.arraycopy(gssToken, oidstart, derOID, 0, oidLen + 2);
        OID tmpOID = null;
        try {
            tmpOID = new OID(derOID);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory.decodeGSSToken", "657", this);
            throw new GSSEncodeDecodeException(99, ex.getMessage());
        }
        if (this._theOID != null) {
            if (!OID.compareOIDs(this._theOID.toString(), tmpOID.toString())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid OID for this factory: " + tmpOID.toString());
                }
                throw new GSSEncodeDecodeException(2);
            }
        } else {
            this._theOID = tmpOID;
        }
        if ((tokenLen = fullTokenLen - (oidLen + 2)) > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "GSS initial context token length: " + tokenLen);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid GSS initial context token length: " + tokenLen);
            }
            throw new GSSEncodeDecodeException(4);
        }
        byte[] token = new byte[tokenLen];
        System.arraycopy(gssToken, i, token, 0, tokenLen);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decodeGSSToken", token);
        }
        return token;
    }

    public byte[] encodeGSSToken(byte[] initContextToken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encodeGSSToken", new Object[]{initContextToken, this});
        }
        if (initContextToken == null || initContextToken.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid GSS initial token form encountered.");
            }
            return null;
        }
        byte[] derOID = this._theOID.getDER();
        int tokenLength = derOID.length + initContextToken.length;
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        bytearrayoutputstream.write(asn, 0, asn.length);
        if (tokenLength < 128) {
            bytearrayoutputstream.write((byte)tokenLength);
        } else if (tokenLength < 256) {
            bytearrayoutputstream.write(-127);
            bytearrayoutputstream.write((byte)tokenLength);
        } else if (tokenLength < 65536) {
            bytearrayoutputstream.write(-126);
            bytearrayoutputstream.write((byte)(tokenLength >> 8));
            bytearrayoutputstream.write((byte)tokenLength);
        } else if (tokenLength < 0x1000000) {
            bytearrayoutputstream.write(-125);
            bytearrayoutputstream.write((byte)(tokenLength >> 16));
            bytearrayoutputstream.write((byte)(tokenLength >> 8));
            bytearrayoutputstream.write((byte)tokenLength);
        } else {
            bytearrayoutputstream.write(-124);
            bytearrayoutputstream.write((byte)(tokenLength >> 24));
            bytearrayoutputstream.write((byte)(tokenLength >> 16));
            bytearrayoutputstream.write((byte)(tokenLength >> 8));
            bytearrayoutputstream.write((byte)tokenLength);
        }
        bytearrayoutputstream.write(derOID, 0, derOID.length);
        bytearrayoutputstream.write(initContextToken, 0, initContextToken.length);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encodeGSSToken");
        }
        return bytearrayoutputstream.toByteArray();
    }

    public static final String mapOidToMechType(String in_Oid) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "mapOidToMechType");
        }
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (in_Oid != null && in_Oid.length() != 0) {
            if (OID.compareOIDs(in_Oid, csiv2.getString("com.ibm.CSI.WSSecurityContextCustomOID"))) {
                return VaultConstants.CUSTOM_MECH_TYPE;
            }
            if (OID.compareOIDs(in_Oid, "oid:1.3.18.0.2.30.2")) {
                return VaultConstants.LTPA_MECH_TYPE;
            }
            if (OID.compareOIDs(in_Oid, "oid:1.2.840.113554.1.2.2")) {
                return VaultConstants.KRB5_MECH_TYPE;
            }
            if (OID.compareOIDs(in_Oid, "oid:2.23.130.1.1.1")) {
                return VaultConstants.GSSUP_MECH_TYPE;
            }
            if (OID.compareOIDs(in_Oid, "oid:1.3.18.0.2.30.6")) {
                return VaultConstants.RSA_PROP_MECH_TYPE;
            }
            return VaultConstants.LOCAL_OS_MECH_TYPE;
        }
        if (OID.compareOIDs(csiv2.getString("com.ibm.CSI.WSSecurityContextCustomOID"), "oid:1.2.840.113554.1.2.2") && csiv2.getBoolean("com.ibm.websphere.security.krb.allowLTPAAuth") && OID.compareOIDs(in_Oid, "oid:1.3.18.0.2.30.2")) {
            return VaultConstants.LTPA_MECH_TYPE;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "in_Oid: " + in_Oid);
            Tr.debug(tc, "secConfig.getWSSecurityContextCustomOID(): " + csiv2.getString("com.ibm.CSI.WSSecurityContextCustomOID"));
            Tr.debug(tc, "secConfig.getLTPASupportedWithKerberos: " + csiv2.getBoolean("com.ibm.websphere.security.krb.allowLTPAAuth"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unknown security mechanism type.");
        }
        return VaultConstants.LTPA_MECH_TYPE;
    }

    public static final String mapMechTypeToOid(String in_MechType) {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (in_MechType != null && in_MechType.length() != 0) {
            if (in_MechType.equals(VaultConstants.LTPA_MECH_TYPE)) {
                return "oid:1.3.18.0.2.30.2";
            }
            if (in_MechType.equals("1.3")) {
                return "oid:1.3.18.0.2.30.2";
            }
            if (in_MechType.equals("5.1")) {
                return "oid:1.3.18.0.2.30.2";
            }
            if (in_MechType.equals("1.8")) {
                return "oid:1.3.18.0.2.30.6";
            }
            if (in_MechType.equals("5.10")) {
                return "oid:1.3.18.0.2.30.6";
            }
            if (in_MechType.equals(VaultConstants.CUSTOM_MECH_TYPE)) {
                return csiv2.getString("com.ibm.CSI.WSSecurityContextCustomOID");
            }
            if (in_MechType.equals("1.7")) {
                return csiv2.getString("com.ibm.CSI.WSSecurityContextCustomOID");
            }
            if (in_MechType.equals("5.9")) {
                return csiv2.getString("com.ibm.CSI.WSSecurityContextCustomOID");
            }
            if (in_MechType.equals(VaultConstants.LOCAL_OS_MECH_TYPE)) {
                return null;
            }
            if (in_MechType.equals("1.4")) {
                return null;
            }
            if (in_MechType.equals("5.2")) {
                return null;
            }
            if (in_MechType.equals(VaultConstants.KRB5_MECH_TYPE)) {
                return "oid:1.2.840.113554.1.2.2";
            }
            if (in_MechType.equals("1.6")) {
                return "oid:1.2.840.113554.1.2.2";
            }
            if (in_MechType.equals("5.8")) {
                return "oid:1.2.840.113554.1.2.2";
            }
            if (in_MechType.equals("4.1")) {
                return "oid:1.2.840.113554.1.2.2";
            }
            if (in_MechType.equals(VaultConstants.GSSUP_MECH_TYPE)) {
                return "oid:2.23.130.1.1.1";
            }
            if (in_MechType.equals("1.5")) {
                return "oid:2.23.130.1.1.1";
            }
            if (in_MechType.equals("1.5.1")) {
                return "oid:2.23.130.1.1.1";
            }
            if (in_MechType.equals("1.5.2")) {
                return "oid:2.23.130.1.1.1";
            }
            if (in_MechType.equals("5.7.4")) {
                return "oid:2.23.130.1.1.1";
            }
            if (in_MechType.equals("5.7.1")) {
                return "oid:2.23.130.1.1.1";
            }
            if (in_MechType.equals("5.7.2")) {
                return "oid:2.23.130.1.1.1";
            }
            if (in_MechType.equals("1.1")) {
                return "oid:2.23.130.1.1.1";
            }
            if (in_MechType.equals("1.1.1")) {
                return "oid:2.23.130.1.1.1";
            }
            if (in_MechType.equals("1.1.2")) {
                return "oid:2.23.130.1.1.1";
            }
            if (in_MechType.equals("5.6")) {
                return "oid:2.23.130.1.1.1";
            }
            if (in_MechType.equals("5.3")) {
                return "oid:2.23.130.1.1.1";
            }
            if (in_MechType.equals("5.4")) {
                return "oid:2.23.130.1.1.1";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unknown security mechanism type.");
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unknown security mechanism type.");
        }
        return null;
    }

    public OID getOID() {
        return this._theOID;
    }

    public void setOID(String oidname) throws GSSEncodeDecodeException {
        this._theOID = new OID(oidname);
    }

    public GSSFactory(OID oid) {
        this._theOID = oid;
    }

    private GSSFactory() {
    }
}

