/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectCSIv2UtilityImpl;

import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CSIv2Security.CSIv2RequirementsNotSatisfied;
import com.ibm.CSIv2Security.CSIv2RequirementsNotSatisfiedReason;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponentHolder;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.ClientSessionKey;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSEncodeDecodeException;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ISecurityUtilityImpl.AuthenticationTarget;
import com.ibm.ISecurityUtilityImpl.MechanismAmbiguityException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.security.auth.rsatoken.RSATokenThreadManager;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityConfigManager;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.TrustedAuthenticationRealm;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Object;
import org.omg.CSIIOP.AS_ContextSec;
import org.omg.CSIIOP.AS_ContextSecHolder;
import org.omg.CSIIOP.SAS_ContextSec;
import org.omg.CSIIOP.SAS_ContextSecHolder;
import org.omg.CSIIOP.ServiceConfiguration;
import org.omg.CSIIOP.TLS_SEC_TRANSHolder;

public final class CSIv2EffectivePerformPolicy {
    private static final TraceComponent tc = Tr.register(CSIv2EffectivePerformPolicy.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
    protected static ORB _orb = null;
    protected String _method = null;
    protected java.lang.Object _proxy = null;
    protected String _protocol = "csiv2";
    protected boolean _stateful = true;
    protected long _stateful_context_id = 0L;
    protected ClientSessionKey _client_session_key = null;
    protected String _connectionKey = "";
    protected String _mechTypeIdentity = "";
    protected boolean _performTLClientAuth = false;
    protected boolean _performTLServerAuth = false;
    protected boolean _performMsgDetectReplay = false;
    protected boolean _performMsgDetectMisordering = false;
    protected boolean _performMsgIntegrity = false;
    protected boolean _performMsgConfidentiality = false;
    protected boolean _performSSLTLS = false;
    protected boolean _performSECIOP = false;
    protected String _performSECIOPMechOID = "";
    protected String _targetHostName = "";
    protected int _targetTCPPort = 0;
    protected int _targetSSLPort = 0;
    protected boolean _performClientAuth = false;
    protected boolean _claimClientAuthRequired = false;
    protected String _performClientAuthMech = "";
    protected String _performClientAuthMechOID = "";
    protected ArrayList _performClientAuthMechOIDList = null;
    protected ArrayList _performClientAuthMechList = null;
    protected ArrayList _targetSecurityNameList = null;
    protected ArrayList _performClientAuthTargetList = null;
    protected String _performSupportedAuthMechList = "";
    protected String _performClientAuthMechType = "";
    protected String _targetSecurityName = "";
    protected String _targetAuthMechOID = "";
    protected boolean _performIDAssertion = false;
    protected String[] _performIDANamingMechList = null;
    protected int _performIdentityTokenType = 0;
    protected String _performServiceCfgList = null;
    protected boolean _performAuthorizationToken = false;
    protected boolean _performDelegationByClient = false;
    protected boolean _isInternalRequestPolicy = false;
    protected boolean _isAdmin = false;
    protected boolean _isNamingReadUnprotected = true;
    protected CSIv2TaggedComponentHolder savedCSIv2Tag = null;
    protected static Hashtable csiv2EffectivePolicyCache = new Hashtable();
    protected boolean _disableCache = false;

    public boolean isAdmin() {
        return this._isAdmin;
    }

    public boolean isNamingReadUnprotected() {
        return this._isNamingReadUnprotected;
    }

    public String[] getPerformIDANamingMechList() {
        return this._performIDANamingMechList;
    }

    public int getPerformIdentityTokenType() {
        return this._performIdentityTokenType;
    }

    public boolean performIdentityAssertion() {
        return this._performIDAssertion;
    }

    public boolean performDelegationByClient() {
        return this._performDelegationByClient;
    }

    public boolean performAuthorizationToken() {
        return this._performAuthorizationToken;
    }

    public String getServiceCfgList() {
        return this._performServiceCfgList;
    }

    public String getPerformClientAuthMechOID() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPerformClientAuthMechOID " + this._performClientAuthMechOID, this.hashCode());
        }
        return this._performClientAuthMechOID;
    }

    public String getTargetAuthMechOID() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTargetAuthMechOID " + this._targetAuthMechOID, this.hashCode());
        }
        return this._targetAuthMechOID;
    }

    public ArrayList getPerformClientAuthMechOIDList() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPerformClientAuthMechOIDList " + this._performClientAuthMechOIDList, this.hashCode());
        }
        return this._performClientAuthMechOIDList;
    }

    public ArrayList getPerformClientAuthMechList() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPerformClientAuthMechList " + this._performClientAuthMechList, this.hashCode());
        }
        return this._performClientAuthMechList;
    }

    public ArrayList getTargetSecurityNameList() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTargetSecurityNameList " + this._targetSecurityNameList, this.hashCode());
        }
        return this._targetSecurityNameList;
    }

    public String getPerformClientAuthMech() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPerformClientAuthMech " + this._performClientAuthMech, this.hashCode());
        }
        return this._performClientAuthMech;
    }

    public void setPerformClientAuthMech(String mech) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPerformClientAuthMech " + this._performClientAuthMech);
        }
        this._performClientAuthMech = mech;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPerformClientAuthMech " + this._performClientAuthMech, this.hashCode());
        }
    }

    public void setPerformClientAuthMechOID(String oid) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPerformClientAuthMechOID " + this._performClientAuthMechOID);
        }
        this._performClientAuthMechOID = oid;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPerformClientAuthMechOID " + this._performClientAuthMechOID, this.hashCode());
        }
    }

    public void setTargetSecurityName(String targetSecurityName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTargetSecurityName " + this._targetSecurityName);
        }
        this._targetSecurityName = targetSecurityName;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTargetSecurityName " + this._targetSecurityName, this.hashCode());
        }
    }

    public void setTargetAuthMechOID(String oid) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTargetAuthMechOID " + this._targetAuthMechOID);
        }
        this._targetAuthMechOID = oid;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTargetAuthMechOID " + this._targetAuthMechOID, this.hashCode());
        }
    }

    public boolean performClientAuthentication() {
        return this._performClientAuth;
    }

    public boolean claimClientAuthenticationRequired() {
        return this._claimClientAuthRequired;
    }

    public String getTargetSecurityName() {
        return this._targetSecurityName;
    }

    public String getTargetHostName() {
        return this._targetHostName;
    }

    public int getTargetTCPPort() {
        return this._targetTCPPort;
    }

    public int getTargetSSLPort() {
        return this._targetSSLPort;
    }

    public String getMechanismTypeIdentity() {
        if (this._performClientAuth) {
            if (this._performSSLTLS) {
                if (OID.compareOIDs(this._performClientAuthMechOID, "oid:2.23.130.1.1.1")) {
                    return "1.5";
                }
                if (OID.compareOIDs(this._performClientAuthMechOID, "oid:1.2.840.113554.1.2.2")) {
                    // empty if block
                }
            } else {
                if (OID.compareOIDs(this._performClientAuthMechOID, "oid:2.23.130.1.1.1")) {
                    return "5.7.4";
                }
                if (OID.compareOIDs(this._performClientAuthMechOID, "oid:1.2.840.113554.1.2.2")) {
                    // empty if block
                }
            }
        }
        return this._mechTypeIdentity;
    }

    public String getPerformSECIOPMechOID() {
        return this._performSECIOPMechOID;
    }

    public boolean performSSLTLS() {
        return this._performSSLTLS;
    }

    public boolean performSECIOP() {
        return this._performSECIOP;
    }

    public boolean performMsgConfidentiality() {
        return this._performMsgConfidentiality;
    }

    public boolean performMsgIntegrity() {
        return this._performMsgIntegrity;
    }

    public boolean performMsgDetectMisordering() {
        return this._performMsgDetectMisordering;
    }

    public boolean performMsgDetectReplay() {
        return this._performMsgDetectReplay;
    }

    public boolean performTLClientAuth() {
        return this._performTLClientAuth;
    }

    public boolean performTLServerAuth() {
        return this._performTLServerAuth;
    }

    private void evaluateStatefulness(boolean supportsStateful, Vector fail_reasons, boolean isAdmin) throws CSIv2RequirementsNotSatisfied {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        boolean bl = this._stateful = supportsStateful && csiv2.getBoolean("com.ibm.CSI.performStateful");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Stateful request? " + this._stateful);
        }
    }

    public ArrayList getPerformClientAuthTargetList() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPerformClientAuthTargetList");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        AuthenticationTarget authTarget = new AuthenticationTarget();
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        this._performSupportedAuthMechList = SecurityObjectLocator.getAdminData().getBoolean("isServerProcess") ? csiv2.getString("com.ibm.CSI.performMessageSupportedAuthMechList") : authTarget.authTargetToMechType(csiv2.getInteger("com.ibm.CORBA.authenticationTarget"));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "_performSupportedAuthMechList " + this._performSupportedAuthMechList);
        }
        if (this._performSupportedAuthMechList != null && this._performSupportedAuthMechList.length() > 0) {
            this._performSupportedAuthMechList = this._performSupportedAuthMechList.toUpperCase();
            String[] auths = this._performSupportedAuthMechList.split("\\|");
            for (int i = 0; i < auths.length; ++i) {
                if (auths[i] == null) continue;
                try {
                    arrayList.add(authTarget.mechtypeToAuthTarget(auths[i]));
                    continue;
                }
                catch (MechanismAmbiguityException e) {
                    // empty catch block
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPerformClientAuthTargetList " + arrayList);
        }
        return arrayList;
    }

    private void evaluateTransportLayer(CSIv2TaggedComponent cTag, Vector fail_reasons, boolean validateCertAuthMismatch, boolean isAdmin) throws CSIv2RequirementsNotSatisfied {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "evaluateTransportLayer.");
        }
        String logMsg = null;
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        boolean evaluation_failed = false;
        if (cTag == null) {
            logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0600E", "JSAS0600E: CSIv2 Tagged Component is NULL.");
            fail_reasons.addElement(logMsg);
            evaluation_failed = true;
        }
        int tagID = cTag.get_Transport_tagID();
        TLS_SEC_TRANSHolder tlsHolder = null;
        short target_supports = 0;
        short target_requires = 0;
        if (tagID == 36) {
            tlsHolder = cTag.getTLS_SEC_TRANS();
            target_supports = tlsHolder.value.target_supports;
            target_requires = tlsHolder.value.target_requires;
            this._targetHostName = tlsHolder.value.addresses[0].host_name;
            this._targetSSLPort = tlsHolder.value.addresses[0].port;
            if (cTag.getIORProfile() != null) {
                this._targetTCPPort = cTag.getIORProfile().getPort();
            }
            this._performSSLTLS = csiv2.getBoolean("com.ibm.CSI.performTransportAssocSSLTLSSupported") || csiv2.getBoolean("com.ibm.CSI.performTransportAssocSSLTLSRequired");
        } else {
            if (tagID == 34) {
                target_supports = 0;
                target_requires = 0;
                if (cTag.getIORProfile() != null) {
                    this._targetHostName = cTag.getIORProfile().getHost();
                }
                if (cTag.getIORProfile() != null) {
                    this._targetTCPPort = cTag.getIORProfile().getPort();
                }
                this._performSSLTLS = false;
                this._performTLClientAuth = false;
                this._performMsgIntegrity = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Perform SSL/TLS: " + this._performSSLTLS + ", Perform client auth at transport layer: " + this._performTLClientAuth + ", Perform integrity at transport layer: " + this._performMsgIntegrity + ", Perform confidentiality at transport layer: " + this._performMsgConfidentiality + ", Target Host: " + this._targetHostName + ", Target TCP Port: " + this._targetTCPPort + ", Target SSL Port: " + this._targetSSLPort);
                }
                if (csiv2.getBoolean("com.ibm.CSI.performTransportAssocSSLTLSRequired")) {
                    logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0603E", "JSAS0603E: The server does not support SSL/TLS, but the client is configured to require it.");
                    fail_reasons.addElement(logMsg);
                    evaluation_failed = true;
                    logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0550I", "JSAS0550I: Evaluation of the transport layer failed.");
                    throw new CSIv2RequirementsNotSatisfied(CSIv2RequirementsNotSatisfiedReason.NotSatisfiedByClient, logMsg);
                }
                return;
            }
            if (tagID == 35) {
                logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0601E", "JSAS0601E: The CSIv2 client configuration does not support SECIOP.");
                fail_reasons.addElement(logMsg);
                evaluation_failed = true;
            } else {
                logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0602E", "JSAS0602E: No valid transport tagged components exist in the IOR.");
                fail_reasons.addElement(logMsg);
                evaluation_failed = true;
            }
        }
        if (target_requires == 0 && target_supports == 0 && csiv2.getBoolean("com.ibm.CSI.performTransportAssocSSLTLSRequired")) {
            logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0603E", "JSAS0603E: The server does not support SSL/TLS, but the client is configured to require it.");
            fail_reasons.addElement(logMsg);
            evaluation_failed = true;
        }
        if (!csiv2.getBoolean("com.ibm.CSI.performTransportAssocSSLTLSSupported") && !csiv2.getBoolean("com.ibm.CSI.performTransportAssocSSLTLSRequired") && this._targetTCPPort == 0) {
            logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0608E", "JSAS0608E: The server requires SSL Confidentiality but the client does not support it.");
            fail_reasons.addElement(logMsg);
            evaluation_failed = true;
        }
        if (csiv2.getBoolean("com.ibm.CSI.performTLClientAuthenticationRequired") && this._performSSLTLS) {
            if ((target_requires & 0x40) == 0 && (target_supports & 0x40) == 0) {
                if (validateCertAuthMismatch) {
                    logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0604E", "JSAS0604E: The client is configured to require SSL client authentication but the server does not support it.");
                    fail_reasons.addElement(logMsg);
                    evaluation_failed = true;
                } else {
                    this._performTLClientAuth = false;
                }
            } else {
                this._performTLClientAuth = true;
            }
        } else if (csiv2.getBoolean("com.ibm.CSI.performTLClientAuthenticationSupported") && this._performSSLTLS) {
            if ((target_requires & 0x40) == 0 && (target_supports & 0x40) == 0) {
                if (validateCertAuthMismatch) {
                    logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0605E", "JSAS0605E: The client is configured to support SSL client certificate authentication, however the server does not accept them.");
                    fail_reasons.addElement(logMsg);
                    evaluation_failed = true;
                } else {
                    this._performTLClientAuth = false;
                }
            } else {
                this._performTLClientAuth = true;
            }
        } else {
            if ((target_requires & 0x40) != 0) {
                logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0606E", "JSAS0606E: The server is configured to require SSL client certificate authentication but the client does not support it.");
                fail_reasons.addElement(logMsg);
                evaluation_failed = true;
            }
            this._performTLClientAuth = false;
        }
        this._performTLServerAuth = true;
        if (csiv2.getBoolean("com.ibm.CSI.performMessageConfidentialityRequired") && this._performSSLTLS) {
            if ((target_requires & 4) == 0 && (target_supports & 4) == 0) {
                logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0607E", "JSAS0607E: The client is configured to require SSL Confidentiality but the server does not support it.");
                fail_reasons.addElement(logMsg);
                evaluation_failed = true;
            } else {
                this._performMsgConfidentiality = true;
            }
        } else if (csiv2.getBoolean("com.ibm.CSI.performMessageConfidentialitySupported") && this._performSSLTLS) {
            this._performMsgConfidentiality = (target_requires & 4) != 0 || (target_supports & 4) != 0;
        } else {
            if ((target_requires & 4) != 0) {
                logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0608E", "JSAS0608E: The server is configured to require Confidentiality but the client does not support it.");
                fail_reasons.addElement(logMsg);
                evaluation_failed = true;
            }
            this._performMsgConfidentiality = false;
        }
        if (csiv2.getBoolean("com.ibm.CSI.performMessageIntegrityRequired") && this._performSSLTLS) {
            if ((target_requires & 2) == 0 && (target_supports & 2) == 0) {
                logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0609E", "JSAS0609E: The client is configured to require SSL Integrity but the server does not support it.");
                fail_reasons.addElement(logMsg);
                evaluation_failed = true;
            } else {
                this._performMsgIntegrity = true;
            }
        } else if (csiv2.getBoolean("com.ibm.CSI.performMessageIntegritySupported") && this._performSSLTLS) {
            this._performMsgIntegrity = (target_requires & 2) != 0 || (target_supports & 2) != 0;
        } else {
            if ((target_requires & 2) != 0 && this._performSSLTLS) {
                logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0610E", "JSAS0610E: The server is configured to require SSL Integrity but the client does not support it.");
                fail_reasons.addElement(logMsg);
                evaluation_failed = true;
            }
            this._performMsgIntegrity = false;
        }
        this._performMsgDetectReplay = true;
        this._performMsgDetectMisordering = true;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Perform SSL/TLS: " + this._performSSLTLS + ", Perform client auth at transport layer: " + this._performTLClientAuth + ", Perform integrity at transport layer: " + this._performMsgIntegrity + ", Perform confidentiality at transport layer: " + this._performMsgConfidentiality + ", Target Host: " + this._targetHostName + ", Target TCP Port: " + this._targetTCPPort + ", Target SSL Port: " + this._targetSSLPort);
        }
        if (evaluation_failed) {
            logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0550I", "JSAS0550I: Evaluation of the transport layer failed.");
            throw new CSIv2RequirementsNotSatisfied(CSIv2RequirementsNotSatisfiedReason.NotSatisfiedByClient, logMsg);
        }
    }

    private void evaluateClientAuthLayer(AS_ContextSecHolder asHolder, Vector fail_reasons, boolean isAdmin) throws CSIv2RequirementsNotSatisfied {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "evaluateClientAuthLayer.");
        }
        String logMsg = null;
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        boolean evaluation_failed = false;
        if (asHolder == null || asHolder.value == null) {
            logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0611E", "JSAS0611E: No authentication mechanism is defined at client authentication layer.");
            fail_reasons.addElement(logMsg);
            evaluation_failed = true;
        }
        AS_ContextSec asContextSec = asHolder.value;
        short target_supports = 0;
        short target_requires = 0;
        byte[] targetAuthMechOID = null;
        byte[] targetName = null;
        if (asContextSec == null) {
            if (csiv2.getBoolean("com.ibm.CSI.performClientAuthenticationRequired")) {
                logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0611E", "JSAS0611E: No authentication mechanism is defined at client authentication layer.");
                fail_reasons.addElement(logMsg);
                evaluation_failed = true;
            }
        } else {
            target_supports = asContextSec.target_supports;
            target_requires = asContextSec.target_requires;
            targetAuthMechOID = asContextSec.client_authentication_mech;
            targetName = asContextSec.target_name;
            if (targetAuthMechOID != null) {
                this._targetAuthMechOID = targetAuthMechOID.toString();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "target_supports: " + target_supports);
                Tr.debug(tc, "target_requires: " + target_requires);
                Tr.debug(tc, "targetAuthMechOID: " + this._targetAuthMechOID);
                Tr.debug(tc, "targetName: " + targetName);
            }
            if ((target_requires & 0x40) != 0) {
                this._claimClientAuthRequired = true;
            }
            if (csiv2.getBoolean("com.ibm.CSI.performClientAuthenticationRequired")) {
                if ((target_supports & 0x40) == 0 && (target_requires & 0x40) == 0) {
                    logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0612E", "JSAS0612E: The client requires client authentication (e.g., userid/password), but the server does not support it.");
                    fail_reasons.addElement(logMsg);
                    evaluation_failed = true;
                }
                this._performClientAuth = true;
            } else if (csiv2.getBoolean("com.ibm.CSI.performClientAuthenticationSupported")) {
                if ((target_supports & 0x40) == 0 && (target_requires & 0x40) == 0) {
                    this._performClientAuth = false;
                    if (target_supports == 0) {
                        return;
                    }
                } else {
                    this._performClientAuth = true;
                }
            } else if ((target_requires & 0x40) != 0) {
                logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0613E", "JSAS0613E: The server requires client authentication (e.g., userid/password), but the client does not support it.");
                fail_reasons.addElement(logMsg);
                evaluation_failed = true;
            } else if (CSIv2EffectivePerformPolicy.methodRequiresAuthenticationRegardlessOfPolicy(this._method, this._proxy)) {
                this._performClientAuth = true;
                this._disableCache = true;
            } else {
                this._performClientAuth = false;
            }
            if (this._performClientAuth) {
                if (targetName == null) {
                    this._performClientAuth = false;
                    logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0618E", "JSAS0618E: The target security name is NULL in CSIv2 tagged component.");
                    fail_reasons.addElement(logMsg);
                    evaluation_failed = true;
                } else {
                    if (this.savedCSIv2Tag != null && this.savedCSIv2Tag.value != null) {
                        this._targetSecurityName = this.savedCSIv2Tag.value.get_targetCompleteName();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "_targetSecurityName: " + this._targetSecurityName);
                    }
                }
                String supportedTargetRealms = null;
                boolean validateOID = true;
                if (!SecurityObjectLocator.getAdminData().getBoolean("isServerProcess")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "case of a pure client: getting supportedTargetRealms from the csiv2 configuration.");
                    }
                    supportedTargetRealms = csiv2.getString("com.ibm.CSI.supportedTargetRealms");
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "about to retrieve outbound trusted realms.");
                    }
                    TrustedAuthenticationRealm outboundRealms = SecurityObjectLocator.getSecurityConfig().getOutboundTrustedAuthenticationRealm();
                    String realmList = null;
                    boolean trustAllRealms = false;
                    if (outboundRealms != null) {
                        supportedTargetRealms = realmList = outboundRealms.getRealmList();
                        trustAllRealms = outboundRealms.getTrustAllRealms();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "found outbound realms element: trustAllRealms = " + trustAllRealms + " : realmList = " + realmList);
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "did not find outbound realms element");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "supportedTargetRealms: " + realmList);
                    }
                    if (trustAllRealms) {
                        validateOID = false;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "trustAllRealms is true ");
                        }
                    }
                    if (validateOID) {
                        if (realmList != null && !realmList.equals("")) {
                            StringTokenizer st = new StringTokenizer(realmList, "|");
                            while (st.hasMoreTokens()) {
                                String realm = st.nextToken();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "realm: " + realm);
                                }
                                if (!this._targetSecurityName.startsWith(realm)) continue;
                                validateOID = false;
                                break;
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "realmList String is null or empty");
                        }
                    }
                }
                GSSFactory gssFactory = new GSSFactory(targetAuthMechOID);
                this._performClientAuthMechOID = gssFactory.getOIDName();
                this._performClientAuthMech = GSSFactory.mapOidToMechType(this._performClientAuthMechOID);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "TargetAuthMech: " + this._performClientAuthMech + " " + this._performClientAuthMechOID);
                }
                if (validateOID) {
                    if (targetAuthMechOID == null) {
                        this._performClientAuth = false;
                        logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0611E", "JSAS0611E: No authentication mechanism is defined at client authentication layer.");
                        fail_reasons.addElement(logMsg);
                        evaluation_failed = true;
                    } else if (isAdmin && SecurityObjectLocator.getAdminData().getBoolean("isServerProcess")) {
                        SecurityConfigManager scm;
                        SecurityConfigObject security2;
                        SecurityConfigObject adminPreferredAuthMech;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Looking for the preferred ADMIN authentication mechanism.");
                        }
                        if ((adminPreferredAuthMech = (security2 = (scm = SecurityObjectLocator.getSecurityConfigManager()).getObject("security")).getObject("adminPreferredAuthMech")) != null && adminPreferredAuthMech.instanceOf("RSAToken") && RSATokenThreadManager.getInstance().isCertificateRetrievalInProcess().booleanValue()) {
                            String activeAuthOID;
                            this._performClientAuthMechOID = activeAuthOID = "oid:1.3.18.0.2.30.6";
                            this._performClientAuth = true;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Forcing _performClientAuthMechOID during RSA bootstrap call to the RSA OID: " + activeAuthOID);
                            }
                        } else if (adminPreferredAuthMech != null && adminPreferredAuthMech.instanceOf("RSAToken")) {
                            if (!OID.compareOIDs(this._performClientAuthMechOID, "oid:1.3.18.0.2.30.6")) {
                                this._performClientAuth = false;
                                this._performClientAuthMechOID = null;
                                logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0805W", "JSAS0805W:  The current OID is not the preferred admin authentication mechanism of RSAToken.");
                                fail_reasons.addElement(logMsg);
                                evaluation_failed = true;
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found the preferred ADMIN authentication mechanism:  RSAToken");
                            }
                        } else if (adminPreferredAuthMech != null && adminPreferredAuthMech.instanceOf("LTPA")) {
                            if (!OID.compareOIDs(this._performClientAuthMechOID, "oid:1.3.18.0.2.30.2")) {
                                this._performClientAuth = false;
                                this._performClientAuthMechOID = null;
                                logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0806W", "JSAS0806W: The current OID is not the preferred admin authentication mechanism of \"LTPA\".");
                                fail_reasons.addElement(logMsg);
                                evaluation_failed = true;
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found the preferred ADMIN authentication mechanism:  LTPA");
                            }
                        } else if (adminPreferredAuthMech != null && adminPreferredAuthMech.instanceOf("KRB5")) {
                            if (!OID.compareOIDs(this._performClientAuthMechOID, "oid:1.2.840.113554.1.2.2")) {
                                this._performClientAuth = false;
                                this._performClientAuthMechOID = null;
                                logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0807W", "JSAS0807W: The current OID is not the preferred admin authentication mechanism of \"KRB5\".");
                                fail_reasons.addElement(logMsg);
                                evaluation_failed = true;
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found the preferred ADMIN authentication mechanism:  KRB5");
                            }
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "The preferred admin authentication mechanism is not understood.");
                            }
                            this._performClientAuth = false;
                            this._performClientAuthMechOID = null;
                            logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0808E", "JSAS0808E: The preferred admin authentication mechanism is not a known ADMIN mechanism.");
                            fail_reasons.addElement(logMsg);
                            evaluation_failed = true;
                        }
                    } else if (!isAdmin && OID.compareOIDs(this._performClientAuthMechOID, "oid:1.3.18.0.2.30.6")) {
                        this._performClientAuth = false;
                        this._performClientAuthMechOID = null;
                        logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0809E", "JSAS0809E: The current OID is RSA but this is not an Admin request.");
                        fail_reasons.addElement(logMsg);
                        evaluation_failed = true;
                    } else {
                        if (!(OID.compareOIDs(this._performClientAuthMechOID, "oid:2.23.130.1.1.1") || OID.compareOIDs(this._performClientAuthMechOID, "oid:1.2.840.113554.1.2.2") || OID.compareOIDs(this._performClientAuthMechOID, "oid:1.3.18.0.2.30.2") || OID.compareOIDs(this._performClientAuthMechOID, csiv2.getString("com.ibm.CSI.WSSecurityContextCustomOID")))) {
                            this._performClientAuth = false;
                            this._performClientAuthMechOID = null;
                            logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0614E", "JSAS0614E: The OID supplied by the server is an unsupported OID for this WebSphere release.");
                            fail_reasons.addElement(logMsg);
                            evaluation_failed = true;
                        }
                        if (this._performClientAuthMechOID != null && !this.performIdentityAssertion()) {
                            boolean matches = false;
                            for (int i = 0; i < this._performClientAuthTargetList.size(); ++i) {
                                int performAuthTarget = (Integer)this._performClientAuthTargetList.get(i);
                                if (OID.compareOIDs(this._performClientAuthMechOID, "oid:1.2.840.113554.1.2.2") && performAuthTarget == 6) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Found client and server supported Kerberos authentication mechanism");
                                    }
                                    matches = true;
                                    break;
                                }
                                if (OID.compareOIDs(this._performClientAuthMechOID, "oid:1.3.18.0.2.30.2") && performAuthTarget == 1) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Found client and server supported LTPA authentication mechanism");
                                    }
                                    matches = true;
                                    break;
                                }
                                if (OID.compareOIDs(this._performClientAuthMechOID, "oid:2.23.130.1.1.1") && performAuthTarget == 4) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Found client and server supported GSSUP authentication mechanism");
                                    }
                                    matches = true;
                                    break;
                                }
                                if (!OID.compareOIDs(this._performClientAuthMechOID, csiv2.getString("com.ibm.CSI.WSSecurityContextCustomOID")) || performAuthTarget != 9) continue;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Found client and server supported Custom authentication mechanism");
                                }
                                matches = true;
                                break;
                            }
                            if (!matches) {
                                logMsg = SecurityMessages.getMsgOrUseDefault("JSAS1504E", this._performSupportedAuthMechList, "JSAS1504E: The server does not support the client authentication mechanism: ");
                                fail_reasons.addElement(logMsg);
                                evaluation_failed = true;
                                this._performClientAuth = false;
                                this._performClientAuthMechOID = null;
                            }
                        }
                    }
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Perform client authentication at message layer: " + this._performClientAuth + ", Perform client auth mechanism: " + this._performClientAuthMechOID + ", Target Name at message layer: " + this._targetSecurityName);
        }
        if (evaluation_failed) {
            logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0551I", "JSAS0551I: Evaluation of the message layer failed.");
            throw new CSIv2RequirementsNotSatisfied(CSIv2RequirementsNotSatisfiedReason.NotSatisfiedByClient, logMsg);
        }
    }

    private void addAuthMechOID(CSIv2TaggedComponentHolder CSIv2TagHolder) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addAuthMechOID");
        }
        if (CSIv2TagHolder == null || CSIv2TagHolder.value == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addAuthMechOID no CSIv2 tag holder supplied");
            }
            return;
        }
        CSIv2TaggedComponent cTag = CSIv2TagHolder.value;
        AS_ContextSecHolder asHolder = cTag.getAS_context_mech_holder();
        if (asHolder == null || asHolder.value == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addAuthMechOID no sec context holder supplied");
            }
            return;
        }
        AS_ContextSec asContextSec = asHolder.value;
        byte[] targetAuthMechOID = asContextSec.client_authentication_mech;
        GSSFactory gssFactory = new GSSFactory(targetAuthMechOID);
        String performClientAuthMechOID = gssFactory.getOIDName();
        String performClientAuthMech = GSSFactory.mapOidToMechType(performClientAuthMechOID);
        String targetSecurityName = asContextSec.target_name == null ? new String("") : cTag.get_targetCompleteName();
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (OID.compareOIDs(performClientAuthMechOID, "oid:2.23.130.1.1.1") || OID.compareOIDs(performClientAuthMechOID, "oid:1.2.840.113554.1.2.2") || OID.compareOIDs(performClientAuthMechOID, "oid:1.3.18.0.2.30.2") || OID.compareOIDs(performClientAuthMechOID, csiv2.getString("com.ibm.CSI.WSSecurityContextCustomOID"))) {
            boolean matches = false;
            for (int i = 0; i < this._performClientAuthTargetList.size(); ++i) {
                int performAuthTarget = (Integer)this._performClientAuthTargetList.get(i);
                if (OID.compareOIDs(performClientAuthMechOID, "oid:1.2.840.113554.1.2.2") && performAuthTarget == 6) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "addAuthMechOID adding KRB5 auth mech OID");
                    }
                    matches = true;
                    break;
                }
                if (OID.compareOIDs(performClientAuthMechOID, "oid:1.3.18.0.2.30.2") && performAuthTarget == 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "addAuthMechOID adding LTPA auth mech OID");
                    }
                    matches = true;
                    break;
                }
                if (OID.compareOIDs(performClientAuthMechOID, "oid:2.23.130.1.1.1") && performAuthTarget == 4) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "addAuthMechOID adding GSSUP auth mech OID");
                    }
                    matches = true;
                    break;
                }
                if (!OID.compareOIDs(performClientAuthMechOID, csiv2.getString("com.ibm.CSI.WSSecurityContextCustomOID")) || performAuthTarget != 9) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "addAuthMechOID adding Custom auth mech OID");
                }
                matches = true;
                break;
            }
            if (matches) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "addAuthMechOID match == true");
                }
                if (this._performClientAuthMechOIDList == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "addAuthMechOID oid list null, creating new list");
                    }
                    this._performClientAuthMechOIDList = new ArrayList();
                    this._performClientAuthMechList = new ArrayList();
                    this._targetSecurityNameList = new ArrayList();
                    this._performClientAuthMechOIDList.add(this._performClientAuthMechOID);
                    this._performClientAuthMechList.add(this._performClientAuthMech);
                    this._targetSecurityNameList.add(this._targetSecurityName);
                }
                if (this._performClientAuthMechOIDList.indexOf(performClientAuthMechOID) == -1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "addAuthMechOID adding mech to list");
                    }
                    this._performClientAuthMechOIDList.add(performClientAuthMechOID);
                    this._performClientAuthMechList.add(performClientAuthMech);
                    this._targetSecurityNameList.add(targetSecurityName);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "addAuthMechOID oid already in list for mech " + performClientAuthMech);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addAuthMechOID", new java.lang.Object[]{this._performClientAuthMechOIDList, this.hashCode()});
        }
    }

    private void evaluateAttributeLayer(SAS_ContextSecHolder sasHolder, Vector fail_reasons, boolean isAdmin) throws CSIv2RequirementsNotSatisfied {
        boolean evaluation_failed;
        String logMsg;
        block37: {
            ServiceConfiguration[] targetPrivilege_auth;
            int targetSupportedIDTokenType;
            byte[][] targetNamingMechList;
            short target_requires;
            short target_supports;
            SAS_ContextSec sasContextSec;
            CSIv2Config csiv2;
            String logMethod;
            block36: {
                if (tc.isDebugEnabled()) {
                    Tr.entry(tc, "evaluateAttributeLayer.");
                }
                logMethod = "CSIv2EffectivePerformPolicy.evaluateAttributeLayer";
                logMsg = null;
                csiv2 = SecurityObjectLocator.getCSIv2Config();
                evaluation_failed = false;
                sasContextSec = sasHolder.value;
                target_supports = 0;
                target_requires = 0;
                targetNamingMechList = null;
                targetSupportedIDTokenType = 0;
                targetPrivilege_auth = null;
                if (sasContextSec != null) break block36;
                if (csiv2.getBoolean("com.ibm.CSI.performIdentityAssertionRequired")) {
                    logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0619E", "JSAS0619E: The sending server requires Identity Assertion but the receiving server does not support it.");
                    fail_reasons.addElement(logMsg);
                    evaluation_failed = true;
                }
                break block37;
            }
            target_supports = sasContextSec.target_supports;
            target_requires = sasContextSec.target_requires;
            targetNamingMechList = sasContextSec.supported_naming_mechanisms;
            targetSupportedIDTokenType = sasContextSec.supported_identity_types;
            targetPrivilege_auth = sasContextSec.privilege_authorities;
            if (csiv2.getBoolean("com.ibm.CSI.performIdentityAssertionRequired")) {
                if (targetNamingMechList == null || targetNamingMechList.length == 0) {
                    logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0620E", "JSAS0620E: No supported naming mechanisms are defined in attribute layer for Identity Assertion.");
                    fail_reasons.addElement(logMsg);
                    evaluation_failed = true;
                }
                if (targetSupportedIDTokenType == 0) {
                    logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0621E", "JSAS0621E: The target server does not support any identity token types.");
                    fail_reasons.addElement(logMsg);
                    evaluation_failed = true;
                }
                if ((target_supports & 0x400) == 0 && (target_requires & 0x400) == 0) {
                    logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0619E", "JSAS0619E: The sending server requires Identity Assertion but the receiving server does not support it.");
                    fail_reasons.addElement(logMsg);
                    evaluation_failed = true;
                }
                if (!evaluation_failed) {
                    this._performIDAssertion = true;
                }
            } else if (csiv2.getBoolean("com.ibm.CSI.performIdentityAssertionSupported") && ((target_supports & 0x400) != 0 || (target_requires & 0x400) != 0)) {
                if (targetSupportedIDTokenType != 0 && targetNamingMechList != null && targetNamingMechList.length > 0) {
                    this._performIDAssertion = true;
                } else if (targetSupportedIDTokenType == 0) {
                    logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0621E", "JSAS0621E: The target server does not support any identity token types.");
                    fail_reasons.addElement(logMsg);
                    evaluation_failed = true;
                } else if (targetNamingMechList == null || targetNamingMechList.length == 0) {
                    logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0620E", "JSAS0620E: No supported naming mechanisms are defined in attribute layer for Identity Assertion.");
                    fail_reasons.addElement(logMsg);
                    evaluation_failed = true;
                }
            }
            if (this._performIDAssertion) {
                int i;
                Vector<String> tmplist = new Vector<String>();
                String tmpStr = null;
                GSSFactory tmpFactory = null;
                for (i = 0; i < targetNamingMechList.length; ++i) {
                    tmpFactory = new GSSFactory(targetNamingMechList[i]);
                    tmpStr = tmpFactory.getOIDName();
                    int authTarget = csiv2.getInteger("com.ibm.CSI.performIdentityAssertionMechanism");
                    if (OID.compareOIDs(tmpStr, "oid:1.2.840.113554.1.2.2")) {
                        if (authTarget != 6) continue;
                        tmplist.addElement(tmpStr);
                        continue;
                    }
                    if (OID.compareOIDs(tmpStr, "oid:2.23.130.1.1.1")) {
                        if (authTarget != 4 && authTarget != 6 && authTarget != 2 && authTarget != 1) continue;
                        tmplist.addElement(tmpStr);
                        continue;
                    }
                    if (OID.compareOIDs(tmpStr, "oid:1.3.18.0.2.30.2")) {
                        if (authTarget != 1) continue;
                        tmplist.addElement(tmpStr);
                        continue;
                    }
                    if (OID.compareOIDs(tmpStr, csiv2.getString("com.ibm.CSI.WSSecurityContextCustomOID"))) {
                        if (authTarget != 9) continue;
                        tmplist.addElement(tmpStr);
                        continue;
                    }
                    logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0620E", "JSAS0620E: No supported naming mechanisms are defined in attribute layer for Identity Assertion.");
                    fail_reasons.addElement(logMsg);
                    evaluation_failed = true;
                }
                if (tmplist.size() != 0) {
                    this._performIDANamingMechList = new String[tmplist.size()];
                    for (i = 0; i < tmplist.size(); ++i) {
                        this._performIDANamingMechList[i] = (String)tmplist.elementAt(i);
                    }
                }
                this._performIdentityTokenType = csiv2.getInteger("com.ibm.CSI.performIdentityAssertionType") & targetSupportedIDTokenType;
                this._performIDAssertion = true;
            }
            if (!csiv2.getBoolean("com.ibm.CSI.rmiOutboundPropagationEnabled") || targetPrivilege_auth == null) break block37;
            for (int i = 0; i < targetPrivilege_auth.length; ++i) {
                String serviceConfig;
                block39: {
                    block42: {
                        String supportedTargetRealms;
                        block41: {
                            block40: {
                                block38: {
                                    ServiceConfiguration currentServiceConfig = targetPrivilege_auth[i];
                                    if (currentServiceConfig.name == null || currentServiceConfig.name.length <= 0) continue;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Logging current service config syntax: " + currentServiceConfig.syntax);
                                        Tr.debug(tc, "Logging current service config bytes (size=" + currentServiceConfig.name.length + "): ");
                                        Tr.debug(tc, "Logging current service config name: " + currentServiceConfig.name);
                                    }
                                    serviceConfig = "";
                                    if (currentServiceConfig.syntax == 324817) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, logMethod, "Service config syntax is SCS_GSSExportedName.");
                                        }
                                        GSSFactory gssFactory = VaultImpl.getInstance().getGSSFactory("oid:2.23.130.1.1.1");
                                        try {
                                            serviceConfig = gssFactory.decodeExportedTargetName(currentServiceConfig.name);
                                        }
                                        catch (GSSEncodeDecodeException e) {
                                            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy.evaluateAttributeLayer", "1572", this);
                                            throw new BAD_PARAM(logMsg + "  Original exception = " + e, 1229066437, CompletionStatus.COMPLETED_NO);
                                        }
                                    } else if (currentServiceConfig.syntax == 1229066446) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Service config syntax is CSIV2_PRIV_ATTR_SYNTAX.");
                                        }
                                        CDRInputStream tagStream = ORB.createCDRInputStream((ORB)_orb, (byte[])currentServiceConfig.name, (int)currentServiceConfig.name.length);
                                        serviceConfig = tagStream.read_string();
                                    }
                                    if (!SecurityObjectLocator.getAdminData().getBoolean("isServerProcess") || serviceConfig == null || !serviceConfig.equals(ContextManagerFactory.getInstance().getDefaultRealm())) break block38;
                                    this._performAuthorizationToken = true;
                                    break block39;
                                }
                                if (SecurityObjectLocator.getAdminData().getBoolean("isServerProcess")) break block40;
                                this._performAuthorizationToken = true;
                                break block39;
                            }
                            TrustedAuthenticationRealm outboundTrustedRealms = SecurityObjectLocator.getSecurityConfig().getOutboundTrustedAuthenticationRealm();
                            boolean trustAllRealms = outboundTrustedRealms.getTrustAllRealms();
                            supportedTargetRealms = outboundTrustedRealms.getRealmList();
                            if (!trustAllRealms) break block41;
                            this._performAuthorizationToken = true;
                            if (!tc.isDebugEnabled()) break block42;
                            Tr.debug(tc, "trustAllRealms is true. Setting _performAuthorizationToken to true");
                            break block42;
                        }
                        if (supportedTargetRealms != null && !supportedTargetRealms.equals("")) {
                            StringTokenizer st = new StringTokenizer(supportedTargetRealms, "|");
                            while (st.hasMoreTokens()) {
                                String realm = st.nextToken();
                                if (!realm.equals("*") && !realm.equalsIgnoreCase(serviceConfig)) continue;
                                this._performAuthorizationToken = true;
                                break;
                            }
                        }
                    }
                    if (!this._performAuthorizationToken) {
                        Tr.warning(tc, "security.JSAS1479W", new java.lang.Object[]{serviceConfig, ContextManagerFactory.getInstance().getDefaultRealm()});
                    }
                }
                this._performServiceCfgList = i == 0 ? serviceConfig : this._performServiceCfgList + "|" + serviceConfig;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Perform client authentication at message layer: " + this._performClientAuth + ", Perform client auth mechanism: " + this._performClientAuthMechOID + ", Target Name at message layer: " + this._targetSecurityName);
        }
        if (evaluation_failed) {
            logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0552I", "JSAS0552I: Evaluation of the attribute layer failed.");
            throw new CSIv2RequirementsNotSatisfied(CSIv2RequirementsNotSatisfiedReason.NotSatisfiedByClient, logMsg);
        }
    }

    public final synchronized CSIv2EffectivePerformPolicy getEffectivePolicy(CSIv2TaggedComponent[] CSIv2TagList, String method2, java.lang.Object proxy, short isAdminFlag, short isNamingReadUnprotectedFlag) throws CSIv2RequirementsNotSatisfied {
        this._method = method2;
        this._proxy = proxy;
        CSIv2TaggedComponent cTag = null;
        CSIv2TaggedComponentHolder CSIv2TagHolder = null;
        this._performClientAuthTargetList = this.getPerformClientAuthTargetList();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "_performClientAuthTargetList[] " + this._performClientAuthTargetList);
        }
        Tr.debug(tc, "Enter getEffectivePolicy.");
        if (isNamingReadUnprotectedFlag == 1 || isNamingReadUnprotectedFlag == -1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Naming read is NOT protected by everyone role");
            }
            this._isNamingReadUnprotected = false;
        }
        if (CSIv2TagList.length > 0) {
            int i;
            Vector fail_reasons = null;
            boolean validateCertAuthMismatch = true;
            for (int ii = 0; ii < 2; ++ii) {
                validateCertAuthMismatch = ii == 0;
                for (i = 0; i < CSIv2TagList.length; ++i) {
                    boolean satisfied = true;
                    cTag = CSIv2TagList[i];
                    CSIv2TagHolder = new CSIv2TaggedComponentHolder(cTag);
                    fail_reasons = new Vector();
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "*** Evaluating CSIv2 tag " + (i + 1) + " of " + CSIv2TagList.length + " validate CertAuth:" + validateCertAuthMismatch + " ***");
                        }
                        satisfied = this.evaluate(CSIv2TagHolder, this, fail_reasons, validateCertAuthMismatch, isAdminFlag);
                        if (!(isAdminFlag != 1 && isAdminFlag != -1 || satisfied)) {
                            fail_reasons = new Vector();
                            satisfied = this.evaluate(CSIv2TagHolder, this, fail_reasons, validateCertAuthMismatch, (short)0);
                        }
                    }
                    catch (CSIv2RequirementsNotSatisfied e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "CSIv2 tag " + i + " failed evaluation.");
                        }
                        Manager.Ffdc.log((Throwable)((java.lang.Object)e), this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy.getEffectivePolicy", "1772");
                        satisfied = false;
                    }
                    if (!satisfied) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "CSIv2 tag " + (i + 1) + " evaluation succeeded.");
                    }
                    if (csiv2EffectivePolicyCache.size() > 50 && !this._disableCache) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Clearing effective policy cache, size > 50");
                        }
                        csiv2EffectivePolicyCache.clear();
                    }
                    if (this._performClientAuth) {
                        ++i;
                        while (i < CSIv2TagList.length) {
                            cTag = CSIv2TagList[i];
                            CSIv2TagHolder = new CSIv2TaggedComponentHolder(cTag);
                            this.addAuthMechOID(CSIv2TagHolder);
                            ++i;
                        }
                    }
                    if (!this._disableCache) {
                        if (this._performClientAuth || !this._performClientAuth && this._method != null && !this._method.equals("")) {
                            csiv2EffectivePolicyCache.put(CSIv2TagList, this);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Size of effective policy cache = " + csiv2EffectivePolicyCache.size());
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Skip inserting this into effective policy cache.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getEffectivePolicy", this);
                    }
                    return this;
                }
            }
            if (fail_reasons == null) {
                throw new CSIv2RequirementsNotSatisfied(CSIv2RequirementsNotSatisfiedReason.NotSatisfiedByTarget, "SECURITY CLIENT/SERVER CONFIG MISMATCH:  The server does not support the client configuration.");
            }
            if (fail_reasons.isEmpty()) {
                throw new CSIv2RequirementsNotSatisfied(CSIv2RequirementsNotSatisfiedReason.NotSatisfiedByTarget, "SECURITY CLIENT/SERVER CONFIG MISMATCH:  The server does not support the client configuration.");
            }
            StringBuffer fail_string = new StringBuffer(500);
            fail_string.append(System.getProperty("line.separator"));
            fail_string.append(System.getProperty("line.separator"));
            fail_string.append(SecurityMessages.getMsgOrUseDefault("JSAS1477W", "JSAS1477W: SECURITY CLIENT/SERVER CONFIG MISMATCH:  The client security configuration (sas.client.props or outbound settings in GUI) does not support the server security configuration for the following reasons: "));
            i = 0;
            Enumeration vEnum = fail_reasons.elements();
            while (vEnum.hasMoreElements()) {
                String reason = (String)vEnum.nextElement();
                fail_string.append(System.getProperty("line.separator"));
                fail_string.append("     ");
                fail_string.append(SecurityMessages.getMsgOrUseDefault("Error", "ERROR "));
                fail_string.append(++i);
                fail_string.append(": ");
                fail_string.append(reason);
            }
            fail_string.append(System.getProperty("line.separator"));
            fail_string.append(System.getProperty("line.separator"));
            Tr.warning(tc, fail_string.toString());
            throw new CSIv2RequirementsNotSatisfied(CSIv2RequirementsNotSatisfiedReason.NotSatisfiedByTarget, fail_string.toString());
        }
        throw new CSIv2RequirementsNotSatisfied(CSIv2RequirementsNotSatisfiedReason.NotSatisfiedByTarget, "There are no CSIv2 Tagged Components in the List.");
    }

    private final boolean evaluate(CSIv2TaggedComponentHolder CSIv2TagHolder, CSIv2EffectivePerformPolicy effPolicy, Vector fail_reasons, boolean validateCertAuthMismatch, short adminFlag) throws CSIv2RequirementsNotSatisfied {
        block13: {
            boolean isAdmin = false;
            if (adminFlag == 1 || adminFlag == -1) {
                isAdmin = true;
            }
            this._isAdmin = isAdmin;
            try {
                if (CSIv2TagHolder != null && CSIv2TagHolder.value != null) {
                    CSIv2TaggedComponent cTag = CSIv2TagHolder.value;
                    this.savedCSIv2Tag = CSIv2TagHolder;
                    if (effPolicy != null) {
                        boolean evaluation_failed = false;
                        try {
                            effPolicy.evaluateStatefulness(cTag.isStateFul(), fail_reasons, isAdmin);
                        }
                        catch (CSIv2RequirementsNotSatisfied e) {
                            evaluation_failed = true;
                        }
                        try {
                            effPolicy.evaluateAttributeLayer(cTag.getSAS_context_mech_holder(), fail_reasons, isAdmin);
                        }
                        catch (CSIv2RequirementsNotSatisfied e) {
                            Manager.Ffdc.log((Throwable)((java.lang.Object)e), this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy.evaluate", "1902");
                            evaluation_failed = true;
                        }
                        try {
                            effPolicy.evaluateClientAuthLayer(cTag.getAS_context_mech_holder(), fail_reasons, isAdmin);
                        }
                        catch (CSIv2RequirementsNotSatisfied e) {
                            evaluation_failed = true;
                        }
                        try {
                            effPolicy.evaluateTransportLayer(cTag, fail_reasons, validateCertAuthMismatch, isAdmin);
                        }
                        catch (CSIv2RequirementsNotSatisfied e) {
                            evaluation_failed = true;
                        }
                        return !evaluation_failed;
                    }
                    Tr.debug(tc, "Effective policy object is null.");
                    fail_reasons.addElement("Effective policy object is null.");
                    break block13;
                }
                Tr.debug(tc, "CSIv2TagHolder is null or the value inside is null.");
                fail_reasons.addElement("CSIv2TagHolder is null or the value inside is null.");
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy.evaluate", "1944");
                Tr.debug(tc, "Exception in getEffectivePolicy, probably CSIv2RequirementsNotSatisfied.", e);
            }
        }
        return false;
    }

    public boolean isStateful() {
        return this._stateful;
    }

    public void setStateful(boolean stateful) {
        this._stateful = stateful;
    }

    public long getStatefulContextID() {
        return this._stateful_context_id;
    }

    public void setStatefulContextID(long stateful_context_id) {
        this._stateful_context_id = stateful_context_id;
    }

    public ClientSessionKey getClientSessionKey() {
        return this._client_session_key;
    }

    public void setClientSessionKey(ClientSessionKey clientSessionKey) {
        this._client_session_key = clientSessionKey;
    }

    public String getConnectionKey() {
        return this._connectionKey;
    }

    public void setConnectionKey(String key) {
        this._connectionKey = key;
    }

    public boolean getIsInternalRequestPolicy() {
        return this._isInternalRequestPolicy;
    }

    private CSIv2EffectivePerformPolicy() {
    }

    public static CSIv2EffectivePerformPolicy getInstance(CSIv2TaggedComponent[] CSIv2TagList, short isAdminFlag, short isNamingReadUnprotectedFlag) throws CSIv2RequirementsNotSatisfied {
        return CSIv2EffectivePerformPolicy.getInstance(CSIv2TagList, null, null, isAdminFlag, isNamingReadUnprotectedFlag);
    }

    public static CSIv2EffectivePerformPolicy getInstance(CSIv2TaggedComponent[] CSIv2TagList, String method2, java.lang.Object proxy, short isAdminFlag, short isNamingReadUnprotectedFlag) throws CSIv2RequirementsNotSatisfied {
        try {
            CSIv2EffectivePerformPolicy cachedPolicy = null;
            if (!CSIv2EffectivePerformPolicy.methodRequiresAuthenticationRegardlessOfPolicy(method2, proxy)) {
                cachedPolicy = (CSIv2EffectivePerformPolicy)csiv2EffectivePolicyCache.get(CSIv2TagList);
            }
            if (cachedPolicy != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Returning policy from cache for CSIv2TagList: " + CSIv2TagList);
                }
                CSIv2EffectivePerformPolicy clone = (CSIv2EffectivePerformPolicy)cachedPolicy.clone();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getInstance returning clone of cached policy", clone);
                }
                return clone;
            }
            cachedPolicy = CSIv2EffectivePerformPolicy.getInstance();
            cachedPolicy.getEffectivePolicy(CSIv2TagList, method2, proxy, isAdminFlag, isNamingReadUnprotectedFlag);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getInstance returning new instance", cachedPolicy);
            }
            return cachedPolicy;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, CSIv2EffectivePerformPolicy.class, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy.getInstance", "2106");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception creating effective policy.", e);
            }
            return null;
        }
    }

    public static CSIv2EffectivePerformPolicy getInstance(CSIv2TaggedComponent[] CSIv2TagList, String method2, ORB orb, IOR ior, short isAdminFlag, short isNamingReadUnprotectedFlag) throws CSIv2RequirementsNotSatisfied {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance", new java.lang.Object[]{CSIv2TagList, method2, orb, ior, isAdminFlag, isNamingReadUnprotectedFlag});
        }
        try {
            CSIv2EffectivePerformPolicy cachedPolicy = (CSIv2EffectivePerformPolicy)csiv2EffectivePolicyCache.get(CSIv2TagList);
            if (cachedPolicy != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getInstance returning policy from cache");
                }
                CSIv2EffectivePerformPolicy clone = (CSIv2EffectivePerformPolicy)cachedPolicy.clone();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getInstance returning clone of cached policy", clone);
                }
                return clone;
            }
            cachedPolicy = CSIv2EffectivePerformPolicy.getInstance();
            Object proxy = orb != null && ior != null ? orb.IORToObject(ior) : null;
            cachedPolicy.getEffectivePolicy(CSIv2TagList, method2, proxy, isAdminFlag, isNamingReadUnprotectedFlag);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getInstance returning new instance", cachedPolicy);
            }
            return cachedPolicy;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, CSIv2EffectivePerformPolicy.class, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy.getInstance", "2106");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getInstance exception creating effective policy, returning null policy", e);
            }
            return null;
        }
    }

    public static CSIv2EffectivePerformPolicy getInternalRequestPolicyInstance() {
        CSIv2EffectivePerformPolicy policy = new CSIv2EffectivePerformPolicy();
        policy._stateful = false;
        policy._stateful_context_id = 0L;
        policy._client_session_key = null;
        policy._connectionKey = "";
        policy._mechTypeIdentity = "";
        policy._performTLClientAuth = true;
        policy._performTLServerAuth = false;
        policy._performMsgDetectReplay = false;
        policy._performMsgDetectMisordering = false;
        policy._performMsgIntegrity = false;
        policy._performMsgConfidentiality = false;
        policy._performSSLTLS = false;
        policy._performSECIOP = false;
        policy._performSECIOPMechOID = "";
        policy._targetHostName = "INTERNAL_SERVER_REQUEST";
        policy._targetTCPPort = 0;
        policy._targetSSLPort = 0;
        policy._performClientAuth = false;
        policy._claimClientAuthRequired = false;
        policy._performClientAuthMechOID = "oid:2.23.130.1.1.1";
        policy._targetSecurityName = "";
        policy._performIDAssertion = true;
        policy._performServiceCfgList = "";
        policy._performAuthorizationToken = false;
        policy._performIDANamingMechList = new String[]{"oid:2.23.130.1.1.1"};
        policy._performIdentityTokenType = 15;
        policy._performDelegationByClient = false;
        policy._isInternalRequestPolicy = true;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning local policy created for internal: " + policy);
        }
        return policy;
    }

    public static CSIv2EffectivePerformPolicy getInstance() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance");
        }
        return new CSIv2EffectivePerformPolicy();
    }

    public CSIv2TaggedComponentHolder getCSIv2TaggedComponent() {
        return this.savedCSIv2Tag;
    }

    protected java.lang.Object clone() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clone");
        }
        CSIv2EffectivePerformPolicy clonedPolicy = new CSIv2EffectivePerformPolicy();
        clonedPolicy._client_session_key = null;
        clonedPolicy._stateful_context_id = 0L;
        clonedPolicy._connectionKey = this._connectionKey;
        clonedPolicy._claimClientAuthRequired = this._claimClientAuthRequired;
        clonedPolicy._mechTypeIdentity = this._mechTypeIdentity;
        clonedPolicy._performAuthorizationToken = this._performAuthorizationToken;
        clonedPolicy._performClientAuth = this._performClientAuth;
        clonedPolicy._performClientAuthMech = this._performClientAuthMech;
        clonedPolicy._performClientAuthMechOID = this._performClientAuthMechOID;
        clonedPolicy._performClientAuthMechList = this._performClientAuthMechList;
        clonedPolicy._performClientAuthMechOIDList = this._performClientAuthMechOIDList;
        clonedPolicy._targetSecurityNameList = this._targetSecurityNameList;
        clonedPolicy._performDelegationByClient = this._performDelegationByClient;
        clonedPolicy._performIDANamingMechList = this._performIDANamingMechList;
        clonedPolicy._performIDAssertion = this._performIDAssertion;
        clonedPolicy._performIdentityTokenType = this._performIdentityTokenType;
        clonedPolicy._performMsgConfidentiality = this._performMsgConfidentiality;
        clonedPolicy._performMsgDetectMisordering = this._performMsgDetectMisordering;
        clonedPolicy._performMsgDetectReplay = this._performMsgDetectReplay;
        clonedPolicy._performMsgIntegrity = this._performMsgIntegrity;
        clonedPolicy._performSECIOP = this._performSECIOP;
        clonedPolicy._performSECIOPMechOID = this._performSECIOPMechOID;
        clonedPolicy._performServiceCfgList = this._performServiceCfgList;
        clonedPolicy._performSSLTLS = this._performSSLTLS;
        clonedPolicy._performTLClientAuth = this._performTLClientAuth;
        clonedPolicy._performTLServerAuth = this._performTLServerAuth;
        clonedPolicy._protocol = this._protocol;
        clonedPolicy._stateful = this._stateful;
        clonedPolicy._targetHostName = this._targetHostName;
        clonedPolicy._targetSecurityName = this._targetSecurityName;
        clonedPolicy._targetAuthMechOID = this._targetAuthMechOID;
        clonedPolicy._targetSSLPort = this._targetSSLPort;
        clonedPolicy._targetTCPPort = this._targetTCPPort;
        clonedPolicy.savedCSIv2Tag = this.savedCSIv2Tag;
        clonedPolicy._isInternalRequestPolicy = this._isInternalRequestPolicy;
        clonedPolicy._isAdmin = this._isAdmin;
        clonedPolicy._isNamingReadUnprotected = this._isNamingReadUnprotected;
        return clonedPolicy;
    }

    public CSIv2EffectivePerformPolicy(byte[] object_bytes) throws Exception {
        this.deserializeVariables(object_bytes);
    }

    public byte[] getBytes() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBytes", this);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Session contents prior to serialization: " + this.toString());
        }
        byte[] out_bytes = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(300);
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            int i;
            int size;
            dos.writeBoolean(this._stateful);
            dos.writeBoolean(this._performTLClientAuth);
            dos.writeBoolean(this._performTLServerAuth);
            dos.writeBoolean(this._performMsgDetectReplay);
            dos.writeBoolean(this._performMsgDetectMisordering);
            dos.writeBoolean(this._performMsgIntegrity);
            dos.writeBoolean(this._performMsgConfidentiality);
            dos.writeBoolean(this._performSSLTLS);
            dos.writeBoolean(this._performSECIOP);
            dos.writeBoolean(this._performClientAuth);
            dos.writeBoolean(this._claimClientAuthRequired);
            dos.writeBoolean(this._performIDAssertion);
            dos.writeBoolean(this._performAuthorizationToken);
            dos.writeBoolean(this._performDelegationByClient);
            dos.writeLong(this._stateful_context_id);
            dos.writeInt(this._targetTCPPort);
            dos.writeInt(this._targetSSLPort);
            dos.writeInt(this._performIdentityTokenType);
            if (this._connectionKey != null && this._connectionKey.length() > 0) {
                dos.writeInt(this._connectionKey.length());
                dos.write(this._connectionKey.getBytes(), 0, this._connectionKey.length());
            } else {
                dos.writeInt(0);
            }
            if (this._mechTypeIdentity != null && this._mechTypeIdentity.length() > 0) {
                dos.writeInt(this._mechTypeIdentity.length());
                dos.write(this._mechTypeIdentity.getBytes(), 0, this._mechTypeIdentity.length());
            } else {
                dos.writeInt(0);
            }
            if (this._performSECIOPMechOID != null && this._performSECIOPMechOID.length() > 0) {
                dos.writeInt(this._performSECIOPMechOID.length());
                dos.write(this._performSECIOPMechOID.getBytes(), 0, this._performSECIOPMechOID.length());
            } else {
                dos.writeInt(0);
            }
            if (this._targetHostName != null && this._targetHostName.length() > 0) {
                dos.writeInt(this._targetHostName.length());
                dos.write(this._targetHostName.getBytes(), 0, this._targetHostName.length());
            } else {
                dos.writeInt(0);
            }
            if (this._performClientAuthMech != null && this._performClientAuthMech.length() > 0) {
                dos.writeInt(this._performClientAuthMech.length());
                dos.write(this._performClientAuthMech.getBytes(), 0, this._performClientAuthMech.length());
            } else {
                dos.writeInt(0);
            }
            if (this._performClientAuthMechOID != null && this._performClientAuthMechOID.length() > 0) {
                dos.writeInt(this._performClientAuthMechOID.length());
                dos.write(this._performClientAuthMechOID.getBytes(), 0, this._performClientAuthMechOID.length());
            } else {
                dos.writeInt(0);
            }
            if (this._performClientAuthMechList != null && this._performClientAuthMechList.size() > 0) {
                size = this._performClientAuthMechList.size();
                dos.writeInt(size);
                for (i = 0; i < size; ++i) {
                    String authMech = (String)this._performClientAuthMechList.get(i);
                    if (authMech != null && authMech.length() > 0) {
                        dos.writeInt(authMech.length());
                        dos.write(authMech.getBytes(), 0, authMech.length());
                        continue;
                    }
                    dos.writeInt(0);
                }
            } else {
                dos.writeInt(0);
            }
            if (this._performClientAuthMechOIDList != null && this._performClientAuthMechOIDList.size() > 0) {
                size = this._performClientAuthMechOIDList.size();
                dos.writeInt(size);
                for (i = 0; i < size; ++i) {
                    String authMechOID = (String)this._performClientAuthMechOIDList.get(i);
                    if (authMechOID != null && authMechOID.length() > 0) {
                        dos.writeInt(authMechOID.length());
                        dos.write(authMechOID.getBytes(), 0, authMechOID.length());
                        continue;
                    }
                    dos.writeInt(0);
                }
            } else {
                dos.writeInt(0);
            }
            if (this._targetSecurityNameList != null && this._targetSecurityNameList.size() > 0) {
                size = this._targetSecurityNameList.size();
                dos.writeInt(size);
                for (i = 0; i < size; ++i) {
                    String targetSecurityName = (String)this._targetSecurityNameList.get(i);
                    if (targetSecurityName != null && targetSecurityName.length() > 0) {
                        dos.writeInt(targetSecurityName.length());
                        dos.write(targetSecurityName.getBytes(), 0, targetSecurityName.length());
                        continue;
                    }
                    dos.writeInt(0);
                }
            } else {
                dos.writeInt(0);
            }
            if (this._targetSecurityName != null && this._targetSecurityName.length() > 0) {
                dos.writeInt(this._targetSecurityName.length());
                dos.write(this._targetSecurityName.getBytes(), 0, this._targetSecurityName.length());
            } else {
                dos.writeInt(0);
            }
            if (this._targetAuthMechOID != null && this._targetAuthMechOID.length() > 0) {
                dos.writeInt(this._targetAuthMechOID.length());
                dos.write(this._targetAuthMechOID.getBytes(), 0, this._targetAuthMechOID.length());
            } else {
                dos.writeInt(0);
            }
            if (this._performServiceCfgList != null && this._performServiceCfgList.length() > 0) {
                dos.writeInt(this._performServiceCfgList.length());
                dos.write(this._performServiceCfgList.getBytes(), 0, this._performServiceCfgList.length());
            } else {
                dos.writeInt(0);
            }
            if (this._performIDANamingMechList != null) {
                dos.writeInt(this._performIDANamingMechList.length);
                for (int i2 = 0; i2 < this._performIDANamingMechList.length; ++i2) {
                    if (this._performIDANamingMechList[i2] != null && this._performIDANamingMechList[i2].length() > 0) {
                        dos.writeInt(this._performIDANamingMechList[i2].length());
                        dos.write(this._performIDANamingMechList[i2].getBytes(), 0, this._performIDANamingMechList[i2].length());
                        continue;
                    }
                    dos.writeInt(0);
                }
            } else {
                dos.writeInt(0);
            }
            dos.writeBoolean(this._isInternalRequestPolicy);
            dos.writeBoolean(this._isAdmin);
            dos.writeBoolean(this._isNamingReadUnprotected);
            out_bytes = baos.toByteArray();
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy.getBytes", "2426", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception serializing native variables.", e);
            }
            throw e;
        }
        finally {
            if (baos != null) {
                baos.close();
            }
            if (dos != null) {
                dos.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBytes", out_bytes);
        }
        return out_bytes;
    }

    private void deserializeVariables(byte[] inputData) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deserializeVariables", new java.lang.Object[]{inputData, this});
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(inputData);
        DataInputStream dis = new DataInputStream(bais);
        try {
            byte[] stringBytes;
            int i;
            int listSize;
            byte[] stringBytes2;
            this._stateful = dis.readBoolean();
            this._performTLClientAuth = dis.readBoolean();
            this._performTLServerAuth = dis.readBoolean();
            this._performMsgDetectReplay = dis.readBoolean();
            this._performMsgDetectMisordering = dis.readBoolean();
            this._performMsgIntegrity = dis.readBoolean();
            this._performMsgConfidentiality = dis.readBoolean();
            this._performSSLTLS = dis.readBoolean();
            this._performSECIOP = dis.readBoolean();
            this._performClientAuth = dis.readBoolean();
            this._claimClientAuthRequired = dis.readBoolean();
            this._performIDAssertion = dis.readBoolean();
            this._performAuthorizationToken = dis.readBoolean();
            this._performDelegationByClient = dis.readBoolean();
            this._stateful_context_id = dis.readLong();
            this._targetTCPPort = dis.readInt();
            this._targetSSLPort = dis.readInt();
            this._performIdentityTokenType = dis.readInt();
            int stringSize = dis.readInt();
            if (stringSize > 0) {
                stringBytes2 = new byte[stringSize];
                dis.read(stringBytes2, 0, stringSize);
                this._connectionKey = new String(stringBytes2);
            }
            if ((stringSize = dis.readInt()) > 0) {
                stringBytes2 = new byte[stringSize];
                dis.read(stringBytes2, 0, stringSize);
                this._mechTypeIdentity = new String(stringBytes2);
            }
            if ((stringSize = dis.readInt()) > 0) {
                stringBytes2 = new byte[stringSize];
                dis.read(stringBytes2, 0, stringSize);
                this._performSECIOPMechOID = new String(stringBytes2);
            }
            if ((stringSize = dis.readInt()) > 0) {
                stringBytes2 = new byte[stringSize];
                dis.read(stringBytes2, 0, stringSize);
                this._targetHostName = new String(stringBytes2);
            }
            if ((stringSize = dis.readInt()) > 0) {
                stringBytes2 = new byte[stringSize];
                dis.read(stringBytes2, 0, stringSize);
                this._performClientAuthMech = new String(stringBytes2);
            }
            if ((stringSize = dis.readInt()) > 0) {
                stringBytes2 = new byte[stringSize];
                dis.read(stringBytes2, 0, stringSize);
                this._performClientAuthMechOID = new String(stringBytes2);
            }
            if ((listSize = dis.readInt()) > 0) {
                this._performClientAuthMechList = new ArrayList();
                for (i = 0; i < listSize; ++i) {
                    stringSize = dis.readInt();
                    if (stringSize > 0) {
                        stringBytes = new byte[stringSize];
                        dis.read(stringBytes, 0, stringSize);
                        this._performClientAuthMechList.add(new String(stringBytes));
                        continue;
                    }
                    this._performClientAuthMechList.add(new String(""));
                }
            }
            if ((listSize = dis.readInt()) > 0) {
                this._performClientAuthMechOIDList = new ArrayList();
                for (i = 0; i < listSize; ++i) {
                    stringSize = dis.readInt();
                    if (stringSize > 0) {
                        stringBytes = new byte[stringSize];
                        dis.read(stringBytes, 0, stringSize);
                        this._performClientAuthMechOIDList.add(new String(stringBytes));
                        continue;
                    }
                    this._performClientAuthMechOIDList.add(new String(""));
                }
            }
            if ((listSize = dis.readInt()) > 0) {
                this._targetSecurityNameList = new ArrayList();
                for (i = 0; i < listSize; ++i) {
                    stringSize = dis.readInt();
                    if (stringSize > 0) {
                        stringBytes = new byte[stringSize];
                        dis.read(stringBytes, 0, stringSize);
                        this._targetSecurityNameList.add(new String(stringBytes));
                        continue;
                    }
                    this._targetSecurityNameList.add(new String(""));
                }
            }
            if ((stringSize = dis.readInt()) > 0) {
                byte[] stringBytes3 = new byte[stringSize];
                dis.read(stringBytes3, 0, stringSize);
                this._targetSecurityName = new String(stringBytes3);
            }
            if ((stringSize = dis.readInt()) > 0) {
                byte[] stringBytes4 = new byte[stringSize];
                dis.read(stringBytes4, 0, stringSize);
                this._targetAuthMechOID = new String(stringBytes4);
            }
            if ((stringSize = dis.readInt()) > 0) {
                byte[] stringBytes5 = new byte[stringSize];
                dis.read(stringBytes5, 0, stringSize);
                this._performServiceCfgList = new String(stringBytes5);
            }
            int idaSize = dis.readInt();
            ArrayList<String> idaArray = new ArrayList<String>();
            for (int i2 = 0; i2 < idaSize; ++i2) {
                stringSize = dis.readInt();
                if (stringSize <= 0) continue;
                byte[] stringBytes6 = new byte[stringSize];
                dis.read(stringBytes6, 0, stringSize);
                idaArray.add(new String(stringBytes6));
            }
            if (idaArray.size() > 0) {
                this._performIDANamingMechList = idaArray.toArray(new String[0]);
            }
            this._isInternalRequestPolicy = dis.readBoolean();
            this._isAdmin = dis.readBoolean();
            this._isNamingReadUnprotected = dis.readBoolean();
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.orbssl.ExtendedSSLConnectionData.deserializeVariables", "2616", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception de-serializing native variables.", e);
            }
            throw e;
        }
        finally {
            if (bais != null) {
                bais.close();
            }
            if (dis != null) {
                dis.close();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Session after deserialization: " + this.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deserializeVariables");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n_stateful: " + this._stateful);
        sb.append("\n_performTLClientAuth: " + this._performTLClientAuth);
        sb.append("\n_performTLServerAuth: " + this._performTLServerAuth);
        sb.append("\n_performMsgDetectReplay: " + this._performMsgDetectReplay);
        sb.append("\n_performMsgDetectMisordering: " + this._performMsgDetectMisordering);
        sb.append("\n_performMsgIntegrity: " + this._performMsgIntegrity);
        sb.append("\n_performMsgConfidentiality: " + this._performMsgConfidentiality);
        sb.append("\n_performSSLTLS: " + this._performSSLTLS);
        sb.append("\n_performSECIOP: " + this._performSECIOP);
        sb.append("\n_performClientAuth: " + this._performClientAuth);
        sb.append("\n_claimClientAuthRequired: " + this._claimClientAuthRequired);
        sb.append("\n_performIDAssertion: " + this._performIDAssertion);
        sb.append("\n_performAuthorizationToken: " + this._performAuthorizationToken);
        sb.append("\n_performDelegationByClient: " + this._performDelegationByClient);
        sb.append("\n_stateful_context_id: " + this._stateful_context_id);
        sb.append("\n_targetTCPPort: " + this._targetTCPPort);
        sb.append("\n_targetSSLPort: " + this._targetSSLPort);
        sb.append("\n_performIdentityTokenType: " + this._performIdentityTokenType);
        sb.append("\n_mechTypeIdentity: " + this._mechTypeIdentity);
        sb.append("\n_performSECIOPMechOID: " + this._performSECIOPMechOID);
        sb.append("\n_targetHostName: " + this._targetHostName);
        sb.append("\n_performClientAuthMech: " + this._performClientAuthMech);
        sb.append("\n_performClientAuthMechOID: " + this._performClientAuthMechOID);
        sb.append("\n_performClientAuthMechOIDList: " + this._performClientAuthMechOIDList);
        sb.append("\n_performClientAuthMechList: " + this._performClientAuthMechList);
        sb.append("\n_targetSecurityNameList: " + this._targetSecurityNameList);
        sb.append("\n_targetSecurityName: " + this._targetSecurityName);
        sb.append("\n_targetAuthMechOID: " + this._targetAuthMechOID);
        sb.append("\n_performServiceCfgList: " + this._performServiceCfgList);
        sb.append("\n_performIDANamingMechList length: " + (this._performIDANamingMechList == null ? "0" : Integer.toString(this._performIDANamingMechList.length)));
        sb.append("\n_internalRequestPolicy: " + this._isInternalRequestPolicy);
        sb.append("\n_connectionKey: " + this._connectionKey);
        sb.append("\n_isAdmin: " + this._isAdmin);
        sb.append("\n_isNamingReadUnprotected: " + this._isNamingReadUnprotected);
        sb.append("\n_hashCode: " + this.hashCode());
        return sb.toString();
    }

    private static boolean methodRequiresAuthenticationRegardlessOfPolicy(String method2, java.lang.Object proxy) {
        String logMethod = "CSIv2EffectivePerformPolicy.methodRequiresAuthenticationRegardlessOfPolicy";
        String logMsg = null;
        if (SecurityLogger.debugTraceEnabled) {
            logMsg = "Method: " + method2 + ", interfaceName: " + (proxy == null ? "null" : proxy.getClass().getName());
            SecurityLogger.debugMessage(logMethod, logMsg);
        }
        if (proxy == null || method2 == null) {
            return false;
        }
        boolean result = false;
        String interfaceName = proxy.getClass().getName();
        if ((interfaceName.equals("com.ibm.ws.orb.services.lsd._LocationServiceStub") || interfaceName.equals("com.ibm.ws.orbimpl.services.lsd.LocationServiceImpl") || interfaceName.equals("com.ibm.org.omg.CORBA._ObjectStub")) && (method2.equals("register_server") || method2.equals("unregister_server") || method2.equals("register_object_adapters") || method2.equals("usregister_object_adapters"))) {
            result = true;
        }
        if (SecurityLogger.debugTraceEnabled) {
            logMsg = "methodRequiresAuthenticationRegardlessOfPolicy: returned " + result + ".";
            SecurityLogger.debugMessage(logMethod, logMsg);
        }
        return result;
    }
}

