/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectBaseL13Impl;

import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.CSIv2Security.CSIv2RequirementsNotSatisfied;
import com.ibm.ISecurityLocalObjectBaseL13Impl.APPSECTaggedComponent;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SSLCompoundTaggedComponent;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SSLTaggedComponent;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponentHolder;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.ServerConnectionKey;
import com.ibm.ISecurityUtilityImpl.ObjectList;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ISecurityUtilityImpl.ServiceInit;
import com.ibm.ISecurityUtilityImpl.VaultConstants;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.ws.connmgmt.ConnectionHandle;
import com.ibm.ws.orb.transport.ConnectionData;
import com.ibm.ws.orb.transport.ConnectionDataCarrier;
import com.ibm.ws.orb.transport.ConnectionInformation;
import com.ibm.ws.orb.transport.DefaultConnectionInterceptor;
import com.ibm.ws.orb.transport.IIOPEndpointProfile;
import com.ibm.ws.orb.transport.ServerConnectionData;
import com.ibm.ws.orbimpl.transport.ConnectionInformationImpl;
import com.ibm.ws.orbimpl.transport.DefaultServerConnectionDataImpl;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityConfigResource;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.orbssl.ExtendedSSLConnectionData;
import com.ibm.ws.security.orbssl.SSLConnectionData;
import com.ibm.ws.security.orbssl.SSLServerConnectionData;
import com.ibm.ws.security.orbssl.SSLServerConnectionDataImpl;
import com.ibm.ws.security.orbssl.ServerConnectionDataImpl;
import com.ibm.ws.security.util.MultiDomainHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws390.utility.JAVAtoCPPUtilities;
import com.ibm.wsspi.channel.framework.ChainEventListener;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.SSLConnectionContext;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Object;
import org.omg.CSIIOP.TLS_SEC_TRANSHolder;

public class SecurityConnectionInterceptor
extends DefaultConnectionInterceptor
implements ChainEventListener {
    private VaultImpl vault = null;
    private ORB orb = null;
    private ChannelFramework cfw = null;
    private SSLServerConnectionData csiServerSSLConnData = null;
    private SSLServerConnectionData csiClientCertServerSSLConnData = null;
    private ServerConnectionData serverTCPConnData = null;
    private DefaultConnectionInterceptor defaultConnInt = null;
    public static Hashtable classNames = new Hashtable();
    private static final int OutcomeUnknown = 0;
    private static final int OutcomeSuccessful = 1;
    private static final int OutcomeRetry = 2;
    private static final int OutcomeFail = 3;
    private static final short WebSphereAS = 16384;
    private static final String ADMIN_CLASS = "adminsec.txt";
    private ObjectList list = null;
    private static boolean prefer_iiop_to_local = false;
    private static boolean isThinClient = false;
    private static final TraceComponent tc = Tr.register(SecurityConnectionInterceptor.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");

    public void init(ORB _orb) {
        if (_orb == null) {
            throw new INTERNAL("ORB is NULL passed into Security!!!");
        }
        this.orb = _orb;
        this.defaultConnInt = new DefaultConnectionInterceptor();
        this.defaultConnInt.init(this.orb);
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (csiv2.getBoolean("com.ibm.CORBA.securityEnabled")) {
            Tr.audit(tc, "security.LoadSCI");
            if (!ServiceInit.isInitialized()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initializing ServiceInit in SCI.");
                }
                ServiceInit si = ServiceInit.getInstance();
                si.initialize(_orb);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Initializing SecurityConnectionInterceptor.");
            }
            this.vault = this.getVault();
            if (this.vault != null) {
                csiv2 = SecurityObjectLocator.getCSIv2Config();
                this.vault.setSecurityConnectionInterceptor(this);
                this.vault.setORB(this.orb);
            } else {
                Tr.error(tc, "security.JSAS0010E");
            }
        }
    }

    public void notifyChainInitializationComplete(ChannelFramework cfw, ORB orb, List secureChains, List insecureChains) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notifyChainInitializationComplete", new java.lang.Object[]{secureChains, insecureChains});
        }
        this.cfw = cfw;
        if (!PlatformHelperFactory.getPlatformHelper().isZOS() || PlatformHelperFactory.getPlatformHelper().isControlJvm() || PlatformHelperFactory.getPlatformHelper().isClientJvm()) {
            try {
                for (int i = 0; secureChains != null && i < secureChains.size(); ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding init complete listener for secure chain: " + (String)secureChains.get(i));
                    }
                    cfw.addChainEventListener((ChainEventListener)this, (String)secureChains.get(i));
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor.notifyChainInitializationComplete", "391", this);
                Tr.debug(tc, e.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "notifyChainInitializationComplete");
        }
    }

    public void chainInitialized(ChainData chainData) {
    }

    public void chainStarted(ChainData chainData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chainStarted", new java.lang.Object[]{chainData});
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting listening port for chain data" + chainData.getName());
            }
            int sslPort = this.cfw.getListeningPort(chainData.getName());
            this.orb.setProperty("com.ibm.CSI.SSLPort", Integer.toString(sslPort));
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor.chainStarted", "421", this);
            Tr.debug(tc, e.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chainStarted");
        }
    }

    public void chainStopped(ChainData chainData) {
    }

    public void chainDestroyed(ChainData chainData) {
    }

    public void chainUpdated(ChainData chainData) {
    }

    protected short formCoalescedQOP(short targetSupports, short targetRequires) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "formCoalescedQOP, THIS IS CALLED");
        }
        short coalescedQOP = targetRequires;
        return coalescedQOP;
    }

    protected short formCSIv2CoalescedQOP(short targetSupports, short targetRequires, CSIv2EffectivePerformPolicy csiv2effectivePolicy) {
        Short supportsShort = new Short(targetSupports);
        Short requiresShort = new Short(targetRequires);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formCSIv2CoalescedQOP", new java.lang.Object[]{supportsShort, requiresShort});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " Input to formCSIv2CoalescedQOP: targetSupports: " + targetSupports + ", targetRequires: " + targetRequires);
        }
        short coalescedQOP = 0;
        if (csiv2effectivePolicy != null) {
            if (csiv2effectivePolicy.performTLClientAuth()) {
                coalescedQOP = (short)(coalescedQOP + 64);
            }
            if (csiv2effectivePolicy.performTLServerAuth()) {
                coalescedQOP = (short)(coalescedQOP + 32);
            }
            if (csiv2effectivePolicy.performMsgIntegrity()) {
                coalescedQOP = (short)(coalescedQOP + 2);
            }
            if (csiv2effectivePolicy.performMsgConfidentiality()) {
                coalescedQOP = (short)(coalescedQOP + 4);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " Output from formCSIv2CoalescedQOP: targetSupports: " + targetSupports + " targetRequires: " + targetRequires + " coalescedQOP: " + coalescedQOP);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formCSIv2CoalescedQOP", new Short(coalescedQOP));
        }
        return coalescedQOP;
    }

    protected String formConnectionKey(String targetHost, int targetPort, String secMech, short coalescedQOP) {
        String key = null;
        Integer port = new Integer(targetPort);
        Short qop = new Short(coalescedQOP);
        if (secMech == null) {
            secMech = " ";
        }
        key = secMech.equals(VaultConstants.SSL_MECH_TYPE) ? targetHost + ":" + port.toString() + ":" + "IIOPSSL" + ":" + qop.toString() : (secMech.equals(VaultConstants.DCE_MECH_TYPE) ? targetHost + ":" + port.toString() + ":" + "IIOPDCE" : targetHost + ":" + port.toString());
        return key;
    }

    public java.lang.Object getServerConnectionData(GIOPConnectionContext ctx) {
        Map stateMap;
        VirtualConnection vc = ctx.getVirtualConnection();
        ConnectionInformation ci = null;
        if (vc != null && (stateMap = vc.getStateMap()) != null && (ci = (ConnectionInformation)stateMap.get("CSIv2ConnectionInfo")) == null) {
            DefaultServerConnectionDataImpl scd = new DefaultServerConnectionDataImpl();
            int remotePort = 0;
            int localPort = 0;
            String remoteHost = null;
            ConnectionHandle ch = ConnectionHandle.getConnectionHandle((VirtualConnection)vc);
            if (ch != null && ch.getIsLocalComm()) {
                remoteHost = ch.toString();
                remotePort = -1;
                localPort = -1;
                scd.setConnectionType(4L);
            } else {
                remoteHost = ctx.getRemoteHost();
                remotePort = ctx.getRemotePort();
                localPort = ctx.getLocalPort();
            }
            scd.setRemoteHost(remoteHost);
            scd.setRemotePort(remotePort);
            scd.setLocalHost(ctx.getLocalHost());
            scd.setLocalPort(localPort);
            scd.setConnectionHandle(ch);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Filter receive request GCC Information: \nConnectionHandle: " + (ch == null ? "null" : ch.toString()) + "\nisLocalComm: " + (ch != null ? ch.getIsLocalComm() : false) + "\nlocal host: " + scd.getLocalHost() + "\nlocal port: " + scd.getLocalPort() + "\nremote host: " + scd.getRemoteHost() + "\nremote port: " + scd.getRemotePort());
            }
            SSLSession session = null;
            SSLConnectionContext sslConnContext = ctx.getSSLContext();
            if (sslConnContext != null) {
                session = sslConnContext.getSession();
            }
            X509Certificate[] cert_chain = null;
            if (session != null) {
                try {
                    cert_chain = (X509Certificate[])session.getPeerCertificates();
                }
                catch (SSLPeerUnverifiedException e) {
                    // empty catch block
                }
            }
            ci = new ConnectionInformationImpl(scd, cert_chain, System.currentTimeMillis(), remoteHost, remotePort);
            stateMap.put("CSIv2ConnectionInfo", ci);
        }
        if (tc.isDebugEnabled()) {
            if (ci != null) {
                Tr.debug(tc, "ConnectionInformation: " + ci.toString());
            } else {
                Tr.debug(tc, "ConnectionInformation is NULL.");
            }
        }
        return ci;
    }

    public byte[] getClientConnectionInfo(java.lang.Object connectionInfo) {
        byte[] data_bytes = null;
        try {
            ConnectionInformation info = (ConnectionInformation)connectionInfo;
            if (info != null) {
                ConnectionData cd = (ConnectionData)info.getConnectionData();
                if (cd != null && cd instanceof ExtendedSSLConnectionData) {
                    data_bytes = ((ExtendedSSLConnectionData)cd).getBytes();
                } else if (cd != null) {
                    String key = cd.getConnectionKey();
                    data_bytes = key.getBytes();
                }
            }
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor.getClentConnectionInfo", "683", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting serialized connection data bytes." + e.getMessage(), new java.lang.Object[]{e});
            }
            throw new INTERNAL("Could not flatten client connection data to bytes");
        }
        return data_bytes;
    }

    public java.lang.Object getClientConnectionInfo(byte[] data_bytes) {
        ConnectionInformationImpl info = null;
        java.lang.Object key = null;
        boolean remotePort = false;
        java.lang.Object remoteHost = null;
        ExtendedSSLConnectionData cd = null;
        try {
            cd = data_bytes != null ? new ExtendedSSLConnectionData(data_bytes) : new ExtendedSSLConnectionData(null, 0L, 0, 0, null);
            info = new ConnectionInformationImpl(cd, null, 0L, null, 0);
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor.getClientConnectionInfo(bytes)", "736", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception de-serializing connection data bytes." + e.getMessage(), new java.lang.Object[]{e});
            }
            throw new INTERNAL("Could not initialize client connection data");
        }
        return info;
    }

    protected IIOPEndpointProfile getLocalCommEndpointProfile(IOR ior, ConnectionDataCarrier cdc) {
        IIOPEndpointProfile localCommEpp = null;
        ConnectionData cd = cdc.getConnectionData();
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        Profile p = ior.getProfile();
        byte[] lsipTagData = p.getTaggedComponent(1229081869);
        if (lsipTagData != null && lsipTagData.length > 0) {
            String activeUserRegistry;
            CSIv2EffectivePerformPolicy policy = null;
            boolean policyPermits = true;
            boolean registryAllows = true;
            boolean securityEnabled = true;
            securityEnabled = csiv2.getBoolean("com.ibm.CORBA.securityEnabled");
            if (cd != null && cd instanceof ExtendedSSLConnectionData) {
                policy = ((ExtendedSSLConnectionData)cd).getEffectivePolicy();
                policyPermits = policy == null || !policy.performTLClientAuth();
            }
            boolean bl = registryAllows = (activeUserRegistry = cdc.getActiveUserRegistry()) != null && activeUserRegistry.equals("LOCALOS");
            if (!securityEnabled || policyPermits || registryAllows) {
                ExtendedSSLConnectionData localCommCD = new ExtendedSSLConnectionData(null, 4L, 0, 0, policy);
                localCommCD.setAltConnectionData(lsipTagData);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Localcomm tag found, LSIP data is: " + lsipTagData);
                }
                localCommEpp = new IIOPEndpointProfile(ior, "localcomm-ziop-out", localCommCD);
            }
        }
        return localCommEpp;
    }

    protected IIOPEndpointProfile[] getUnsecureIIOPProfiles(IOR ior, String class_name, String method_name) {
        IIOPEndpointProfile[] epProfiles = this.defaultConnInt.getIIOPEndpointProfiles(ior, class_name, method_name);
        if (epProfiles != null && epProfiles.length > 0) {
            ConnectionData cd = epProfiles[0].getConnectionData();
            ConnectionDataCarrier connDataCarrier = new ConnectionDataCarrier();
            connDataCarrier.setConnectionData(cd);
            IIOPEndpointProfile localCommEpp = this.getLocalCommEndpointProfile(ior, connDataCarrier);
            if (localCommEpp != null) {
                IIOPEndpointProfile[] tmpProfiles = new IIOPEndpointProfile[epProfiles.length + 1];
                if (prefer_iiop_to_local) {
                    System.arraycopy(epProfiles, 0, tmpProfiles, 0, epProfiles.length);
                    tmpProfiles[epProfiles.length] = localCommEpp;
                } else {
                    tmpProfiles[0] = localCommEpp;
                    System.arraycopy(epProfiles, 0, tmpProfiles, 1, epProfiles.length);
                }
                epProfiles = tmpProfiles;
            }
        }
        return epProfiles;
    }

    public IIOPEndpointProfile[] getIIOPEndpointProfiles(IOR ior, String class_name, String method_name) {
        String connKey;
        ConnectionDataCarrier connDataCarrier;
        if (ior == null) {
            return null;
        }
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (!csiv2.getBoolean("com.ibm.CORBA.securityEnabled")) {
            return this.getUnsecureIIOPProfiles(ior, class_name, method_name);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIIOPEndpointProfiles", new java.lang.Object[]{ior, class_name, method_name});
        }
        boolean valid = false;
        IIOPEndpointProfile[] epProfiles = null;
        Profile p = ior.getProfile();
        valid = this.getConnectionKey(p, 0, ior, class_name, method_name, connDataCarrier = new ConnectionDataCarrier());
        if (!valid) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security could not obtain a valid ConnectionKey.");
            }
            throw new NO_PERMISSION("Security could not obtain a valid ConnectionKey.");
        }
        ConnectionData cd = connDataCarrier.getConnectionData();
        String chainName = super.getChainName(this.orb, 2L);
        if (cd != null && (connKey = cd.getConnectionKey()) != null && connKey.indexOf("IIOPSSL") != -1) {
            chainName = super.getChainName(this.orb, 1L);
        }
        IIOPEndpointProfile iiopepp = new IIOPEndpointProfile(ior, chainName, cd);
        IIOPEndpointProfile localCommEpp = this.getLocalCommEndpointProfile(ior, connDataCarrier);
        epProfiles = localCommEpp != null ? (prefer_iiop_to_local ? new IIOPEndpointProfile[]{iiopepp, localCommEpp} : new IIOPEndpointProfile[]{localCommEpp, iiopepp}) : new IIOPEndpointProfile[]{iiopepp};
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "IIOP endpoint profile(s): " + (epProfiles == null ? "null" : epProfiles.toString()));
            Tr.exit(tc, "getIIOPEndpointProfiles");
        }
        return epProfiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getConnectionKey(Profile p, int ProfileID, IOR ior, String class_name, String method_name, ConnectionDataCarrier cd) {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (!csiv2.getBoolean("com.ibm.CORBA.securityEnabled")) {
            return this.defaultConnInt.getConnectionKey(p, ProfileID, ior, class_name, method_name, cd);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionKey", new java.lang.Object[]{p, new Integer(ProfileID), ior, class_name, method_name, cd, this});
        }
        String activeUserRegistry = null;
        String targetSecName = null;
        String targetRealm = null;
        String mechanism = null;
        java.lang.Object connectionKey = null;
        boolean dcetagID = false;
        int sslPort = 0;
        short sslTargetSupports = 0;
        short sslTargetRequires = 0;
        short secTargetRequires = 0;
        boolean indirectRef = true;
        boolean sslTagFound = false;
        boolean sslCmpdTagFound = false;
        boolean continueWithConnection = false;
        boolean CSIv2TransportFound = false;
        boolean CSIv2TagFound = false;
        String hostname = null;
        CSIv2TaggedComponent[] csiv2TaggedComponent = null;
        CSIv2EffectivePerformPolicy csiv2effectivePolicy = null;
        boolean appSecTagFound = false;
        APPSECTaggedComponent appSecTaggedComponent = null;
        short appsecEnabledState = 0;
        short isAdmin = -1;
        short isNamingReadUnprotected = 0;
        if (class_name == null) {
            class_name = this.getClassName(ior);
        }
        if (tc.isDebugEnabled()) {
            if (class_name != null) {
                Tr.debug(tc, "getConnectionKey invoked for operation " + class_name + "." + method_name + " on ORB " + this.orb);
            } else {
                Tr.debug(tc, "getConnectionKey invoked with class_name NULL on ORB " + this.orb);
            }
        }
        boolean doCSI = false;
        try {
            block42: {
                block43: {
                    csiv2TaggedComponent = CSIv2TaggedComponent.getCSIv2TaggedComponentList(p, ior);
                    CSIv2TagFound = csiv2TaggedComponent != null;
                    SSLCompoundTaggedComponent sslCmpdTaggedComponent = null;
                    SSLTaggedComponent sslTaggedComponent = null;
                    sslCmpdTaggedComponent = SSLCompoundTaggedComponent.getSSLCompoundTaggedComponent(p, ior);
                    if (sslCmpdTaggedComponent == null) {
                        sslTaggedComponent = SSLTaggedComponent.getSSLTaggedComponent(p, ior);
                        if (sslTaggedComponent != null) {
                            sslTargetSupports = sslTaggedComponent.get_targetCoalescedSuppQOP();
                            sslTargetRequires = sslTaggedComponent.get_targetCoalescedReqQOP();
                            sslPort = sslTaggedComponent.get_SSLPort();
                            sslTagFound = true;
                        }
                    } else {
                        sslCmpdTagFound = true;
                        sslTargetSupports = sslCmpdTaggedComponent.get_targetCoalescedSuppQOP();
                        sslTargetRequires = sslCmpdTaggedComponent.get_targetCoalescedReqQOP();
                        sslPort = sslCmpdTaggedComponent.get_SSLPort();
                        secTargetRequires = sslCmpdTaggedComponent.get_targetCoalescedReqQOP();
                        mechanism = sslCmpdTaggedComponent.getMechanismType().trim();
                        targetSecName = sslCmpdTaggedComponent.get_targetCompleteName();
                        targetRealm = RealmSecurityName.getRealm(sslCmpdTaggedComponent.get_targetCompleteName());
                    }
                    if ((appSecTaggedComponent = APPSECTaggedComponent.getAPPSECTaggedComponent(p, ior)) != null) {
                        appSecTagFound = true;
                        appsecEnabledState = appSecTaggedComponent.get_enabledState();
                        activeUserRegistry = appSecTaggedComponent.get_activeUserRegistry();
                        isAdmin = appSecTaggedComponent.get_isAdminFlag();
                        isNamingReadUnprotected = appSecTaggedComponent.get_isNamingReadUnprotectedFlag();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Active user registry is: " + activeUserRegistry == null ? "null" : activeUserRegistry + ", :isAdmin is: " + isAdmin + ", isNamingReadUnprotected is: " + isNamingReadUnprotected);
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SSL tag found is " + sslTagFound + ", SSL compound tag found is " + sslCmpdTagFound + ", CSIv2 tag found is " + CSIv2TagFound + ", Mechanism is " + mechanism + ", APPSec tag found is " + appSecTagFound + ";");
                    }
                    if (CSIv2TagFound || sslCmpdTagFound || sslTagFound) {
                        if (!CSIv2TagFound && (sslCmpdTagFound || sslTagFound)) {
                            Tr.debug(tc, "Found old SSL tagged component.");
                            doCSI = false;
                        } else {
                            Tr.debug(tc, "Found CSIv2 tagged component.");
                            doCSI = true;
                        }
                    }
                    if (!doCSI) break block42;
                    if (PlatformHelperFactory.getPlatformHelper().isControlJvm()) {
                        boolean pushedSecurity = false;
                        try {
                            SecurityConfigResource res = null;
                            if (!MultiDomainHelper.isClassNameAdmin(class_name)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "getConnectionKey pushing app name " + class_name);
                                }
                                res = new SecurityConfigResource(class_name, "application");
                                pushedSecurity = SecurityObjectLocator.pushDomainContext(res);
                            }
                            csiv2effectivePolicy = CSIv2EffectivePerformPolicy.getInstance(csiv2TaggedComponent, method_name, this.orb, ior, isAdmin, isNamingReadUnprotected);
                        }
                        finally {
                            if (pushedSecurity) {
                                SecurityObjectLocator.popDomainContext();
                            }
                        }
                    } else {
                        csiv2effectivePolicy = CSIv2EffectivePerformPolicy.getInstance(csiv2TaggedComponent, method_name, this.orb, ior, isAdmin, isNamingReadUnprotected);
                    }
                    if (csiv2effectivePolicy == null) break block43;
                    this.vault.getCurrent().setEffectivePolicy(csiv2effectivePolicy);
                    targetRealm = targetSecName = csiv2effectivePolicy.getTargetSecurityName();
                    CSIv2TaggedComponentHolder tagHolder = csiv2effectivePolicy.getCSIv2TaggedComponent();
                    if (!csiv2effectivePolicy.performSSLTLS() || tagHolder == null) break block42;
                    int Trans_TagID = tagHolder.value.get_Transport_tagID();
                    if (Trans_TagID == 36) {
                        TLS_SEC_TRANSHolder tls_sec_trans = tagHolder.value.getTLS_SEC_TRANS();
                        sslTargetSupports = tls_sec_trans.value.target_supports;
                        sslTargetRequires = tls_sec_trans.value.target_requires;
                        hostname = tagHolder.value.get_Transport_Address().value.host_name;
                        sslPort = tagHolder.value.get_Transport_Address().value.port;
                        CSIv2TransportFound = true;
                        if ((sslTargetRequires & 0x20) == 0 && (sslTargetSupports & 0x20) != 0) {
                            sslTargetRequires = (short)(sslTargetRequires | 0x20);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "CSIv2TransportFound is " + CSIv2TransportFound + ", sslTargetSupports is " + sslTargetSupports + ", sslTargetRequires is " + sslTargetRequires + ", sslport  is          " + sslPort + ", hostname is          " + hostname + ";");
                        }
                        break block42;
                    } else {
                        Tr.debug(tc, "Unrecognized transport tag ID: " + Trans_TagID + ". Connection refused.");
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getConnectionKey", Boolean.FALSE);
                        }
                        return false;
                    }
                }
                Tr.debug(tc, "Cannot form CSIv2EffectivePerformPolicy. Connection refused.");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getConnectionKey", Boolean.FALSE);
                }
                return false;
            }
            if (targetRealm != null && !targetRealm.equals("")) {
                this.vault.getCurrent().setTargetSecurityRealm(targetRealm);
            }
            continueWithConnection = method_name == null || method_name.length() == 0 ? this.getConnectionKeyForLocateRequest(p, cd, class_name, sslTagFound, sslCmpdTagFound, sslPort, sslTargetSupports, sslTargetRequires, method_name, CSIv2TransportFound, csiv2effectivePolicy) : (p.getPort() != 0 && ORB.isSpecialMethod((String)method_name) && csiv2effectivePolicy != null && !csiv2effectivePolicy.claimClientAuthenticationRequired() || p.getPort() != 0 && SecurityConnectionInterceptor.isSpecialNamingMethod(method_name, class_name) || SecurityConnectionInterceptor.isSpecialSSLRequiredNamingMethod(method_name, class_name) ? this.getConnectionKeyForSpecialRequest(p, cd, class_name, sslTagFound, sslCmpdTagFound, sslPort, sslTargetSupports, sslTargetRequires, method_name, CSIv2TransportFound, csiv2effectivePolicy) : this.getConnectionKeyForMethodRequest(p, cd, class_name, sslTagFound, sslCmpdTagFound, sslPort, sslTargetSupports, sslTargetRequires, secTargetRequires, method_name, targetSecName, mechanism, CSIv2TransportFound, csiv2effectivePolicy));
        }
        catch (CSIv2RequirementsNotSatisfied e) {
            Manager.Ffdc.log((Throwable)((java.lang.Object)e), this, "com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor.getConnectionKey", "1288", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CSIv2RequirementsNotSatisfied Exception caught in getConnectionKey.", (java.lang.Object)e);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConnectionKey", "INITIALIZE");
            }
            throw new INITIALIZE(e.debugMessage, 1229066442, CompletionStatus.COMPLETED_NO);
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor.getConnectionKey", "1298", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Java runtime exception in getConnectionKey.", new java.lang.Object[]{e});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConnectionKey");
            }
            if (e.getMessage() != null && !e.getMessage().equals("")) {
                throw new INTERNAL("Java runtime exception in getConnectionKey.", 1229066417, CompletionStatus.COMPLETED_NO);
            }
            throw new INTERNAL(e.getMessage(), 1229066417, CompletionStatus.COMPLETED_NO);
        }
        if (continueWithConnection) {
            cd.setActiveUserRegistry(activeUserRegistry);
            ConnectionData ecd = cd.getConnectionData();
            if (ecd != null && csiv2effectivePolicy != null) {
                csiv2effectivePolicy.setConnectionKey(ecd.getConnectionKey());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConnectionKey", Boolean.TRUE);
            }
            return true;
        }
        Tr.debug(tc, "Cannot form valid connection key. Connection refused.");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnectionKey", Boolean.FALSE);
        }
        return false;
    }

    public boolean getConnectionKeyForLocateRequest(Profile p, ConnectionDataCarrier cd, String class_name, boolean sslTagFound, boolean sslCmpdTagFound, int sslPort, short sslTargetSupports, short sslTargetRequires, String method_name, boolean CSIv2TransportFound, CSIv2EffectivePerformPolicy csiv2effectivePolicy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionKeyForLocateRequest", new java.lang.Object[]{p, cd, class_name, new Boolean(sslTagFound), new Boolean(sslCmpdTagFound), new Integer(sslPort), new Short(sslTargetSupports), new Short(sslTargetRequires), method_name, new Boolean(CSIv2TransportFound), this});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Effecive Policy: ", csiv2effectivePolicy);
        }
        String targetHostName = null;
        String mechanism = null;
        String key = null;
        int port = 0;
        int connType = 0;
        short coalescedQOP = 0;
        if (tc.isDebugEnabled()) {
            if (class_name != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Forming connection key for locate request on " + class_name);
                }
            } else {
                Tr.debug(tc, "Forming connection key for locate request. No class_name available.");
            }
        }
        if ((sslTagFound || sslCmpdTagFound || CSIv2TransportFound) && (csiv2effectivePolicy == null || csiv2effectivePolicy.performSSLTLS())) {
            targetHostName = SecurityConnectionInterceptor.getHostfromProfile(p);
            port = sslPort & 0xFFFF;
            connType = 1;
            coalescedQOP = CSIv2TransportFound && csiv2effectivePolicy != null ? this.formCSIv2CoalescedQOP(sslTargetSupports, sslTargetRequires, csiv2effectivePolicy) : this.formCoalescedQOP(sslTargetSupports, sslTargetRequires);
            mechanism = VaultConstants.SSL_MECH_TYPE;
            key = this.formConnectionKey(targetHostName, port, mechanism, coalescedQOP);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting SSL ExtendedSSLConnectionData object.");
            }
            cd.setConnectionData(new ExtendedSSLConnectionData(key, connType, coalescedQOP, 0, csiv2effectivePolicy));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSL key set, mechanism is " + mechanism);
            }
        } else {
            key = this.createSimpleKey(SecurityConnectionInterceptor.getHostfromProfile(p), p.getPort(), class_name);
            connType = 2;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting TCPIP ConnectionDataImpl object.");
            }
            cd.setConnectionData(new ExtendedSSLConnectionData(key, connType, 0, 0, csiv2effectivePolicy));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TCP Connection, connection type is " + connType);
            }
        }
        if (tc.isDebugEnabled()) {
            if (class_name != null) {
                Tr.debug(tc, "Returning connection key - " + key + " for locate request on " + class_name);
            } else {
                Tr.debug(tc, "Returning connection key - " + key + " for locate request.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnectionKeyForLocateRequest", Boolean.TRUE);
        }
        return true;
    }

    public boolean getConnectionKeyForMethodRequest(Profile p, ConnectionDataCarrier cd, String class_name, boolean sslTagFound, boolean sslCmpdTagFound, int sslPort, short sslTargetSupports, short sslTargetRequires, short secTargetRequires, String method_name, String targetSecName, String mechanism, boolean CSIv2TransportFound, CSIv2EffectivePerformPolicy csiv2effectivePolicy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionKeyForMethodRequest", new java.lang.Object[]{p, cd, class_name, new Boolean(sslTagFound), new Boolean(sslCmpdTagFound), new Integer(sslPort), new Short(sslTargetSupports), new Short(sslTargetRequires), new Short(secTargetRequires), method_name, targetSecName, mechanism, new Boolean(CSIv2TransportFound), this});
        }
        String connectionKey = null;
        java.lang.Object clientSecName = null;
        String targetHostName = null;
        boolean port = false;
        boolean connType = false;
        boolean coalescedQOP = false;
        if (tc.isDebugEnabled()) {
            if (class_name != null) {
                Tr.debug(tc, "Forming connection key for method - " + method_name + " on " + class_name);
            } else {
                Tr.debug(tc, "Forming connection key for method - " + method_name + ". No class_name available.");
            }
        }
        targetHostName = SecurityConnectionInterceptor.getHostfromProfile(p) + ":" + p.getPort();
        connectionKey = this.establishConnectionInfo(p, cd, sslTagFound, sslCmpdTagFound, sslPort, sslTargetSupports, sslTargetRequires, secTargetRequires, targetHostName, CSIv2TransportFound, csiv2effectivePolicy, class_name);
        if (tc.isDebugEnabled()) {
            if (class_name != null) {
                Tr.debug(tc, "Returning connection key - " + connectionKey + " for " + method_name + " request on " + class_name);
            } else {
                Tr.debug(tc, "Returning connection key - " + connectionKey + " for " + method_name + " request.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnectionKeyForMethodRequest");
        }
        return connectionKey != null;
    }

    public boolean getConnectionKeyForSpecialRequest(Profile p, ConnectionDataCarrier cd, String class_name, boolean sslTagFound, boolean sslCmpdTagFound, int sslPort, short sslTargetSupports, short sslTargetRequires, String method_name, boolean CSIv2TransportFound, CSIv2EffectivePerformPolicy csiv2effectivePolicy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionKeyForSpecialRequest", new java.lang.Object[]{p, cd, class_name, new Boolean(sslTagFound), new Boolean(sslCmpdTagFound), new Integer(sslPort), new Short(sslTargetSupports), new Short(sslTargetRequires), method_name, new Boolean(CSIv2TransportFound), this});
        }
        String targetHostName = null;
        String mechanism = null;
        String key = null;
        int port = 0;
        int connType = 0;
        short coalescedQOP = 0;
        if (tc.isDebugEnabled()) {
            if (class_name != null) {
                Tr.debug(tc, "Forming connection key for " + method_name + " request on " + class_name);
            } else {
                Tr.debug(tc, "Forming connection key for " + method_name + " request. No class_name available.");
            }
        }
        if (p.getPort() == 0 && SecurityConnectionInterceptor.isSpecialNamingMethod(method_name, class_name) || SecurityConnectionInterceptor.isSpecialSSLRequiredNamingMethod(method_name, class_name) && (csiv2effectivePolicy == null || csiv2effectivePolicy.performSSLTLS())) {
            targetHostName = SecurityConnectionInterceptor.getHostfromProfile(p);
            port = sslPort & 0xFFFF;
            connType = 1;
            coalescedQOP = CSIv2TransportFound && csiv2effectivePolicy != null ? this.formCSIv2CoalescedQOP(sslTargetSupports, sslTargetRequires, csiv2effectivePolicy) : this.formCoalescedQOP(sslTargetSupports, sslTargetRequires);
            mechanism = VaultConstants.SSL_MECH_TYPE;
            key = this.formConnectionKey(targetHostName, port, mechanism, coalescedQOP);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting SSL ExtendedSSLConnectionData object for special naming method for CSIv2.");
            }
            cd.setConnectionData(new ExtendedSSLConnectionData(key, connType, coalescedQOP, 0, csiv2effectivePolicy));
        }
        if (key == null) {
            if (!(!sslTagFound && !sslCmpdTagFound && !CSIv2TransportFound || SecurityConnectionInterceptor.isSpecialNamingMethod(method_name, class_name) && p.getPort() != 0 || csiv2effectivePolicy != null && !csiv2effectivePolicy.performSSLTLS())) {
                targetHostName = SecurityConnectionInterceptor.getHostfromProfile(p);
                port = sslPort & 0xFFFF;
                connType = 1;
                coalescedQOP = CSIv2TransportFound && csiv2effectivePolicy != null ? this.formCSIv2CoalescedQOP(sslTargetSupports, sslTargetRequires, csiv2effectivePolicy) : this.formCoalescedQOP(sslTargetSupports, sslTargetRequires);
                mechanism = VaultConstants.SSL_MECH_TYPE;
                key = this.formConnectionKey(targetHostName, port, mechanism, coalescedQOP);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting SSL ExtendedSSLConnectionData object.");
                }
                cd.setConnectionData(new ExtendedSSLConnectionData(key, connType, coalescedQOP, 0, csiv2effectivePolicy));
            } else {
                key = this.createSimpleKey(SecurityConnectionInterceptor.getHostfromProfile(p), p.getPort(), class_name);
                connType = 2;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting TCPIP ConnectionDataImpl object.");
                }
                cd.setConnectionData(new ExtendedSSLConnectionData(key, connType, 0, 0, csiv2effectivePolicy));
            }
        }
        if (tc.isDebugEnabled()) {
            if (class_name != null) {
                Tr.debug(tc, "Returning connection key - " + key + " for " + method_name + " on " + class_name);
            } else {
                Tr.debug(tc, "Returning connection key - " + key + " for " + method_name);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnectionKeyForSpecialRequest", Boolean.TRUE);
        }
        return true;
    }

    public SSLServerConnectionData getCSIRegisteredSSLServerConnectionDataObject() {
        return this.csiServerSSLConnData;
    }

    public SSLServerConnectionData getCSIClientCertRegisteredSSLServerConnectionDataObject() {
        return this.csiClientCertServerSSLConnData;
    }

    public ServerConnectionData getRegisteredTCPServerConnectionDataObject() {
        return this.serverTCPConnData;
    }

    public ServerConnectionData[] getServerConnectionData(ORB orb) {
        CSIv2Config csiv2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerConnectionData", new java.lang.Object[]{orb, this});
        }
        if ((csiv2 = SecurityObjectLocator.getCSIv2Config()).getBoolean("com.ibm.CORBA.securityEnabled")) {
            String hostName = null;
            List secureTransportList = null;
            List insecureTransportList = null;
            try {
                hostName = orb.getLocalHost();
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor.getServerConnectionData", "1645", this);
                hostName = null;
                Tr.error(tc, "security.JSAS0445E", new java.lang.Object[]{e});
            }
            if (hostName == null || hostName.length() == 0) {
                hostName = "localHost";
            }
            String transportMode = orb.getProperty("com.ibm.CORBA.TransportMode");
            boolean pluggableMode = true;
            if (transportMode != null && !transportMode.equalsIgnoreCase("Pluggable")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "*** IN CHANNEL FRAMEWORK MODE ACTING AS PLUGGABLE ***");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "In pluggable transport mode.");
            }
            if (pluggableMode) {
                int ConnectionDataCount = 0;
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Getting TCPIP ConnectionObject.");
                    }
                    this.getTcpConnectionObject(hostName);
                    if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Getting CSIv2 SSL (w/ and w/o ClientCert) ConnectionObjects for z/OS.");
                        }
                        this.getCSISSLConnectionObject(hostName);
                        if (csiv2.getBoolean("com.ibm.CSI.claimTransportAssocSSLTLSRequired")) {
                            ((ServerConnectionDataImpl)this.serverTCPConnData).setAddToServerProfile(false);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "The TCP/IP port in the IOR profile will be 0.  The value of AddToServerProfile is " + this.serverTCPConnData.getAddToServerProfile());
                            }
                        }
                    } else if (csiv2.getBoolean("com.ibm.CSI.claimTransportAssocSSLTLSRequired")) {
                        if (csiv2.getBoolean("com.ibm.CSI.claimTLClientAuthenticationRequired")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Getting CSIv2 SSL (w/ClientCert) ConnectionObject.");
                            }
                            this.getCSIClientCertSSLConnectionObject(hostName);
                        } else if (csiv2.getBoolean("com.ibm.CSI.claimTLClientAuthenticationSupported")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Getting CSIv2 SSL (w/ and w/o ClientCert) ConnectionObjects.");
                            }
                            this.getCSISSLConnectionObject(hostName);
                            this.getCSIClientCertSSLConnectionObject(hostName);
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Getting CSIv2 SSL (w/o ClientCert) ConnectionObjects.");
                            }
                            this.getCSISSLConnectionObject(hostName);
                        }
                        ((ServerConnectionDataImpl)this.serverTCPConnData).setAddToServerProfile(false);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The TCP/IP port in the IOR profile will be 0.  The value of AddToServerProfile is " + this.serverTCPConnData.getAddToServerProfile());
                        }
                    } else if (csiv2.getBoolean("com.ibm.CSI.claimTransportAssocSSLTLSSupported")) {
                        if (csiv2.getBoolean("com.ibm.CSI.claimTLClientAuthenticationRequired")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Getting CSIv2 SSL (w/ClientCert) ConnectionObject.");
                            }
                            this.getCSIClientCertSSLConnectionObject(hostName);
                        } else if (csiv2.getBoolean("com.ibm.CSI.claimTLClientAuthenticationSupported")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Getting CSIv2 SSL (w/ and w/o ClientCert) ConnectionObjects.");
                            }
                            this.getCSISSLConnectionObject(hostName);
                            this.getCSIClientCertSSLConnectionObject(hostName);
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Getting CSIv2 SSL (w/o ClientCert) ConnectionObjects.");
                            }
                            this.getCSISSLConnectionObject(hostName);
                        }
                    }
                    if (this.serverTCPConnData != null) {
                        ++ConnectionDataCount;
                    }
                    if (this.csiServerSSLConnData != null) {
                        ++ConnectionDataCount;
                    }
                    if (this.csiClientCertServerSSLConnData != null) {
                        ++ConnectionDataCount;
                    }
                    ServerConnectionData[] serverConnDataArray = new ServerConnectionData[ConnectionDataCount];
                    int ConnectionDataCountOrig = ConnectionDataCount;
                    if (this.serverTCPConnData != null) {
                        serverConnDataArray[ConnectionDataCountOrig - ConnectionDataCount--] = this.serverTCPConnData;
                    }
                    if (this.csiServerSSLConnData != null) {
                        serverConnDataArray[ConnectionDataCountOrig - ConnectionDataCount--] = this.csiServerSSLConnData;
                    }
                    if (this.csiClientCertServerSSLConnData != null) {
                        serverConnDataArray[ConnectionDataCountOrig - ConnectionDataCount--] = this.csiClientCertServerSSLConnData;
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getServerConnectionData", serverConnDataArray);
                    }
                    return serverConnDataArray;
                }
                catch (Exception e) {
                    Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor.getServerConnectionData", "1814", this);
                    Tr.debug(tc, "Exception getting SSL server connection data array from pluggable transport configuration.  Exception is: " + e.getMessage(), new java.lang.Object[]{e});
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getServerConnectionData", null);
                    }
                    return null;
                }
            }
            try {
                int port;
                String portString;
                Properties tranProps;
                int i;
                ArrayList<ServerConnectionDataImpl> connDataList = new ArrayList<ServerConnectionDataImpl>();
                if (insecureTransportList != null && insecureTransportList.size() > 0) {
                    for (i = 0; i < insecureTransportList.size(); ++i) {
                        tranProps = (Properties)insecureTransportList.get(i);
                        portString = tranProps.getProperty("com.ibm.CORBA.ListenerPort");
                        port = 0;
                        if (portString != null) {
                            port = new Short(portString).intValue();
                        }
                        if (port == orb.getBootstrapPort()) continue;
                        if (tc.isDebugEnabled()) {
                            String chainName = tranProps.getProperty("ChainName");
                            String endPointName = tranProps.getProperty("EndPointName");
                            Tr.debug(tc, "Creating TCP server connection data for chain name: " + chainName + ", and endPointName: " + endPointName);
                        }
                        ServerConnectionDataImpl tcpCD = new ServerConnectionDataImpl();
                        tcpCD.setServerPort(port);
                        tcpCD.setConnectionKey(this.formConnectionKey(hostName, port, " ", (short)0));
                        tcpCD.setConnectionType(2L);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Requesting to create a TCPIP server connection with:");
                            Tr.debug(tc, "  Connection key: " + tcpCD.getConnectionKey() + ", Connection type: " + tcpCD.getConnectionType() + ", Server port: " + tcpCD.getServerPort());
                        }
                        connDataList.add(tcpCD);
                    }
                }
                if (secureTransportList != null && secureTransportList.size() > 0) {
                    for (i = 0; i < secureTransportList.size(); ++i) {
                        tranProps = (Properties)secureTransportList.get(i);
                        portString = tranProps.getProperty("com.ibm.CSI.SSLPort");
                        port = 0;
                        if (portString != null) {
                            port = new Short(portString).shortValue();
                        }
                        if (tc.isDebugEnabled()) {
                            String chainName = tranProps.getProperty("ChainName");
                            String endPointName = tranProps.getProperty("EndPointName");
                            Tr.debug(tc, "Creating SSL server connection data for chain name: " + chainName + ", and endPointName: " + endPointName);
                        }
                        short trans_target_requires = 0;
                        short trans_target_supports = 0;
                        String securityLevel = tranProps.getProperty("com.ibm.ssl.securityLevel");
                        if (securityLevel != null && securityLevel.equalsIgnoreCase("high")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Claim security level is HIGH for this transport tag.");
                            }
                            trans_target_requires = (short)(trans_target_requires | 2);
                            trans_target_supports = (short)(trans_target_supports | 2);
                            trans_target_requires = (short)(trans_target_requires | 4);
                            trans_target_supports = (short)(trans_target_supports | 4);
                            trans_target_supports = (short)(trans_target_supports | 0x20);
                        } else if (securityLevel != null && securityLevel.equalsIgnoreCase("medium")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Claim security level is MEDIUM for this transport tag.");
                            }
                            trans_target_requires = (short)(trans_target_requires | 2);
                            trans_target_supports = (short)(trans_target_supports | 2);
                            trans_target_supports = (short)(trans_target_supports | 4);
                            trans_target_supports = (short)(trans_target_supports | 0x20);
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Claim security level is LOW for this transport tag.");
                            }
                            trans_target_supports = (short)(trans_target_supports | 2);
                            trans_target_supports = (short)(trans_target_supports | 4);
                            trans_target_supports = (short)(trans_target_supports | 0x20);
                        }
                        String clientAuthRequired = tranProps.getProperty("com.ibm.ssl.clientAuthentication");
                        String clientAuthSupported = tranProps.getProperty("com.ibm.ssl.clientAuthenticationSupported");
                        if (clientAuthRequired != null && clientAuthRequired.equals("true")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Claim client authentication is required for this transport tag.");
                            }
                            trans_target_requires = (short)(trans_target_requires | 0x40);
                            trans_target_supports = (short)(trans_target_supports | 0x40);
                        } else if (clientAuthSupported != null && clientAuthSupported.equals("true")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Claim client authentication is supported for this transport tag.");
                            }
                            trans_target_supports = (short)(trans_target_supports | 0x40);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Claim client authentication is disabled for this transport tag.");
                        }
                        SSLServerConnectionDataImpl sslCD = new SSLServerConnectionDataImpl();
                        sslCD.setConnectionKey(this.formConnectionKey(hostName, port, VaultConstants.SSL_MECH_TYPE, trans_target_supports));
                        sslCD.setConnectionType(1L);
                        sslCD.setServerPort(port);
                        sslCD.setTargetRequiresQOP(trans_target_requires);
                        sslCD.setTargetSupportsQOP(trans_target_supports);
                        String alias = tranProps.getProperty("com.ibm.ssl.alias");
                        sslCD.setSSLConfigAlias(alias);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Requesting to create an SSL server connection with:");
                            Tr.debug(tc, "  Alias: " + alias);
                        }
                        connDataList.add(sslCD);
                    }
                }
                ServerConnectionData[] serverConnDataArray = connDataList.toArray(new ServerConnectionData[connDataList.size()]);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerConnectionData");
                }
                return serverConnDataArray;
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor.getServerConnectionData", "1986", this);
                Tr.debug(tc, "Exception getting SSL server connection data array from channel framework configuration.  Exception is: " + e.getMessage(), new java.lang.Object[]{e});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerConnectionData", null);
                }
                return null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerConnectionData");
        }
        return this.defaultConnInt.getServerConnectionData(orb);
    }

    public void notifyBrokenConnection(ConnectionInformation connectInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notifyBrokenConnection", new java.lang.Object[]{connectInfo, this});
        }
        ConnectionData connectData = (ConnectionData)connectInfo.getConnectionData();
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (this.vault != null && csiv2.getBoolean("com.ibm.CORBA.NotifyBrokenConnectionEnabled")) {
            if (connectData != null && connectData instanceof ExtendedSSLConnectionData) {
                String key = connectData.getConnectionKey();
                if (tc.isDebugEnabled() && key != null) {
                    Tr.debug(tc, "A client connection is broken:  " + key);
                }
                this.vault.deleteSessionsForConnection(key);
            } else {
                String remoteHost = connectInfo.getRemoteHost();
                int remotePort = connectInfo.getRemotePort();
                long connectCreateTime = connectInfo.getConnectionCreationTime();
                ServerConnectionKey connKey = new ServerConnectionKey(connectCreateTime, remoteHost, remotePort);
                if (tc.isDebugEnabled() && connKey != null) {
                    Tr.debug(tc, "A server connection is broken: " + connKey.get_server_connection_hash());
                }
                this.vault.deleteSessionsForConnection(connKey);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "notifyBrokenConnection");
        }
    }

    public static boolean isSpecial(String method2, String class_name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSpecial", new java.lang.Object[]{method2, class_name});
        }
        if (class_name != null) {
            Tr.debug(tc, "method  = " + method2 + ", class name = " + class_name);
            if (method2.equals("get_compatibility_level")) {
                Tr.debug(tc, "method matches");
            } else {
                Tr.debug(tc, "method no matches");
            }
            if (class_name.equals("com.ibm.WsnOptimizedNaming._NamingContextStub")) {
                Tr.debug(tc, "interface matches");
            } else {
                Tr.debug(tc, "interface no matches");
            }
            return method2.equals("get_compatibility_level") && class_name.equals("com.ibm.WsnOptimizedNaming._NamingContextStub");
        }
        return false;
    }

    public static boolean isSpecialClass(String method2, String class_name) {
        if (class_name != null) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isSpecialClass", new java.lang.Object[]{method2, class_name});
            }
            if (method2.equals("get_compatibility_level") && class_name.equals("com.ibm.WsnBootstrap._WsnNameServiceStub")) {
                return true;
            }
            if (method2.equals("get_compatibility_level") && class_name.equals("com.ibm.ws.naming.bootstrap.WsnNameServiceImpl")) {
                return true;
            }
            if (method2.equals("get_context_id_string") && class_name.equals("com.ibm.WsnBootstrap._WsnNameServiceStub")) {
                return true;
            }
            if (method2.equals("get_context_id_string") && class_name.equals("com.ibm.ws.naming.bootstrap.WsnNameServiceImpl")) {
                return true;
            }
            if (method2.equals("get_full_primary_name") && class_name.equals("com.ibm.WsnBootstrap._WsnNameServiceStub")) {
                return true;
            }
            if (method2.equals("get_full_primary_name") && class_name.equals("com.ibm.ws.naming.bootstrap.WsnNameServiceImpl")) {
                return true;
            }
            if (method2.equals("list") && class_name.equals("com.ibm.WsnBootstrap._WsnNameServiceStub")) {
                return true;
            }
            if (method2.equals("list") && class_name.equals("com.ibm.ws.naming.bootstrap.WsnNameServiceImpl")) {
                return true;
            }
            if (method2.equals("list_complete_info") && class_name.equals("com.ibm.WsnBootstrap._WsnNameServiceStub")) {
                return true;
            }
            if (method2.equals("list_complete_info") && class_name.equals("com.ibm.ws.naming.bootstrap.WsnNameServiceImpl")) {
                return true;
            }
            if (method2.equals("resolve") && class_name.equals("com.ibm.WsnBootstrap._WsnNameServiceStub")) {
                return true;
            }
            if (method2.equals("resolve") && class_name.equals("com.ibm.ws.naming.bootstrap.WsnNameServiceImpl")) {
                return true;
            }
            if (method2.equals("resolve_complete_info") && class_name.equals("com.ibm.WsnBootstrap._WsnNameServiceStub")) {
                return true;
            }
            if (method2.equals("resolve_complete_info") && class_name.equals("com.ibm.ws.naming.bootstrap.WsnNameServiceImpl")) {
                return true;
            }
            if (method2.equals("BindingIterator_next_one") && class_name.equals("com.ibm.WsnBootstrap._WsnNameServiceStub")) {
                return true;
            }
            if (method2.equals("BindingIterator_next_one") && class_name.equals("com.ibm.ws.naming.bootstrap.WsnNameServiceImpl")) {
                return true;
            }
            if (method2.equals("BindingIterator_next_one") && class_name.equals("com.ibm.WsnBootstrap._WsnNameServiceStub")) {
                return true;
            }
            if (method2.equals("BindingIterator_next_one") && class_name.equals("com.ibm.ws.naming.bootstrap.WsnNameServiceImpl")) {
                return true;
            }
            if (method2.equals("BindingIterator_Destroy") && class_name.equals("com.ibm.WsnBootstrap._WsnNameServiceStub")) {
                return true;
            }
            return method2.equals("BindingIterator_Destroy") && class_name.equals("com.ibm.ws.naming.bootstrap.WsnNameServiceImpl");
        }
        return false;
    }

    public static boolean isNamingMethodUnprotected(String method2, String class_name) {
        if (class_name != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isNamingMethodUnprotected, method = " + method2 + ", class_name = " + class_name);
            }
            if (method2.equals("get_compatibility_level") && class_name.equals("com.ibm.WsnOptimizedNaming._NamingContextStub")) {
                return true;
            }
            if (method2.equals("resolve_complete_info") && class_name.equals("com.ibm.WsnOptimizedNaming._NamingContextStub")) {
                return true;
            }
            if (method2.equals("list_complete_info_dist") && class_name.equals("com.ibm.WsnOptimizedNaming._NamingContextStub")) {
                return true;
            }
            if (method2.equals("list_complete_info") && class_name.equals("com.ibm.WsnOptimizedNaming._NamingContextStub")) {
                return true;
            }
            if (method2.equals("destroy") && class_name.equals("com.ibm.WsnOptimizedNaming._DistBindingDataIteratorStub")) {
                return true;
            }
            if (method2.equals("next_n") && class_name.equals("com.ibm.WsnOptimizedNaming._DistBindingDataIteratorStub")) {
                return true;
            }
            if (method2.equals("next_one") && class_name.equals("com.ibm.WsnOptimizedNaming._DistBindingDataIteratorStub")) {
                return true;
            }
            if (method2.equals("next_one") && class_name.equals("org.omg.CosNaming._BindingIteratorStub")) {
                return true;
            }
            if (method2.equals("next_n") && class_name.equals("org.omg.CosNaming._BindingIteratorStub")) {
                return true;
            }
            if (method2.equals("destroy") && class_name.equals("org.omg.CosNaming._BindingIteratorStub")) {
                return true;
            }
            if (method2.equals("resolve_str") && class_name.equals("org.omg.CosNaming._NamingContextExtStub")) {
                return true;
            }
            if (method2.equals("to_string") && class_name.equals("org.omg.CosNaming._NamingContextExtStub")) {
                return true;
            }
            if (method2.equals("to_name") && class_name.equals("org.omg.CosNaming._NamingContextExtStub")) {
                return true;
            }
            if (method2.equals("to_url") && class_name.equals("org.omg.CosNaming._NamingContextExtStub")) {
                return true;
            }
            if (method2.equals("resolve") && class_name.equals("org.omg.CosNaming._NamingContextStub")) {
                return true;
            }
            if (method2.equals("list") && class_name.equals("org.omg.CosNaming._NamingContextStub")) {
                return true;
            }
            if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
                if (method2.equals("resolve_complete_info") && class_name.equals("com.ibm.ws.naming.distcos.WsnDistributedNC")) {
                    return true;
                }
                if (method2.equals("resolve_complete_info") && class_name.equals("com.ibm.ws.naming.distcos.PersistentXmlNC")) {
                    return true;
                }
                if (method2.equals("resolve_complete_info") && class_name.equals("com.ibm.ws.naming.distcos.PersistentXmlMasterNC")) {
                    return true;
                }
                if (method2.equals("resolve_complete_info") && class_name.equals("com.ibm.ws.naming.distcos.PersistentXmlSlaveNC")) {
                    return true;
                }
                if (method2.equals("resolve_complete_info") && class_name.equals("com.ibm.ws.naming.distcos.ReadOnlyNC")) {
                    return true;
                }
                if (method2.equals("resolve_complete_info") && class_name.equals("com.ibm.ws.naming.distcos.DistBindingDataIteratorImpl")) {
                    return true;
                }
                if (method2.equals("resolve_complete_info") && class_name.equals("com.ibm.ws.naming.ipcos.BindingDataIteratorImpl")) {
                    return true;
                }
                if (method2.equals("resolve_complete_info") && class_name.equals("com.ibm.ws.naming.ipcos.BindingIteratorImpl")) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static boolean isSpecialNamingMethod(String method2, String class_name) {
        if (class_name != null) {
            Tr.debug(tc, "method = " + method2 + ", class_name = " + class_name);
            if (method2.equals("getProperties") && class_name.equals("com.ibm.WsnBootstrap._WsnNameServiceStub")) {
                return true;
            }
            if (method2.equals("getProperties") && class_name.equals("com.ibm.ws.naming.bootstrap.WsnNameServiceImpl")) {
                return true;
            }
            if (method2.equals("get") && class_name.equals("com.ibm.rmi.corba.CORBAObjectImpl")) {
                return true;
            }
            if ((method2.equals("get") || method2.equals("list")) && class_name.equals("com.ibm.ws390.orb.INITImpl")) {
                return true;
            }
            return method2.equals("meta") && class_name.equals("com.ibm.org.omg.SendingContext._CodeBaseStub");
        }
        return false;
    }

    public static boolean isSpecialSSLRequiredNamingMethod(String method2, String class_name) {
        if (class_name != null) {
            if (class_name.equals("com.ibm.ws.security.server._SecurityServer_Stub")) {
                return true;
            }
            if (class_name.equals("com.ibm.websphere.security._UserRegistry_Stub") && !method2.equals("createCredential")) {
                return true;
            }
            if (class_name.equals("com.ibm.ws.security.server._SecurityServerImpl_Tie")) {
                return true;
            }
            return class_name.equals("com.ibm.ws.security.registry._UserRegistryImpl_Tie");
        }
        return false;
    }

    public String createSimpleKey(String host, int port, String class_name) {
        String hostPort = host + ":" + port;
        if (class_name != null && (class_name.equals("com.ibm.ws.orb.transport.DummyObjectImpl") || class_name.equals("com.ibm.org.omg.CORBA._ObjectStub") || class_name.equals("<unknown>"))) {
            this.vault.getCurrent().setFirstHost(host);
            this.vault.getCurrent().setFirstPort(Integer.toString(port));
            String allhosts = this.vault.getCurrent().getAllHosts();
            int idx = allhosts.indexOf(hostPort);
            if (idx == -1) {
                this.vault.getCurrent().setAllHosts(hostPort + "|" + allhosts);
                this.vault.getCurrent().setAllPorts(Integer.toString(port) + "|" + this.vault.getCurrent().getAllPorts());
            } else {
                int hpLength = hostPort.length();
                String newAllHosts = allhosts.substring(0, idx) + allhosts.substring(idx + hpLength + 1);
                String allPorts = this.vault.getCurrent().getAllPorts();
                String sPort = Integer.toString(port);
                int pIdx = allPorts.indexOf(sPort);
                String newAllPorts = "";
                if (pIdx != -1) {
                    int pLength = sPort.length();
                    newAllPorts = allPorts.substring(0, pIdx) + allPorts.substring(pIdx + pLength + 1);
                }
                this.vault.getCurrent().setAllHosts(hostPort + "|" + newAllHosts);
                this.vault.getCurrent().setAllPorts(Integer.toString(port) + "|" + newAllPorts);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "New value of getFirstHost/Port():  " + this.vault.getCurrent().getFirstHost() + ":" + this.vault.getCurrent().getFirstPort());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "New value of getAllHosts():  " + this.vault.getCurrent().getAllHosts());
            }
        }
        return hostPort;
    }

    public VaultImpl getVault() {
        if (this.vault == null) {
            this.vault = VaultImpl.getInstance();
        }
        return this.vault;
    }

    public boolean getTcpConnectionObject(String hostName) {
        ServerConnectionDataImpl tcpCD = new ServerConnectionDataImpl();
        tcpCD.setServerPort(this.orb.getListenerPort());
        tcpCD.setConnectionKey(this.formConnectionKey(hostName, this.orb.getListenerPort(), " ", (short)0));
        tcpCD.setConnectionType(2L);
        this.serverTCPConnData = tcpCD;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Requesting to create a TCPIP server connection with:");
            Tr.debug(tc, "  Connection key: " + tcpCD.getConnectionKey() + ", Connection type: " + tcpCD.getConnectionType() + ", Server port: " + tcpCD.getServerPort());
        }
        return true;
    }

    public boolean getCSISSLConnectionObject(String hostName) {
        SSLServerConnectionDataImpl sslCD = new SSLServerConnectionDataImpl();
        short requiredQOP = 0;
        requiredQOP = (short)(requiredQOP | 0x20);
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (csiv2.getBoolean("com.ibm.CSI.claimMessageIntegrityRequired")) {
            requiredQOP = (short)(requiredQOP | 2);
        }
        if (csiv2.getBoolean("com.ibm.CSI.claimMessageConfidentialityRequired")) {
            requiredQOP = (short)(requiredQOP | 4);
        }
        short supportedQOP = 0;
        supportedQOP = (short)(supportedQOP | 0x20);
        if (csiv2.getBoolean("com.ibm.CSI.claimMessageIntegritySupported")) {
            supportedQOP = (short)(supportedQOP | 2);
        }
        if (csiv2.getBoolean("com.ibm.CSI.claimMessageConfidentialitySupported")) {
            supportedQOP = (short)(supportedQOP | 4);
        }
        sslCD.setConnectionKey(this.formConnectionKey(hostName, csiv2.getInteger("com.ibm.CSI.SSLPort"), VaultConstants.SSL_MECH_TYPE, supportedQOP));
        sslCD.setConnectionType(1L);
        sslCD.setServerPort(csiv2.getInteger("com.ibm.CSI.SSLPort"));
        sslCD.setTargetRequiresQOP(requiredQOP);
        sslCD.setTargetSupportsQOP(supportedQOP);
        sslCD.setSSLConfigAlias(csiv2.getString("com.ibm.ssl.csi.inbound.alias"));
        sslCD.setEndPointName("CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS");
        this.csiServerSSLConnData = sslCD;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Requesting to create an SSL server connection with:");
            Tr.debug(tc, "  Alias: " + sslCD.getSSLConfigAlias());
        }
        return true;
    }

    public boolean getCSIClientCertSSLConnectionObject(String hostName) {
        SSLServerConnectionDataImpl sslCD = new SSLServerConnectionDataImpl();
        short requiredQOP = 0;
        requiredQOP = (short)(requiredQOP | 0x20);
        requiredQOP = (short)(requiredQOP | 0x40);
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (csiv2.getBoolean("com.ibm.CSI.claimMessageIntegrityRequired")) {
            requiredQOP = (short)(requiredQOP | 2);
        }
        if (csiv2.getBoolean("com.ibm.CSI.claimMessageConfidentialityRequired")) {
            requiredQOP = (short)(requiredQOP | 4);
        }
        short supportedQOP = 0;
        supportedQOP = (short)(supportedQOP | 0x20);
        supportedQOP = (short)(supportedQOP | 0x40);
        if (csiv2.getBoolean("com.ibm.CSI.claimMessageIntegritySupported")) {
            supportedQOP = (short)(supportedQOP | 2);
        }
        if (csiv2.getBoolean("com.ibm.CSI.claimMessageConfidentialitySupported")) {
            supportedQOP = (short)(supportedQOP | 4);
        }
        sslCD.setConnectionKey(this.formConnectionKey(hostName, csiv2.getInteger("com.ibm.CSI.ClientCertSSLPort"), VaultConstants.SSL_MECH_TYPE, supportedQOP));
        sslCD.setConnectionType(1L);
        sslCD.setServerPort(csiv2.getInteger("com.ibm.CSI.ClientCertSSLPort"));
        sslCD.setTargetRequiresQOP(requiredQOP);
        sslCD.setTargetSupportsQOP(supportedQOP);
        sslCD.setSSLConfigAlias(csiv2.getString("com.ibm.ssl.csi.inbound.alias"));
        sslCD.setEndPointName("CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS");
        this.csiClientCertServerSSLConnData = sslCD;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Requesting to create an SSL server connection including EstablishTrustInClient with:");
            Tr.debug(tc, "  Alias: " + sslCD.getSSLConfigAlias());
        }
        return true;
    }

    public String establishConnectionInfo(Profile p, ConnectionDataCarrier cd, boolean sslTagFound, boolean sslCmpdTagFound, int sslPort, short sslTargetSupports, short sslTargetRequires, short secTargetRequires, String targetHostName, boolean CSIv2TransportFound, CSIv2EffectivePerformPolicy csiv2effectivePolicy, String class_name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "establishConnectionInfo", new java.lang.Object[]{p, cd, new Boolean(sslTagFound), new Boolean(sslCmpdTagFound), new Integer(sslPort), new Short(sslTargetSupports), new Short(sslTargetRequires), new Short(secTargetRequires), targetHostName, new Boolean(CSIv2TransportFound), this});
        }
        String mechanism = null;
        String connectionKey = null;
        int port = 0;
        int connType = 0;
        short coalescedQOP = 0;
        boolean SSLEnabled = false;
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (sslTagFound || sslCmpdTagFound || CSIv2TransportFound) {
            if (!csiv2.getBoolean("com.ibm.CSI.performTransportAssocSSLTLSSupported") && !csiv2.getBoolean("com.ibm.CSI.performTransportAssocSSLTLSRequired") && p.getPort() == 0) {
                throw new NO_PERMISSION("SSL is not supported or required in client configuration, however, no TCP/IP port specified in IOR profile.");
            }
            if ((sslTagFound || sslCmpdTagFound || CSIv2TransportFound) && (csiv2effectivePolicy == null || csiv2effectivePolicy.performSSLTLS())) {
                SSLEnabled = true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, ", Creating SSL connectionKey: " + SSLEnabled + ", sslCmpdTagFound is " + sslCmpdTagFound + ", sslTagFound is " + sslTagFound + ";" + ", CSIv2TransportFound is " + CSIv2TransportFound + ";");
        }
        if (SSLEnabled) {
            port = sslPort & 0xFFFF;
            connType = 1;
            coalescedQOP = CSIv2TransportFound && csiv2effectivePolicy != null ? this.formCSIv2CoalescedQOP(sslTargetSupports, sslTargetRequires, csiv2effectivePolicy) : this.formCoalescedQOP(sslTargetSupports, sslTargetRequires);
            mechanism = VaultConstants.SSL_MECH_TYPE;
            String cleanHostName = null;
            int index = targetHostName.lastIndexOf(":");
            cleanHostName = index >= 0 ? targetHostName.substring(0, index) : targetHostName;
            connectionKey = this.formConnectionKey(cleanHostName, port, mechanism, coalescedQOP);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting SSL ExtendedSSLConnectionData object.");
            }
            cd.setConnectionData(new ExtendedSSLConnectionData(connectionKey, connType, coalescedQOP, 0, csiv2effectivePolicy));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "establishConnectionInfo", connectionKey);
            }
            return connectionKey;
        }
        connectionKey = this.createSimpleKey(SecurityConnectionInterceptor.getHostfromProfile(p), p.getPort(), class_name);
        connType = 2;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting TCPIP ConnectionDataImpl object.");
        }
        cd.setConnectionData(new ExtendedSSLConnectionData(connectionKey, connType, 0, 0, csiv2effectivePolicy));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SSL not enabled, returning connection key - " + connectionKey);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "establishConnectionInfo", connectionKey);
        }
        return connectionKey;
    }

    public SSLConnectionData getSSLConfigurationParameters(String connKey, long connType, short qop, int errorCode) {
        return new ExtendedSSLConnectionData(connKey, connType, qop, errorCode, null);
    }

    static String getHostfromProfile(Profile p) {
        String targetHostName = null;
        try {
            targetHostName = p.getHostIPAddress();
            if (targetHostName != null && targetHostName.trim().length() == 0) {
                targetHostName = null;
            }
        }
        catch (Throwable e) {
            Manager.Ffdc.log(e, SecurityConnectionInterceptor.class, "com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor.getHostfromProfile", "2652");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not resolve host, ignore if HTTP Tunneling is enabled", new java.lang.Object[]{e});
            }
            targetHostName = null;
        }
        if (targetHostName == null) {
            targetHostName = p.getHost();
        }
        return targetHostName;
    }

    private String getClassName(IOR ior) {
        String iorString;
        String class_name = "<unknown>";
        if (ior != null && (class_name = (String)classNames.get(iorString = ior.stringify())) == null) {
            Object effectiveTarget;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting class name from IOR.");
            }
            if (ior != null && !ior.isBootstrap() && (effectiveTarget = this.orb.IORToObject(ior)) != null) {
                class_name = effectiveTarget.getClass().getName();
            }
            if (class_name != null) {
                classNames.put(iorString, class_name);
                if (classNames.size() > 100) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Clearing className hashtable (size > 100).");
                    }
                    classNames.clear();
                }
            } else {
                class_name = "<unknown>";
            }
        }
        return class_name;
    }

    static {
        if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
            isThinClient = Boolean.getBoolean("com.ibm.websphere.thinclient");
            prefer_iiop_to_local = isThinClient ? true : JAVAtoCPPUtilities.getNativeBooleanVariable((String)"private_bboc_prefer_iiop_to_local", (boolean)false);
        }
    }
}

