/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.wst.common.internal.emf.resource.EMF2SAXRenderer;
import org.eclipse.wst.common.internal.emf.resource.ReferencedXMIResourceImpl;
import org.eclipse.wst.common.internal.emf.resource.Renderer;
import org.eclipse.wst.common.internal.emf.resource.TranslatorResource;
import org.eclipse.wst.common.internal.emf.utilities.StringUtil;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;

public abstract class TranslatorResourceImpl
extends ReferencedXMIResourceImpl
implements TranslatorResource {
    public static final String CONFIG_WTP_LOGGER = "com.ibm.config.eclipse.wtp";
    public static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    public static final String CLASS_NAME = TranslatorResourceImpl.class.getName();
    public static final EStructuralFeature ID_FEATURE = EcorePackage.eINSTANCE.getEClass_EIDAttribute();
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected Renderer renderer;
    protected static final String DEFAULT_VERSION = "1.0";
    protected String xmlVersion;
    protected int versionID;
    protected String publicId;
    protected String systemId;

    public TranslatorResourceImpl() {
        logger.finer("Constructor [ No Args ]");
    }

    public TranslatorResourceImpl(URI uri) {
        super(uri);
        this.setDefaults();
        logger.finer("Constructor [ URI ]");
    }

    public TranslatorResourceImpl(Renderer renderer) {
        this.setRenderer(renderer);
        this.setDefaults();
        logger.finer("Constructor [ Renderer ]");
    }

    public TranslatorResourceImpl(URI uri, Renderer renderer) {
        super(uri);
        logger.finer("Constructor [ URI, Renderer ]");
        this.setRenderer(renderer);
        this.setDefaults();
    }

    protected void init() {
        super.init();
        this.setEncoding(DEFAULT_ENCODING);
    }

    public void setEncoding(String encoding) {
        logger.finer("Encoding [ " + encoding + " ]");
        super.setEncoding(encoding);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + this.getURI().toString();
    }

    public void setURI(URI uri) {
        super.setURI(uri);
        logger.finer("URI [ " + uri + " ]");
    }

    public void setID(EObject eObject, String id) {
        String oldId = this.getID(eObject);
        super.setID(eObject, id);
        eObject.eNotify(new ENotificationImpl((InternalEObject)eObject, 1, ID_FEATURE, (Object)oldId, (Object)id));
    }

    public String getEncoding() {
        if (super.getEncoding() == null) {
            this.setEncoding(DEFAULT_ENCODING);
        }
        return super.getEncoding();
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(Renderer renderer) {
        logger.finer("Renderer [ " + renderer + " ]");
        this.renderer = renderer;
        if (renderer.getResource() != this) {
            renderer.setResource(this);
        }
    }

    public String getXMLVersion() {
        if (this.xmlVersion == null) {
            this.xmlVersion = DEFAULT_VERSION;
        }
        return this.xmlVersion;
    }

    public void setXMLVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
        logger.finer("Version [ " + xmlVersion + " ]");
    }

    public int getVersionID() {
        return this.versionID;
    }

    public void setVersionID(int versionID) {
        this.versionID = versionID;
        logger.finer("Module Version ID [ " + versionID + " ]");
    }

    protected abstract int getDefaultVersionID();

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public boolean usesDTD() {
        return this.getPublicId() != null && this.getSystemId() != null;
    }

    public void setDoctypeValues(String aPublicId, String aSystemId) {
        logger.finer("Public ID [ " + aPublicId + " ] and System ID [ " + aSystemId + " ]");
        boolean changed = !StringUtil.stringsEqual(this.publicId, aPublicId) || !StringUtil.stringsEqual(this.systemId, aSystemId);
        this.publicId = aPublicId;
        this.systemId = aSystemId;
        if (changed) {
            this.eNotify(new NotificationImpl(1, null, null){

                public Object getFeature() {
                    return DOC_TYPE_FEATURE;
                }

                public Object getNotifier() {
                    return TranslatorResourceImpl.this;
                }
            });
        }
    }

    protected abstract String getDefaultPublicId();

    protected abstract String getDefaultSystemId();

    public abstract void setDefaults();

    public EObject getRootObject() {
        if (this.contents == null || this.contents.isEmpty()) {
            return null;
        }
        return (EObject)this.getContents().get(0);
    }

    protected EList primGetContents() {
        return super.getContents();
    }

    public EList getContents() {
        this.waitForResourceToLoadIfNecessary();
        if (this.contents == null) {
            this.initializeContents();
        }
        return this.contents;
    }

    protected void initializeContents() {
        this.contents = new ResourceImpl.ContentsEList(this){
            private static final long serialVersionUID = 1L;

            public boolean add(Object object) {
                TranslatorResourceImpl.this.getRenderer().prepareToAddContents();
                return super.add(object);
            }

            public boolean addAll(Collection collection) {
                TranslatorResourceImpl.this.getRenderer().prepareToAddContents();
                return super.addAll(collection);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Map options) throws IOException {
        String methodName = "load";
        logger.entering(CLASS_NAME, methodName);
        logger.finer("URI [ " + this.getURI() + " ]");
        TranslatorResourceImpl translatorResourceImpl = this;
        synchronized (translatorResourceImpl) {
            long start = System.currentTimeMillis();
            logger.finer("Start Time [ " + start + " ]");
            if (this.isLoaded) {
                logger.finer("Already loaded");
            } else {
                this.displayOptions(methodName, options);
                if (this.getRenderer().useStreamsForIO()) {
                    logger.finer("Loading using streams");
                    URI useUri = this.getURI();
                    logger.logp(Level.FINER, CLASS_NAME, methodName, "Adding URI to load options [ {0} ]", new Object[]{useUri});
                    super.load(EMF2SAXRenderer.addURI(options, useUri));
                } else {
                    logger.finer("Loading using null stream");
                    this.load((InputStream)null, options);
                }
                this.displayDiagnostics(methodName);
            }
            long end = System.currentTimeMillis();
            long duration = end - start;
            logger.finer("End Time [ " + end + " ]");
            logger.finer("Duration [ " + duration + " ]");
            logger.exiting(CLASS_NAME, methodName);
        }
    }

    protected void basicDoLoad(InputStream inputStream, Map options) throws IOException {
        String methodName = "basicDoLoad";
        logger.entering(CLASS_NAME, methodName);
        logger.finer("URI [ " + this.getURI() + " ]");
        boolean isTrackingMods = this.isTrackingModification();
        try {
            if (isTrackingMods) {
                this.setTrackingModification(false);
            }
            this.getRenderer().doLoad(inputStream, options);
        }
        finally {
            if (isTrackingMods) {
                this.setTrackingModification(true);
            }
        }
        logger.exiting(CLASS_NAME, methodName);
    }

    public void save(Map options) throws IOException {
        String methodName = "save";
        logger.entering(CLASS_NAME, methodName);
        logger.finer("URI [ " + this.getURI() + " ]");
        this.displayOptions(methodName, options);
        long start = System.currentTimeMillis();
        logger.finer("Start Time [ " + start + " ]");
        if (this.getRenderer().useStreamsForIO()) {
            logger.finer("Saving to stream");
            super.save(options);
        } else {
            logger.finer("Saving with null stream stream");
            this.notifyAboutToSave();
            try {
                this.doSave((OutputStream)null, options);
            }
            catch (IOException e) {
                String message = "Exception during save of [ " + TranslatorResourceImpl.getResourceMessage(this) + " ]" + " [ " + e + " ]";
                logger.warning(message);
                this.notifySaveFailed();
                logger.exiting(CLASS_NAME, methodName);
                throw e;
            }
            this.notifySaved();
        }
        this.displayDiagnostics("Save");
        long end = System.currentTimeMillis();
        long duration = end - start;
        logger.finer("End Time [ " + end + " ]");
        logger.finer("Duration [ " + duration + " ]");
        logger.exiting(CLASS_NAME, methodName);
    }

    protected void displayOptions(String title, Map options) {
        logger.finer("Title [ " + title + " ]");
        URIConverter.Cipher cipher = options == null ? null : (URIConverter.Cipher)options.get("CIPHER");
        logger.finer("Cipher [ " + cipher + " ]");
        boolean useZipValue = this.useZip();
        if (!useZipValue) {
            useZipValue = options != null && Boolean.TRUE.equals(options.get("ZIP"));
        }
        logger.finer("Use Zip [ " + useZipValue + " ]");
        logger.finer("Renderer [ " + this.getRenderer() + " ]");
        logger.finer("URIConverter [ " + this.getURIConverter() + " ]");
    }

    /*
     * Unable to fully structure code
     */
    protected void displayDiagnostics(String title) {
        block3: {
            block2: {
                TranslatorResourceImpl.logger.finer("[ " + title + " ]");
                useWarnings = this.getWarnings().iterator();
                if (useWarnings.hasNext()) ** GOTO lbl7
                TranslatorResourceImpl.logger.finest("No warnings");
                break block2;
lbl-1000:
                // 1 sources

                {
                    TranslatorResourceImpl.logger.warning("Warning [ " + useWarnings.next() + " ]");
lbl7:
                    // 2 sources

                    ** while (useWarnings.hasNext())
                }
            }
            useErrors = this.getErrors().iterator();
            if (useErrors.hasNext()) ** GOTO lbl14
            TranslatorResourceImpl.logger.finest("No errors");
            break block3;
lbl-1000:
            // 1 sources

            {
                TranslatorResourceImpl.logger.warning("Error [ " + useErrors.next() + " ]");
lbl14:
                // 2 sources

                ** while (useErrors.hasNext())
            }
        }
    }

    public void doSave(OutputStream outputStream, Map options) throws IOException {
        this.getRenderer().doSave(outputStream, options);
        this.setModified(false);
    }

    protected void doUnload() {
        this.getRenderer().preUnload();
        super.doUnload();
    }

    public boolean isModified() {
        return super.isModified() || this.getRenderer().isModified();
    }

    public void accessForWrite() {
        this.getRenderer().accessForWrite();
        super.accessForWrite();
    }

    public void accessForRead() {
        this.getRenderer().accessForRead();
        super.accessForRead();
    }

    public void releaseFromRead() {
        this.getRenderer().releaseFromRead();
        super.releaseFromRead();
    }

    public void releaseFromWrite() {
        this.getRenderer().releaseFromWrite();
        super.releaseFromWrite();
    }

    public void preDelete() {
        super.preDelete();
        this.getRenderer().preDelete();
    }

    public boolean isShared() {
        return super.isShared() || this.getRenderer().isShared();
    }

    public boolean isSharedForWrite() {
        return super.isSharedForWrite() || this.getRenderer().isSharedForWrite();
    }

    public static String getResourceMessage(TranslatorResource resource) {
        if (resource == null) {
            return "*** null translator resource ***";
        }
        return "public ID [ " + resource.getPublicId() + " ]" + " and system ID [ " + resource.getSystemId() + " ]";
    }

    public static String getResourceMessage(XMIResource resource) {
        if (resource == null) {
            return "*** null XMI resource ***";
        }
        return "URI [ " + resource.getURI() + " ]";
    }

    public boolean setModuleVersionID(Document document) {
        return false;
    }

    public boolean setModuleVersionID(Attributes attributes) {
        return false;
    }
}

