/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.test;

import java.io.IOException;
import org.eclipse.tptp.platform.agentcontroller.internal.stream.SharedMemoryInputStream;
import org.eclipse.tptp.platform.agentcontroller.internal.stream.SharedMemoryOutputStream;

public class TestSharedMemory {
    private String _shmName = "SHM_TEST";
    private SharedMemoryOutputStream _shmOut;
    private SharedMemoryInputStream _shmIn;
    private int _iterations = 1000000;

    public static void main(String[] args) {
        TestSharedMemory t = new TestSharedMemory();
        t.test01();
    }

    public void test01() {
        TestInputThread tin = new TestInputThread();
        TestOutputThread tout = new TestOutputThread();
        tin.start();
        tout.start();
        try {
            tout.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    class TestInputThread
    extends Thread {
        private byte[] buffer = new byte[1024];

        public TestInputThread() {
            this.setName("Input Thread");
            TestSharedMemory.this._shmIn = new SharedMemoryInputStream(TestSharedMemory.this._shmName);
        }

        public void run() {
            int totalByteReceived = 0;
            int byteReceived = 1;
            while (byteReceived > 0) {
                try {
                    byteReceived = TestSharedMemory.this._shmIn.read(this.buffer);
                    if (byteReceived <= 0) continue;
                    totalByteReceived += byteReceived;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                TestSharedMemory.this._shmIn.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("Total byte received = " + totalByteReceived);
        }
    }

    class TestOutputThread
    extends Thread {
        public TestOutputThread() {
            this.setName("Output Thread ");
            TestSharedMemory.this._shmOut = new SharedMemoryOutputStream(TestSharedMemory.this._shmName);
        }

        public void run() {
            int totalByteSent = 0;
            int i = 0;
            while (i < TestSharedMemory.this._iterations) {
                String str = new String("iteration " + i);
                try {
                    byte[] b = str.getBytes();
                    TestSharedMemory.this._shmOut.write(b);
                    totalByteSent += b.length;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            try {
                TestSharedMemory.this._shmOut.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("Total byte sent = " + totalByteSent);
        }
    }
}

