/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.proxy;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.tptp.platform.agentcontroller.internal.proxy.AgentProxy;
import org.eclipse.tptp.platform.agentcontroller.internal.proxy.NodeProxy;
import org.eclipse.tptp.platform.agentcontroller.internal.proxy.ProcessProxyListener;

public class ProcessProxy {
    private long _pid;
    private String _name;
    private Vector _agents = new Vector();
    private NodeProxy _node = null;
    private Vector _listeners = new Vector();
    private Process _process = null;
    private String _attachedClient;
    private int _rc = 0;
    private boolean _isActive = true;
    private Vector _environments = new Vector();
    private Vector _parameters = new Vector();

    public ProcessProxy(long pid) {
        this(pid, null);
    }

    public ProcessProxy(long pid, String name) {
        this._pid = pid;
        this._name = name;
    }

    public void addAgent(AgentProxy agent) {
        this._agents.add(agent);
        this._isActive = true;
    }

    public void addProcessListener(ProcessProxyListener listener) {
        this._listeners.add(listener);
    }

    public void appendEnvironment(String name, String value) {
        NVPair env = new NVPair(name, value);
        this._environments.add(env);
    }

    public void appendParameter(String name) {
        this._parameters.add(name);
    }

    public String getName() {
        return this._name;
    }

    public long getPid() {
        return this._pid;
    }

    public Enumeration getAgents() {
        return this._agents.elements();
    }

    public AgentProxy getAgent(String agentName) {
        AgentProxy agent = null;
        Enumeration agents = this.getAgents();
        while (agents.hasMoreElements()) {
            AgentProxy a = (AgentProxy)agents.nextElement();
            if (!a.getName().equals(agentName)) continue;
            agent = a;
        }
        if (agent == null) {
            Enumeration agents2 = this.getAgents();
            while (agents2.hasMoreElements()) {
                AgentProxy a = (AgentProxy)agents2.nextElement();
                if (!a.getName().startsWith(agentName)) continue;
                agent = a;
            }
        }
        return agent;
    }

    public String getAttacheClient() {
        return this._attachedClient;
    }

    public NodeProxy getNode() {
        return this._node;
    }

    public Process getProcess() {
        return this._process;
    }

    public int getReturnCode() {
        return this._rc;
    }

    public boolean isAlive() {
        boolean alive = false;
        if (this._process != null) {
            try {
                this._rc = this._process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                alive = true;
            }
        } else {
            Enumeration agents = this.getAgents();
            while (agents.hasMoreElements()) {
                AgentProxy agent = (AgentProxy)agents.nextElement();
                if (!agent.isActive()) continue;
                alive = true;
            }
        }
        return alive;
    }

    public boolean isActive() {
        return this._isActive;
    }

    public void prependEnvironment(String name, String value) {
        NVPair env = new NVPair(name, value);
        this._environments.insertElementAt(env, 0);
    }

    public void prependParameter(String name) {
        this._parameters.insertElementAt(name, 0);
    }

    public void processExited() {
        Enumeration e = this._listeners.elements();
        while (e.hasMoreElements()) {
            ProcessProxyListener l = (ProcessProxyListener)e.nextElement();
            l.processExited(this._pid);
        }
    }

    public void processLaunched(long pid) {
        this._pid = pid;
        Enumeration e = this._listeners.elements();
        while (e.hasMoreElements()) {
            ProcessProxyListener l = (ProcessProxyListener)e.nextElement();
            l.processLaunched(this._pid);
        }
    }

    public void removeAgent(AgentProxy agent) {
        if (this._agents.contains(agent)) {
            this._agents.remove(agent);
            if (this._agents.size() == 0) {
                this._isActive = false;
            }
        }
    }

    public void removeAllAgents() {
        this._agents.removeAllElements();
        this._isActive = false;
    }

    public void setActive(boolean isActive) {
        this._isActive = isActive;
    }

    public void setAttacheClient(String attacheClient) {
        this._attachedClient = attacheClient;
    }

    public void setNode(NodeProxy n) {
        this._node = n;
    }

    public void setProcess(Process p) {
        this._process = p;
    }

    class NVPair {
        String _name;
        String _value;

        public NVPair(String name, String value) {
            this._name = name;
            this._value = value;
        }

        public String getName() {
            return this._name;
        }

        public String getValue() {
            return this._value;
        }
    }
}

