/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.tptp.platform.agentcontroller.internal.Serializer;
import org.eclipse.tptp.platform.agentcontroller.internal.TPTPMessage;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.BaseConnectionImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.TPTPLoggerImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.TPTPMessageImpl;

public class SocketControlConnectionImpl
extends BaseConnectionImpl {
    private Socket _socket = null;
    private String _host;
    private int _port;
    private Serializer _serializer = null;
    private boolean _destroyed = false;

    public SocketControlConnectionImpl(String hostname, int port) {
        this._host = hostname;
        this._port = port;
        this.setName(String.valueOf(this.getConnectionType()) + ":" + this.getConnectionName());
        try {
            this._socket = new Socket(this._host, this._port);
            TPTPLoggerImpl.log(this, 2, "Socket control channel created to host: " + this._host + ":" + this._port);
        }
        catch (UnknownHostException unknownHostException) {
            TPTPLoggerImpl.log(0, "Cannot load find host: " + this._host + ":" + this._port);
        }
        catch (IOException iOException) {
            TPTPLoggerImpl.log(0, "IOException occurred when connecting to: " + this._host + ":" + this._port);
        }
    }

    public SocketControlConnectionImpl(Socket socket) {
        this._host = socket.getInetAddress().getHostName();
        this._port = socket.getPort();
        this.setName(String.valueOf(this.getConnectionType()) + ":" + this.getConnectionName());
        this._socket = socket;
        TPTPLoggerImpl.log(this, 2, "Socket control channel created to host: " + this._host + ":" + this._port);
    }

    public void create() {
    }

    public void destroyConnection() {
        this._destroyed = true;
        try {
            this._socket.close();
            TPTPLoggerImpl.log(this, 2, "Socket control channel destroyed");
        }
        catch (IOException iOException) {
            TPTPLoggerImpl.log(this, 0, "Error during socket control channel destruction");
        }
    }

    public String getConnectionName() {
        return new String(String.valueOf(this._host) + ":" + this._port);
    }

    public String getConnectionType() {
        return "TPTP_SOCKET_CONTROL_CONNECTION";
    }

    public InputStream getInputStream() {
        InputStream in = null;
        try {
            in = this._socket.getInputStream();
        }
        catch (IOException iOException) {
            TPTPLoggerImpl.log(0, "Error getting input stream of host: " + this._host + ":" + this._port);
        }
        return in;
    }

    public OutputStream getOutputStream() {
        OutputStream out = null;
        try {
            out = this._socket.getOutputStream();
        }
        catch (IOException iOException) {
            TPTPLoggerImpl.log(0, "Error getting output stream of host: " + this._host + ":" + this._port);
        }
        return out;
    }

    public void setInputStream(InputStream inputStream) {
    }

    public void setOutputStream(OutputStream outputStream) {
    }

    public void objectReceived(Object object) throws IOException {
        if (object != null && object instanceof TPTPMessage) {
            TPTPMessage message = (TPTPMessage)object;
            this._serializer.putObject(this._socket.getOutputStream(), message.getPayload());
        }
    }

    public void run() {
        if (this._serializer != null) {
            Object obj = null;
            do {
                try {
                    obj = this._serializer.getObject(this._socket.getInputStream());
                }
                catch (IOException iOException) {
                    return;
                }
                if (obj == null) continue;
                TPTPMessageImpl message = new TPTPMessageImpl();
                message.setSource(this.getConnectionId());
                message.setPayload(obj);
                try {
                    this.sendToQueue(message);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } while (!this._destroyed && obj != null);
        }
    }

    public void setSerializer(Serializer serializer) {
        this._serializer = serializer;
    }
}

