/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.tptp.platform.agentcontroller.internal.AgentController;
import org.eclipse.tptp.platform.agentcontroller.internal.Queue;
import org.eclipse.tptp.platform.agentcontroller.internal.SystemShutdownListener;
import org.eclipse.tptp.platform.agentcontroller.internal.config.Configuration;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.ConfigurationImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.ConnectionFactoryImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.HyadesMessageDispatcherImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.HyadesMessageProcessorImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.HyadesSerializer;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.NamedPipeConnectionImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.PlatformUtility;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.ProcessPollingThreadImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.QueueFactoryImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.SocketServerConnectionImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.TPTPLoggerImpl;

public class AgentControllerImpl
implements AgentController,
SystemShutdownListener {
    private String _name = null;
    private boolean _isAutoStart = false;
    private boolean _isEnabled = true;
    private boolean _isRunning = false;
    private boolean _isSocketEnabled = false;
    private int _port = 10002;
    private Queue _inputQueue = null;
    private Queue _outputQueue = null;
    private NamedPipeConnectionImpl _ramaster = null;
    private SocketServerConnectionImpl _socketServerConnection = null;
    private boolean _isTriggered = false;
    private Configuration _configuration = null;
    private HyadesMessageProcessorImpl _messageProcessor = null;
    private HyadesMessageDispatcherImpl _messageDispatcher = null;
    private ProcessPollingThreadImpl _processPollingThread = null;

    public static void main(String[] args) {
        AgentControllerImpl agentController = new AgentControllerImpl();
        if (args.length > 0) {
            if (args[0].startsWith("RASERVER_HOME=")) {
                String homedir = args[0].substring(args[0].indexOf(61) + 1);
                System.out.println("RASERVER_HOME = " + homedir);
                agentController.start(homedir);
            } else {
                System.err.println("Error: Missing RASERVER_HOME directory");
            }
        }
    }

    public AgentControllerImpl() {
        try {
            this._name = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            this._name = "localhost";
        }
        if (this._isAutoStart) {
            this.start();
        }
    }

    public String getName() {
        return this._name;
    }

    public String getOS() {
        return PlatformUtility.getOSName();
    }

    public boolean isEnabled() {
        return this._isEnabled;
    }

    public synchronized boolean isRunning() {
        return this._isRunning;
    }

    public void setAutoStart(boolean autoStart) {
        this._isAutoStart = autoStart;
        if (autoStart && !this.isRunning()) {
            this.start();
        }
    }

    public void setEnabled(boolean enabled) {
        this._isEnabled = enabled;
        if (!enabled && this.isRunning()) {
            this.stop();
        }
    }

    public void setPort(int port) {
        this._port = port;
        if (this.isRunning() && this._socketServerConnection != null) {
            this._socketServerConnection.destroy();
            this._socketServerConnection.interrupt();
            this._socketServerConnection = ConnectionFactoryImpl.createSocketServerConnection(port);
            this._socketServerConnection.start();
        }
    }

    public void setSocketEnabled(boolean socketEnabled) {
        this._isSocketEnabled = socketEnabled;
        if (this.isRunning()) {
            if (socketEnabled && this._socketServerConnection == null) {
                this._socketServerConnection = ConnectionFactoryImpl.createSocketServerConnection(this._port);
                this._socketServerConnection.start();
            } else if (!socketEnabled && this._socketServerConnection != null) {
                this._socketServerConnection.destroy();
                this._socketServerConnection.interrupt();
                this._socketServerConnection = null;
            }
        }
    }

    public void start() {
        this.start(null);
    }

    public synchronized void start(String homedir) {
        if (!this._isRunning && this._isEnabled) {
            this._inputQueue = QueueFactoryImpl.getInputControlQueue();
            this._outputQueue = QueueFactoryImpl.getOutputControlQueue();
            this._messageProcessor = new HyadesMessageProcessorImpl();
            this._messageDispatcher = new HyadesMessageDispatcherImpl();
            this._processPollingThread = new ProcessPollingThreadImpl(this._messageProcessor.getNode(), this._messageProcessor);
            this._processPollingThread.setSystemShutdownListener(this);
            if (this._isSocketEnabled) {
                this._socketServerConnection = ConnectionFactoryImpl.createSocketServerConnection(this._port);
            }
            if (NamedPipeConnectionImpl.isPipeAvailable("ramaster")) {
                this._ramaster = ConnectionFactoryImpl.createNamedPipeConnection("ramaster", true);
                this._ramaster.setSerializer(new HyadesSerializer());
            }
            this._messageProcessor.setInputQueue(this._inputQueue);
            this._messageProcessor.setOutputQueue(this._outputQueue);
            this._messageDispatcher.setInputQueue(this._outputQueue);
            TPTPLoggerImpl.log(this, 3, "Started to load configuration");
            this._configuration = ConfigurationImpl.getInstance();
            TPTPLoggerImpl.log(this, 3, "Finished loading configuration");
            this._messageProcessor.setConfiguration(this._configuration);
            ConnectionFactoryImpl.startAll();
            this._messageProcessor.start();
            this._messageDispatcher.start();
            this._processPollingThread.start();
            TPTPLoggerImpl.log(this, 2, "Integrated Agent Controller started");
        }
        this._isRunning = true;
        this._isTriggered = false;
    }

    public synchronized void stop() {
        if (this._isRunning && this._isTriggered) {
            TPTPLoggerImpl.log(3, "Destroying connection: " + this._ramaster.getConnectionId());
            this._ramaster.destroyConnection();
            ConnectionFactoryImpl.removeConnection(this._ramaster.getConnectionId());
            ConnectionFactoryImpl.stopAll();
            QueueFactoryImpl.destroyInputControlQueue();
            QueueFactoryImpl.destroyOutputControlQueue();
            this._messageProcessor.interrupt();
            this._messageDispatcher.interrupt();
            try {
                this._messageProcessor.join();
                this._messageDispatcher.join();
            }
            catch (InterruptedException interruptedException) {}
            TPTPLoggerImpl.log(this, 2, "Integrated Agent Controller stopped");
            this._processPollingThread.interrupt();
            this._isRunning = false;
            this._isTriggered = false;
        }
    }

    public void shutdown() {
        if (!this._isAutoStart) {
            this.stop();
        }
    }

    public void triggered() {
        this._isTriggered = true;
    }
}

