/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.config;

import java.io.File;
import java.util.Hashtable;
import org.eclipse.tptp.platform.agentcontroller.internal.config.Parameter;
import org.eclipse.tptp.platform.agentcontroller.internal.config.Variable;

public class Application {
    private String _executable;
    private String _location;
    private String _path;
    private boolean _extends = false;
    private StringBuffer _prependParameter = new StringBuffer();
    private StringBuffer _appendParameter = new StringBuffer();
    private Hashtable _variables = new Hashtable();

    public Application() {
        this(null, null, null);
    }

    public Application(String executable, String path, String location) {
        this._executable = executable;
        this._path = path;
        this._location = location;
    }

    public String getExecutable() {
        return this._executable;
    }

    public void setExecutable(String executable) {
        this._executable = executable;
    }

    public boolean isExtends() {
        return this._extends;
    }

    public void setExtends(boolean extend) {
        this._extends = extend;
    }

    public String getLocation() {
        return this._location;
    }

    public void setLocation(String location) {
        this._location = location;
    }

    public String getPrependParameter() {
        return this._prependParameter.toString();
    }

    public String getAppendParameter() {
        return this._appendParameter.toString();
    }

    public void addParameter(Parameter parameter) {
        if (parameter.getPosition().equals(Parameter.APPEND)) {
            this._appendParameter.append(" " + parameter.getValue());
        } else if (parameter.getPosition().equals(Parameter.PREPEND)) {
            this._prependParameter.insert(0, String.valueOf(parameter.getValue()) + " ");
        }
    }

    public String getPath() {
        return this._path;
    }

    public void setPath(String path) {
        this._path = path;
    }

    public Hashtable getVariables() {
        return this._variables;
    }

    public String getVariable(String name) {
        return (String)this._variables.get(name);
    }

    public void addVariable(Variable variable) {
        String name = variable.getName();
        String value = variable.getValue();
        String position = variable.getPosition();
        if (!this._variables.containsKey(name)) {
            this._variables.put(name, value);
        } else if (position.equals(Variable.APPEND)) {
            String oldValue = (String)this._variables.get(name);
            String newValue = String.valueOf(oldValue) + File.pathSeparator + value;
            this._variables.put(name, newValue);
        } else if (position.equals(Variable.PREPEND)) {
            String oldValue = (String)this._variables.get(name);
            String newValue = String.valueOf(value) + File.pathSeparator + oldValue;
            this._variables.put(name, newValue);
        } else if (position.equals(Variable.REPLACE)) {
            this._variables.put(name, value);
        }
    }
}

