/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.parser;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jst.jsp.core.internal.parser.internal.JSPTokenizer;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockTokenizer;
import org.eclipse.wst.sse.core.internal.ltk.parser.JSPCapableParser;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.ltk.parser.StructuredDocumentRegionHandler;
import org.eclipse.wst.sse.core.internal.ltk.parser.StructuredDocumentRegionHandlerExtension;
import org.eclipse.wst.sse.core.internal.ltk.parser.StructuredDocumentRegionParser;
import org.eclipse.wst.sse.core.internal.ltk.parser.TagMarker;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.text.IRegionComparible;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.parser.XMLSourceParser;

public class JSPSourceParser
extends XMLSourceParser
implements JSPCapableParser {
    public void addNestablePrefix(TagMarker marker) {
        ((JSPTokenizer)this.getTokenizer()).addNestablePrefix(marker);
    }

    public List getNestablePrefixes() {
        return ((JSPTokenizer)this.getTokenizer()).getNestablePrefixes();
    }

    protected BlockTokenizer getTokenizer() {
        if (this.fTokenizer == null) {
            this.fTokenizer = new JSPTokenizer();
            this.getStructuredDocumentRegionHandlers().add(new NestablePrefixHandler());
        }
        return this.fTokenizer;
    }

    public RegionParser newInstance() {
        JSPSourceParser newInstance = new JSPSourceParser();
        newInstance.setTokenizer(this.getTokenizer().newInstance());
        return newInstance;
    }

    protected IStructuredDocumentRegion parseNodes() {
        IStructuredDocumentRegion headNode = null;
        IStructuredDocumentRegion lastNode = null;
        ITextRegion region = null;
        IStructuredDocumentRegion currentNode = null;
        String type = null;
        while ((region = this.getNextRegion()) != null) {
            type = region.getType();
            if (type == "BLOCK_TEXT") {
                if (currentNode != null && currentNode.getLastRegion().getType() == "BLOCK_TEXT") {
                    currentNode.addRegion(region);
                    currentNode.setLength(region.getStart() + region.getLength() - currentNode.getStart());
                    region.adjustStart(-currentNode.getStart());
                    if (region instanceof ITextRegionContainer) {
                        ((ITextRegionContainer)region).setParent((ITextRegionCollection)currentNode);
                    }
                } else {
                    if (currentNode != null) {
                        if (!currentNode.isEnded()) {
                            currentNode.setLength(region.getStart() - currentNode.getStart());
                        }
                        lastNode = currentNode;
                    }
                    this.fireNodeParsed(currentNode);
                    currentNode = this.createStructuredDocumentRegion(type);
                    if (lastNode != null) {
                        lastNode.setNext(currentNode);
                    }
                    currentNode.setPrevious(lastNode);
                    currentNode.setStart(region.getStart());
                    currentNode.setLength(region.getStart() + region.getLength() - currentNode.getStart());
                    currentNode.setEnded(true);
                    region.adjustStart(-currentNode.getStart());
                    currentNode.addRegion(region);
                    if (region instanceof ITextRegionContainer) {
                        ((ITextRegionContainer)region).setParent((ITextRegionCollection)currentNode);
                    }
                }
            } else if (currentNode != null && currentNode.isEnded() || type == "XML_CONTENT" || type == "XML_CHAR_REFERENCE" || type == "XML_ENTITY_REFERENCE" || type == "XML_PI_OPEN" || type == "XML_TAG_OPEN" || type == "XML_END_TAG_OPEN" || type == "XML_COMMENT_OPEN" || type == "XML_CDATA_OPEN" || type == "XML_DECLARATION_OPEN" || type == "JSP_COMMENT_OPEN" || type == "JSP_DECLARATION_OPEN" || type == "JSP_DIRECTIVE_OPEN" || type == "JSP_EXPRESSION_OPEN" || type == "JSP_SCRIPTLET_OPEN" || type == "JSP_CLOSE" || type == "JSP_EL_OPEN") {
                if (currentNode != null) {
                    if (!currentNode.isEnded()) {
                        currentNode.setLength(region.getStart() - currentNode.getStart());
                    }
                    lastNode = currentNode;
                }
                this.fireNodeParsed(currentNode);
                currentNode = this.createStructuredDocumentRegion(type);
                if (lastNode != null) {
                    lastNode.setNext(currentNode);
                }
                currentNode.setPrevious(lastNode);
                currentNode.setStart(region.getStart());
                currentNode.addRegion(region);
                currentNode.setLength(region.getStart() + region.getLength() - currentNode.getStart());
                region.adjustStart(-currentNode.getStart());
                if (region instanceof ITextRegionContainer) {
                    ((ITextRegionContainer)region).setParent((ITextRegionCollection)currentNode);
                }
            } else if (type == "XML_TAG_NAME" || type == "XML_TAG_ATTRIBUTE_NAME" || type == "XML_TAG_ATTRIBUTE_EQUALS" || type == "XML_TAG_ATTRIBUTE_VALUE" || type == "XML_COMMENT_TEXT" || type == "XML_PI_CONTENT" || type == "XML_DOCTYPE_INTERNAL_SUBSET" || type == "JSP_COMMENT_TEXT" || type == "JSP_ROOT_TAG_NAME" || type == "JSP_DIRECTIVE_NAME" || type == "JSP_EL_CONTENT") {
                currentNode.addRegion(region);
                currentNode.setLength(region.getStart() + region.getLength() - currentNode.getStart());
                region.adjustStart(-currentNode.getStart());
                if (region instanceof ITextRegionContainer) {
                    ((ITextRegionContainer)region).setParent((ITextRegionCollection)currentNode);
                }
            } else if (type == "XML_PI_CLOSE" || type == "XML_TAG_CLOSE" || type == "XML_EMPTY_TAG_CLOSE" || type == "XML_COMMENT_CLOSE" || type == "XML_CDATA_CLOSE" || type == "JSP_CLOSE" || type == "JSP_COMMENT_CLOSE" || type == "JSP_DIRECTIVE_CLOSE" || type == "XML_DECLARATION_CLOSE" || type == "JSP_EL_CLOSE") {
                currentNode.setEnded(true);
                currentNode.setLength(region.getStart() + region.getLength() - currentNode.getStart());
                currentNode.addRegion(region);
                region.adjustStart(-currentNode.getStart());
                if (region instanceof ITextRegionContainer) {
                    ((ITextRegionContainer)region).setParent((ITextRegionCollection)currentNode);
                }
            } else if (type == "WHITE_SPACE") {
                ITextRegion lastRegion = currentNode.getLastRegion();
                if (lastRegion instanceof ITextRegionContainer) {
                    ITextRegionContainer container2 = (ITextRegionContainer)lastRegion;
                    container2.getRegions().add(region);
                    container2.setParent((ITextRegionCollection)currentNode);
                    region.adjustStart(container2.getLength() - region.getStart());
                }
                currentNode.getLastRegion().adjustLength(region.getLength());
                currentNode.adjustLength(region.getLength());
            } else if (type == "UNDEFINED" && currentNode != null) {
                if (currentNode.getLastRegion() != null && currentNode.getLastRegion().getType() == "UNDEFINED") {
                    currentNode.getLastRegion().adjustLength(region.getLength());
                    currentNode.adjustLength(region.getLength());
                } else {
                    currentNode.addRegion(region);
                    currentNode.setLength(region.getStart() + region.getLength() - currentNode.getStart());
                    region.adjustStart(-currentNode.getStart());
                }
                if (region instanceof ITextRegionContainer) {
                    ((ITextRegionContainer)region).setParent((ITextRegionCollection)currentNode);
                }
            } else {
                if (currentNode == null) {
                    currentNode = this.createStructuredDocumentRegion(type);
                    currentNode.setStart(region.getStart());
                }
                currentNode.addRegion(region);
                currentNode.setLength(region.getStart() + region.getLength() - currentNode.getStart());
                region.adjustStart(-currentNode.getStart());
                if (region instanceof ITextRegionContainer) {
                    ((ITextRegionContainer)region).setParent((ITextRegionCollection)currentNode);
                }
            }
            if (type == "XML_CONTENT" || type == "XML_CHAR_REFERENCE" || type == "XML_ENTITY_REFERENCE" || type == "JSP_DECLARATION_OPEN" || type == "JSP_EXPRESSION_OPEN" || type == "JSP_SCRIPTLET_OPEN" || type == "JSP_CONTENT" || type == "JSP_CLOSE") {
                currentNode.setEnded(true);
            }
            if (headNode != null || currentNode == null) continue;
            headNode = currentNode;
        }
        if (currentNode != null) {
            this.fireNodeParsed(currentNode);
            currentNode.setPrevious(lastNode);
        }
        this.primReset();
        return headNode;
    }

    public void removeNestablePrefix(String tagName) {
        ((JSPTokenizer)this.getTokenizer()).removeNestablePrefix(tagName);
    }

    protected class NestablePrefixHandler
    implements StructuredDocumentRegionHandler,
    StructuredDocumentRegionHandlerExtension {
        private static final String XMLNS = "xmlns:";

        protected NestablePrefixHandler() {
        }

        protected void enableForTaglib(String prefix, IStructuredDocumentRegion anchorFlatNode) {
            if (prefix == null) {
                return;
            }
            List tagmarkers = ((JSPTokenizer)JSPSourceParser.this.getTokenizer()).getNestablePrefixes();
            int i = 0;
            while (i < tagmarkers.size()) {
                if (((TagMarker)tagmarkers.get(i)).getTagName().equals(prefix)) {
                    return;
                }
                ++i;
            }
            ((JSPTokenizer)JSPSourceParser.this.getTokenizer()).getNestablePrefixes().add(new TagMarker(prefix, (ITextRegion)anchorFlatNode));
        }

        public void nodeParsed(IStructuredDocumentRegion aCoreFlatNode) {
            if (aCoreFlatNode.getNumberOfRegions() > 4 && aCoreFlatNode.getRegions().get(1).getType() == "JSP_DIRECTIVE_NAME") {
                ITextRegion name = aCoreFlatNode.getRegions().get(1);
                try {
                    boolean processDirectiveName;
                    int offset = aCoreFlatNode.getStartOffset(name);
                    int length = name.getTextLength();
                    boolean taglibdetected = false;
                    boolean taglibdirectivedetected = false;
                    if (JSPSourceParser.this.fCharSequenceSource instanceof IRegionComparible) {
                        taglibdetected = ((IRegionComparible)JSPSourceParser.this.fCharSequenceSource).regionMatches(offset, length, "taglib");
                        taglibdirectivedetected = ((IRegionComparible)JSPSourceParser.this.fCharSequenceSource).regionMatches(offset, length, "jsp:directive.taglib");
                    } else {
                        String directiveName = JSPSourceParser.this.getText(offset, length);
                        taglibdetected = directiveName.equals("taglib");
                        taglibdirectivedetected = directiveName.equals("jsp:directive.taglib");
                    }
                    boolean bl = processDirectiveName = taglibdetected || taglibdirectivedetected;
                    if (processDirectiveName) {
                        this.processTaglib(aCoreFlatNode);
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
            } else if (aCoreFlatNode.getNumberOfRegions() > 4 && aCoreFlatNode.getRegions().get(1).getType() == "JSP_ROOT_TAG_NAME") {
                this.processJSPRoot(aCoreFlatNode);
            }
        }

        protected void processJSPRoot(IStructuredDocumentRegion taglibFlatNode) {
            ITextRegionList regions = taglibFlatNode.getRegions();
            String prefix = null;
            boolean taglib = false;
            try {
                int i = 0;
                while (i < regions.size()) {
                    ITextRegion region = regions.get(i);
                    if (region.getType() == "XML_TAG_ATTRIBUTE_NAME") {
                        int length;
                        int offset = taglibFlatNode.getStartOffset(region);
                        String name = JSPSourceParser.this.getText(offset, length = region.getTextLength());
                        if (name.startsWith(XMLNS) && name.length() > XMLNS.length()) {
                            prefix = name.substring(6);
                            taglib = true;
                        } else {
                            prefix = null;
                            taglib = false;
                        }
                    } else if (taglib && region.getType() == "XML_TAG_ATTRIBUTE_VALUE" && (prefix = StringUtils.strip(prefix)) != null && prefix.length() > 0) {
                        this.enableForTaglib(prefix, taglibFlatNode);
                        prefix = null;
                    }
                    ++i;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                prefix = null;
            }
        }

        protected void processTaglib(IStructuredDocumentRegion taglibFlatNode) {
            ITextRegionList regions = taglibFlatNode.getRegions();
            String prefix = null;
            boolean prefixname = false;
            try {
                int i = 0;
                while (i < regions.size()) {
                    ITextRegion region = regions.get(i);
                    if (region.getType() == "XML_TAG_ATTRIBUTE_NAME") {
                        if (JSPSourceParser.this.fCharSequenceSource != null && JSPSourceParser.this.fCharSequenceSource instanceof IRegionComparible) {
                            int offset = taglibFlatNode.getStartOffset(region);
                            int length = region.getTextLength();
                            prefixname = ((IRegionComparible)JSPSourceParser.this.fCharSequenceSource).regionMatches(offset, length, "prefix");
                        } else {
                            prefixname = JSPSourceParser.this.getText(taglibFlatNode.getStartOffset(region), region.getTextLength()).equals("prefix");
                        }
                    } else if (prefixname && region.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                        prefix = JSPSourceParser.this.getText(taglibFlatNode.getStartOffset(region), region.getTextLength());
                    }
                    ++i;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                prefix = null;
            }
            prefix = StringUtils.strip(prefix);
            if (prefix != null && prefix.length() > 0) {
                this.enableForTaglib(prefix, taglibFlatNode);
            }
        }

        public void resetNodes() {
            Iterator tagmarkers = ((JSPTokenizer)JSPSourceParser.this.getTokenizer()).getNestablePrefixes().iterator();
            while (tagmarkers.hasNext()) {
                if (((TagMarker)tagmarkers.next()).isGlobal()) continue;
                tagmarkers.remove();
            }
        }

        public void setStructuredDocument(IStructuredDocument newDocument) {
            this.resetNodes();
            JSPSourceParser.this.getStructuredDocumentRegionHandlers().remove(this);
            if (newDocument != null && newDocument.getParser() instanceof StructuredDocumentRegionParser) {
                ((StructuredDocumentRegionParser)newDocument.getParser()).addStructuredDocumentRegionHandler((StructuredDocumentRegionHandler)this);
            }
        }
    }
}

