/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.webapplication.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jst.j2ee.common.Listener;
import org.eclipse.jst.j2ee.common.MessageDestination;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.common.internal.impl.JNDIEnvRefsGroupImpl;
import org.eclipse.jst.j2ee.common.internal.util.CommonUtil;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionResource;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.jsp.JSPConfig;
import org.eclipse.jst.j2ee.webapplication.ContextParam;
import org.eclipse.jst.j2ee.webapplication.ErrorCodeErrorPage;
import org.eclipse.jst.j2ee.webapplication.ErrorPage;
import org.eclipse.jst.j2ee.webapplication.ExceptionTypeErrorPage;
import org.eclipse.jst.j2ee.webapplication.Filter;
import org.eclipse.jst.j2ee.webapplication.FilterMapping;
import org.eclipse.jst.j2ee.webapplication.LocalEncodingMappingList;
import org.eclipse.jst.j2ee.webapplication.LoginConfig;
import org.eclipse.jst.j2ee.webapplication.MimeMapping;
import org.eclipse.jst.j2ee.webapplication.SecurityConstraint;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.SessionConfig;
import org.eclipse.jst.j2ee.webapplication.TagLibRef;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebapplicationPackage;
import org.eclipse.jst.j2ee.webapplication.WelcomeFileList;

public class WebAppImpl
extends JNDIEnvRefsGroupImpl
implements WebApp {
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    private static String className = "WebAppImpl";
    protected static final boolean DISTRIBUTABLE_EDEFAULT = false;
    protected boolean distributable = false;
    protected boolean distributableESet = false;
    protected static final String VERSION_EDEFAULT = null;
    protected String version = VERSION_EDEFAULT;
    protected static final boolean METADATA_COMPLETE_EDEFAULT = false;
    protected boolean metadataComplete = false;
    protected boolean metadataCompleteESet = false;
    protected EList contexts = null;
    protected EList errorPages = null;
    protected WelcomeFileList fileList = null;
    protected EList tagLibs = null;
    protected EList constraints = null;
    protected LoginConfig loginConfig = null;
    protected EList mimeMappings = null;
    protected SessionConfig sessionConfig = null;
    protected EList servletMappings = null;
    protected EList servlets = null;
    protected EList securityRoles = null;
    protected EList filters = null;
    protected EList filterMappings = null;
    protected EList listeners = null;
    protected EList contextParams = null;
    protected JSPConfig jspConfig = null;
    protected EList messageDestinations = null;
    protected LocalEncodingMappingList localEncodingMappingList = null;
    private boolean _J2EEVersionIDStored = false;
    private int _storedJ2EEVersionID;

    protected EClass eStaticClass() {
        return WebapplicationPackage.Literals.WEB_APP;
    }

    public boolean containsSecurityRole(String name) {
        return this.getSecurityRoleNamed(name) != null;
    }

    public ErrorPage getErrorPageByCode(Integer code) {
        EList lerrorPages = this.getErrorPages();
        String codeString = code.toString();
        for (ErrorPage ep : lerrorPages) {
            ErrorCodeErrorPage ecep;
            if (!ep.isErrorCode() || !codeString.equals((ecep = (ErrorCodeErrorPage)ep).getErrorCode())) continue;
            return ecep;
        }
        return null;
    }

    public ErrorPage getErrorPageByExceptionType(String exceptionType) {
        if (exceptionType != null) {
            EList lerrorPages = this.getErrorPages();
            for (ErrorPage ep : lerrorPages) {
                ExceptionTypeErrorPage etep;
                if (!ep.isExceptionType() || !exceptionType.equals((etep = (ExceptionTypeErrorPage)ep).getExceptionTypeName())) continue;
                return etep;
            }
        }
        return null;
    }

    public FilterMapping getFilterMapping(Filter aFilter) {
        if (aFilter != null) {
            EList mappings = this.getFilterMappings();
            for (int i = 0; i < mappings.size(); ++i) {
                FilterMapping mapping = (FilterMapping)mappings.get(i);
                if (!aFilter.equals(mapping.getFilter())) continue;
                return mapping;
            }
        }
        return null;
    }

    public Filter getFilterNamed(String name) {
        EList lfilters = this.getFilters();
        if (lfilters == null || lfilters.size() == 0) {
            return null;
        }
        for (int i = 0; i < lfilters.size(); ++i) {
            Filter next = (Filter)lfilters.get(i);
            if (!next.getName().equals(name)) continue;
            return next;
        }
        return null;
    }

    public List getFilterNames() {
        EList lfilters = this.getFilters();
        ArrayList<String> names = new ArrayList<String>(lfilters.size());
        for (int i = 0; i < lfilters.size(); ++i) {
            Filter next = (Filter)lfilters.get(i);
            names.add(next.getName());
        }
        return names;
    }

    public String getMimeType(String extension2) {
        if (extension2 != null) {
            EList mappings = this.getMimeMappings();
            for (int i = 0; i < mappings.size(); ++i) {
                MimeMapping mapping = (MimeMapping)mappings.get(i);
                if (!extension2.equals(mapping.getExtension())) continue;
                return mapping.getMimeType();
            }
        }
        return null;
    }

    public SecurityRole getSecurityRoleNamed(String roleName) {
        EList tempRoles = this.getSecurityRoles();
        for (int i = 0; i < tempRoles.size(); ++i) {
            SecurityRole role = (SecurityRole)tempRoles.get(i);
            if (!role.getRoleName().equals(roleName)) continue;
            return role;
        }
        return null;
    }

    public ServletMapping getServletMapping(Servlet aServlet) {
        if (aServlet != null) {
            EList mappings = this.getServletMappings();
            for (int i = 0; i < mappings.size(); ++i) {
                ServletMapping mapping = (ServletMapping)mappings.get(i);
                if (!aServlet.equals(mapping.getServlet())) continue;
                return mapping;
            }
        }
        return null;
    }

    public Servlet getServletNamed(String name) {
        EList lservlets = this.getServlets();
        if (lservlets == null || lservlets.size() == 0) {
            return null;
        }
        for (int i = 0; i < lservlets.size(); ++i) {
            Servlet next = (Servlet)lservlets.get(i);
            String nextName = next.getServletName();
            if (nextName == null || !nextName.equals(name)) continue;
            return next;
        }
        return null;
    }

    public List getServletNames() {
        EList lservlets = this.getServlets();
        ArrayList<String> names = new ArrayList<String>(lservlets.size());
        for (int i = 0; i < lservlets.size(); ++i) {
            Servlet next = (Servlet)lservlets.get(i);
            names.add(next.getServletName());
        }
        return names;
    }

    public boolean isVersion2_2Descriptor() {
        CommonUtil.checkDDObjectForVersion(this);
        String systemId = ((XMLResource)this.eResource()).getSystemId();
        return systemId == null ? false : systemId.equals("http://java.sun.com/j2ee/dtds/web-app_2_2.dtd");
    }

    public boolean isVersion2_3Descriptor() {
        CommonUtil.checkDDObjectForVersion(this);
        String systemId = ((XMLResource)this.eResource()).getSystemId();
        return systemId == null ? false : systemId.equals("http://java.sun.com/dtd/web-app_2_3.dtd");
    }

    public void renameSecurityRole(String existingRoleName, String newRoleName) {
        SecurityRole role = this.getSecurityRoleNamed(existingRoleName);
        if (role != null) {
            role.setRoleName(newRoleName);
        }
        EList theServlets = this.getServlets();
        for (int i = 0; i < theServlets.size(); ++i) {
            Servlet servlet = (Servlet)theServlets.get(i);
            servlet.reSyncSecurityRoleRef(existingRoleName, newRoleName);
        }
    }

    public boolean isDistributable() {
        return this.distributable;
    }

    public void setDistributable(boolean newDistributable) {
        boolean oldDistributable = this.distributable;
        this.distributable = newDistributable;
        boolean oldDistributableESet = this.distributableESet;
        this.distributableESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 18, oldDistributable, this.distributable, !oldDistributableESet));
        }
    }

    public void unsetDistributable() {
        boolean oldDistributable = this.distributable;
        boolean oldDistributableESet = this.distributableESet;
        this.distributable = false;
        this.distributableESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 2, 18, oldDistributable, false, oldDistributableESet));
        }
    }

    public boolean isSetDistributable() {
        return this.distributableESet;
    }

    public void setDisplayName(String newDisplayName) {
        super.setDisplayName(newDisplayName);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String newVersion) {
        String oldVersion = this.version;
        this.version = newVersion;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 19, (Object)oldVersion, (Object)this.version));
        }
    }

    public boolean isMetadataComplete() {
        return this.metadataComplete;
    }

    public void setMetadataComplete(boolean newMetadataComplete) {
        boolean oldMetadataComplete = this.metadataComplete;
        this.metadataComplete = newMetadataComplete;
        boolean oldMetadataCompleteESet = this.metadataCompleteESet;
        this.metadataCompleteESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 20, oldMetadataComplete, this.metadataComplete, !oldMetadataCompleteESet));
        }
    }

    public void unsetMetadataComplete() {
        boolean oldMetadataComplete = this.metadataComplete;
        boolean oldMetadataCompleteESet = this.metadataCompleteESet;
        this.metadataComplete = false;
        this.metadataCompleteESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 2, 20, oldMetadataComplete, false, oldMetadataCompleteESet));
        }
    }

    public boolean isSetMetadataComplete() {
        return this.metadataCompleteESet;
    }

    public EList getContexts() {
        if (this.contexts == null) {
            this.contexts = new EObjectContainmentWithInverseEList(ContextParam.class, this, 21, 3);
        }
        return this.contexts;
    }

    public EList getErrorPages() {
        if (this.errorPages == null) {
            this.errorPages = new EObjectContainmentWithInverseEList(ErrorPage.class, this, 22, 1);
        }
        return this.errorPages;
    }

    public WelcomeFileList getFileList() {
        return this.fileList;
    }

    public NotificationChain basicSetFileList(WelcomeFileList newFileList, NotificationChain msgs) {
        WelcomeFileList oldFileList = this.fileList;
        this.fileList = newFileList;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 23, (Object)oldFileList, (Object)newFileList);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add(notification);
            }
        }
        return msgs;
    }

    public void setFileList(WelcomeFileList newFileList) {
        if (newFileList != this.fileList) {
            NotificationChain msgs = null;
            if (this.fileList != null) {
                msgs = ((InternalEObject)((Object)this.fileList)).eInverseRemove(this, 0, WelcomeFileList.class, msgs);
            }
            if (newFileList != null) {
                msgs = ((InternalEObject)((Object)newFileList)).eInverseAdd(this, 0, WelcomeFileList.class, msgs);
            }
            if ((msgs = this.basicSetFileList(newFileList, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 23, (Object)newFileList, (Object)newFileList));
        }
    }

    public EList getTagLibs() {
        if (this.tagLibs == null) {
            this.tagLibs = new EObjectContainmentWithInverseEList(TagLibRef.class, this, 24, 2);
        }
        return this.tagLibs;
    }

    public EList getConstraints() {
        if (this.constraints == null) {
            this.constraints = new EObjectContainmentWithInverseEList(SecurityConstraint.class, this, 25, 1);
        }
        return this.constraints;
    }

    public int getVersionID() throws IllegalStateException {
        J2EEVersionResource res = (J2EEVersionResource)((Object)this.eResource());
        if (res == null) {
            if (this.version == null) {
                throw new IllegalStateException();
            }
            if (this.version.equals("2.4")) {
                return 24;
            }
            if (this.version.equals("2.3")) {
                return 23;
            }
            if (this.version.equals("2.2")) {
                return 22;
            }
        }
        return res.getModuleVersionID();
    }

    public LoginConfig getLoginConfig() {
        return this.loginConfig;
    }

    public NotificationChain basicSetLoginConfig(LoginConfig newLoginConfig, NotificationChain msgs) {
        LoginConfig oldLoginConfig = this.loginConfig;
        this.loginConfig = newLoginConfig;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 26, (Object)oldLoginConfig, (Object)newLoginConfig);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add(notification);
            }
        }
        return msgs;
    }

    public void setLoginConfig(LoginConfig newLoginConfig) {
        if (newLoginConfig != this.loginConfig) {
            NotificationChain msgs = null;
            if (this.loginConfig != null) {
                msgs = ((InternalEObject)((Object)this.loginConfig)).eInverseRemove(this, 3, LoginConfig.class, msgs);
            }
            if (newLoginConfig != null) {
                msgs = ((InternalEObject)((Object)newLoginConfig)).eInverseAdd(this, 3, LoginConfig.class, msgs);
            }
            if ((msgs = this.basicSetLoginConfig(newLoginConfig, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 26, (Object)newLoginConfig, (Object)newLoginConfig));
        }
    }

    public EList getMimeMappings() {
        if (this.mimeMappings == null) {
            this.mimeMappings = new EObjectContainmentWithInverseEList(MimeMapping.class, this, 27, 2);
        }
        return this.mimeMappings;
    }

    public SessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    public NotificationChain basicSetSessionConfig(SessionConfig newSessionConfig, NotificationChain msgs) {
        SessionConfig oldSessionConfig = this.sessionConfig;
        this.sessionConfig = newSessionConfig;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 28, (Object)oldSessionConfig, (Object)newSessionConfig);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add(notification);
            }
        }
        return msgs;
    }

    public void setSessionConfig(SessionConfig newSessionConfig) {
        if (newSessionConfig != this.sessionConfig) {
            NotificationChain msgs = null;
            if (this.sessionConfig != null) {
                msgs = ((InternalEObject)((Object)this.sessionConfig)).eInverseRemove(this, 1, SessionConfig.class, msgs);
            }
            if (newSessionConfig != null) {
                msgs = ((InternalEObject)((Object)newSessionConfig)).eInverseAdd(this, 1, SessionConfig.class, msgs);
            }
            if ((msgs = this.basicSetSessionConfig(newSessionConfig, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 28, (Object)newSessionConfig, (Object)newSessionConfig));
        }
    }

    public EList getServletMappings() {
        if (this.servletMappings == null) {
            this.servletMappings = new EObjectContainmentWithInverseEList(ServletMapping.class, this, 29, 3);
        }
        return this.servletMappings;
    }

    public EList getServlets() {
        if (this.servlets == null) {
            this.servlets = new EObjectContainmentWithInverseEList(Servlet.class, this, 30, 9);
        }
        return this.servlets;
    }

    public EList getSecurityRoles() {
        if (this.securityRoles == null) {
            this.securityRoles = new EObjectContainmentEList(SecurityRole.class, this, 31);
        }
        return this.securityRoles;
    }

    public EList getFilters() {
        if (this.filters == null) {
            this.filters = new EObjectContainmentEList(Filter.class, this, 32);
        }
        return this.filters;
    }

    public EList getFilterMappings() {
        if (this.filterMappings == null) {
            this.filterMappings = new EObjectContainmentEList(FilterMapping.class, this, 33);
        }
        return this.filterMappings;
    }

    public EList getListeners() {
        if (this.listeners == null) {
            this.listeners = new EObjectContainmentEList(Listener.class, this, 34);
        }
        return this.listeners;
    }

    public EList getContextParams() {
        if (this.contextParams == null) {
            this.contextParams = new EObjectContainmentEList(ParamValue.class, this, 35);
        }
        return this.contextParams;
    }

    public EList getEnvEntries() {
        return this.getEnvironmentProperties();
    }

    public JSPConfig getJspConfig() {
        return this.jspConfig;
    }

    public NotificationChain basicSetJspConfig(JSPConfig newJspConfig, NotificationChain msgs) {
        JSPConfig oldJspConfig = this.jspConfig;
        this.jspConfig = newJspConfig;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 36, (Object)oldJspConfig, (Object)newJspConfig);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add(notification);
            }
        }
        return msgs;
    }

    public void setJspConfig(JSPConfig newJspConfig) {
        if (newJspConfig != this.jspConfig) {
            NotificationChain msgs = null;
            if (this.jspConfig != null) {
                msgs = ((InternalEObject)((Object)this.jspConfig)).eInverseRemove(this, -37, null, msgs);
            }
            if (newJspConfig != null) {
                msgs = ((InternalEObject)((Object)newJspConfig)).eInverseAdd(this, -37, null, msgs);
            }
            if ((msgs = this.basicSetJspConfig(newJspConfig, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 36, (Object)newJspConfig, (Object)newJspConfig));
        }
    }

    public EList getMessageDestinations() {
        if (this.messageDestinations == null) {
            this.messageDestinations = new EObjectContainmentEList(MessageDestination.class, this, 37);
        }
        return this.messageDestinations;
    }

    public LocalEncodingMappingList getLocalEncodingMappingList() {
        return this.localEncodingMappingList;
    }

    public NotificationChain basicSetLocalEncodingMappingList(LocalEncodingMappingList newLocalEncodingMappingList, NotificationChain msgs) {
        LocalEncodingMappingList oldLocalEncodingMappingList = this.localEncodingMappingList;
        this.localEncodingMappingList = newLocalEncodingMappingList;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 38, (Object)oldLocalEncodingMappingList, (Object)newLocalEncodingMappingList);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add(notification);
            }
        }
        return msgs;
    }

    public void setLocalEncodingMappingList(LocalEncodingMappingList newLocalEncodingMappingList) {
        if (newLocalEncodingMappingList != this.localEncodingMappingList) {
            NotificationChain msgs = null;
            if (this.localEncodingMappingList != null) {
                msgs = ((InternalEObject)((Object)this.localEncodingMappingList)).eInverseRemove(this, -39, null, msgs);
            }
            if (newLocalEncodingMappingList != null) {
                msgs = ((InternalEObject)((Object)newLocalEncodingMappingList)).eInverseAdd(this, -39, null, msgs);
            }
            if ((msgs = this.basicSetLocalEncodingMappingList(newLocalEncodingMappingList, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 38, (Object)newLocalEncodingMappingList, (Object)newLocalEncodingMappingList));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 21: {
                return ((InternalEList)this.getContexts()).basicAdd(otherEnd, msgs);
            }
            case 22: {
                return ((InternalEList)this.getErrorPages()).basicAdd(otherEnd, msgs);
            }
            case 23: {
                if (this.fileList != null) {
                    msgs = ((InternalEObject)((Object)this.fileList)).eInverseRemove(this, -24, null, msgs);
                }
                return this.basicSetFileList((WelcomeFileList)((Object)otherEnd), msgs);
            }
            case 24: {
                return ((InternalEList)this.getTagLibs()).basicAdd(otherEnd, msgs);
            }
            case 25: {
                return ((InternalEList)this.getConstraints()).basicAdd(otherEnd, msgs);
            }
            case 26: {
                if (this.loginConfig != null) {
                    msgs = ((InternalEObject)((Object)this.loginConfig)).eInverseRemove(this, -27, null, msgs);
                }
                return this.basicSetLoginConfig((LoginConfig)((Object)otherEnd), msgs);
            }
            case 27: {
                return ((InternalEList)this.getMimeMappings()).basicAdd(otherEnd, msgs);
            }
            case 28: {
                if (this.sessionConfig != null) {
                    msgs = ((InternalEObject)((Object)this.sessionConfig)).eInverseRemove(this, -29, null, msgs);
                }
                return this.basicSetSessionConfig((SessionConfig)((Object)otherEnd), msgs);
            }
            case 29: {
                return ((InternalEList)this.getServletMappings()).basicAdd(otherEnd, msgs);
            }
            case 30: {
                return ((InternalEList)this.getServlets()).basicAdd(otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 21: {
                return ((InternalEList)this.getContexts()).basicRemove(otherEnd, msgs);
            }
            case 22: {
                return ((InternalEList)this.getErrorPages()).basicRemove(otherEnd, msgs);
            }
            case 23: {
                return this.basicSetFileList(null, msgs);
            }
            case 24: {
                return ((InternalEList)this.getTagLibs()).basicRemove(otherEnd, msgs);
            }
            case 25: {
                return ((InternalEList)this.getConstraints()).basicRemove(otherEnd, msgs);
            }
            case 26: {
                return this.basicSetLoginConfig(null, msgs);
            }
            case 27: {
                return ((InternalEList)this.getMimeMappings()).basicRemove(otherEnd, msgs);
            }
            case 28: {
                return this.basicSetSessionConfig(null, msgs);
            }
            case 29: {
                return ((InternalEList)this.getServletMappings()).basicRemove(otherEnd, msgs);
            }
            case 30: {
                return ((InternalEList)this.getServlets()).basicRemove(otherEnd, msgs);
            }
            case 31: {
                return ((InternalEList)this.getSecurityRoles()).basicRemove(otherEnd, msgs);
            }
            case 32: {
                return ((InternalEList)this.getFilters()).basicRemove(otherEnd, msgs);
            }
            case 33: {
                return ((InternalEList)this.getFilterMappings()).basicRemove(otherEnd, msgs);
            }
            case 34: {
                return ((InternalEList)this.getListeners()).basicRemove(otherEnd, msgs);
            }
            case 35: {
                return ((InternalEList)this.getContextParams()).basicRemove(otherEnd, msgs);
            }
            case 36: {
                return this.basicSetJspConfig(null, msgs);
            }
            case 37: {
                return ((InternalEList)this.getMessageDestinations()).basicRemove(otherEnd, msgs);
            }
            case 38: {
                return this.basicSetLocalEncodingMappingList(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 18: {
                return this.isDistributable() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 19: {
                return this.getVersion();
            }
            case 20: {
                return this.isMetadataComplete() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 21: {
                return this.getContexts();
            }
            case 22: {
                return this.getErrorPages();
            }
            case 23: {
                return this.getFileList();
            }
            case 24: {
                return this.getTagLibs();
            }
            case 25: {
                return this.getConstraints();
            }
            case 26: {
                return this.getLoginConfig();
            }
            case 27: {
                return this.getMimeMappings();
            }
            case 28: {
                return this.getSessionConfig();
            }
            case 29: {
                return this.getServletMappings();
            }
            case 30: {
                return this.getServlets();
            }
            case 31: {
                return this.getSecurityRoles();
            }
            case 32: {
                return this.getFilters();
            }
            case 33: {
                return this.getFilterMappings();
            }
            case 34: {
                return this.getListeners();
            }
            case 35: {
                return this.getContextParams();
            }
            case 36: {
                return this.getJspConfig();
            }
            case 37: {
                return this.getMessageDestinations();
            }
            case 38: {
                return this.getLocalEncodingMappingList();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 18: {
                this.setDistributable((Boolean)newValue);
                return;
            }
            case 19: {
                this.setVersion((String)newValue);
                return;
            }
            case 20: {
                this.setMetadataComplete((Boolean)newValue);
                return;
            }
            case 21: {
                this.getContexts().clear();
                this.getContexts().addAll((Collection)newValue);
                return;
            }
            case 22: {
                this.getErrorPages().clear();
                this.getErrorPages().addAll((Collection)newValue);
                return;
            }
            case 23: {
                this.setFileList((WelcomeFileList)newValue);
                return;
            }
            case 24: {
                this.getTagLibs().clear();
                this.getTagLibs().addAll((Collection)newValue);
                return;
            }
            case 25: {
                this.getConstraints().clear();
                this.getConstraints().addAll((Collection)newValue);
                return;
            }
            case 26: {
                this.setLoginConfig((LoginConfig)newValue);
                return;
            }
            case 27: {
                this.getMimeMappings().clear();
                this.getMimeMappings().addAll((Collection)newValue);
                return;
            }
            case 28: {
                this.setSessionConfig((SessionConfig)newValue);
                return;
            }
            case 29: {
                this.getServletMappings().clear();
                this.getServletMappings().addAll((Collection)newValue);
                return;
            }
            case 30: {
                this.getServlets().clear();
                this.getServlets().addAll((Collection)newValue);
                return;
            }
            case 31: {
                this.getSecurityRoles().clear();
                this.getSecurityRoles().addAll((Collection)newValue);
                return;
            }
            case 32: {
                this.getFilters().clear();
                this.getFilters().addAll((Collection)newValue);
                return;
            }
            case 33: {
                this.getFilterMappings().clear();
                this.getFilterMappings().addAll((Collection)newValue);
                return;
            }
            case 34: {
                this.getListeners().clear();
                this.getListeners().addAll((Collection)newValue);
                return;
            }
            case 35: {
                this.getContextParams().clear();
                this.getContextParams().addAll((Collection)newValue);
                return;
            }
            case 36: {
                this.setJspConfig((JSPConfig)newValue);
                return;
            }
            case 37: {
                this.getMessageDestinations().clear();
                this.getMessageDestinations().addAll((Collection)newValue);
                return;
            }
            case 38: {
                this.setLocalEncodingMappingList((LocalEncodingMappingList)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 18: {
                this.unsetDistributable();
                return;
            }
            case 19: {
                this.setVersion(VERSION_EDEFAULT);
                return;
            }
            case 20: {
                this.unsetMetadataComplete();
                return;
            }
            case 21: {
                this.getContexts().clear();
                return;
            }
            case 22: {
                this.getErrorPages().clear();
                return;
            }
            case 23: {
                this.setFileList(null);
                return;
            }
            case 24: {
                this.getTagLibs().clear();
                return;
            }
            case 25: {
                this.getConstraints().clear();
                return;
            }
            case 26: {
                this.setLoginConfig(null);
                return;
            }
            case 27: {
                this.getMimeMappings().clear();
                return;
            }
            case 28: {
                this.setSessionConfig(null);
                return;
            }
            case 29: {
                this.getServletMappings().clear();
                return;
            }
            case 30: {
                this.getServlets().clear();
                return;
            }
            case 31: {
                this.getSecurityRoles().clear();
                return;
            }
            case 32: {
                this.getFilters().clear();
                return;
            }
            case 33: {
                this.getFilterMappings().clear();
                return;
            }
            case 34: {
                this.getListeners().clear();
                return;
            }
            case 35: {
                this.getContextParams().clear();
                return;
            }
            case 36: {
                this.setJspConfig(null);
                return;
            }
            case 37: {
                this.getMessageDestinations().clear();
                return;
            }
            case 38: {
                this.setLocalEncodingMappingList(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 18: {
                return this.isSetDistributable();
            }
            case 19: {
                return VERSION_EDEFAULT == null ? this.version != null : !VERSION_EDEFAULT.equals(this.version);
            }
            case 20: {
                return this.isSetMetadataComplete();
            }
            case 21: {
                return this.contexts != null && !this.contexts.isEmpty();
            }
            case 22: {
                return this.errorPages != null && !this.errorPages.isEmpty();
            }
            case 23: {
                return this.fileList != null;
            }
            case 24: {
                return this.tagLibs != null && !this.tagLibs.isEmpty();
            }
            case 25: {
                return this.constraints != null && !this.constraints.isEmpty();
            }
            case 26: {
                return this.loginConfig != null;
            }
            case 27: {
                return this.mimeMappings != null && !this.mimeMappings.isEmpty();
            }
            case 28: {
                return this.sessionConfig != null;
            }
            case 29: {
                return this.servletMappings != null && !this.servletMappings.isEmpty();
            }
            case 30: {
                return this.servlets != null && !this.servlets.isEmpty();
            }
            case 31: {
                return this.securityRoles != null && !this.securityRoles.isEmpty();
            }
            case 32: {
                return this.filters != null && !this.filters.isEmpty();
            }
            case 33: {
                return this.filterMappings != null && !this.filterMappings.isEmpty();
            }
            case 34: {
                return this.listeners != null && !this.listeners.isEmpty();
            }
            case 35: {
                return this.contextParams != null && !this.contextParams.isEmpty();
            }
            case 36: {
                return this.jspConfig != null;
            }
            case 37: {
                return this.messageDestinations != null && !this.messageDestinations.isEmpty();
            }
            case 38: {
                return this.localEncodingMappingList != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer("\n\nWAR File deployment descriptor   [ ");
        result.append(this.getClass().getName() + '@' + Integer.toHexString(this.hashCode())).append(" ]\n\n");
        result.append("  *Resource           [ " + this.eResource() + " ]\n");
        result.append("  Version             [ " + this.version + " ]\n");
        try {
            result.append("  Version ID          [ " + this.getVersionID() + " ]\n");
        }
        catch (IllegalStateException e) {
            result.append("  Version ID          [ ERROR: cannot be calculated - IllegalStateException ]\n");
        }
        result.append("  Metadata Complete   [ ");
        result.append(this.metadataComplete);
        result.append(" ]\n");
        result.append("  Distributable       [ ");
        if (this.distributableESet) {
            result.append(this.distributable);
        } else {
            result.append("<unset>");
        }
        result.append(" ]\n");
        if (this.securityRoles != null) {
            result.append("\n  WAR contains [ " + this.securityRoles.size() + " ] security roles\n");
            for (SecurityRole sr : this.securityRoles) {
                if (sr != null) {
                    result.append(sr);
                    continue;
                }
                result.append("  Security Role        [ " + sr + " ]\n");
            }
        } else {
            result.append("\n  WAR contains no security roles\n");
        }
        result.append("\n");
        return result.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        WebApp webAppClone = (WebApp)super.clone();
        this.patchClone(this, webAppClone);
        return webAppClone;
    }

    protected HashMap getServletMap() {
        HashMap<String, Servlet> servletMap = new HashMap<String, Servlet>();
        for (Servlet nextServlet : this.getServlets()) {
            servletMap.put(nextServlet.getServletName(), nextServlet);
        }
        return servletMap;
    }

    protected void patchClone(WebApp webApp, WebApp webAppClone) {
        HashMap servletMap = this.getServletMap();
        Iterator useFilterMappings = webApp.getFilterMappings().iterator();
        Iterator cloneFilterMappings = webAppClone.getFilterMappings().iterator();
        while (useFilterMappings.hasNext()) {
            FilterMapping nextFilterMapping = (FilterMapping)useFilterMappings.next();
            FilterMapping nextCloneFilterMapping = (FilterMapping)cloneFilterMappings.next();
            this.patchClone(servletMap, nextFilterMapping, nextCloneFilterMapping);
        }
    }

    protected void patchClone(HashMap servletMap, FilterMapping filterMapping, FilterMapping cloneFilterMapping) {
        Servlet firstMappedServlet = null;
        Servlet lastMappedServlet = null;
        int numServlets = 0;
        for (Servlet nextServlet : cloneFilterMapping.getServlets()) {
            if (numServlets == 0) {
                firstMappedServlet = nextServlet;
            }
            lastMappedServlet = nextServlet;
            ++numServlets;
        }
        if (numServlets > 1) {
            cloneFilterMapping.getServlets().remove(numServlets - 1);
        }
        for (String nextServletName : filterMapping.getServletNames()) {
            if (servletMap.containsKey(nextServletName)) continue;
            cloneFilterMapping.getServlets().add(nextServletName);
        }
    }

    public void storeJ2EEVersionID() throws IllegalStateException {
        String methodName = "storeJ2EEVersionID";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        if (this._J2EEVersionIDStored) {
            logger.logp(Level.FINER, className, methodName, "RETURN J2EE version ID value already stored [ {0} ]", this._storedJ2EEVersionID);
            return;
        }
        J2EEVersionResource res = (J2EEVersionResource)((Object)this.eResource());
        if (res == null) {
            logger.logp(Level.FINER, className, methodName, "RETURN Throwing IllegalStateException as resource is null");
            throw new IllegalStateException("XMLResource is null");
        }
        this._storedJ2EEVersionID = res.getJ2EEVersionID();
        this._J2EEVersionIDStored = true;
        logger.logp(Level.FINER, className, methodName, "RETURN Stored [ {0} ]", this._storedJ2EEVersionID);
    }

    public int getJ2EEVersionID() throws IllegalStateException {
        if (!this._J2EEVersionIDStored) {
            this.storeJ2EEVersionID();
        }
        return this._storedJ2EEVersionID;
    }
}

