/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.webapplication.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.jst.j2ee.webapplication.FilterMapping;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class EServletList
extends EObjectResolvingEList {
    public static final String CONFIG_WTP_LOGGER = "com.ibm.config.eclipse.wtp";
    public static final String CONFIG_WTP_RESOURCE_BUNDLE = "commonarchive";
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp", "commonarchive");
    protected static final String CLASS_NAME = EServletList.class.getName();
    private static final long serialVersionUID = 1L;
    protected List servletNames;

    public EServletList(Class dataClass, InternalEObject owner, int featureID) {
        super(dataClass, owner, featureID);
        String methodName = "EServletList";
        logger.logp(Level.FINEST, CLASS_NAME, methodName, "Constructed for [ {0} ]", owner);
    }

    public void addUnique(Object object) {
        String methodName = "addUnique";
        logger.logp(Level.FINEST, CLASS_NAME, methodName, "Adding [ {0} ]", object);
        if (object instanceof String) {
            this.addServletName((String)object);
        } else {
            this.removeServletName((Servlet)object);
            super.addUnique(object);
        }
    }

    public void addUnique(int index, Object object) {
        String methodName = "addUnique";
        logger.logp(Level.FINEST, CLASS_NAME, methodName, "Adding [ {0} at {1} ]", new Object[]{object, new Integer(index)});
        if (object instanceof String) {
            this.addServletName((String)object);
        } else {
            this.removeServletName((Servlet)object);
            super.addUnique(index, object);
        }
    }

    protected List getRawServletNames() {
        return this.servletNames;
    }

    protected List getServletNames() {
        String methodName = "getServletNames";
        logger.logp(Level.FINEST, CLASS_NAME, methodName, "Entry");
        ArrayList<String> names = new ArrayList<String>();
        Object[] useMembers = this.toArray();
        for (int memberNo = 0; memberNo < useMembers.length; ++memberNo) {
            Servlet nextMember = (Servlet)useMembers[memberNo];
            String nextMemberName = nextMember.getServletName();
            names.add(nextMemberName);
            logger.logp(Level.FINEST, CLASS_NAME, methodName, "Adding name from servlet [ {0} ]", nextMemberName);
        }
        if (this.servletNames != null) {
            logger.logp(Level.FINEST, CLASS_NAME, methodName, "Adding names from raw servlet names collection.");
            for (String nextName : this.servletNames) {
                logger.logp(Level.FINEST, CLASS_NAME, methodName, "Adding name from raw servlet names [ {0} ]", nextName);
            }
            names.addAll(this.servletNames);
        }
        logger.logp(Level.FINEST, CLASS_NAME, methodName, "Exit");
        return names;
    }

    protected void addServletName(String servletName) {
        String methodName = "addServletName";
        logger.logp(Level.FINEST, CLASS_NAME, methodName, "Adding [ {0} ]", servletName);
        if (this.servletNames == null) {
            this.servletNames = new ArrayList();
        }
        this.servletNames.add(servletName);
    }

    protected boolean removeServletName(Servlet servlet) {
        String methodName = "removeServletName";
        logger.logp(Level.FINEST, CLASS_NAME, methodName, "Removing [ {0} ]", servlet);
        if (this.servletNames == null) {
            logger.logp(Level.FINEST, CLASS_NAME, methodName, "Null names list");
            return false;
        }
        int offset = this.servletNames.indexOf(servlet.getServletName());
        if (offset == -1) {
            logger.logp(Level.FINEST, CLASS_NAME, methodName, "Name not found");
            return false;
        }
        this.removeServletName(offset);
        return true;
    }

    protected void removeServletName(int offset) {
        String methodName = "removeServletName";
        logger.logp(Level.FINEST, CLASS_NAME, methodName, "Remove at offset", new Integer(offset));
        this.servletNames.remove(offset);
        if (this.servletNames.size() == 0) {
            this.servletNames = null;
        }
    }

    protected void resolveNames() {
        WebApp webApp;
        String methodName = "resolveNames";
        logger.logp(Level.FINEST, CLASS_NAME, methodName, "Entry");
        if (this.servletNames == null) {
            logger.logp(Level.FINEST, CLASS_NAME, methodName, "Null; no resolution");
            return;
        }
        int numServletNames = this.servletNames.size();
        if (numServletNames == 0) {
            logger.logp(Level.FINEST, CLASS_NAME, methodName, "Empty list; no resolution");
            this.servletNames = null;
        }
        if ((webApp = (WebApp)((FilterMapping)this.getNotifier()).eContainer()) == null) {
            logger.logp(Level.FINEST, CLASS_NAME, methodName, "Null container; no resolution");
            return;
        }
        for (int servletNameNo = 0; servletNameNo < numServletNames; ++servletNameNo) {
            String nextServletName = (String)this.servletNames.get(servletNameNo);
            Servlet nextServlet = webApp.getServletNamed(nextServletName);
            if (nextServlet != null) {
                logger.logp(Level.FINEST, CLASS_NAME, methodName, "Resolved [ {0} ]", nextServletName);
                this.removeServletName(servletNameNo);
                --numServletNames;
                --servletNameNo;
                super.addUnique(nextServlet);
                continue;
            }
            logger.logp(Level.FINEST, CLASS_NAME, methodName, "Unable to resolve [ {0} ]", nextServletName);
        }
    }

    public int size() {
        if (this.servletNames != null) {
            this.resolveNames();
        }
        return this.size;
    }

    public boolean isEmpty() {
        if (this.servletNames != null) {
            this.resolveNames();
        }
        return super.isEmpty();
    }

    public boolean contains(Object object) {
        if (this.servletNames != null) {
            this.resolveNames();
        }
        return super.contains(object);
    }

    public int indexOf(Object object) {
        if (this.servletNames != null) {
            this.resolveNames();
        }
        return super.indexOf(object);
    }

    public int lastIndexOf(Object object) {
        if (this.servletNames != null) {
            this.resolveNames();
        }
        return super.lastIndexOf(object);
    }

    public Object[] toArray() {
        if (this.servletNames != null) {
            this.resolveNames();
        }
        return super.toArray();
    }

    public Object[] toArray(Object[] array) {
        if (this.servletNames != null) {
            this.resolveNames();
        }
        return super.toArray(array);
    }

    public Object[] data() {
        if (this.servletNames != null) {
            this.resolveNames();
        }
        return super.data();
    }

    public Object get(int index) {
        if (this.servletNames != null) {
            this.resolveNames();
        }
        return super.get(index);
    }

    public Object basicGet(int index) {
        if (this.servletNames != null) {
            this.resolveNames();
        }
        return super.basicGet(index);
    }

    public boolean removeAll(Collection collection) {
        if (this.servletNames != null) {
            this.resolveNames();
        }
        return super.removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        if (this.servletNames != null) {
            this.resolveNames();
        }
        return super.retainAll(collection);
    }

    public void clear() {
        this.servletNames = null;
        super.clear();
    }

    public Object clone() {
        Object clone = super.clone();
        if (this.servletNames != null) {
            ArrayList newNames = new ArrayList();
            newNames.addAll(this.servletNames);
            ((EServletList)clone).servletNames = newNames;
        }
        return clone;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.servletNames != null) {
            this.resolveNames();
        }
        return super.equals(object);
    }

    public int hashCode() {
        if (this.servletNames != null) {
            this.resolveNames();
        }
        return super.hashCode();
    }

    public String toString() {
        if (this.servletNames != null) {
            this.resolveNames();
        }
        return super.toString();
    }

    public Iterator iterator() {
        if (this.servletNames != null) {
            this.resolveNames();
        }
        return super.iterator();
    }
}

