/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jem.internal.java.adapters.jdk.JavaJDKAdapterFactory;
import org.eclipse.jst.j2ee.common.internal.impl.J2EEResouceFactorySaxRegistry;
import org.eclipse.jst.j2ee.common.internal.impl.J2EEResourceFactoryDomRegistry;
import org.eclipse.jst.j2ee.common.internal.impl.J2EEResourceFactoryRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ArchiveTypeDiscriminatorRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveFactoryRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveURIConverterImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIterator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIteratorImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.TempZipFileLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveWrapperClassLoader;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseArchive;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseConfigRegister;
import org.eclipse.wst.common.internal.emf.utilities.ExtendedEcoreUtil;

public abstract class LoadStrategyImpl
extends AdapterImpl
implements LoadStrategy {
    protected static String className = LoadStrategyImpl.class.getName();
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp", "commonarchive");
    protected boolean isOpen = true;
    protected Container container;
    protected ResourceSet resourceSet;
    protected LooseArchive looseArchive;
    protected Map collectedLooseArchiveFiles = Collections.EMPTY_MAP;
    protected boolean readOnly = false;
    private int rendererType;

    public void addOrReplaceMofResource(Resource aResource) {
        Resource existingResource = this.getResourceSet().getResource(aResource.getURI(), false);
        if (existingResource != null) {
            this.getResourceSet().getResources().remove(existingResource);
        }
        this.getResourceSet().getResources().add(aResource);
    }

    protected void updateModificationTracking(Resource res) {
        boolean shouldTrackMods;
        boolean trackingMods = res.isTrackingModification();
        boolean isReadOnly = this.container != null ? ((Archive)this.container).getOptions().isReadOnly() : false;
        boolean bl = shouldTrackMods = !isReadOnly && !ArchiveUtil.isJavaResource(res) && !ArchiveUtil.isRegisteredURIMapping(res);
        if (shouldTrackMods && !trackingMods) {
            res.setTrackingModification(true);
        }
    }

    public void close() {
        this.setIsOpen(false);
        if (this.resourceSet != null && this.resourceSet.eAdapters().contains(this)) {
            this.resourceSet.eAdapters().remove(this);
        }
    }

    protected abstract boolean primContains(String var1);

    public boolean contains(String uri) {
        if (this.containsUsingLooseArchive(uri)) {
            return true;
        }
        return this.primContains(uri);
    }

    protected boolean containsUsingLooseArchive(String uri) {
        if (this.getLooseArchive() == null) {
            return false;
        }
        LooseArchive loose = this.getLooseArchive();
        if (loose.getResourcesPath() == null) {
            return false;
        }
        java.io.File aFile = new java.io.File(loose.getResourcesPath(), uri);
        if (aFile.exists()) {
            return true;
        }
        return LooseConfigRegister.singleton().findFirstLooseChild(uri, loose) != null;
    }

    protected File createDirectory(String uri) {
        File aFile = null;
        aFile = this.getArchiveFactory().createFile();
        aFile.setDirectoryEntry(true);
        aFile.setURI(uri);
        aFile.setOriginalURI(uri);
        aFile.setLoadingContainer(this.getContainer());
        return aFile;
    }

    protected File createFile(String uri, long size, long lastModified, boolean isDirectory) {
        String methodName = "createFile";
        File aFile = this.getArchiveFactory().createFile();
        aFile.setURI(uri);
        aFile.setOriginalURI(uri);
        aFile.setSize(size);
        aFile.setLastModified(lastModified);
        aFile.setDirectoryEntry(isDirectory);
        aFile.setLoadingContainer(this.getContainer());
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", aFile);
        return aFile;
    }

    protected File createFile(String uri, boolean permitNonRelativePaths) {
        return this.createFile(uri, null, permitNonRelativePaths, null, null);
    }

    protected File createFile(String uri) {
        return this.createFile(uri, null, false, null, null);
    }

    protected File createFile(String uri, String fullpath, boolean permitNonRelativePaths, java.io.File directory, String filename) {
        String methodName = "createFile";
        logger.logp(Level.FINER, className, methodName, "ENTRY URI [ {0} ]", uri);
        File aFile = null;
        if (permitNonRelativePaths && ArchiveTypeDiscriminatorRegistry.INSTANCE.isKnownArchiveType(uri)) {
            logger.logp(Level.FINER, className, methodName, "Opening non-relative path archive");
            CommonarchiveFactory factory = CommonarchiveFactory.eINSTANCE;
            String filepath = null;
            try {
                filepath = directory.getPath() + "/" + filename;
                LoadStrategy childStrategy = factory.createLoadStrategy(filepath);
                ArchiveOptions options = ((Archive)this.container).getOptions().cloneWith(childStrategy, uri);
                aFile = factory.openArchive(options, uri);
            }
            catch (OpenFailureException e) {
                logger.logp(Level.WARNING, className, methodName, "OpenFailureException creating [ {0} ]", filepath);
            }
            catch (FileNotFoundException e) {
                logger.logp(Level.WARNING, className, methodName, "FileNotFoundException creating [ {0} ]", filepath);
            }
            catch (IOException e) {
                logger.logp(Level.WARNING, className, methodName, "IOException creating [ {0} ]", filepath);
            }
        } else if (this.isArchive(uri)) {
            logger.logp(Level.FINER, className, methodName, "Opening nested archive");
            aFile = this.openNestedArchive(uri);
        }
        if (aFile == null) {
            logger.logp(Level.FINER, className, methodName, "Opening plain file");
            aFile = this.primCreateFile(uri);
        }
        aFile.setLoadingContainer(this.getContainer());
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", aFile);
        return aFile;
    }

    protected File primCreateFile(String uri) {
        File file = this.getArchiveFactory().createFile();
        file.setURI(uri);
        file.setOriginalURI(uri);
        return file;
    }

    protected File primCreateFile(String uri, java.io.File baseFile) {
        File file = this.primCreateFile(uri);
        file.setSize(baseFile.length());
        file.setLastModified(baseFile.lastModified());
        return file;
    }

    protected void finalize() throws Throwable {
        if (this.isOpen) {
            this.close();
        }
    }

    public String getAbsolutePath() throws FileNotFoundException {
        String methodName = "getAbsolutePath";
        logger.logp(Level.FINER, className, methodName, "ENTRY/RETURN Throwing FileNotFoundException");
        throw new FileNotFoundException(CommonArchiveResourceHandler.Absolute_path_unknown_EXC_);
    }

    public String getResourcesPath() throws FileNotFoundException {
        return this.getLooseArchive() == null ? this.getAbsolutePath() : this.getLooseArchive().getResourcesPath();
    }

    protected String primGetResourcesPath() {
        return this.getLooseResourcesPath();
    }

    protected String getLooseResourcesPath() {
        return this.getLooseArchive() == null ? null : this.getLooseArchive().getResourcesPath();
    }

    public String getBinariesPath() throws FileNotFoundException {
        String methodName = "getBinariesPath";
        String uri = this.container.getURI();
        logger.logp(Level.FINER, className, methodName, "ENTRY for archive [ {0} ]", uri);
        LooseArchive la = this.getLooseArchive();
        if (la != null) {
            String looseBinariesPath = la.getBinariesPath();
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ] from loose archive", looseBinariesPath);
            return looseBinariesPath;
        }
        logger.logp(Level.FINER, className, methodName, "No loose archive.");
        if (!this.container.isArchive()) {
            logger.logp(Level.FINER, className, methodName, "Non-archive case");
            String nonArchiveBinariesPath = this.getAbsolutePath();
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ] for non-archive from absolute path", nonArchiveBinariesPath);
            return nonArchiveBinariesPath;
        }
        logger.logp(Level.FINER, className, methodName, "Archive case");
        Archive archive = (Archive)this.container;
        ArchiveOptions ao = archive.getOptions();
        if (!archive.isEARFile()) {
            logger.logp(Level.FINER, className, methodName, "Non-EAR case");
            String archiveBinariesPath = ao.getParentEarBinariesPath();
            logger.logp(Level.FINER, className, methodName, "parentEarBinariesPath [ {0} ]", archiveBinariesPath);
            if (archiveBinariesPath != null) {
                logger.logp(Level.FINER, className, methodName, "Appending archive URI.");
                archiveBinariesPath = archiveBinariesPath + java.io.File.separatorChar + uri;
            } else {
                logger.logp(Level.FINER, className, methodName, "parentEarBinariesPath is not set; using absolute path.");
                archiveBinariesPath = this.getAbsolutePath();
            }
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ] non-EAR archive case", archiveBinariesPath);
            return archiveBinariesPath;
        }
        logger.logp(Level.FINER, className, methodName, "EAR case");
        String earBinariesPath = ao.getAltBinariesPath();
        logger.logp(Level.FINER, className, methodName, "altBinariesPath [ {0} ]", earBinariesPath);
        if (earBinariesPath == null) {
            logger.logp(Level.FINER, className, methodName, "altBinariesPath is not set; using absolute path.");
            earBinariesPath = this.getAbsolutePath();
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ] EAR case", earBinariesPath);
        return earBinariesPath;
    }

    public CommonarchiveFactory getArchiveFactory() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory();
    }

    public Archive getArchive() {
        return (Archive)this.container;
    }

    public Container getContainer() {
        return this.container;
    }

    public ResourceSet primGetResourceSet() {
        return this.resourceSet;
    }

    public boolean requiresIterationOnSave() {
        if (!this.getContainer().isArchive() || this.isDirectory()) {
            return true;
        }
        Archive anArchive = (Archive)this.getContainer();
        if (anArchive.isModuleFile()) {
            ModuleFile moduleFile = (ModuleFile)anArchive;
            if (moduleFile.requiresIterationOnSave()) {
                return true;
            }
            return !anArchive.getOptions().isReadOnly();
        }
        if (anArchive.getOptions().isSaveLibrariesAsFiles() && anArchive.getLoadingContainer() != null) {
            if (anArchive.isIndexed()) {
                EList files = anArchive.getFiles();
                File aFile = null;
                Container firstContainer = null;
                Container lContainer = null;
                for (int i = 0; i < files.size(); ++i) {
                    aFile = (File)files.get(i);
                    if (i == 0 && (firstContainer = aFile.getLoadingContainer()).getLoadStrategy().isDirectory()) {
                        return true;
                    }
                    lContainer = aFile.getLoadingContainer();
                    if (lContainer == firstContainer) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public ResourceSet getResourceSet() {
        String methodName = "getResourceSet";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        if (this.resourceSet == null) {
            this.initializeResourceSet();
            this.resourceSet.eAdapters().add(this);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", this.resourceSet);
        return this.resourceSet;
    }

    public void notifyChanged(Notification msg) {
        switch (msg.getEventType()) {
            case 3: {
                this.updateModificationTracking((Resource)msg.getNewValue());
                break;
            }
            case 5: {
                List list = (List)msg.getNewValue();
                for (int i = 0; i < list.size(); ++i) {
                    this.updateModificationTracking((Resource)list.get(i));
                }
                break;
            }
        }
    }

    public FileIterator getFileIterator() throws IOException {
        return new FileIteratorImpl(this.getContainer().getFiles());
    }

    public FileIterator getFileIteratorDirect() throws IOException {
        return this.getFileIterator();
    }

    public void closeFileIteratorDirect(FileIterator it) throws IOException {
    }

    public abstract List getFiles();

    public List collectFiles() {
        String methodName = "collectFiles";
        String containerURI = "unknown";
        if (this.container != null) {
            containerURI = this.container.getURI();
        }
        logger.logp(Level.FINER, className, methodName, "ENTRY - URI [ {0} ]", containerURI);
        this.collectFilesFromLooseArchives();
        List files = this.getFiles();
        if (logger.isLoggable(Level.FINEST)) {
            StringBuffer msgBuffer = new StringBuffer();
            msgBuffer.append("getFiles collected files:\n");
            Iterator i = files.iterator();
            while (i.hasNext()) {
                msgBuffer.append(i.next());
                msgBuffer.append("\n");
            }
            logger.logp(Level.FINEST, className, methodName, msgBuffer.toString());
        }
        files.addAll(this.collectedLooseArchiveFiles.values());
        this.collectedLooseArchiveFiles = Collections.EMPTY_MAP;
        this.collectFilesFromBinaries(files);
        logger.logp(Level.FINER, className, methodName, "RETURN Collected a total of [ {0} ] files", Integer.toString(files.size()));
        return files;
    }

    protected void collectFilesFromBinaries(List filesSoFar) {
    }

    protected void collectFilesFromLooseArchives() {
        String methodName = "collectFilesFromLooseArchives";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        if (!this.canHaveLooseChildren() || this.getLooseArchive() == null) {
            this.collectedLooseArchiveFiles = Collections.EMPTY_MAP;
            logger.logp(Level.FINER, className, methodName, "RETURN No loose archive files to collect");
            return;
        }
        this.collectedLooseArchiveFiles = new HashMap();
        LooseArchive useLooseArchive = this.getLooseArchive();
        List children = LooseConfigRegister.singleton().getLooseChildren(useLooseArchive);
        for (int i = 0; i < children.size(); ++i) {
            Archive archive;
            LooseArchive loose = (LooseArchive)children.get(i);
            String uri = loose.getUri();
            if (this.collectedLooseArchiveFiles.containsKey(uri) || (archive = this.openNestedArchive(loose)) == null) continue;
            this.collectedLooseArchiveFiles.put(uri, archive);
            archive.setLoadingContainer(this.getContainer());
        }
        if (logger.isLoggable(Level.FINEST)) {
            StringBuffer msgBuffer = new StringBuffer();
            msgBuffer.append("collectFilesFromLooseArchives collected files:\n");
            Iterator i = this.collectedLooseArchiveFiles.values().iterator();
            while (i.hasNext()) {
                msgBuffer.append(i.next());
                msgBuffer.append("\n");
            }
            logger.logp(Level.FINEST, className, methodName, msgBuffer.toString());
        }
        logger.logp(Level.FINER, className, methodName, "RETURN Collected [ {0} ] loose archive files", Integer.toString(this.collectedLooseArchiveFiles.size()));
    }

    public abstract InputStream getInputStream(String var1) throws IOException, FileNotFoundException;

    public InputStream getResourceInputStream(String uri) throws IOException {
        return this.getResourceSet().getURIConverter().createInputStream(URI.createURI(uri));
    }

    public Collection getLoadedMofResources() {
        EList resources = this.getResourceSet().getResources();
        if (resources.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Resource> result = new ArrayList<Resource>(resources.size());
        for (Resource res : resources) {
            if (!res.isLoaded()) continue;
            result.add(res);
        }
        return result;
    }

    public Resource getMofResource(String uri) throws FileNotFoundException, ResourceLoadException {
        try {
            return this.getResourceSet().getResource(URI.createURI(uri), true);
        }
        catch (WrappedException wrapEx) {
            if (ExtendedEcoreUtil.getFileNotFoundDetector().isFileNotFound(wrapEx)) {
                FileNotFoundException fileNotFoundEx = ExtendedEcoreUtil.getInnerFileNotFoundException(wrapEx);
                throw fileNotFoundEx;
            }
            this.throwResourceLoadException(uri, wrapEx);
            return null;
        }
    }

    protected void initializeResourceSet() {
        String methodName = "initializeResourceSet";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        Archive archive = (Archive)this.getContainer();
        ArchiveURIConverterImpl converter = new ArchiveURIConverterImpl(archive, this.primGetResourcesPath());
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource.Factory.Registry reg = this.createResourceFactoryRegistry();
        rs.setResourceFactoryRegistry(reg);
        this.setResourceSet(rs);
        rs.setURIConverter(converter);
        if (archive.shouldUseJavaReflection()) {
            JavaJDKAdapterFactory adapterFactory = new JavaJDKAdapterFactory();
            adapterFactory.setContextClassLoader(this.getWrapperClassLoader(archive));
            adapterFactory.flushAll();
            rs.getAdapterFactories().add(adapterFactory);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    protected ClassLoader getWrapperClassLoader(Archive archive) {
        return new ArchiveWrapperClassLoader(archive);
    }

    protected Resource.Factory.Registry createResourceFactoryRegistry() {
        if (this.isReadOnly()) {
            return new J2EEResouceFactorySaxRegistry();
        }
        J2EEResourceFactoryRegistry registry = null;
        switch (this.getRendererType()) {
            case 1: {
                registry = new J2EEResouceFactorySaxRegistry();
                break;
            }
            case 2: {
                registry = new J2EEResourceFactoryDomRegistry();
                break;
            }
            default: {
                registry = new J2EEResourceFactoryRegistry();
            }
        }
        return registry;
    }

    public int getRendererType() {
        return this.rendererType;
    }

    protected boolean isArchive(String uri) {
        return ((Archive)this.getContainer()).isNestedArchive(uri);
    }

    public boolean isClassLoaderNeeded() {
        return true;
    }

    public boolean isDirectory() {
        return false;
    }

    public Resource getExistingMofResource(String uri) {
        return this.getResourceSet().getResource(URI.createURI(uri), false);
    }

    public boolean isMofResourceLoaded(String uri) {
        Resource res = this.getExistingMofResource(uri);
        return res != null && res.isLoaded();
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean isUsing(java.io.File aSystemFile) {
        return false;
    }

    public Resource makeMofResource(String uri, EList extent) {
        Resource existing = this.getExistingMofResource(uri);
        if (existing != null) {
            return existing;
        }
        return this.getResourceSet().createResource(URI.createURI(uri));
    }

    protected Archive openNestedArchive(String uri) {
        String methodName = "openNestedArchive(String)";
        logger.logp(Level.FINER, className, methodName, "ENTER [ {0} ]", uri);
        try {
            Archive a = ((Archive)this.getContainer()).openNestedArchive(uri);
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", a);
            return a;
        }
        catch (OpenFailureException e) {
            logger.logp(Level.SEVERE, className, methodName, CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.LoadStrategy_open_nested_archive_failure_0, new Object[]{e.getMessage()}));
            logger.throwing(className, methodName, e);
            logger.logp(Level.FINER, className, methodName, "RETURN [ null ] failure case");
            return null;
        }
    }

    protected Archive openNestedArchive(LooseArchive loose) {
        String methodName = "openNestedArchive - loose";
        logger.logp(Level.FINER, className, methodName, "ENTER [ {0} ]", loose.getUri());
        try {
            Archive a = ((Archive)this.getContainer()).openNestedArchive(loose);
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ] ", a);
            return a;
        }
        catch (OpenFailureException e) {
            logger.logp(Level.WARNING, className, methodName, CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.LoadStrategy_open_nested_archive_failure_0, new Object[]{e.getMessage()}));
            logger.throwing(className, methodName, e);
            logger.logp(Level.FINER, className, methodName, "RETURN [ null ] failure case");
            return null;
        }
    }

    public void setContainer(Container newContainer) {
        this.container = newContainer;
    }

    public void setResourceSet(ResourceSet newResourceSet) {
        if (this.resourceSet != newResourceSet) {
            if (this.resourceSet != null) {
                this.resourceSet.eAdapters().remove(this);
            }
            if (newResourceSet != null && !newResourceSet.eAdapters().contains(this)) {
                newResourceSet.eAdapters().add(this);
            }
            this.resourceSet = newResourceSet;
        }
    }

    protected void setIsOpen(boolean newIsOpen) {
        this.isOpen = newIsOpen;
    }

    protected void throwResourceLoadException(String resourceUri, Exception ex) throws ResourceLoadException {
        throw new ResourceLoadException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.load_resource_EXC_, new Object[]{resourceUri, this.getContainer().getURI()}), ex);
    }

    public LooseArchive getLooseArchive() {
        String methodName = "getLooseArchive";
        logger.logp(Level.FINER, className, methodName, "ENTRY/RETURN [ {0} ] ", this.looseArchive);
        return this.looseArchive;
    }

    public void setLooseArchive(LooseArchive looseArchive) {
        String methodName = "setLooseArchive";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ] ", looseArchive);
        this.looseArchive = looseArchive;
        this.checkLoosePathsValid();
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public void setLooseArchivePrim(LooseArchive looseArchive) {
        String methodName = "setLooseArchivePrim";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ] ", looseArchive);
        this.looseArchive = looseArchive;
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    protected void checkLoosePathsValid() {
        String methodName = "checkLoosePathsValid";
        if (this.looseArchive == null) {
            logger.logp(Level.FINER, className, methodName, "ENTRY/RETURN Valid: Loose paths are not-applicable; there is no loose archive.");
            return;
        }
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        String looseBinariesPath = this.looseArchive.getBinariesPath();
        logger.logp(Level.FINER, className, methodName, "Loose binaries path [ {0} ] ", looseBinariesPath);
        if (!this.exists(looseBinariesPath)) {
            boolean tempFileExists;
            logger.logp(Level.FINER, className, methodName, "The loose binaries path does not exist; checking for temporary files.");
            if (this instanceof TempZipFileLoadStrategyImpl) {
                logger.logp(Level.FINER, className, methodName, "Temp file case");
                TempZipFileLoadStrategyImpl ls = (TempZipFileLoadStrategyImpl)this;
                java.io.File file = ls.getFile();
                tempFileExists = file != null && file.exists();
            } else if (this.isDirectory()) {
                tempFileExists = true;
                logger.logp(Level.FINER, className, methodName, "Directory case: Allowing (verification is incomplete!)");
            } else {
                tempFileExists = false;
                logger.logp(Level.FINER, className, methodName, "No temp file processing.");
            }
            if (!tempFileExists) {
                logger.logp(Level.WARNING, className, methodName, "RETURN Non-Valid: Binaries path does not exist, and the temp file does not exist.");
                throw new ArchiveRuntimeException("Loose Archive Binaries path not found [ " + looseBinariesPath + " ]");
            }
        } else {
            logger.logp(Level.FINER, className, methodName, "The binaries path exists");
        }
        String looseResourcesPath = this.looseArchive.getResourcesPath();
        logger.logp(Level.FINER, className, methodName, "Loose resources path [ {0} ]", looseResourcesPath);
        if (!this.exists(looseResourcesPath)) {
            logger.logp(Level.WARNING, className, methodName, "RETURN Non-Valid: Resources path does not exist.");
            throw new ArchiveRuntimeException("Loose Archive Resources path [ " + looseResourcesPath + " ]");
        }
        logger.logp(Level.FINER, className, methodName, "The resources path exists");
        logger.logp(Level.FINER, className, methodName, "RETURN loose paths valid");
    }

    private boolean exists(String path) {
        java.io.File ioFile;
        return path != null && (ioFile = new java.io.File(path)).exists();
    }

    protected boolean canHaveLooseChildren() {
        return this.container.isEARFile() || this.container.isWARFile();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setRendererType(int rendererType) {
        this.rendererType = rendererType;
    }

    public List getFiles(String subfolderPath) {
        ArrayList<File> subset = new ArrayList<File>();
        List theFiles = this.getFiles();
        for (int i = 0; i < theFiles.size(); ++i) {
            File aFile = (File)theFiles.get(i);
            if (!aFile.getURI().startsWith(subfolderPath)) continue;
            subset.add(aFile);
        }
        return subset;
    }

    public String getAdditionalBinariesPath() {
        String resourcesPath;
        String binariesPath;
        String methodName = "getAdditionalBinariesPath";
        logger.logp(Level.FINER, className, methodName, "ENTRY Container URI [ {0} ]", this.getContainer().getURI());
        try {
            binariesPath = this.getBinariesPath();
            logger.logp(Level.FINER, className, methodName, "Binaries Path [ {0} ]", binariesPath);
        }
        catch (FileNotFoundException e) {
            binariesPath = null;
            logger.throwing(className, methodName, e);
            logger.logp(Level.SEVERE, className, methodName, "Unable to obtain binaries path for archive [ {0} ]", this.getContainer().getURI());
        }
        try {
            resourcesPath = this.getResourcesPath();
            logger.logp(Level.FINER, className, methodName, "Resource Path [ {0} ]", resourcesPath);
        }
        catch (FileNotFoundException e) {
            logger.logp(Level.FINER, className, methodName, "Unable to obtain resources path for archive [ {0} ]", this.getContainer().getURI());
            resourcesPath = null;
        }
        if (binariesPath == null) {
            logger.logp(Level.FINER, className, methodName, "RETURN null (no binaries path)");
            return null;
        }
        if (resourcesPath != null && binariesPath.equals(resourcesPath)) {
            logger.logp(Level.FINER, className, methodName, "RETURN null (paths are the same)");
            return null;
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ] (paths are different)", binariesPath);
        return binariesPath;
    }
}

