/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.util.logging.Level;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.client.ClientFactory;
import org.eclipse.jst.j2ee.client.ClientPackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ApplicationClientFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminatorImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.AppClient50ExportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.AppClient50NoDDSaveFilter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ImportStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ImportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.XmlBasedImportStrategyImpl;

public class AppClient50NoDDImportStrategyImpl
extends XmlBasedImportStrategyImpl {
    protected static Discriminator discriminator;

    public ImportStrategy createImportStrategy(Archive old, Archive newArchive) {
        return AppClient50NoDDImportStrategyImpl.getDiscriminator().createImportStrategy(old, newArchive);
    }

    public ApplicationClientFile getApplicationClientFile() {
        return (ApplicationClientFile)this.getArchive();
    }

    public static ArchiveTypeDiscriminator getDiscriminator() {
        if (discriminator == null) {
            discriminator = new Discriminator();
        }
        return discriminator;
    }

    public boolean isNoDDStrategy() {
        return true;
    }

    public void importMetaData() throws Exception {
        this.loadDeploymentDescriptor();
    }

    protected boolean allowNullResource() {
        return true;
    }

    public void loadDeploymentDescriptor() throws Exception {
        ClientFactory clientFactory = ClientPackage.eINSTANCE.getClientFactory();
        ApplicationClient client = clientFactory.createApplicationClient();
        client.setVersion("5");
        this.versionCheck(client);
        ApplicationClientFile appClientFile = this.getApplicationClientFile();
        appClientFile.setDeploymentDescriptor(client);
        appClientFile.setExportStrategy(new AppClient50ExportStrategyImpl());
        appClientFile.setGeneratedDD(true);
        AppClient50NoDDSaveFilter saveFilter = new AppClient50NoDDSaveFilter();
        appClientFile.setSaveFilter(saveFilter);
    }

    public static class Discriminator
    extends ArchiveTypeDiscriminatorImpl {
        protected static final String className = Discriminator.class.getName();

        public boolean canImport(Archive anArchive) {
            String methodName = "canImport";
            XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "ENTRY archive [ {0} ]", anArchive);
            Archive.ModuleVersionEnum version = Archive.ModuleVersionEnum.CLIENT50;
            if (anArchive.isSetCanImportAs(version)) {
                boolean canImport = anArchive.getCanImportAs(version);
                XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN cached CLIENT50 value [ {0} ]", Boolean.toString(canImport));
                return canImport;
            }
            boolean canImport = this.hasClientContent(anArchive);
            anArchive.setCanImportAs(version, canImport);
            anArchive.closeArchiveZipFile();
            XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN CLIENT50 [ {0} ]", Boolean.toString(canImport));
            return canImport;
        }

        private boolean hasClientContent(Archive anArchive) {
            String methodName = "hasClientContent";
            if (!anArchive.getURI().endsWith(".jar")) {
                XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "URI does not end with .jar");
                XmlBasedImportStrategyImpl.logger.exiting(className, methodName, new Boolean(false));
                return false;
            }
            XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "URI ends with .jar");
            ArchiveManifest mf = anArchive.getManifest();
            if (mf == null) {
                XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "Archive has no manifest");
                XmlBasedImportStrategyImpl.logger.exiting(className, methodName, new Boolean(false));
                return false;
            }
            if (mf.getMainClass() == null) {
                XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "Archive manifest has no main class");
                XmlBasedImportStrategyImpl.logger.exiting(className, methodName, new Boolean(false));
                return false;
            }
            XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "Archive has manifest and main class");
            String blockingDescriptor = anArchive.containsFile("META-INF/application.xml") ? "META-INF/application.xml" : (anArchive.containsFile("WEB-INF/web.xml") ? "WEB-INF/web.xml" : (anArchive.containsFile("META-INF/ejb-jar.xml") ? "META-INF/ejb-jar.xml" : (anArchive.containsFile("META-INF/ra.xml") ? "META-INF/ra.xml" : null)));
            if (blockingDescriptor == null) {
                XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "No blocking descriptors");
                XmlBasedImportStrategyImpl.logger.exiting(className, methodName, new Boolean(true));
                return true;
            }
            XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "Blocked by descriptor [ {0} ]", blockingDescriptor);
            XmlBasedImportStrategyImpl.logger.exiting(className, methodName, new Boolean(false));
            return false;
        }

        public ImportStrategy createImportStrategy(Archive old, Archive newArchive) {
            return new AppClient50NoDDImportStrategyImpl();
        }

        public String getUnableToOpenMessage() {
            return this.getXmlDDMessage(CommonArchiveResourceHandler.Application_Client_Jar_Fil, "META-INF/application-client.xml");
        }

        public Archive createConvertedArchive() {
            return ImportStrategyImpl.getArchiveFactory().createApplicationClientFile();
        }
    }
}

