/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.GenericArchiveTypeDiscriminator;

public class ArchiveTypeDiscriminatorRegistry {
    private Collection discriminators = null;
    private Collection customTypes = null;
    private static final String[] defaultKnownTypes = new String[]{".ear", ".war", ".jar", ".zip", ".far", ".rar"};
    public static final ArchiveTypeDiscriminatorRegistry INSTANCE = new ArchiveTypeDiscriminatorRegistry();

    public static void registorDiscriminator(GenericArchiveTypeDiscriminator discriminator) {
        INSTANCE.getDiscriminators().add(discriminator);
        INSTANCE.addKnownArchiveTypes(discriminator.getCustomFileExtensions());
    }

    public static ArchiveTypeDiscriminatorRegistry getInstance() {
        return INSTANCE;
    }

    public Collection getDiscriminators() {
        if (this.discriminators == null) {
            this.discriminators = new ArrayList();
        }
        return this.discriminators;
    }

    public void contributeTypes(Archive archive) {
        if (this.discriminators == null) {
            return;
        }
        GenericArchiveTypeDiscriminator discriminator2 = null;
        for (GenericArchiveTypeDiscriminator discriminator2 : this.discriminators) {
            if (!discriminator2.discriminate(archive)) continue;
            archive.getTypes().add(discriminator2.getTypeKey());
        }
    }

    public void addKnownArchiveTypes(String[] newTypes) {
        if (this.customTypes == null) {
            this.customTypes = new ArrayList();
        }
        for (int i = 0; i < newTypes.length; ++i) {
            this.customTypes.add(newTypes[i]);
        }
    }

    public boolean isKnownArchiveType(String fileURI) {
        if (fileURI == null || fileURI.length() == 0) {
            return false;
        }
        String lowerCaseUri = fileURI.toLowerCase();
        if (lowerCaseUri.length() > 4 && lowerCaseUri.charAt(lowerCaseUri.length() - 4) == '.') {
            String ending = lowerCaseUri.substring(lowerCaseUri.length() - 4);
            for (int i = 0; i < defaultKnownTypes.length; ++i) {
                String knownEnding = defaultKnownTypes[i];
                if (!knownEnding.equals(ending)) continue;
                return true;
            }
        }
        String customType2 = null;
        if (this.customTypes != null) {
            for (String customType2 : this.customTypes) {
                if (!fileURI.endsWith(customType2)) continue;
                return true;
            }
        }
        return false;
    }
}

