/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.logging.core.internationalization;

import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import java.util.StringTokenizer;

final class ICUInternationalizationUtilities {
    ICUInternationalizationUtilities() {
    }

    protected static String format(long milliseconds, String dateFormatPattern, ULocale locale, String timeZoneID) throws IllegalArgumentException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormatPattern, locale);
        simpleDateFormat.setCalendar((Calendar)new GregorianCalendar(TimeZone.getTimeZone((String)timeZoneID)));
        String formattedDateString = simpleDateFormat.format(new Date(milliseconds));
        if (timeZoneID.equals("GMT")) {
            return formattedDateString.substring(0, formattedDateString.lastIndexOf("+00:00"));
        }
        return formattedDateString;
    }

    protected static String format(String message, Object[] arguments, ULocale locale) throws IllegalArgumentException {
        return new MessageFormat(message, locale).format((Object)arguments);
    }

    protected static String[] tokenize(String string, String delimiters) {
        String[] tokens = null;
        if (string != null) {
            StringTokenizer tokenizer = new StringTokenizer(string, delimiters);
            tokens = new String[tokenizer.countTokens()];
            int counter = 0;
            while (counter < tokens.length) {
                tokens[counter] = tokenizer.nextToken();
                ++counter;
            }
        }
        return tokens;
    }
}

