/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.common;

import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.internal.execution.local.common.Message;
import org.eclipse.hyades.internal.execution.local.common.RAString;
import org.eclipse.hyades.internal.execution.local.control.AgentConfigurationEntry;

public class AgentConfigurationCommand
extends CommandElement
implements Constants {
    private long processId = 0L;
    private RAString processUUID = new RAString();
    private RAString agentName = new RAString();
    private RAString agentUUID = new RAString();
    private RAString agentType = new RAString();
    private RAString nodeUUID = new RAString();
    private Vector entries = new Vector();

    public AgentConfigurationCommand() {
        this._tag = 50L;
    }

    public int getSize() {
        int size = 0;
        size += super.getSize();
        size += 4;
        size += this.processUUID.getSize();
        size += this.agentName.getSize();
        size += this.agentUUID.getSize();
        size += this.agentType.getSize();
        size += this.nodeUUID.getSize();
        size += 4;
        int i = 0;
        while (i < this.entries.size()) {
            RAString name = new RAString(((AgentConfigurationEntry)this.entries.elementAt(i)).getName());
            RAString type = new RAString(((AgentConfigurationEntry)this.entries.elementAt(i)).getType());
            RAString value = new RAString(((AgentConfigurationEntry)this.entries.elementAt(i)).getValue());
            size += name.getSize();
            size += type.getSize();
            size += value.getSize();
            ++i;
        }
        return size;
    }

    public int readFromBuffer(byte[] buffer, int offset) {
        int current = offset;
        current = super.readFromBuffer(buffer, current);
        this.processId = Message.readRALongFromBuffer(buffer, current);
        current += 4;
        current = Message.readRAStringFromBuffer(buffer, current, this.processUUID);
        current = Message.readRAStringFromBuffer(buffer, current, this.agentName);
        current = Message.readRAStringFromBuffer(buffer, current, this.agentUUID);
        current = Message.readRAStringFromBuffer(buffer, current, this.agentType);
        current = Message.readRAStringFromBuffer(buffer, current, this.nodeUUID);
        long numConfig = Message.readRALongFromBuffer(buffer, current);
        current += 4;
        int i = 0;
        while ((long)i < numConfig) {
            RAString type = new RAString();
            RAString name = new RAString();
            RAString value = new RAString();
            current = Message.readRAStringFromBuffer(buffer, current, type);
            current = Message.readRAStringFromBuffer(buffer, current, name);
            current = Message.readRAStringFromBuffer(buffer, current, value);
            AgentConfigurationEntry entry = new AgentConfigurationEntry();
            entry.setType(type.getData());
            entry.setName(name.getData());
            entry.setValue(value.getData());
            this.addEntry(entry);
            ++i;
        }
        return current;
    }

    public int writeToBuffer(byte[] buffer, int offset) {
        int current = offset;
        current = super.writeToBuffer(buffer, current);
        current = Message.writeRALongToBuffer(buffer, current, this.processId);
        current = Message.writeRAStringToBuffer(buffer, current, this.processUUID);
        current = Message.writeRAStringToBuffer(buffer, current, this.agentName);
        current = Message.writeRAStringToBuffer(buffer, current, this.agentUUID);
        current = Message.writeRAStringToBuffer(buffer, current, this.agentType);
        current = Message.writeRAStringToBuffer(buffer, current, this.nodeUUID);
        current = Message.writeRALongToBuffer(buffer, current, this.entries.size());
        int i = 0;
        while (i < this.entries.size()) {
            AgentConfigurationEntry entry = (AgentConfigurationEntry)this.entries.elementAt(i);
            current = Message.writeRAStringToBuffer(buffer, current, new RAString(entry.getType()));
            current = Message.writeRAStringToBuffer(buffer, current, new RAString(entry.getName()));
            current = Message.writeRAStringToBuffer(buffer, current, new RAString(entry.getValue()));
            ++i;
        }
        return current;
    }

    public void clear() {
        this.entries.clear();
    }

    public AgentConfigurationEntry[] getConfigurations() {
        return (AgentConfigurationEntry[])this.entries.toArray();
    }

    public void addEntry(AgentConfigurationEntry entry) {
        this.entries.add(entry);
    }

    public boolean removeEntry(AgentConfigurationEntry entry) {
        if (this.entries.contains(entry)) {
            this.entries.remove(entry);
            return true;
        }
        return false;
    }

    public RAString getAgentName() {
        return this.agentName;
    }

    public void setAgentName(RAString agentName) {
        this.agentName = agentName;
    }

    public RAString getAgentType() {
        return this.agentType;
    }

    public void setAgentType(RAString agentType) {
        this.agentType = agentType;
    }

    public RAString getAgentUUID() {
        return this.agentUUID;
    }

    public void setAgentUUID(RAString agentUUID) {
        this.agentUUID = agentUUID;
    }

    public RAString getNodeUUID() {
        return this.nodeUUID;
    }

    public void setNodeUUID(RAString nodeUUID) {
        this.nodeUUID = nodeUUID;
    }

    public long getProcessId() {
        return this.processId;
    }

    public void setProcessId(long processId) {
        this.processId = processId;
    }

    public RAString getProcessUUID() {
        return this.processUUID;
    }

    public void setProcessUUID(RAString processUUID) {
        this.processUUID = processUUID;
    }
}

