/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.remote;

import java.util.Stack;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.core.impl.ExecutionComponentImpl;
import org.eclipse.hyades.execution.invocation.CallData;
import org.eclipse.hyades.execution.invocation.Invoker;
import org.eclipse.hyades.execution.invocation.Marshaller;
import org.eclipse.hyades.execution.invocation.ReturnData;
import org.eclipse.hyades.execution.remote.ExecutionComponentFactoryImpl;
import org.eclipse.hyades.internal.execution.local.common.BinaryCustomCommand;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.remote.AgentControllerListener;
import org.eclipse.hyades.internal.execution.remote.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.remote.CustomCommandHandler;
import org.eclipse.hyades.internal.execution.remote.RemoteClientListener;
import org.eclipse.hyades.internal.execution.remote.RemoteComponentSkeleton;

public class SessionImpl
extends ExecutionComponentImpl
implements ISession {
    private Object completionLock = new Object();
    private boolean completed = false;
    private boolean initializedWithRAC = false;
    RemoteComponentSkeleton agent;
    private final Stack messageQueue = new Stack();

    public SessionImpl(String name, String type) {
        this.agent = new RemoteComponentSkeleton(name, type);
    }

    public void init() {
        this.agent.addAgentControllerListener(new AgentControllerListener(){

            public void agentControllerActive() {
                SessionImpl.this.initializedWithRAC = true;
            }

            public void agentControllerInactive() {
                if (SessionImpl.this.initializedWithRAC) {
                    System.exit(-2);
                }
            }
        });
        this.agent.addRemoteClientListener(new RemoteClientListener(){

            public void clientActive() {
            }

            public void clientInactive() {
                SessionImpl.this.release();
            }
        });
        this.agent.addCommandListener(new CustomCommandHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleCommand(CustomCommand command) {
                Stack stack = SessionImpl.this.messageQueue;
                synchronized (stack) {
                    SessionImpl.this.messageQueue.push(command);
                    if (SessionImpl.this.messageQueue.size() == 1) {
                        SessionImpl.this.messageQueue.notify();
                    }
                }
            }
        });
        ExecutionComponentFactoryImpl.getInstance(this);
        try {
            this.agent.initialize();
        }
        catch (AgentControllerUnavailableException agentControllerUnavailableException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForExit() {
        while (!this.completed) {
            Object object = this.completionLock;
            synchronized (object) {
                try {
                    this.completionLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exit() {
        Object object = this.completionLock;
        synchronized (object) {
            this.completed = true;
            this.completionLock.notifyAll();
        }
    }

    public void release() {
        this.exit();
    }

    public void replyRemote(CustomCommand command) {
        byte[] data = command.getDataBinary();
        this.agent.broadcastMessage(data, 0, data.length, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCommands() {
        while (true) {
            Stack stack = this.messageQueue;
            synchronized (stack) {
                while (this.messageQueue.size() == 0) {
                    Stack stack2 = this.messageQueue;
                    synchronized (stack2) {
                        block18: {
                            try {
                                this.messageQueue.wait(2000L);
                                if (this.messageQueue.size() != 0) break block18;
                                Object object = this.completionLock;
                                synchronized (object) {
                                    if (this.completed) {
                                        return;
                                    }
                                }
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                }
                BinaryCustomCommand command = (BinaryCustomCommand)this.messageQueue.pop();
                CallData callData = null;
                try {
                    callData = Marshaller.unmarshalMethodCall(command.getDataBinary());
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    return;
                }
                try {
                    ReturnData returnData = Invoker.invoke(callData);
                    command.setData(Marshaller.marshalReturnValue(returnData));
                    this.replyRemote(command);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

