/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.local.file;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended;
import org.eclipse.hyades.execution.core.task.ProgressiveTask;
import org.eclipse.hyades.execution.local.file.FileManagerExtendedImpl;
import org.eclipse.hyades.execution.local.file.FileManagerExtendedTimedImpl;
import org.eclipse.hyades.execution.local.file.FileManagerLegacy;
import org.eclipse.hyades.execution.local.file.FileManagerLocal;
import org.eclipse.hyades.execution.local.file.IFileManagerFactory;
import org.eclipse.hyades.execution.local.file.ProvisionalFileManagerExtended;
import org.eclipse.hyades.execution.local.file.ProvisionalFileManagerExtendedTimed;
import org.eclipse.hyades.execution.local.util.AgentControllerDescriptor;
import org.eclipse.hyades.execution.local.util.IAgentControllerDescriptor;
import org.eclipse.hyades.internal.execution.core.file.FileSystemServices;
import org.eclipse.hyades.internal.execution.core.file.ServerNotAvailableException;
import org.eclipse.hyades.internal.execution.local.control.Connection;
import org.eclipse.hyades.internal.execution.local.control.LocalConnectionImpl;

public final class FileManagerFactory
implements IFileManagerFactory {
    private static final IFileManagerFactory factory = new FileManagerFactory();
    private static final int QUERY_SERVER_AVAILABILITY_TIMEOUT_INCREMENT = 15000;
    private static final int QUERY_SERVER_AVAILABILITY_TIMEOUT_START = 7500;
    private static final int QUERY_SERVER_AVAILABILITY_TRIES = 25;
    private final HashMap connectionSpecificManagers = new HashMap();
    private final HashMap iterationSpecificManagers = new HashMap();

    public static IFileManagerFactory getInstance() {
        return factory;
    }

    private FileManagerFactory() {
    }

    public synchronized IFileManagerExtended create(Connection connection) throws ServerNotAvailableException {
        IFileManagerExtended fileManager = null;
        if (connection instanceof LocalConnectionImpl) {
            fileManager = new FileManagerLocal();
        } else {
            String cacheKey = this.getConnectionKey(connection);
            fileManager = (IFileManagerExtended)this.connectionSpecificManagers.get(cacheKey);
            if (fileManager == null && (fileManager = this.create(new NewFileServerProvider(connection), new ProvisionalNewFileServerProvider(connection), new LegacyFileServerProvider(connection))) != null) {
                this.connectionSpecificManagers.put(cacheKey, fileManager);
            }
        }
        return fileManager;
    }

    private IFileManagerExtended create(IFileServerProvider provider) {
        return this.create(provider, provider);
    }

    private IFileManagerExtended create(IFileServerProvider primaryProvider, IFileServerProvider secondaryProvider) {
        IFileManagerExtended fileManager = null;
        int i = 0;
        int timeout = 7500;
        while (fileManager == null && i < 25) {
            fileManager = primaryProvider.provide(timeout);
            primaryProvider.reset();
            if (fileManager == null) {
                fileManager = secondaryProvider.provide(timeout);
                secondaryProvider.reset();
            }
            FileSystemServices.println("File manager factory created file manager " + fileManager, this);
            timeout += 15000;
            ++i;
        }
        return fileManager;
    }

    private IFileManagerExtended create(IFileServerProvider primaryProvider, IFileServerProvider secondaryProvider, IFileServerProvider ternaryProvider) {
        IFileManagerExtended fileManager = null;
        int i = 0;
        int timeout = 7500;
        while (fileManager == null && i < 25) {
            fileManager = primaryProvider.provide(timeout);
            primaryProvider.reset();
            if (fileManager == null) {
                fileManager = secondaryProvider.provide(timeout);
                secondaryProvider.reset();
                if (fileManager == null) {
                    fileManager = ternaryProvider.provide(timeout);
                    ternaryProvider.reset();
                }
            }
            timeout += 15000;
            ++i;
        }
        FileSystemServices.println("File manager factory created file manager " + fileManager, this);
        return fileManager;
    }

    public synchronized IFileManagerExtended create(InetSocketAddress fileServerAddress) {
        return this.create(new NewFileServerProvider(fileServerAddress));
    }

    public synchronized IFileManagerExtended createTimed(Connection connection, int iterations) throws ServerNotAvailableException {
        IFileManagerExtended fileManager = null;
        if (connection instanceof LocalConnectionImpl) {
            fileManager = new FileManagerLocal();
        } else {
            String key = this.getConnectionIterationKey(connection, iterations);
            fileManager = (IFileManagerExtended)this.iterationSpecificManagers.get(key);
            if (fileManager == null && (fileManager = this.create(new NewTimedFileServerProvider(connection, iterations), new ProvisionalNewTimedFileServerProvider(connection, iterations), new LegacyFileServerProvider(connection))) != null) {
                this.iterationSpecificManagers.put(key, fileManager);
            }
        }
        return fileManager;
    }

    public synchronized IFileManagerExtended createTimed(InetSocketAddress fileServerAddress, int iterations) {
        return this.create(new NewTimedFileServerProvider(fileServerAddress, iterations));
    }

    private String getConnectionIterationKey(Connection connection, int iterations) {
        return this.getConnectionKey(connection).toString().concat("~").concat(String.valueOf(iterations));
    }

    private String getConnectionKey(Connection connection) {
        return connection.getNode().getInetAddress().toString();
    }

    private static abstract class AbstractFileServerProvider
    implements IFileServerProvider {
        final Object attemptLock;
        IAgentControllerDescriptor descriptor;
        Throwable exception;
        IFileManagerExtended fileManager;
        IFileServerProvider.ServerValidity serverValidity = IFileServerProvider.ServerValidity.UNKNOWN;
        private boolean shouldCancel;

        private AbstractFileServerProvider(IFileManagerExtended fileManager) {
            this.attemptLock = new Object();
            this.fileManager = fileManager;
        }

        private AbstractFileServerProvider(IFileManagerExtended fileManager, IAgentControllerDescriptor descriptor) {
            this.attemptLock = new Object();
            this.fileManager = fileManager;
            this.descriptor = descriptor;
        }

        public IFileServerProvider.ServerValidity getServerValidity() {
            return this.serverValidity;
        }

        abstract String getTaskName();

        abstract Runnable getTaskRunnable();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IFileManagerExtended provide(int timeout) {
            ProgressiveTask queryServerAvailability = new ProgressiveTask(this.getTaskName(), this.getTaskRunnable(), (IProgressMonitor)new NullProgressMonitor(this){
                final /* synthetic */ AbstractFileServerProvider this$1;
                {
                    this.this$1 = abstractFileServerProvider;
                }

                public boolean isCanceled() {
                    return AbstractFileServerProvider.access$0(this.this$1);
                }
            }, 3000);
            Object object = this.attemptLock;
            synchronized (object) {
                queryServerAvailability.execute(ProgressiveTask.Synchronicity.ASYNCHRONOUS);
                try {
                    FileSystemServices.println("File system services provider attempting " + this.fileManager + " with timeout " + timeout, this);
                    this.attemptLock.wait(timeout);
                }
                catch (InterruptedException interruptedException) {}
            }
            boolean bl = this.shouldCancel = this.serverValidity == IFileServerProvider.ServerValidity.UNKNOWN;
            if (this.exception != null) {
                FileSystemServices.println("Exception encountered during server validity detection (potentially expected) " + this.exception.getLocalizedMessage(), this);
            }
            return this.serverValidity == IFileServerProvider.ServerValidity.VALID ? this.fileManager : null;
        }

        public void reset() {
            this.fileManager.reset();
        }

        static /* synthetic */ boolean access$0(AbstractFileServerProvider abstractFileServerProvider) {
            return abstractFileServerProvider.shouldCancel;
        }
    }

    private static interface IFileServerProvider {
        public ServerValidity getServerValidity();

        public IFileManagerExtended provide(int var1);

        public void reset();

        public static final class ServerValidity {
            public static final ServerValidity INVALID = new ServerValidity();
            public static final ServerValidity UNKNOWN = new ServerValidity();
            public static final ServerValidity VALID = new ServerValidity();

            private ServerValidity() {
            }
        }
    }

    private static class LegacyFileServerProvider
    extends AbstractFileServerProvider {
        private LegacyFileServerProvider(Connection connection) {
            super(new FileManagerExtendedImpl.Adapter(new FileManagerLegacy(connection)), new AgentControllerDescriptor(connection.getNode()));
        }

        String getTaskName() {
            return "Query Legacy File Server Availability";
        }

        Runnable getTaskRunnable() {
            return new Runnable(this){
                final /* synthetic */ LegacyFileServerProvider this$1;
                {
                    this.this$1 = legacyFileServerProvider;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        IFileServerProvider.ServerValidity serverValidity = this.this$1.serverValidity = this.this$1.descriptor != null && this.this$1.descriptor.isVersionAtMost("3.2") || this.this$1.descriptor == null ? IFileServerProvider.ServerValidity.VALID : IFileServerProvider.ServerValidity.UNKNOWN;
                        if (this.this$1.serverValidity == IFileServerProvider.ServerValidity.UNKNOWN) {
                            File file = File.createTempFile("tptp", "tptp");
                            file.deleteOnExit();
                            this.this$1.fileManager.getFile(file.getAbsolutePath(), ".");
                            this.this$1.serverValidity = IFileServerProvider.ServerValidity.VALID;
                        }
                    }
                    catch (Throwable e) {
                        this.this$1.serverValidity = IFileServerProvider.ServerValidity.INVALID;
                        this.this$1.exception = e;
                    }
                    Object object = this.this$1.attemptLock;
                    synchronized (object) {
                        this.this$1.attemptLock.notifyAll();
                    }
                }
            };
        }
    }

    private static class NewFileServerProvider
    extends AbstractFileServerProvider {
        private NewFileServerProvider(Connection connection) throws ServerNotAvailableException {
            super(new FileManagerExtendedImpl(connection), new AgentControllerDescriptor(connection.getNode()));
        }

        private NewFileServerProvider(IFileManagerExtended fileManager) {
            super(fileManager);
        }

        private NewFileServerProvider(IFileManagerExtended fileManager, IAgentControllerDescriptor descriptor) {
            super(fileManager, descriptor);
        }

        private NewFileServerProvider(InetSocketAddress fileServerAddress) {
            super((IFileManagerExtended)new FileManagerExtendedImpl(fileServerAddress));
        }

        String getTaskName() {
            return "Query New File Server Availability";
        }

        Runnable getTaskRunnable() {
            return new Runnable(this){
                final /* synthetic */ NewFileServerProvider this$1;
                {
                    this.this$1 = newFileServerProvider;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    this.this$1.serverValidity = this.this$1.descriptor != null && this.this$1.descriptor.isVersionAtLeast("4.1") || this.this$1.descriptor == null ? IFileServerProvider.ServerValidity.VALID : IFileServerProvider.ServerValidity.INVALID;
                    Object object = this.this$1.attemptLock;
                    synchronized (object) {
                        this.this$1.attemptLock.notifyAll();
                    }
                }
            };
        }
    }

    private static class NewTimedFileServerProvider
    extends NewFileServerProvider {
        private int iterations = 0;

        private NewTimedFileServerProvider(Connection connection, int iterations) throws ServerNotAvailableException {
            super((IFileManagerExtended)new FileManagerExtendedTimedImpl(connection, iterations), (IAgentControllerDescriptor)new AgentControllerDescriptor(connection.getNode()));
            this.iterations = iterations;
        }

        private NewTimedFileServerProvider(InetSocketAddress fileServerAddress, int iterations) {
            super((IFileManagerExtended)new FileManagerExtendedTimedImpl(fileServerAddress, iterations));
            this.iterations = iterations;
        }

        String getTaskName() {
            return "Query New Timed File Server Availability";
        }

        public IFileManagerExtended provide(int timeout) {
            return super.provide(timeout * this.iterations);
        }
    }

    private static class ProvisionalNewFileServerProvider
    extends AbstractFileServerProvider {
        private ProvisionalNewFileServerProvider(Connection connection) {
            super(new ProvisionalFileManagerExtended(connection), new AgentControllerDescriptor(connection.getNode()));
        }

        private ProvisionalNewFileServerProvider(IFileManagerExtended fileManager, IAgentControllerDescriptor descriptor) {
            super(fileManager, descriptor);
        }

        String getTaskName() {
            return "Query Provisional New File Server Availability";
        }

        Runnable getTaskRunnable() {
            return new Runnable(this){
                final /* synthetic */ ProvisionalNewFileServerProvider this$1;
                {
                    this.this$1 = provisionalNewFileServerProvider;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        if (this.this$1.descriptor.isVersionWithin("3.3", "4.0.1")) {
                            this.this$1.fileManager.isServerAvailable();
                            this.this$1.serverValidity = IFileServerProvider.ServerValidity.VALID;
                        } else {
                            this.this$1.serverValidity = IFileServerProvider.ServerValidity.INVALID;
                        }
                    }
                    catch (Throwable e) {
                        this.this$1.serverValidity = IFileServerProvider.ServerValidity.UNKNOWN;
                        this.this$1.exception = e;
                    }
                    Object object = this.this$1.attemptLock;
                    synchronized (object) {
                        this.this$1.attemptLock.notifyAll();
                    }
                }
            };
        }
    }

    private static class ProvisionalNewTimedFileServerProvider
    extends ProvisionalNewFileServerProvider {
        private int iterations = 0;

        private ProvisionalNewTimedFileServerProvider(Connection connection, int iterations) {
            super((IFileManagerExtended)new ProvisionalFileManagerExtendedTimed(connection, iterations), (IAgentControllerDescriptor)new AgentControllerDescriptor(connection.getNode()));
            this.iterations = iterations;
        }

        String getTaskName() {
            return "Query Provisional New Timed File Server Availability";
        }

        public IFileManagerExtended provide(int timeout) {
            return super.provide(timeout * this.iterations);
        }
    }
}

