/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.local;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Properties;
import org.eclipse.hyades.automation.client.adapters.java.AutomationClientAdapter;
import org.eclipse.hyades.execution.core.DaemonConnectException;
import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.IExecutionComponentStateChangeListener;
import org.eclipse.hyades.execution.core.INodeExtended;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.core.UnknownDaemonException;
import org.eclipse.hyades.execution.core.file.IFileManager;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended;
import org.eclipse.hyades.execution.core.util.ConnectionSpecifier;
import org.eclipse.hyades.execution.core.util.MutableObject;
import org.eclipse.hyades.execution.invocation.Marshaller;
import org.eclipse.hyades.execution.local.SessionImpl;
import org.eclipse.hyades.execution.local.SessionStub;
import org.eclipse.hyades.execution.local.file.FileManagerFactory;
import org.eclipse.hyades.internal.execution.core.file.ServerNotAvailableException;
import org.eclipse.hyades.internal.execution.local.common.Console;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.control.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.local.control.AgentFactory;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.NoSuchApplicationException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessActiveException;
import org.eclipse.hyades.internal.execution.local.control.ProcessFactory;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.internal.execution.security.DuplicateUserException;
import org.eclipse.hyades.internal.execution.security.LoginFailedException;
import org.eclipse.hyades.internal.execution.security.SecureConnectionRequiredException;

public class NodeImpl
implements INodeExtended {
    private static final boolean DEBUG = false;
    private boolean connected = false;
    IFileManagerExtended fileManager;
    private final String name;
    public Node node;
    private Object sessionLock = new Object();

    public NodeImpl(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private ISession _connect(String daemonType, Principal principal) throws UnknownDaemonException, DaemonConnectException, UnknownHostException {
        block17: {
            client = new AutomationClientAdapter();
            properties = new Properties();
            properties.setProperty("host", this.name);
            properties.setProperty("port", daemonType);
            properties.put("showErrors", new Boolean(true));
            mutableNode = new MutableObject();
            properties.put("mutableNode", mutableNode);
            try {
                client.execute("org.eclipse.hyades.ui.connector", properties);
                this.node = (Node)mutableNode.getAndClear();
                if (this.node == null) {
                    throw new DaemonConnectException();
                }
            }
            catch (Throwable v0) {
                this.node = this.connectUsingLegacyMethod(daemonType, principal);
                if (this.node != null) break block17;
                throw new DaemonConnectException();
            }
        }
        if (this.node == null) {
            return null;
        }
        rprocess = ProcessFactory.createProcess(this.node, "HyadesTestingSession");
        ragent = AgentFactory.createAgent(rprocess, "RemoteSession", "HyadesSession");
        ragent.setAutoAttach(true);
        sessionInstance = new SessionStub(new SessionImpl(this, ragent));
        Marshaller.addInstanceToMap(sessionInstance.getUniqueId(), sessionInstance);
        try {
            rprocess.setParameters("org.eclipse.hyades.execution.remote.NodeImpl " + sessionInstance.getUniqueId().toString());
        }
        catch (ProcessActiveException v1) {}
        processListener = new ProcessListener(){

            public void processExited(Process process) {
                NodeImpl.this.releaseSessionLock();
            }

            public void processLaunched(Process process) {
            }
        };
        rprocess.addProcessListener(processListener);
        stateChangeListener = new IExecutionComponentStateChangeListener(){

            public void stateChanged(ExecutionComponentStateChangeEvent event2) {
                if (event2.getState() == 2) {
                    NodeImpl.this.releaseSessionLock();
                }
            }
        };
        sessionInstance.addExecutionComponentStateChangeListener(stateChangeListener);
        try {
            rprocess.launch();
            rprocess.getProcessId();
            if (true) ** GOTO lbl79
        }
        catch (InactiveProcessException e) {
            this.cleanup(this.node, rprocess, sessionInstance, processListener, stateChangeListener);
            exc = new DaemonConnectException();
            exc.initCause(e);
            throw exc;
        }
        catch (NoSuchApplicationException e) {
            this.cleanup(this.node, rprocess, sessionInstance, processListener, stateChangeListener);
            exc = new DaemonConnectException();
            exc.initCause(e);
            throw exc;
        }
        catch (ProcessActiveException e) {
            this.cleanup(this.node, rprocess, sessionInstance, processListener, stateChangeListener);
            exc = new DaemonConnectException();
            exc.initCause(e);
            throw exc;
        }
        catch (NotConnectedException e) {
            this.cleanup(this.node, rprocess, sessionInstance, processListener, stateChangeListener);
            exc = new DaemonConnectException();
            exc.initCause(e);
            throw exc;
        }
        do {
            var11_15 = this.sessionLock;
            synchronized (var11_15) {
                try {
                    this.sessionLock.wait();
                }
                catch (InterruptedException v2) {}
            }
lbl79:
            // 3 sources

        } while (!this.connected);
        rprocess.removeProcessListener(processListener);
        sessionInstance.removeExecutionComponentStateChangeListener(stateChangeListener);
        return sessionInstance;
    }

    private void captureConsoleOutput(Process process) {
        Console console = process.getConsole();
        console.setDataProcessor(new DataProcessor(){

            public void incommingData(byte[] buffer, int length, InetAddress peer) {
                System.out.print("====>");
                System.out.print(new String(buffer, 0, length));
                System.out.flush();
            }

            public void incommingData(char[] buffer, int length, InetAddress peer) {
                System.out.print("====>");
                System.out.print(new String(buffer, 0, length));
                System.out.flush();
            }

            public void invalidDataType(byte[] data, int length, InetAddress peer) {
            }

            public void waitingForData() {
            }
        });
    }

    private void cleanup(Node node, Process process, ISession sessionInstance, ProcessListener processListener, IExecutionComponentStateChangeListener stateChangeListener) {
        try {
            process.removeProcessListener(processListener);
            Marshaller.removeInstanceFromMap(((SessionStub)sessionInstance).getUniqueId());
            sessionInstance.removeExecutionComponentStateChangeListener(stateChangeListener);
            this.node.getConnection().disconnect();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public ISession connect(ConnectionSpecifier specifier) throws UnknownDaemonException, DaemonConnectException, UnknownHostException {
        return this.connect("iac".equalsIgnoreCase(specifier.getServerClass()) ? String.valueOf("-1") : String.valueOf(specifier.getPort()), null);
    }

    public ISession connect(String daemonType, Principal principal) throws UnknownDaemonException, DaemonConnectException, UnknownHostException {
        ISession sessionInstance = this._connect(daemonType, principal);
        if (sessionInstance != null) {
            try {
                this.fileManager = FileManagerFactory.getInstance().create(this.node.getConnection());
            }
            catch (ServerNotAvailableException e) {
                DaemonConnectException exc = new DaemonConnectException();
                exc.initCause(e);
                throw exc;
            }
        }
        return sessionInstance;
    }

    public ISession connect(String daemonType, Principal principal, int iterations) throws UnknownDaemonException, DaemonConnectException, UnknownHostException {
        ISession sessionInstance = this._connect(daemonType, principal);
        if (sessionInstance != null) {
            try {
                this.fileManager = FileManagerFactory.getInstance().createTimed(this.node.getConnection(), iterations);
            }
            catch (ServerNotAvailableException e) {
                DaemonConnectException exc = new DaemonConnectException();
                exc.initCause(e);
                throw exc;
            }
        }
        return sessionInstance;
    }

    public Node connectUsingLegacyMethod(String daemonType, Principal principal) throws UnknownDaemonException, DaemonConnectException, UnknownHostException {
        Node node = null;
        try {
            node = principal == null ? NodeFactory.createNode(this.name) : NodeFactory.createNode(this.name, principal);
        }
        catch (DuplicateUserException e) {
            throw e;
        }
        catch (UnknownHostException e) {
            throw e;
        }
        try {
            node.connect(Integer.parseInt(daemonType));
        }
        catch (SecureConnectionRequiredException e) {
            throw e;
        }
        catch (LoginFailedException e) {
            throw e;
        }
        catch (AgentControllerUnavailableException e) {
            throw e;
        }
        return node;
    }

    public IFileManager getFileManager() {
        return this.fileManager;
    }

    public String getName() {
        return this.name;
    }

    public Node getUnderlyingNode() {
        return this.node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseSessionLock() {
        Object object = this.sessionLock;
        synchronized (object) {
            this.connected = true;
            this.sessionLock.notify();
        }
    }
}

