/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.rose.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.importer.rose.RoseImporterPlugin;
import org.eclipse.emf.importer.rose.builder.RoseUtil;
import org.eclipse.emf.importer.rose.builder.RoseVisitor;
import org.eclipse.emf.importer.rose.builder.TableObject;
import org.eclipse.emf.importer.rose.parser.RoseNode;
import org.eclipse.emf.importer.rose.parser.Util;

public class RoseEcoreBuilder
implements RoseVisitor {
    public boolean noQualify = false;
    public boolean unsettablePrimitive = "true".equals(System.getProperty("EMF_UNSETTABLE_PRIMITIVE"));
    protected RoseUtil roseUtil;
    protected Set bounded = new HashSet();
    protected Map eStructuralFeatureToXMLNamespaceMap = new HashMap();
    protected List eStructuralFeatures = new BasicEList(){

        protected boolean useEquals() {
            return false;
        }
    };
    protected Map eEnums = new HashMap();
    protected Map idToParentMap = new HashMap();
    protected EReference ref1 = null;
    protected EReference ref2 = null;
    protected RoseNode role1 = null;
    protected RoseNode role2 = null;
    protected static final Pattern ANNOTATION_PATTERN = Pattern.compile("\\G\\s*((?>\\\\.|\\S)+)((?:\\s+(?>\\\\.|\\S)+\\s*+=\\s*(['\"])((?>\\\\.|.)*?)\\3)*)");
    protected static final Pattern ANNOTATION_DETAIL_PATTERN = Pattern.compile("\\s+((?>\\\\.|\\S)+)\\s*+=\\s*((['\"])((?>\\\\.|.)*?)\\3)");
    protected static Comparator eClassComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            int count2;
            EClass c1 = (EClass)o1;
            EClass c2 = (EClass)o2;
            int count1 = c1.getEAllAttributes().size() + c1.getEAllReferences().size();
            if (count1 < (count2 = c2.getEAllAttributes().size() + c2.getEAllReferences().size())) {
                return 1;
            }
            if (count1 > count2) {
                return -1;
            }
            return c1.getName().compareTo(c2.getName());
        }
    };
    protected Comparator eStructuralFeatureComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return RoseEcoreBuilder.this.eStructuralFeatures.indexOf(o1) - RoseEcoreBuilder.this.eStructuralFeatures.indexOf(o2);
        }
    };

    public RoseEcoreBuilder(RoseUtil roseUtil) {
        this.roseUtil = roseUtil;
    }

    public void visitList(RoseNode roseNode) {
    }

    public void visitObject(RoseNode roseNode) {
        String roseNodeValue = roseNode.getValue();
        String objectKey = roseNode.getKey();
        String objectType = Util.getType(roseNodeValue);
        String objectName = Util.getName(roseNodeValue);
        RoseNode currentNode = roseNode;
        Object parent = currentNode.getNode();
        while (parent == null) {
            currentNode = currentNode.getParent();
            parent = currentNode.getNode();
        }
        this.visitObject(roseNode, roseNodeValue, objectKey, objectType, objectName, parent);
    }

    protected void visitObject(RoseNode roseNode, String roseNodeValue, String objectKey, String objectType, String objectName, Object parent) {
        if (objectKey.equals("") && objectType.equals("Class_Category")) {
            this.visitClassCategory(roseNode, roseNodeValue, objectKey, objectName, parent);
        } else if (objectType.equals("Class")) {
            this.visitClass(roseNode, roseNodeValue, objectKey, objectName, parent);
        } else if (objectType.equals("Operation")) {
            this.visitOperation(roseNode, roseNodeValue, objectKey, objectName, parent);
        } else if (objectType.equals("Parameter")) {
            this.visitParameter(roseNode, roseNodeValue, objectKey, objectName, parent);
        } else if (objectType.equals("Inheritance_Relationship")) {
            this.visitInheritanceRelationship(roseNode, roseNodeValue, objectKey, objectName, parent);
        } else if (!(!objectType.equals("ClassAttribute") || roseNode.isDerived() && "reference".equals(roseNode.getStereotype()))) {
            this.visitClassattribute(roseNode, roseNodeValue, objectKey, objectName, parent);
        } else if (objectType.equals("Association")) {
            this.visitAssociation(roseNode, roseNodeValue, objectKey, objectName, parent);
        } else if (objectType.equals("Role") && !objectName.startsWith("/")) {
            this.visitRole(roseNode, roseNodeValue, objectKey, objectName, parent);
        }
    }

    protected void visitClassCategory(RoseNode roseNode, String roseNodeValue, String objectKey, String objectName, Object parent) {
        if (roseNode.isLoaded()) {
            String id = roseNode.getRoseId();
            if (this.idToParentMap.containsKey(id)) {
                parent = this.idToParentMap.get(id);
            }
            EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
            if (parent instanceof EPackage) {
                ((EPackage)parent).getESubpackages().add(ePackage);
            } else if (parent instanceof EList) {
                ((EList)parent).add(ePackage);
            }
            this.setEPackageProperties(roseNode, ePackage, objectName.toLowerCase());
        } else {
            this.idToParentMap.put(roseNode.getRoseId(), parent);
        }
    }

    protected void visitClass(RoseNode roseNode, String roseNodeValue, String objectKey, String objectName, Object parent) {
        RoseNode stereoTypeNode;
        if (objectName == null || objectName.length() == 0) {
            String quid = roseNode.getRoseId();
            if (quid != null) {
                quid = quid.substring(1, quid.length() - 1);
            }
            objectName = "Unnamed" + quid;
            this.error(RoseImporterPlugin.INSTANCE.getString("_UI_UnnamedClass_message", new Object[]{objectName}));
        }
        if ((stereoTypeNode = roseNode.findNodeWithKey("stereotype")) != null) {
            String stereoTypeValue = stereoTypeNode.getValue();
            if ((stereoTypeValue = stereoTypeValue.substring(1, stereoTypeValue.length() - 1)).equals("Interface")) {
                EClass eClass = EcoreFactory.eINSTANCE.createEClass();
                String classifierName = roseNode.getClassifierName();
                if (classifierName == null || classifierName.length() == 0) {
                    classifierName = this.validName(this.upperCaseName(objectName));
                }
                eClass.setName(classifierName);
                roseNode.setNode(eClass);
                this.setEClassProperties(roseNode, eClass);
                eClass.setInterface(true);
                eClass.setAbstract(true);
                this.build(roseNode, parent, eClass);
            } else if (stereoTypeValue.equalsIgnoreCase("enumeration")) {
                EEnum eEnum = EcoreFactory.eINSTANCE.createEEnum();
                String classifierName = roseNode.getClassifierName();
                if (classifierName == null || classifierName.length() == 0) {
                    classifierName = this.validName(this.upperCaseName(objectName));
                }
                eEnum.setName(classifierName);
                roseNode.setNode(eEnum);
                this.setEEnumProperties(roseNode, eEnum);
                this.build(roseNode, parent, eEnum);
            } else if (stereoTypeValue.equalsIgnoreCase("datatype") || stereoTypeValue.equalsIgnoreCase("primitive")) {
                EDataType eDataType = EcoreFactory.eINSTANCE.createEDataType();
                String classifierName = roseNode.getClassifierName();
                if (classifierName == null || classifierName.length() == 0) {
                    classifierName = this.validName(this.upperCaseName(objectName));
                }
                eDataType.setName(classifierName);
                roseNode.setNode(eDataType);
                this.setEDataTypeProperties(roseNode, eDataType);
                this.build(roseNode, parent, eDataType);
                String uml2MOFCorbaType = roseNode.getUML2MOFCorbaType();
                if (uml2MOFCorbaType != null) {
                    int end;
                    int start = (uml2MOFCorbaType = uml2MOFCorbaType.trim()).indexOf("typedef ");
                    if (start != -1 && (end = (uml2MOFCorbaType = uml2MOFCorbaType.substring(8)).lastIndexOf(" ")) != -1) {
                        uml2MOFCorbaType = uml2MOFCorbaType.substring(0, end);
                    }
                    if (uml2MOFCorbaType != null && uml2MOFCorbaType.length() != 0) {
                        this.roseUtil.typeTable.put(eDataType, uml2MOFCorbaType);
                    }
                }
            } else if (stereoTypeValue.equalsIgnoreCase("javatype")) {
                int index;
                EDataType eDataType = EcoreFactory.eINSTANCE.createEDataType();
                String classifierName = roseNode.getClassifierName();
                if (classifierName == null || classifierName.length() == 0) {
                    index = objectName.lastIndexOf(".");
                    classifierName = this.validName(this.upperCaseName(index == -1 ? objectName : objectName.substring(index + 1)));
                }
                eDataType.setName(this.validName(this.upperCaseName((index = objectName.lastIndexOf(".")) == -1 ? objectName : objectName.substring(index + 1))));
                eDataType.setInstanceClassName(objectName);
                roseNode.setNode(eDataType);
                this.setEDataTypeProperties(roseNode, eDataType);
                this.build(roseNode, parent, eDataType);
            } else if (stereoTypeValue.equalsIgnoreCase("abstract")) {
                EClass eClass = EcoreFactory.eINSTANCE.createEClass();
                String classifierName = roseNode.getClassifierName();
                if (classifierName == null || classifierName.length() == 0) {
                    classifierName = this.validName(this.upperCaseName(objectName));
                }
                eClass.setName(classifierName);
                roseNode.setNode(eClass);
                this.setEClassProperties(roseNode, eClass);
                this.build(roseNode, parent, eClass);
            } else if (stereoTypeValue.equalsIgnoreCase("MapEntry")) {
                EClass eClass = EcoreFactory.eINSTANCE.createEClass();
                String classifierName = roseNode.getClassifierName();
                if (classifierName == null || classifierName.length() == 0) {
                    classifierName = this.validName(this.upperCaseName(objectName));
                }
                eClass.setName(classifierName);
                roseNode.setNode(eClass);
                this.setEClassProperties(roseNode, eClass);
                eClass.setInstanceClassName("java.util.Map$Entry");
                this.build(roseNode, parent, eClass);
            } else {
                this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_UnrecognizedStereotype_message", new Object[]{stereoTypeValue, objectName}));
                EClass eClass = EcoreFactory.eINSTANCE.createEClass();
                String classifierName = roseNode.getClassifierName();
                if (classifierName == null || classifierName.length() == 0) {
                    classifierName = this.validName(this.upperCaseName(objectName));
                }
                eClass.setName(classifierName);
                roseNode.setNode(eClass);
                this.setEClassProperties(roseNode, eClass);
                this.build(roseNode, parent, eClass);
            }
        } else {
            EClass eClass = EcoreFactory.eINSTANCE.createEClass();
            String classifierName = roseNode.getClassifierName();
            if (classifierName == null || classifierName.length() == 0) {
                classifierName = this.validName(this.upperCaseName(objectName));
            }
            eClass.setName(classifierName);
            roseNode.setNode(eClass);
            this.setEClassProperties(roseNode, eClass);
            this.build(roseNode, parent, eClass);
        }
    }

    protected void visitOperation(RoseNode roseNode, String roseNodeValue, String objectKey, String objectName, Object parent) {
        EOperation eOperation = EcoreFactory.eINSTANCE.createEOperation();
        String operationName = roseNode.getOperationName();
        if (operationName == null || operationName.length() == 0) {
            operationName = this.validName(objectName);
        }
        eOperation.setName(operationName);
        roseNode.setNode(eOperation);
        this.setResultType(roseNode, eOperation);
        this.setEOperationProperties(roseNode, eOperation);
        if (parent instanceof EClass) {
            ((EClass)parent).getEOperations().add(eOperation);
        }
    }

    protected void visitParameter(RoseNode roseNode, String roseNodeValue, String objectKey, String objectName, Object parent) {
        EParameter eParameter = EcoreFactory.eINSTANCE.createEParameter();
        eParameter.setName(this.validName(objectName));
        roseNode.setNode(eParameter);
        if (parent instanceof EOperation) {
            ((EOperation)parent).getEParameters().add(eParameter);
        }
        this.setEParameterProperties(roseNode, eParameter);
    }

    protected void visitInheritanceRelationship(RoseNode roseNode, String roseNodeValue, String objectKey, String objectName, Object parent) {
        ArrayList<String> superList;
        String quidu = roseNode.getRoseRefId();
        if (quidu != null && !quidu.equals("")) {
            quidu = quidu.substring(1, quidu.length() - 1);
        }
        if ((superList = (ArrayList<String>)this.roseUtil.superTable.get(parent)) == null) {
            superList = new ArrayList<String>();
            this.roseUtil.superTable.put(parent, superList);
        }
        superList.add(quidu);
        superList.add(roseNode.getStereotype());
    }

    protected void visitClassattribute(RoseNode roseNode, String roseNodeValue, String objectKey, String objectName, Object parent) {
        if (parent instanceof EEnum) {
            EEnumLiteral eEnumLiteral = ((EEnum)parent).getEEnumLiteral(objectName);
            if (eEnumLiteral == null) {
                eEnumLiteral = EcoreFactory.eINSTANCE.createEEnumLiteral();
                String literalName = roseNode.getAttributeName();
                if (literalName == null || literalName.length() == 0) {
                    literalName = this.validName(objectName);
                }
                eEnumLiteral.setName(literalName);
                roseNode.setNode(eEnumLiteral);
                if (!this.setEEnumLiteralProperties(roseNode, eEnumLiteral)) {
                    if (((EEnum)parent).getELiterals() == null) {
                        eEnumLiteral.setValue(0);
                    } else {
                        eEnumLiteral.setValue(((EEnum)parent).getELiterals().size());
                    }
                }
                ((EEnum)parent).getELiterals().add(eEnumLiteral);
            }
        } else if (parent instanceof EClassifier) {
            String stereoTypeValue = null;
            RoseNode stereoTypeNode = roseNode.findNodeWithKey("stereotype");
            if (stereoTypeNode != null) {
                stereoTypeValue = stereoTypeNode.getValue();
                stereoTypeValue = stereoTypeValue.substring(1, stereoTypeValue.length() - 1);
            }
            if ((parent instanceof EDataType || parent instanceof EClass) && "javaclass".equalsIgnoreCase(stereoTypeValue)) {
                this.roseUtil.typeTable.remove(parent);
                ((EClassifier)parent).setInstanceClassName(objectName);
            } else if (parent instanceof EClass) {
                EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
                String attributeName = roseNode.getAttributeName();
                if (attributeName == null || attributeName.length() == 0) {
                    attributeName = this.validName(objectName);
                }
                eAttribute.setName(attributeName);
                roseNode.setNode(eAttribute);
                this.setEAttributeProperties(roseNode, eAttribute);
                ((EClass)parent).getEStructuralFeatures().add(eAttribute);
                if (eAttribute.getUpperBound() == 0) {
                    eAttribute.setUpperBound(1);
                }
            }
        }
    }

    protected void visitAssociation(RoseNode roseNode, String roseNodeValue, String objectKey, String objectName, Object parent) {
        this.ref1 = null;
        this.ref2 = null;
        this.role1 = null;
        this.role2 = null;
    }

    protected void visitRole(RoseNode roseNode, String roseNodeValue, String objectKey, String objectName, Object parent) {
        EReference ref = EcoreFactory.eINSTANCE.createEReference();
        ref.setUpperBound(0);
        String referenceName = roseNode.getReferenceName();
        if (referenceName == null || referenceName.length() == 0) {
            referenceName = this.validName(objectName);
        }
        ref.setName(referenceName);
        roseNode.setNode(ref);
        this.setEReferenceProperties(roseNode, ref);
        if (this.ref1 == null) {
            this.ref1 = ref;
        } else if (this.ref2 == null) {
            this.ref2 = ref;
        }
        if (this.role1 == null) {
            this.role1 = roseNode;
        } else if (this.role2 == null) {
            this.role2 = roseNode;
        }
        if (this.ref1 != null && this.ref2 != null && this.role1 != null && this.role2 != null) {
            TableObject obj;
            String ref2Quidu;
            String ref1Quidu = this.role1.getRoseRefId();
            if (ref1Quidu != null && !ref1Quidu.equals("")) {
                ref1Quidu = ref1Quidu.substring(1, ref1Quidu.length() - 1);
            }
            if ((ref2Quidu = this.role2.getRoseRefId()) != null && !ref2Quidu.equals("")) {
                ref2Quidu = ref2Quidu.substring(1, ref2Quidu.length() - 1);
            }
            boolean ref1Navigable = this.role1.isNavigable();
            boolean ref2Navigable = this.role2.isNavigable();
            if (ref1Navigable) {
                this.ref2.setEOpposite(this.ref1);
                this.setEReferenceIsContainment(this.ref1, this.role1, this.role2);
                this.roseUtil.refTable.put(this.ref1, ref2Quidu);
                obj = (TableObject)this.roseUtil.quidTable.get(ref1Quidu);
                if (obj != null) {
                    this.roseUtil.typeTable.put(this.ref1, obj.getName());
                } else {
                    this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_UnresolvedTypeNameFor_message", new Object[]{this.role1.getRoseSupplier(), this.ref1.getName()}));
                    this.roseUtil.typeTable.put(this.ref1, "EObject");
                }
            }
            if (ref2Navigable) {
                this.ref1.setEOpposite(this.ref2);
                this.setEReferenceIsContainment(this.ref2, this.role2, this.role1);
                this.roseUtil.refTable.put(this.ref2, ref1Quidu);
                obj = (TableObject)this.roseUtil.quidTable.get(ref2Quidu);
                if (obj != null) {
                    this.roseUtil.typeTable.put(this.ref2, obj.getName());
                } else {
                    this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_UnresolvedTypeNameFor_message", new Object[]{this.role2.getRoseSupplier(), this.ref2.getName()}));
                    this.roseUtil.typeTable.put(this.ref2, "EObject");
                }
            }
        }
        if (ref.getUpperBound() == 0) {
            this.setEReferenceDefaultMultiplicity(ref);
        }
    }

    protected EList getExtentFromTableObject(RoseNode roseNode) {
        TableObject obj;
        String quid = roseNode.getRoseId();
        if (quid != null) {
            quid = quid.substring(1, quid.length() - 1);
        }
        return (obj = (TableObject)this.roseUtil.quidTable.get(quid)) == null ? null : obj.getContainer().getExtent();
    }

    protected void setEReferenceIsContainment(EReference ref, RoseNode role1, RoseNode role2) {
        boolean isAggregate = role2.isAggregate();
        String containmentV = role1.getContainment();
        if (isAggregate && containmentV != null && containmentV.equalsIgnoreCase("by value")) {
            EReference opposite = ref.getEOpposite();
            if (opposite != null && opposite.getUpperBound() != 1) {
                if (this.bounded.contains(opposite)) {
                    this.error(RoseImporterPlugin.INSTANCE.getString("_UI_ContainerRelationUpperBound_message", new Object[]{ref.getName(), ref.getEOpposite().getName()}));
                }
                opposite.setUpperBound(1);
            }
            ref.setContainment(true);
        }
    }

    protected void setResultType(RoseNode roseNode, EOperation eOperation) {
        String quid = roseNode.getRoseRefId();
        if (quid != null && !quid.equals("")) {
            TableObject tableObj = (TableObject)this.roseUtil.quidTable.get(quid = quid.substring(1, quid.length() - 1));
            if (tableObj != null) {
                this.roseUtil.typeTable.put(eOperation, tableObj.getName());
            } else {
                this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_UnresolvedTypeIDFor_message", new Object[]{quid, eOperation.getName()}));
                this.roseUtil.typeTable.put(eOperation, "EString");
            }
        } else {
            String resultValue = this.getQualifiedTypeName(eOperation, roseNode.getResult());
            if (resultValue != null && !resultValue.equalsIgnoreCase("void")) {
                if (!resultValue.equals("")) {
                    this.roseUtil.typeTable.put(eOperation, resultValue);
                } else {
                    this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_UnresolvedTypeNameFor_message", new Object[]{roseNode.getRoseSupplier(), eOperation.getName()}));
                    this.roseUtil.typeTable.put(eOperation, "EString");
                }
            }
        }
    }

    protected void setEModelElementProperties(RoseNode roseNode, EModelElement eModelElement) {
        String constraints;
        String documentation;
        String annotation = roseNode.getAnnotation();
        if (annotation != null) {
            Matcher matcher = ANNOTATION_PATTERN.matcher(annotation);
            while (matcher.find()) {
                EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                eAnnotation.setSource(CodeGenUtil.parseString(matcher.group(1)));
                Matcher detailMatcher = ANNOTATION_DETAIL_PATTERN.matcher(matcher.group(2));
                while (detailMatcher.find()) {
                    eAnnotation.getDetails().put(CodeGenUtil.parseString(detailMatcher.group(1)), CodeGenUtil.parseString(detailMatcher.group(4)));
                }
                eModelElement.getEAnnotations().add(eAnnotation);
            }
        }
        if ((documentation = roseNode.getDocumentation()) != null) {
            EcoreUtil.setDocumentation(eModelElement, documentation);
        }
        if ((constraints = roseNode.getEcoreConstraints()) != null) {
            ArrayList<String> constraintList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(constraints);
            while (stringTokenizer.hasMoreTokens()) {
                String constraint = stringTokenizer.nextToken();
                constraintList.add(constraint);
            }
            EcoreUtil.setConstraints(eModelElement, constraintList);
        }
    }

    protected void setEPackageProperties(RoseNode roseNode, EPackage ePackage, String tentativeName) {
        String nsURI;
        String nsPrefix;
        roseNode.setNode(ePackage);
        this.setEModelElementProperties(roseNode, ePackage);
        String packageName = roseNode.getPackageName();
        if (packageName == null || packageName.length() == 0) {
            packageName = this.validName(tentativeName);
        }
        ePackage.setName(packageName);
        String basePackage = roseNode.getBasePackage();
        String prefix = this.validName(this.upperCaseName(roseNode.getPrefix()));
        String string = nsPrefix = roseNode.getNsPrefix() == null || roseNode.getNsPrefix().length() == 0 ? (String)this.roseUtil.packageNameToNSNameMap.get(packageName) : roseNode.getNsPrefix();
        if (nsPrefix == null || nsPrefix.length() == 0) {
            nsPrefix = packageName;
            EPackage eSuperPackage = ePackage.getESuperPackage();
            if (eSuperPackage != null) {
                nsPrefix = String.valueOf(eSuperPackage.getNsPrefix()) + "." + nsPrefix;
            } else if (basePackage != null && basePackage.length() != 0) {
                nsPrefix = String.valueOf(basePackage) + "." + nsPrefix;
            }
        }
        ePackage.setNsPrefix(nsPrefix);
        String string2 = nsURI = roseNode.getNsURI() == null || roseNode.getNsURI().length() == 0 ? (String)this.roseUtil.packageNameToNSURIMap.get(packageName) : roseNode.getNsURI();
        if (nsURI == null || nsURI.length() == 0) {
            nsURI = this.noQualify ? String.valueOf(nsPrefix) + ".ecore" : "http:///" + nsPrefix.replace('.', '/') + ".ecore";
        }
        ePackage.setNsURI(nsURI);
        if (prefix != null && prefix.length() == 0) {
            prefix = null;
        }
        if (basePackage != null && basePackage.length() == 0) {
            basePackage = null;
        }
        if (prefix != null || basePackage != null) {
            ArrayList<String> information = new ArrayList<String>();
            information.add(basePackage);
            information.add(prefix);
            this.roseUtil.getEPackageToInformationMap().put(ePackage, information);
        }
    }

    protected void setEClassProperties(RoseNode roseNode, EClass eClass) {
        int xmlContentKind;
        this.setEModelElementProperties(roseNode, eClass);
        String xmlName = roseNode.getXMLName();
        if (xmlName != null && xmlName.length() != 0) {
            ExtendedMetaData.INSTANCE.setName(eClass, xmlName);
        }
        if ((xmlContentKind = roseNode.getXMLContentKind()) != 0) {
            ExtendedMetaData.INSTANCE.setContentKind(eClass, xmlContentKind);
        }
        eClass.setAbstract(roseNode.isAbstract());
    }

    protected void setEDataTypeProperties(RoseNode roseNode, EDataType eDataType) {
        this.setEModelElementProperties(roseNode, eDataType);
        String xmlName = roseNode.getXMLName();
        if (xmlName != null && xmlName.length() != 0) {
            ExtendedMetaData.INSTANCE.setName(eDataType, xmlName);
        }
        eDataType.setSerializable(!roseNode.isAbstract());
    }

    protected void setEEnumProperties(RoseNode roseNode, EEnum eEnum) {
        String value;
        this.setEModelElementProperties(roseNode, eEnum);
        String xmlName = roseNode.getXMLName();
        if (xmlName != null && xmlName.length() != 0) {
            ExtendedMetaData.INSTANCE.setName(eEnum, xmlName);
        }
        if ((value = roseNode.getDocumentation()) != null && !value.equals("")) {
            this.eEnums.put(eEnum, value);
        }
    }

    protected void populateEEnumFromDocumentation(EEnum eEnum, String documentation) {
        EList eLiterals = eEnum.getELiterals();
        StringTokenizer stringTokenizer = new StringTokenizer(documentation, ", \n\r\t");
        while (stringTokenizer.hasMoreTokens()) {
            String literalV;
            String name = literalV = stringTokenizer.nextToken();
            String number = "";
            int ind = literalV.indexOf("=");
            if (ind != -1) {
                name = literalV.substring(0, ind);
                number = literalV.substring(ind + 1, literalV.length());
            }
            int numberValue = 0;
            if (!number.equals("")) {
                numberValue = new Integer(number);
            } else if (!eLiterals.isEmpty()) {
                numberValue = ((EEnumLiteral)eLiterals.get(eLiterals.size() - 1)).getValue() + 1;
            }
            if (name.equals("")) continue;
            EEnumLiteral lit = eEnum.getEEnumLiteral(name);
            if (lit == null) {
                lit = EcoreFactory.eINSTANCE.createEEnumLiteral();
                lit.setName(this.validName(name));
                lit.setValue(numberValue);
                eLiterals.add(lit);
                continue;
            }
            lit.setValue(numberValue);
        }
    }

    protected void setEOperationProperties(RoseNode roseNode, EOperation eOperation) {
        String stereotype;
        String exceptions;
        this.setETypedElementProperties(roseNode, eOperation);
        eOperation.setUnique(roseNode.isUnique());
        String semantics = roseNode.getSemantics();
        if (semantics != null) {
            EAnnotation eAnnotation = eOperation.getEAnnotation("http://www.eclipse.org/emf/2002/GenModel");
            if (eAnnotation == null) {
                eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                eAnnotation.setSource("http://www.eclipse.org/emf/2002/GenModel");
                eOperation.getEAnnotations().add(eAnnotation);
            }
            eAnnotation.getDetails().put("body", semantics);
        }
        if ((exceptions = roseNode.getExceptions()) != null) {
            int count = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(exceptions.trim(), ",");
            while (stringTokenizer.hasMoreTokens()) {
                String exceptionValue;
                String exception = stringTokenizer.nextToken().trim();
                if (exception.indexOf("[") != -1) {
                    exception = exception.substring(0, exception.indexOf("["));
                }
                if ((exceptionValue = this.getQualifiedTypeName(eOperation, exception)) != null && !exceptionValue.equals("")) {
                    EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                    eAnnotation.getReferences().add(eOperation);
                    eAnnotation.getDetails().put("position", Integer.toString(count++));
                    this.roseUtil.typeTable.put(eAnnotation, exceptionValue);
                    continue;
                }
                this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_UnresolvedTypeNameFor_message", new Object[]{roseNode.getRoseSupplier(), eOperation.getName()}));
            }
        }
        if ((stereotype = roseNode.getStereotype()) != null && "inv".equals(stereotype)) {
            eOperation.setEType(EcorePackage.Literals.EBOOLEAN);
            eOperation.getEParameters().clear();
            EParameter eParameter = EcoreFactory.eINSTANCE.createEParameter();
            eParameter.setName("diagnostics");
            eParameter.setEType(EcorePackage.Literals.EDIAGNOSTIC_CHAIN);
            eOperation.getEParameters().add(eParameter);
            eParameter = EcoreFactory.eINSTANCE.createEParameter();
            eParameter.setName("context");
            eParameter.setEType(EcorePackage.Literals.EMAP);
            eOperation.getEParameters().add(eParameter);
        }
    }

    protected void setEAttributeProperties(RoseNode roseNode, EAttribute eAttribute) {
        this.eStructuralFeatures.add(eAttribute);
        String quid = roseNode.getRoseRefId();
        if (quid != null && !quid.equals("")) {
            TableObject tableObj = (TableObject)this.roseUtil.quidTable.get(quid = quid.substring(1, quid.length() - 1));
            if (tableObj != null) {
                this.roseUtil.typeTable.put(eAttribute, tableObj.getName());
            } else {
                this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_UnresolvedTypeIDFor_message", new Object[]{quid, eAttribute.getName()}));
                this.roseUtil.typeTable.put(eAttribute, "String");
            }
        } else {
            String type = this.getQualifiedTypeName(eAttribute, roseNode.getType());
            if (type != null && !type.equals("")) {
                this.roseUtil.typeTable.put(eAttribute, type);
            } else {
                this.roseUtil.typeTable.put(eAttribute, "String");
                this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_AttributeDoesNotDefineItsType_message", new Object[]{eAttribute.getName()}));
            }
        }
        String initv = roseNode.getInitV();
        if (initv != null && initv.length() >= 2) {
            if (initv.charAt(0) == '\'' && initv.charAt(initv.length() - 1) == '\'') {
                try {
                    char i = CodeGenUtil.parseChar(initv.substring(1, initv.length() - 1));
                    initv = Integer.toString(i);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.error(RoseImporterPlugin.INSTANCE.getString("_UI_InvalidDefaultValueForAttribute_message", new Object[]{eAttribute.getName()}));
                    initv = null;
                }
            } else if (initv.charAt(0) == '\"' && initv.charAt(initv.length() - 1) == '\"') {
                try {
                    initv = CodeGenUtil.parseString(initv.substring(1, initv.length() - 1));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.error(RoseImporterPlugin.INSTANCE.getString("_UI_InvalidDefaultValueForAttribute_message", new Object[]{eAttribute.getName()}));
                    initv = null;
                }
            }
        }
        if (initv != null) {
            eAttribute.setDefaultValueLiteral(initv);
        }
        this.setEStructuralFeatureProperties(roseNode, eAttribute);
        eAttribute.setDerived(roseNode.isDerived());
        eAttribute.setTransient(roseNode.isTransient());
        eAttribute.setVolatile(roseNode.isVolatile());
        eAttribute.setChangeable(roseNode.isChangeable());
        eAttribute.setUnique(roseNode.isUnique());
        eAttribute.setUnsettable(roseNode.isUnsettable());
        eAttribute.setID(roseNode.isID());
        this.setEStructuralFeatureVisibility(roseNode, eAttribute);
    }

    protected void setEReferenceProperties(RoseNode roseNode, EReference eReference) {
        this.eStructuralFeatures.add(eReference);
        eReference.setDerived(roseNode.getParent().getParent().isDerived());
        this.setEStructuralFeatureProperties(roseNode, eReference);
        eReference.setTransient(roseNode.isTransient());
        eReference.setVolatile(roseNode.isVolatile());
        eReference.setChangeable(roseNode.isChangeable());
        eReference.setResolveProxies(roseNode.isResolveProxies());
        eReference.setUnsettable(roseNode.isUnsettable());
        this.setEStructuralFeatureVisibility(roseNode, eReference);
    }

    protected void setEStructuralFeatureProperties(RoseNode roseNode, EStructuralFeature eStructuralFeature) {
        String xmlNamespace;
        int xmlFeatureKind;
        this.setETypedElementProperties(roseNode, eStructuralFeature);
        String xmlName = roseNode.getXMLName();
        if (xmlName != null && xmlName.length() != 0) {
            ExtendedMetaData.INSTANCE.setName(eStructuralFeature, xmlName);
        }
        if ((xmlFeatureKind = roseNode.getXMLFeatureKind()) != 0) {
            ExtendedMetaData.INSTANCE.setFeatureKind(eStructuralFeature, xmlFeatureKind);
        }
        if ((xmlNamespace = roseNode.getXMLNamespace()) != null && xmlNamespace.length() != 0) {
            this.eStructuralFeatureToXMLNamespaceMap.put(eStructuralFeature, xmlNamespace);
        }
    }

    protected void setETypedElementProperties(RoseNode roseNode, ETypedElement eTypedElement) {
        String multiplicity;
        this.setEModelElementProperties(roseNode, eTypedElement);
        String string = multiplicity = eTypedElement instanceof EReference ? roseNode.getRoleMultiplicity() : roseNode.getStereotype();
        if (multiplicity != null) {
            this.bounded.add(eTypedElement);
            if (multiplicity.length() > 0 && Character.isLetter(multiplicity.charAt(0)) && !"n".equalsIgnoreCase(multiplicity)) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(multiplicity, ". \n\r\t");
            switch (stringTokenizer.countTokens()) {
                case 1: {
                    String bound = stringTokenizer.nextToken();
                    if (bound.equals("*") || bound.equalsIgnoreCase("n")) {
                        eTypedElement.setUpperBound(-1);
                        break;
                    }
                    try {
                        int boundValue = Integer.parseInt(bound);
                        if (boundValue > 0) {
                            eTypedElement.setLowerBound(boundValue);
                            eTypedElement.setUpperBound(boundValue);
                            break;
                        }
                        this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_BadMultiplicityFor_message", new Object[]{multiplicity, eTypedElement.getName()}));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_BadMultiplicityFor_message", new Object[]{multiplicity, eTypedElement.getName()}));
                    }
                    break;
                }
                case 2: {
                    String lowerBound = stringTokenizer.nextToken();
                    try {
                        int lowerBoundValue = Integer.parseInt(lowerBound);
                        if (lowerBoundValue >= 0) {
                            String upperBound = stringTokenizer.nextToken();
                            if (upperBound.equals("*") || upperBound.equalsIgnoreCase("n")) {
                                eTypedElement.setLowerBound(lowerBoundValue);
                                eTypedElement.setUpperBound(-1);
                                break;
                            }
                            int upperBoundValue = Integer.parseInt(upperBound);
                            if (upperBoundValue <= 0 || lowerBoundValue > upperBoundValue) {
                                this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_BadMultiplicityFor_message", new Object[]{multiplicity, eTypedElement.getName()}));
                                break;
                            }
                            eTypedElement.setLowerBound(lowerBoundValue);
                            eTypedElement.setUpperBound(upperBoundValue);
                            break;
                        }
                        this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_BadMultiplicityFor_message", new Object[]{multiplicity, eTypedElement.getName()}));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_BadMultiplicityFor_message", new Object[]{multiplicity, eTypedElement.getName()}));
                    }
                    break;
                }
                default: {
                    this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_BadMultiplicityFor_message", new Object[]{multiplicity, eTypedElement.getName()}));
                }
            }
        }
    }

    protected void setEStructuralFeatureVisibility(RoseNode roseNode, EStructuralFeature eStructuralFeature) {
        switch (roseNode.getVisibility()) {
            case 1: {
                EcoreUtil.setSuppressedVisibility(eStructuralFeature, 0, true);
                if (eStructuralFeature.isChangeable() && !eStructuralFeature.isMany()) {
                    EcoreUtil.setSuppressedVisibility(eStructuralFeature, 1, true);
                }
                if (!eStructuralFeature.isUnsettable()) break;
                EcoreUtil.setSuppressedVisibility(eStructuralFeature, 2, true);
                if (!eStructuralFeature.isChangeable()) break;
                EcoreUtil.setSuppressedVisibility(eStructuralFeature, 3, true);
                break;
            }
            case 2: {
                if (eStructuralFeature.isMany()) {
                    this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_InvalidReadOnlyVisibility_message", new Object[]{eStructuralFeature.getName()}));
                } else if (eStructuralFeature.isChangeable()) {
                    EcoreUtil.setSuppressedVisibility(eStructuralFeature, 1, true);
                }
                if (!eStructuralFeature.isUnsettable()) break;
                EcoreUtil.setSuppressedVisibility(eStructuralFeature, 2, true);
                if (!eStructuralFeature.isChangeable()) break;
                EcoreUtil.setSuppressedVisibility(eStructuralFeature, 3, true);
                break;
            }
            case 3: {
                if (!eStructuralFeature.isChangeable() && !eStructuralFeature.isMany()) {
                    this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_InvalidReadWriteVisibility_message", new Object[]{eStructuralFeature.getName()}));
                }
                if (!eStructuralFeature.isUnsettable()) break;
                EcoreUtil.setSuppressedVisibility(eStructuralFeature, 2, true);
                if (!eStructuralFeature.isChangeable()) break;
                EcoreUtil.setSuppressedVisibility(eStructuralFeature, 3, true);
                break;
            }
            case 4: {
                if (eStructuralFeature.isMany()) {
                    this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_InvalidReadOnlyVisibility_message", new Object[]{eStructuralFeature.getName()}));
                } else if (eStructuralFeature.isChangeable()) {
                    EcoreUtil.setSuppressedVisibility(eStructuralFeature, 1, true);
                }
                if (!eStructuralFeature.isUnsettable()) {
                    this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_InvalidUnsettableVisibility_message", new Object[]{eStructuralFeature.getName()}));
                    break;
                }
                if (!eStructuralFeature.isChangeable()) break;
                EcoreUtil.setSuppressedVisibility(eStructuralFeature, 3, true);
                break;
            }
            case 5: {
                if (!eStructuralFeature.isChangeable()) {
                    this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_InvalidReadWriteVisibility_message", new Object[]{eStructuralFeature.getName()}));
                }
                if (eStructuralFeature.isUnsettable()) break;
                this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_InvalidUnsettableVisibility_message", new Object[]{eStructuralFeature.getName()}));
                break;
            }
        }
    }

    protected boolean setEEnumLiteralProperties(RoseNode roseNode, EEnumLiteral eEnumLiteral) {
        this.setEModelElementProperties(roseNode, eEnumLiteral);
        String value = roseNode.getInitV();
        if (value != null && !value.equals("")) {
            eEnumLiteral.setValue(Integer.parseInt(value));
            return true;
        }
        return false;
    }

    protected void setEParameterProperties(RoseNode roseNode, EParameter eParameter) {
        this.setEModelElementProperties(roseNode, eParameter);
        String quid = roseNode.getRoseRefId();
        if (quid != null && !quid.equals("")) {
            TableObject tableObj = (TableObject)this.roseUtil.quidTable.get(quid = quid.substring(1, quid.length() - 1));
            if (tableObj != null) {
                this.roseUtil.typeTable.put(eParameter, tableObj.getName());
            } else {
                this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_UnresolvedTypeIDFor_message", new Object[]{quid, eParameter.getEOperation().getName()}));
                this.roseUtil.typeTable.put(eParameter, "EObject");
            }
        } else {
            String type = this.getQualifiedTypeName(eParameter, roseNode.getType());
            if (type != null && !type.equals("")) {
                this.roseUtil.typeTable.put(eParameter, type);
            } else {
                this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_UnresolvedTypeNameFor_message", new Object[]{roseNode.getRoseSupplier(), eParameter.getEOperation().getName()}));
                this.roseUtil.typeTable.put(eParameter, "EObject");
            }
        }
    }

    protected void setEReferenceDefaultMultiplicity(EReference eReference) {
        if (eReference.getEOpposite() == null || !eReference.getEOpposite().isContainment()) {
            eReference.setLowerBound(0);
            eReference.setUpperBound(-1);
        }
    }

    public void setEEnums() {
        Iterator i = this.eEnums.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            EEnum eEnum = (EEnum)entry.getKey();
            if (!eEnum.getELiterals().isEmpty()) continue;
            this.populateEEnumFromDocumentation(eEnum, (String)entry.getValue());
        }
    }

    public void setSuper() {
        HashMap<EClass, List[]> superMap = new HashMap<EClass, List[]>();
        Iterator i = this.roseUtil.superTable.keySet().iterator();
        while (i.hasNext()) {
            Object subObject = i.next();
            if (subObject instanceof EClass) {
                EClass eClass = (EClass)subObject;
                ArrayList<Object> extend = new ArrayList<Object>();
                ArrayList<Object> unspecified = new ArrayList<Object>();
                ArrayList<Object> mixin = new ArrayList<Object>();
                ArrayList<Object> nonClass = new ArrayList<Object>();
                Iterator j = ((List)this.roseUtil.superTable.get(eClass)).iterator();
                while (j.hasNext()) {
                    String quid = (String)j.next();
                    String stereotype = (String)j.next();
                    TableObject tableObject = (TableObject)this.roseUtil.quidTable.get(quid);
                    if (tableObject == null) continue;
                    Object superObject = tableObject.getObject();
                    if (superObject instanceof EClass) {
                        EClass superClass = (EClass)superObject;
                        if (!superClass.isInterface()) {
                            if ("extend".equals(stereotype)) {
                                extend.add(superObject);
                                continue;
                            }
                            if ("mixin".equals(stereotype)) {
                                mixin.add(superObject);
                                continue;
                            }
                            unspecified.add(superObject);
                            continue;
                        }
                        nonClass.add(superObject);
                        continue;
                    }
                    this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_CannotAddSuperLinkBetween_message", new Object[]{eClass.getName(), ((ENamedElement)superObject).getName()}));
                }
                if (extend.size() > 1) {
                    this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_CannotSpecifyMoreThanOneExtendFor_message", new Object[]{eClass.getName()}));
                }
                superMap.put(eClass, new List[]{extend, unspecified, mixin});
                eClass.getESuperTypes().addAll(extend);
                eClass.getESuperTypes().addAll(unspecified);
                eClass.getESuperTypes().addAll(mixin);
                eClass.getESuperTypes().addAll(nonClass);
                continue;
            }
            this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_CannotAddSuperLinkInvolving_message", new Object[]{((ENamedElement)subObject).getName()}));
        }
        this.sortSuper(superMap);
    }

    protected void sortSuper(Map superMap) {
        Iterator entries = superMap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            EClass eClass = (EClass)entry.getKey();
            List[] collections = (List[])entry.getValue();
            Collections.sort(collections[0], eClassComparator);
            Collections.sort(collections[1], eClassComparator);
            Collections.sort(collections[2], eClassComparator);
            UniqueEList combined = new UniqueEList(collections[0]);
            combined.addAll(collections[1]);
            combined.addAll(collections[2]);
            EList eSuper = eClass.getESuperTypes();
            ListIterator ordered = combined.listIterator();
            while (ordered.hasNext()) {
                Object eSuperItem = ordered.next();
                eSuper.move(ordered.previousIndex(), eSuperItem);
            }
        }
    }

    public void setIDs(EObject parent, EObject child) {
        new EcoreSwitch(){

            public Object caseEPackage(EPackage ePackage) {
                return null;
            }

            public Object caseEClassifier(EClassifier eClassifier) {
                return null;
            }

            public Object caseEOperation(EOperation eOperation) {
                return null;
            }

            public Object caseEParameter(EParameter eParameter) {
                return null;
            }

            public Object caseEStructuralFeature(EStructuralFeature eStructuralFeature) {
                return null;
            }

            public Object caseEEnumLiteral(EEnumLiteral eEnumLiteral) {
                return null;
            }

            public Object defaultCase(EObject eObject) {
                Iterator i = eObject.eContents().iterator();
                while (i.hasNext()) {
                    RoseEcoreBuilder.this.setIDs(eObject, (EObject)i.next());
                }
                return this;
            }
        }.doSwitch(child);
    }

    public void validate(EObject object) {
        new EcoreSwitch(){

            public Object caseEDataType(EDataType eDataType) {
                return RoseEcoreBuilder.this.validateEDataType(eDataType);
            }

            public Object caseEEnum(EEnum eEnum) {
                return RoseEcoreBuilder.this.validateEEnum(eEnum);
            }

            public Object caseEClass(EClass eClass) {
                return RoseEcoreBuilder.this.validateEClass(eClass);
            }

            public Object defaultCase(EObject eObject) {
                Iterator i = eObject.eContents().iterator();
                while (i.hasNext()) {
                    RoseEcoreBuilder.this.validate((EObject)i.next());
                }
                return this;
            }
        }.doSwitch(object);
    }

    protected Object validateEDataType(EDataType eDataType) {
        if (!(eDataType instanceof EEnum) && eDataType.getInstanceClassName() == null) {
            this.error(RoseImporterPlugin.INSTANCE.getString("_UI_DatatypeNotSetFor_message", new Object[]{eDataType.getName()}));
            eDataType.setInstanceClassName("java.lang.String");
        }
        return null;
    }

    protected Object validateEEnum(EEnum eEnum) {
        Iterator literals = eEnum.getELiterals().iterator();
        block0: while (literals.hasNext()) {
            EEnumLiteral eEnumLiteral = (EEnumLiteral)literals.next();
            Iterator allLiterals = eEnum.getELiterals().iterator();
            while (allLiterals.hasNext()) {
                EEnumLiteral otherLiteral = (EEnumLiteral)allLiterals.next();
                if (eEnumLiteral == otherLiteral) continue block0;
                if (!eEnumLiteral.getName().equalsIgnoreCase(otherLiteral.getName())) continue;
                this.error(RoseImporterPlugin.INSTANCE.getString("_UI_DuplicateLiteral_message", new Object[]{eEnumLiteral.getName(), eEnum.getName()}));
                literals.remove();
                continue block0;
            }
        }
        return this;
    }

    protected Object validateEClass(EClass eClass) {
        EStructuralFeature otherFeature;
        Iterator allFeatures;
        ArrayList<EReference> oppositesToRemove = new ArrayList<EReference>();
        Iterator features = eClass.getEStructuralFeatures().iterator();
        block2: while (features.hasNext()) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)features.next();
            if (eStructuralFeature instanceof EAttribute) {
                EAttribute eAttribute = (EAttribute)eStructuralFeature;
                if (this.unsettablePrimitive) {
                    try {
                        EDataType eDataType = eAttribute.getEAttributeType();
                        if (eDataType instanceof EEnum || eDataType.getInstanceClass().isPrimitive()) {
                            eAttribute.setUnsettable(true);
                        }
                    }
                    catch (Exception exception) {}
                }
                Iterator allFeatures2 = eClass.getEAllStructuralFeatures().iterator();
                while (allFeatures2.hasNext()) {
                    EStructuralFeature otherFeature2 = (EStructuralFeature)allFeatures2.next();
                    if (eAttribute == otherFeature2) continue block2;
                    if (eAttribute.getName().equalsIgnoreCase(otherFeature2.getName())) {
                        this.error(RoseImporterPlugin.INSTANCE.getString("_UI_DuplicateAttribute_message", new Object[]{eAttribute.getName(), eClass.getName()}));
                        features.remove();
                        continue block2;
                    }
                    if (eAttribute.getEAttributeType().isSerializable() || eAttribute.isTransient()) continue;
                    this.error(RoseImporterPlugin.INSTANCE.getString("_UI_TheAttributeShouldBeTransient_message", new Object[]{eAttribute.getName(), eAttribute.getEType().getName()}));
                    continue block2;
                }
                continue;
            }
            EReference eReference = (EReference)eStructuralFeature;
            EReference opposite = eReference.getEOpposite();
            if (opposite != null) {
                if (opposite.eContainer() == null) {
                    this.error(RoseImporterPlugin.INSTANCE.getString("_UI_AnAssociationHasADanglingEnd_message", new Object[]{opposite.getName(), eReference.getName()}));
                    opposite = null;
                    eReference.setEOpposite(null);
                } else if (opposite.isContainment()) {
                    eReference.setTransient(true);
                    if (eReference.getUpperBound() != 1) {
                        if (this.bounded.contains(eReference)) {
                            this.error(RoseImporterPlugin.INSTANCE.getString("_UI_ContainerRelationUpperBound_message", new Object[]{opposite.getName(), eReference.getName()}));
                        }
                        eReference.setUpperBound(1);
                    }
                }
            }
            if (eReference.isTransient() && !eReference.isVolatile() && opposite != null && !opposite.isTransient() && opposite.isResolveProxies() && !opposite.isContainment()) {
                this.error(RoseImporterPlugin.INSTANCE.getString("_UI_CrossDocumentBidirectionalTransient_message", new Object[]{opposite.getName(), eReference.getName()}));
            }
            allFeatures = eClass.getEAllStructuralFeatures().iterator();
            while (allFeatures.hasNext()) {
                otherFeature = (EStructuralFeature)allFeatures.next();
                if (eReference == otherFeature) break;
                if (!eReference.getName().equalsIgnoreCase(otherFeature.getName())) continue;
                this.error(RoseImporterPlugin.INSTANCE.getString("_UI_DuplicateReference_message", new Object[]{eReference.getName(), eClass.getName()}));
                if (opposite != null) {
                    oppositesToRemove.add(opposite);
                }
                features.remove();
                break;
            }
            if (eReference.isContainer() || !"java.util.Map$Entry".equals(eReference.getEType().getInstanceClassName()) || eReference.isContainment() && eReference.isMany()) continue;
            this.error(RoseImporterPlugin.INSTANCE.getString("_UI_MultiplicityManyContainmentIsAssumedFor_message", new Object[]{eReference.getName(), eClass.getName()}));
            eReference.setContainment(true);
            eReference.setUpperBound(-1);
        }
        Iterator opposites = oppositesToRemove.iterator();
        while (opposites.hasNext()) {
            EReference opposite = (EReference)opposites.next();
            EClass oppositeEClass = opposite.getEContainingClass();
            if (oppositeEClass == null) continue;
            oppositeEClass.getEStructuralFeatures().remove(opposite);
        }
        Iterator operations = eClass.getEOperations().iterator();
        while (operations.hasNext()) {
            EOperation eOperation = (EOperation)operations.next();
            EClassifier opType = eOperation.getEType();
            if (opType instanceof EClass && "java.util.Map$Entry".equals(opType.getInstanceClassName()) && !eOperation.isMany()) {
                this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_MultiplicityManyIsAssumedForOperation_message", new Object[]{eOperation.getName(), eClass.getName()}));
                eOperation.setUpperBound(-1);
            }
            Iterator paramters = eOperation.getEParameters().iterator();
            while (paramters.hasNext()) {
                EParameter eParameter = (EParameter)paramters.next();
                EClassifier paramType = eParameter.getEType();
                if (!(paramType instanceof EClass) || !"java.util.Map$Entry".equals(paramType.getInstanceClassName()) || eParameter.isMany()) continue;
                this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_MultiplicityManyIsAssumedForParameter_message", new Object[]{eParameter.getName(), eOperation.getName(), eClass.getName()}));
                eParameter.setUpperBound(-1);
            }
        }
        if (eClass.getESuperTypes().size() > 1) {
            Iterator superTypes = eClass.getESuperTypes().iterator();
            superTypes.next();
            block8: while (superTypes.hasNext()) {
                EClass superType = (EClass)superTypes.next();
                Iterator superFeatures = superType.getEAllStructuralFeatures().iterator();
                block9: while (superFeatures.hasNext()) {
                    EStructuralFeature superFeature = (EStructuralFeature)superFeatures.next();
                    allFeatures = eClass.getEAllStructuralFeatures().iterator();
                    while (allFeatures.hasNext()) {
                        otherFeature = (EStructuralFeature)allFeatures.next();
                        if (superFeature == otherFeature) continue block9;
                        if (!superFeature.getName().equalsIgnoreCase(otherFeature.getName())) continue;
                        this.error(RoseImporterPlugin.INSTANCE.getString("_UI_DuplicateFeatureInheritance_message", new Object[]{superFeature.getName(), eClass.getName(), superType.getName()}));
                        superTypes.remove();
                        continue block8;
                    }
                }
            }
        }
        if ("java.util.Map$Entry".equals(eClass.getInstanceClassName())) {
            EStructuralFeature keyFeature = eClass.getEStructuralFeature("key");
            EStructuralFeature valueFeature = eClass.getEStructuralFeature("value");
            if (keyFeature == null) {
                this.error(RoseImporterPlugin.INSTANCE.getString("_UI_ExpectingFeatureNamedKey_message", new Object[]{eClass.getName()}));
                eClass.setInstanceClassName(null);
            }
            if (valueFeature == null) {
                this.error(RoseImporterPlugin.INSTANCE.getString("_UI_ExpectingFeatureNamedValue_message", new Object[]{eClass.getName()}));
                eClass.setInstanceClassName(null);
            }
        }
        return this;
    }

    public void setEReferences() {
        Iterator<Object> i = this.roseUtil.refTable.keySet().iterator();
        while (i.hasNext()) {
            EReference eReference = (EReference)i.next();
            String quid = (String)this.roseUtil.refTable.get(eReference);
            TableObject tableObject = (TableObject)this.roseUtil.quidTable.get(quid);
            if (tableObject == null) continue;
            Object struct = tableObject.getObject();
            if (struct instanceof EClass) {
                ((EClass)struct).getEStructuralFeatures().add(-1 - Collections.binarySearch(((EClass)struct).getEStructuralFeatures(), eReference, this.eStructuralFeatureComparator), eReference);
                continue;
            }
            this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_CannotAddReference_message", new Object[]{eReference.getName(), tableObject.getName()}));
        }
        i = this.eStructuralFeatureToXMLNamespaceMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            EStructuralFeature eStructuralFeature = (EStructuralFeature)entry.getKey();
            if (eStructuralFeature.eContainer() == null) continue;
            ExtendedMetaData.INSTANCE.setNamespace((EStructuralFeature)entry.getKey(), (String)entry.getValue());
        }
    }

    public void setETypeClassifier() {
        Iterator it = this.roseUtil.typeTable.keySet().iterator();
        while (it.hasNext()) {
            EStructuralFeature eStructuralFeature;
            EClassifier eType;
            EModelElement element = (EModelElement)it.next();
            String type = (String)this.roseUtil.typeTable.get(element);
            int position = -1;
            if (element instanceof EAnnotation) {
                position = Integer.parseInt((String)((EAnnotation)element).getDetails().get("position"));
                element = (EModelElement)((EAnnotation)element).getReferences().get(0);
            }
            TableObject tableObj = null;
            if (type.indexOf(".") == -1) {
                String qualifier = "";
                EObject parent = element.eContainer();
                while (parent != null) {
                    if (parent instanceof EPackage) {
                        qualifier = String.valueOf(((EPackage)parent).getName()) + "." + qualifier;
                    }
                    parent = parent.eContainer();
                }
                tableObj = (TableObject)this.roseUtil.nameTable.get(String.valueOf(qualifier) + type);
            }
            if (tableObj == null) {
                tableObj = (TableObject)this.roseUtil.nameTable.get(type);
            }
            if (tableObj != null && tableObj.getObject() != null && element instanceof ETypedElement) {
                eType = (EClassifier)tableObj.getObject();
            } else {
                eType = this.getBasicType(type);
                if (eType == null) {
                    this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_UnresolvedTypeNameFor_message", new Object[]{type, ((ENamedElement)element).getName()}));
                    eType = this.getBasicType("EString");
                }
            }
            if (element instanceof EAttribute && eType instanceof EClass) {
                EAttribute eAttribute = (EAttribute)element;
                EReference eReference = EcoreFactory.eINSTANCE.createEReference();
                eReference.setName(eAttribute.getName());
                eReference.setTransient(eAttribute.isTransient());
                eReference.setVolatile(eAttribute.isVolatile());
                eReference.setDerived(eAttribute.isDerived());
                eReference.setChangeable(eAttribute.isChangeable());
                eReference.setLowerBound(eAttribute.getLowerBound());
                eReference.setUpperBound(eAttribute.getUpperBound());
                eReference.setContainment(true);
                eReference.setResolveProxies(false);
                eReference.getEAnnotations().addAll(eAttribute.getEAnnotations());
                eReference.setUnsettable(eAttribute.isUnsettable());
                this.eStructuralFeatures.set(this.eStructuralFeatures.indexOf(eAttribute), eReference);
                EClass containingClass = eAttribute.getEContainingClass();
                containingClass.getEStructuralFeatures().add(containingClass.getEStructuralFeatures().indexOf(eAttribute), eReference);
                containingClass.getEStructuralFeatures().remove(eAttribute);
                element = eReference;
            } else if (element instanceof EReference) {
                EReference eReference = (EReference)element;
                boolean convert = eType instanceof EDataType;
                int kind = ExtendedMetaData.INSTANCE.getFeatureKind(eReference);
                if (kind == 3 || kind == 5 || kind == 6) {
                    convert = true;
                    eType = EcorePackage.Literals.EFEATURE_MAP_ENTRY;
                }
                if (convert) {
                    EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
                    eAttribute.setName(eReference.getName());
                    eAttribute.setTransient(eReference.isTransient());
                    eAttribute.setVolatile(eReference.isVolatile());
                    eAttribute.setDerived(eReference.isDerived());
                    eAttribute.setChangeable(eReference.isChangeable());
                    eAttribute.setLowerBound(eReference.getLowerBound());
                    eAttribute.setUpperBound(eReference.getUpperBound());
                    eAttribute.getEAnnotations().addAll(eReference.getEAnnotations());
                    eAttribute.setUnsettable(eReference.isUnsettable());
                    this.eStructuralFeatures.set(this.eStructuralFeatures.indexOf(eReference), eAttribute);
                    EClass containingClass = eReference.getEContainingClass();
                    if (containingClass != null) {
                        containingClass.getEStructuralFeatures().add(containingClass.getEStructuralFeatures().indexOf(eReference), eAttribute);
                        containingClass.getEStructuralFeatures().remove(eReference);
                    }
                    element = eAttribute;
                }
            }
            if (element instanceof EDataType) {
                ((EDataType)element).setInstanceClassName(eType.getInstanceClassName());
                continue;
            }
            if (position != -1) {
                EList exceptions = ((EOperation)element).getEExceptions();
                if (exceptions.contains(eType)) continue;
                if (position < exceptions.size()) {
                    exceptions.add(position, eType);
                    continue;
                }
                exceptions.add(eType);
                continue;
            }
            ((ETypedElement)element).setEType(eType);
            if (!(element instanceof EStructuralFeature) || !"".equals((eStructuralFeature = (EStructuralFeature)element).getName())) continue;
            eStructuralFeature.setName(eType.getName());
        }
    }

    protected EClassifier getBasicType(String value) {
        if (value.equals("boolean") || value.equalsIgnoreCase("eboolean")) {
            return EcorePackage.Literals.EBOOLEAN;
        }
        if (value.equalsIgnoreCase("boolean") || value.equalsIgnoreCase("ebooleanobject")) {
            return EcorePackage.Literals.EBOOLEAN_OBJECT;
        }
        if (value.equalsIgnoreCase("string") || value.equalsIgnoreCase("estring")) {
            return EcorePackage.Literals.ESTRING;
        }
        if (value.equalsIgnoreCase("char") || value.equalsIgnoreCase("echar")) {
            return EcorePackage.Literals.ECHAR;
        }
        if (value.equalsIgnoreCase("character") || value.equalsIgnoreCase("echaracterobject")) {
            return EcorePackage.Literals.ECHARACTER_OBJECT;
        }
        if (value.equals("double") || value.equalsIgnoreCase("edouble") || value.equalsIgnoreCase("currency")) {
            return EcorePackage.Literals.EDOUBLE;
        }
        if (value.equalsIgnoreCase("double") || value.equalsIgnoreCase("edoubleobject")) {
            return EcorePackage.Literals.EDOUBLE_OBJECT;
        }
        if (value.equalsIgnoreCase("int") || value.equalsIgnoreCase("eint")) {
            return EcorePackage.Literals.EINT;
        }
        if (value.equalsIgnoreCase("integer") || value.equalsIgnoreCase("eintegerobject")) {
            return EcorePackage.Literals.EINTEGER_OBJECT;
        }
        if (value.equals("long long") || value.equals("long") || value.equalsIgnoreCase("elong")) {
            return EcorePackage.Literals.ELONG;
        }
        if (value.equalsIgnoreCase("long") || value.equalsIgnoreCase("elongobject")) {
            return EcorePackage.Literals.ELONG_OBJECT;
        }
        if (value.equals("float") || value.equalsIgnoreCase("efloat") || value.equalsIgnoreCase("single")) {
            return EcorePackage.Literals.EFLOAT;
        }
        if (value.equalsIgnoreCase("float") || value.equalsIgnoreCase("efloatobject")) {
            return EcorePackage.Literals.EFLOAT_OBJECT;
        }
        if (value.equals("short") || value.equalsIgnoreCase("eshort")) {
            return EcorePackage.Literals.ESHORT;
        }
        if (value.equalsIgnoreCase("short") || value.equalsIgnoreCase("eshortobject")) {
            return EcorePackage.Literals.ESHORT_OBJECT;
        }
        if (value.equals("byte") || value.equalsIgnoreCase("ebyte")) {
            return EcorePackage.Literals.EBYTE;
        }
        if (value.equals("byte[]") || value.equalsIgnoreCase("ebytearray") || value.equalsIgnoreCase("ebyte[]")) {
            return EcorePackage.Literals.EBYTE_ARRAY;
        }
        if (value.equalsIgnoreCase("byte") || value.equalsIgnoreCase("ebyteObject")) {
            return EcorePackage.Literals.EBYTE_OBJECT;
        }
        if (value.equalsIgnoreCase("ebigdecimal")) {
            return EcorePackage.Literals.EBIG_DECIMAL;
        }
        if (value.equalsIgnoreCase("ebiginteger")) {
            return EcorePackage.Literals.EBIG_INTEGER;
        }
        if (value.equalsIgnoreCase("edate")) {
            return EcorePackage.Literals.EDATE;
        }
        if (value.equalsIgnoreCase("eobject")) {
            return EcorePackage.Literals.EOBJECT;
        }
        if (value.equalsIgnoreCase("efeaturemapentry")) {
            return EcorePackage.Literals.EFEATURE_MAP_ENTRY;
        }
        return null;
    }

    public void createEPackageForRootClasses(EList extent, RoseNode roseNode, String packageName) {
        ArrayList list = new ArrayList();
        Iterator i = extent.iterator();
        while (i.hasNext()) {
            Object object = i.next();
            if (object instanceof EPackage) continue;
            list.add(object);
        }
        if (!list.isEmpty()) {
            EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
            this.setEPackageProperties(roseNode, ePackage, packageName.toLowerCase());
            extent.add(ePackage);
            Iterator i2 = list.iterator();
            while (i2.hasNext()) {
                EClassifier eClassifier = (EClassifier)i2.next();
                ePackage.getEClassifiers().add(eClassifier);
                extent.remove(eClassifier);
            }
        }
    }

    protected void build(RoseNode roseNode, Object parent, ENamedElement eNamedElement) {
        TableObject tableObj;
        String quid = roseNode.getRoseId();
        if (quid != null && !quid.equals("")) {
            quid = quid.substring(1, quid.length() - 1);
        }
        if ((tableObj = (TableObject)this.roseUtil.quidTable.get(quid)) != null) {
            tableObj.setObject(eNamedElement);
        }
        if (parent instanceof EPackage) {
            ((EPackage)parent).getEClassifiers().add(eNamedElement);
        } else if (parent instanceof EList) {
            ((EList)parent).add(eNamedElement);
        }
    }

    protected String upperCaseName(String name) {
        return name != null && name.length() > 0 && Character.isLowerCase(name.charAt(0)) ? String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1) : name;
    }

    protected String validName(String name) {
        return CodeGenUtil.validJavaIdentifier(name);
    }

    protected void warning(String message) {
        System.err.println("-->Warning: " + message);
        this.roseUtil.addDiagnostic(new BasicDiagnostic(2, RoseImporterPlugin.getPlugin().getBundle().getSymbolicName(), 0, message, null));
    }

    protected void error(String message) {
        System.err.println("-->Error: " + message);
        this.roseUtil.addDiagnostic(new BasicDiagnostic(4, RoseImporterPlugin.getPlugin().getBundle().getSymbolicName(), 0, message, null));
    }

    protected String getQualifiedTypeName(ETypedElement typedElement, String type) {
        if (type == null || type.length() == 0 || "void".equals(type)) {
            return type;
        }
        String qualifiedType = type;
        if (qualifiedType.indexOf("::") != -1) {
            StringTokenizer st = new StringTokenizer(qualifiedType, "::");
            if (st.hasMoreTokens()) {
                st.nextToken();
            }
            StringBuffer stringBuffer = new StringBuffer();
            while (st.hasMoreTokens()) {
                stringBuffer.append(st.nextToken().replace('\"', ' ').replace('[', ' ').replace(']', ' ').trim());
                if (!st.hasMoreTokens()) continue;
                stringBuffer.append(".");
            }
            qualifiedType = stringBuffer.toString();
        }
        if (qualifiedType.indexOf(46) == -1) {
            String qualifier = "";
            EObject parent = typedElement.eContainer();
            while (parent != null) {
                if (parent instanceof EPackage) {
                    qualifier = String.valueOf(((EPackage)parent).getName()) + "." + qualifier;
                }
                parent = parent.eContainer();
            }
            qualifiedType = String.valueOf(qualifier) + qualifiedType;
        }
        if (!qualifiedType.equals(type) && !this.roseUtil.nameTable.containsKey(qualifiedType)) {
            qualifiedType = type;
        }
        return qualifiedType;
    }
}

