/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.merge.java;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.facade.FacadeVisitor;
import org.eclipse.emf.codegen.merge.java.facade.JCompilationUnit;
import org.eclipse.emf.codegen.merge.java.facade.JField;
import org.eclipse.emf.codegen.merge.java.facade.JImport;
import org.eclipse.emf.codegen.merge.java.facade.JInitializer;
import org.eclipse.emf.codegen.merge.java.facade.JMethod;
import org.eclipse.emf.codegen.merge.java.facade.JNode;
import org.eclipse.emf.codegen.merge.java.facade.JPackage;
import org.eclipse.emf.codegen.merge.java.facade.JType;

public class JPatternDictionary
extends FacadeVisitor {
    protected static final Pattern COMMENT = Pattern.compile("/\\*.*?\\*/", 40);
    protected static final Object[] NO_ARGUMENTS = new Object[0];
    protected JControlModel controlModel;
    protected JPackage jPackage;
    protected Map importMap;
    protected Map typeMap;
    protected Map initializerMap;
    protected Map fieldMap;
    protected Map methodMap;
    protected Map markupMap;
    protected Set noImportSet;

    public JPatternDictionary(JCompilationUnit compilationUnit, JControlModel controlModel) {
        this.controlModel = controlModel;
        this.start(compilationUnit);
    }

    public JPackage getJPackage() {
        return this.jPackage;
    }

    public Map getImportMap() {
        if (this.importMap == null) {
            this.importMap = new HashMap();
        }
        return this.importMap;
    }

    public Map getTypeMap() {
        if (this.typeMap == null) {
            this.typeMap = new HashMap();
        }
        return this.typeMap;
    }

    public Map getInitializerMap() {
        if (this.initializerMap == null) {
            this.initializerMap = new HashMap();
        }
        return this.initializerMap;
    }

    public Map getFieldMap() {
        if (this.fieldMap == null) {
            this.fieldMap = new HashMap();
        }
        return this.fieldMap;
    }

    public Map getMethodMap() {
        if (this.methodMap == null) {
            this.methodMap = new HashMap();
        }
        return this.methodMap;
    }

    public Map getMarkupMap() {
        if (this.markupMap == null) {
            this.markupMap = new HashMap();
        }
        return this.markupMap;
    }

    public boolean isMarkedUp(Pattern markupPattern, JNode node) {
        if (markupPattern == null) {
            return true;
        }
        Iterator markupEntries = this.getMarkupMap().entrySet().iterator();
        while (markupEntries.hasNext()) {
            Map.Entry markupEntry = markupEntries.next();
            String key = (String)markupEntry.getKey();
            if (key == null || !markupPattern.matcher(key).find() || !((Collection)markupEntry.getValue()).contains(node)) continue;
            return true;
        }
        return false;
    }

    protected Set getNoImporterSet() {
        if (this.noImportSet == null) {
            this.noImportSet = new HashSet();
        }
        return this.noImportSet;
    }

    public boolean isNoImport(JImport jImport) {
        return this.noImportSet != null && this.getNoImporterSet().contains(jImport.getQualifiedName());
    }

    protected boolean visit(JCompilationUnit compilationUnit) {
        if (this.controlModel.getNoImportPattern() != null) {
            Matcher matcher = this.controlModel.getNoImportPattern().matcher(compilationUnit.getContents());
            while (matcher.find()) {
                this.getNoImporterSet().add(matcher.group(1));
            }
        }
        return true;
    }

    protected boolean visit(JPackage jPackage) {
        this.jPackage = jPackage;
        return super.visit(jPackage);
    }

    protected boolean visit(JType type) {
        this.getTypeMap().put(type.getQualifiedName(), type);
        return true;
    }

    protected boolean visit(JImport jImport) {
        this.getImportMap().put(jImport.getQualifiedName(), jImport);
        return super.visit(jImport);
    }

    protected boolean visit(JInitializer initializer) {
        this.getInitializerMap().put(initializer.getQualifiedName(), initializer);
        return super.visit(initializer);
    }

    protected boolean visit(JField field) {
        this.getFieldMap().put(field.getQualifiedName(), field);
        return super.visit(field);
    }

    protected boolean visit(JMethod method) {
        this.getMethodMap().put(method.getQualifiedName(), method);
        return super.visit(method);
    }

    protected void afterVisit(JNode node) {
        Iterator dictionaryPatterns = this.controlModel.getDictionaryPatterns().iterator();
        while (dictionaryPatterns.hasNext()) {
            JControlModel.DictionaryPattern dictionaryPattern = (JControlModel.DictionaryPattern)dictionaryPatterns.next();
            if (!dictionaryPattern.getSelectorFeature().getFeatureClass().isInstance(node)) continue;
            try {
                Matcher matcher;
                String selection = (String)dictionaryPattern.getSelectorFeature().getFeatureMethod().invoke((Object)node, NO_ARGUMENTS);
                if (dictionaryPattern.getSelectorFeature().getFeatureMethod().getName().equals("getComment")) {
                    String contents = node.getContents();
                    int start = 0;
                    int end = contents.length();
                    int count = 0;
                    while (start < end) {
                        Matcher matcher2 = COMMENT.matcher(contents.subSequence(start, end));
                        if (!matcher2.find()) break;
                        if (++count > 1) {
                            int braceIndex = contents.indexOf("{", start);
                            if (braceIndex <= start + matcher2.start(0)) break;
                            selection = null;
                            break;
                        }
                        start += matcher2.end(0) + 1;
                    }
                }
                if (selection == null || !(matcher = dictionaryPattern.getPattern().matcher(selection)).find()) continue;
                int i = 1;
                while (i <= matcher.groupCount()) {
                    String markup = matcher.group(i);
                    HashSet<JNode> collection = (HashSet<JNode>)this.getMarkupMap().get(markup);
                    if (collection == null) {
                        collection = new HashSet<JNode>();
                        this.getMarkupMap().put(markup, collection);
                    }
                    collection.add(node);
                    ++i;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
    }
}

