/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.merge.java;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JPatternDictionary;
import org.eclipse.emf.codegen.merge.java.facade.JCompilationUnit;
import org.eclipse.emf.codegen.merge.java.facade.JField;
import org.eclipse.emf.codegen.merge.java.facade.JImport;
import org.eclipse.emf.codegen.merge.java.facade.JInitializer;
import org.eclipse.emf.codegen.merge.java.facade.JMember;
import org.eclipse.emf.codegen.merge.java.facade.JMethod;
import org.eclipse.emf.codegen.merge.java.facade.JNode;
import org.eclipse.emf.codegen.merge.java.facade.JPackage;
import org.eclipse.emf.codegen.merge.java.facade.JType;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;

public class JMerger {
    public static final String DEFAULT_FACADE_HELPER_CLASS;
    protected JCompilationUnit sourceCompilationUnit;
    protected JCompilationUnit targetCompilationUnit;
    protected JPatternDictionary sourcePatternDictionary;
    protected JPatternDictionary targetPatternDictionary;
    protected Map sourceToTargetMap = new HashMap();
    protected Map targetToSourceMap = new HashMap();
    protected Map orderedSourceChildrenMap = new HashMap();
    protected boolean isBlocked;
    protected boolean fixInterfaceBrace;
    protected JControlModel controlModel;
    protected static final Pattern INTERFACE_BRACE_PATTERN;
    protected static Object[] noArguments;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.codegen.merge.java.facade.jdom.JDOMFacadeHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DEFAULT_FACADE_HELPER_CLASS = clazz.getName();
        INTERFACE_BRACE_PATTERN = Pattern.compile("(?:\\n\\r|\\r\\n|\\n|\\r)(\\s*)(?:public|private|protected|static|\\s)*(?:interface|class)\\s*[^\\{\\n\\r]*(\\{)(\\n\\r|\\r\\n|\\n|\\r)", 8);
        noArguments = new Object[0];
    }

    public JMerger() {
    }

    public JMerger(JControlModel controlModel) {
        this();
        this.controlModel = controlModel;
    }

    public void merge() {
        this.pullTargetCompilationUnit();
        if (!this.isBlocked) {
            this.pushSourceCompilationUnit();
            this.sweepTargetCompilationUnit();
            this.sortTargetCompilationUnit();
        }
    }

    public void remerge() {
        this.sourceToTargetMap.clear();
        this.targetToSourceMap.clear();
        this.orderedSourceChildrenMap.clear();
        this.isBlocked = false;
        this.merge();
    }

    public boolean isFixInterfaceBrace() {
        return this.fixInterfaceBrace;
    }

    public void setFixInterfaceBrace(boolean fixInterfaceBrace) {
        this.fixInterfaceBrace = fixInterfaceBrace;
    }

    public String getSourceCompilationUnitContents() {
        return this.sourceCompilationUnit.getContents();
    }

    public JCompilationUnit getSourceCompilationUnit() {
        return this.sourceCompilationUnit;
    }

    public JControlModel getControlModel() {
        return this.controlModel;
    }

    public void setSourceCompilationUnit(JCompilationUnit sourceCompilationUnit) {
        this.sourceCompilationUnit = sourceCompilationUnit;
        this.sourcePatternDictionary = new JPatternDictionary(sourceCompilationUnit, this.getControlModel());
    }

    public String getTargetCompilationUnitContents() {
        String result = this.targetCompilationUnit.getContents();
        if (this.fixInterfaceBrace) {
            Matcher matcher = INTERFACE_BRACE_PATTERN.matcher(result);
            int offset = 0;
            while (matcher.find()) {
                if (this.getControlModel().standardBraceStyle) {
                    if (result.charAt(matcher.start(2) - 1) == ' ') continue;
                    result = String.valueOf(result.substring(0, offset + matcher.start(2))) + " {" + result.substring(offset + matcher.end(2), result.length());
                    ++offset;
                    continue;
                }
                result = String.valueOf(result.substring(0, offset + matcher.start(2))) + matcher.group(3) + matcher.group(1) + "{" + result.substring(offset + matcher.end(2), result.length());
                offset += matcher.group(1).length() + matcher.group(3).length();
            }
        }
        return result;
    }

    public JCompilationUnit getTargetCompilationUnit() {
        return this.targetCompilationUnit;
    }

    public void setTargetCompilationUnit(JCompilationUnit targetCompilationUnit) {
        this.targetCompilationUnit = targetCompilationUnit;
        this.targetPatternDictionary = new JPatternDictionary(targetCompilationUnit, this.getControlModel());
    }

    public JPatternDictionary getSourcePatternDictionary() {
        return this.sourcePatternDictionary;
    }

    public void setSourcePatternDictionary(JPatternDictionary sourcePatternDictionary) {
        this.sourcePatternDictionary = sourcePatternDictionary;
    }

    public JPatternDictionary getTargetPatternDictionary() {
        return this.targetPatternDictionary;
    }

    public void setTargetPatternDictionary(JPatternDictionary targetPatternDictionary) {
        this.targetPatternDictionary = targetPatternDictionary;
    }

    public Map getSourceToTargetMap() {
        return this.sourceToTargetMap;
    }

    public void setSourceToTargetMap(Map sourceToTargetMap) {
        this.sourceToTargetMap = sourceToTargetMap;
    }

    public JCompilationUnit createCompilationUnitForURI(String uri) {
        return this.createCompilationUnitForURI(uri, null);
    }

    public JCompilationUnit createCompilationUnitForURI(String uri, String encoding) {
        try {
            URL url = null;
            try {
                url = new URL(uri);
            }
            catch (MalformedURLException malformedURLException) {
                url = new URL("file:" + uri);
            }
            if (url != null) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(url.openStream());
                byte[] input = new byte[bufferedInputStream.available()];
                bufferedInputStream.read(input);
                bufferedInputStream.close();
                return this.getControlModel().getFacadeHelper().createCompilationUnit(url.toString(), encoding == null ? new String(input) : new String(input, encoding));
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    public JCompilationUnit createCompilationUnitForInputStream(InputStream inputStream) {
        return this.createCompilationUnitForInputStream(inputStream, null);
    }

    public JCompilationUnit createCompilationUnitForInputStream(InputStream inputStream, String encoding) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] input = new byte[bufferedInputStream.available()];
            bufferedInputStream.read(input);
            bufferedInputStream.close();
            return this.getControlModel().getFacadeHelper().createCompilationUnit("NAME", encoding == null ? new String(input) : new String(input, encoding));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public JCompilationUnit createCompilationUnitForContents(String contents) {
        return this.getControlModel().getFacadeHelper().createCompilationUnit("NAME", contents);
    }

    protected void pullTargetCompilationUnit() {
        if (this.targetCompilationUnit == null) {
            this.setTargetCompilationUnit((JCompilationUnit)this.insertClone(this.sourceCompilationUnit));
        } else {
            this.map(this.sourceCompilationUnit, this.targetCompilationUnit);
            this.applyPullRules(this.sourceCompilationUnit, this.targetCompilationUnit);
            Iterator i = this.targetCompilationUnit.getChildren().iterator();
            while (i.hasNext()) {
                JNode child = (JNode)i.next();
                if (child instanceof JPackage) {
                    this.pullTargetPackage((JPackage)child);
                    continue;
                }
                if (child instanceof JImport) {
                    this.pullTargetImport((JImport)child);
                    continue;
                }
                if (!(child instanceof JType)) continue;
                JType type = (JType)child;
                boolean bl = this.isBlocked = this.getControlModel().getBlockPattern() != null && type.getComment() != null && this.getControlModel().getBlockPattern().matcher(type.getComment()).find();
                if (this.isBlocked) continue;
                this.pullTargetType(type);
            }
        }
    }

    protected void pullTargetPackage(JPackage targetPackage) {
        JPackage sourcePackage = this.sourcePatternDictionary.getJPackage();
        this.map(sourcePackage, targetPackage);
        this.applyPullRules(sourcePackage, targetPackage);
    }

    protected void pullTargetImport(JImport targetImport) {
        JImport sourceImport = (JImport)this.sourcePatternDictionary.getImportMap().get(targetImport.getQualifiedName());
        this.map(sourceImport, targetImport);
        if (sourceImport != null) {
            this.applyPullRules(sourceImport, targetImport);
        }
    }

    protected void pullTargetType(JType targetType) {
        JType sourceType = (JType)this.sourcePatternDictionary.getTypeMap().get(targetType.getQualifiedName());
        this.map(sourceType, targetType);
        if (sourceType != null) {
            this.applyPullRules(sourceType, targetType);
        }
        Iterator i = targetType.getChildren().iterator();
        while (i.hasNext()) {
            JNode child = (JNode)i.next();
            if (child instanceof JInitializer) {
                this.pullTargetInitializer((JInitializer)child);
                continue;
            }
            if (child instanceof JField) {
                this.pullTargetField((JField)child);
                continue;
            }
            if (child instanceof JMethod) {
                this.pullTargetMethod((JMethod)child);
                continue;
            }
            if (!(child instanceof JType)) continue;
            this.pullTargetType((JType)child);
        }
    }

    protected void pullTargetInitializer(JInitializer targetInitializer) {
        JInitializer sourceInitializer = (JInitializer)this.sourcePatternDictionary.getInitializerMap().get(targetInitializer.getQualifiedName());
        this.map(sourceInitializer, targetInitializer);
        if (sourceInitializer != null) {
            this.applyPullRules(sourceInitializer, targetInitializer);
        }
    }

    protected void pullTargetField(JField targetField) {
        JField sourceField = (JField)this.sourcePatternDictionary.getFieldMap().get(targetField.getQualifiedName());
        this.map(sourceField, targetField);
        if (sourceField != null) {
            this.applyPullRules(sourceField, targetField);
        }
    }

    protected void pullTargetMethod(JMethod targetMethod) {
        String qualifiedTargetMethodName = targetMethod.getQualifiedName();
        JMethod sourceMethod = (JMethod)this.sourcePatternDictionary.getMethodMap().get(qualifiedTargetMethodName);
        if (sourceMethod == null && this.getControlModel().getRedirect() != null && targetMethod.getName() != null && targetMethod.getName().endsWith(this.getControlModel().getRedirect())) {
            int index = qualifiedTargetMethodName.indexOf("(");
            qualifiedTargetMethodName = String.valueOf(qualifiedTargetMethodName.substring(0, index - this.getControlModel().getRedirect().length())) + qualifiedTargetMethodName.substring(index);
            sourceMethod = (JMethod)this.sourcePatternDictionary.getMethodMap().get(qualifiedTargetMethodName);
        }
        this.map(sourceMethod, targetMethod);
        if (sourceMethod != null) {
            this.applyPullRules(sourceMethod, targetMethod);
        }
    }

    protected void applyPullRules(JNode sourceNode, JNode targetNode) {
        try {
            Iterator pullRules = this.getControlModel().getPullRules().iterator();
            while (pullRules.hasNext()) {
                JControlModel.PullRule pullRule = (JControlModel.PullRule)pullRules.next();
                if (!this.sourcePatternDictionary.isMarkedUp(pullRule.getSourceMarkup(), sourceNode) || !this.targetPatternDictionary.isMarkedUp(pullRule.getTargetMarkup(), targetNode) || !pullRule.getSourceGetFeature().getFeatureClass().isInstance(sourceNode) || !pullRule.getTargetPutFeature().getFeatureClass().isInstance(targetNode)) continue;
                if (pullRule.getEqualityFeature() != null) {
                    Method equalityFeatureMethod = pullRule.getEqualityFeature().getFeatureMethod();
                    Object value1 = equalityFeatureMethod.invoke((Object)sourceNode, noArguments);
                    Object value2 = equalityFeatureMethod.invoke((Object)targetNode, noArguments);
                    if (value1 == null ? value2 != null : !value1.equals(value2)) continue;
                }
                Method sourceGetMethod = pullRule.getSourceGetFeature().getFeatureMethod();
                Object value = sourceGetMethod.invoke((Object)sourceNode, noArguments);
                Method targetPutMethod = pullRule.getTargetPutFeature().getFeatureMethod();
                if (!sourceGetMethod.getReturnType().isArray() || targetPutMethod.getParameterTypes()[0].isAssignableFrom(sourceGetMethod.getReturnType())) {
                    if (value instanceof String) {
                        String oldStringValue;
                        String stringValue = (String)value;
                        stringValue = this.getControlModel().getFacadeHelper().applyFormatRules(stringValue);
                        Pattern sourceTransfer = pullRule.getSourceTransfer();
                        if (sourceTransfer != null && (oldStringValue = (String)sourceGetMethod.invoke((Object)targetNode, noArguments)) != null) {
                            Matcher sourceMatcher = sourceTransfer.matcher(stringValue);
                            Matcher targetMatcher = sourceTransfer.matcher(oldStringValue);
                            if (sourceMatcher.groupCount() >= 1 && targetMatcher.groupCount() >= 1) {
                                StringBuffer result = new StringBuffer();
                                int index = 0;
                                while (sourceMatcher.find() && targetMatcher.find()) {
                                    result.append(stringValue.substring(index, sourceMatcher.start(1)));
                                    result.append(targetMatcher.group(1));
                                    index = sourceMatcher.end(1);
                                }
                                if (result.length() == 0) {
                                    stringValue = null;
                                } else {
                                    result.append(stringValue.substring(index));
                                    stringValue = result.toString();
                                }
                            } else {
                                stringValue = null;
                            }
                        }
                        value = stringValue;
                    }
                    if (value == null && !targetPutMethod.getName().equals("setInitializer") && !targetPutMethod.getName().equals("setSuperclass") && !targetPutMethod.getName().equals("setExceptions")) continue;
                    Object oldValue = sourceGetMethod.invoke((Object)targetNode, noArguments);
                    if (value != null ? value.equals(oldValue) : oldValue == null) continue;
                    if (targetPutMethod.getName().equals("setSuperclass") && oldValue != null && value != null && ((String)oldValue).trim().equals(((String)value).trim()) || sourceGetMethod.getName().equals("getReturnType") && this.getControlModel().getBlockPattern() != null && ((JMethod)targetNode).getComment() != null && this.getControlModel().getBlockPattern().matcher(((JMethod)targetNode).getComment()).find()) continue;
                    targetPutMethod.invoke((Object)targetNode, value);
                    if (!targetPutMethod.getName().equals("setBody") || !(sourceNode instanceof JMethod)) continue;
                    JMethod sourceMethod = (JMethod)sourceNode;
                    JMethod targetMethod = (JMethod)targetNode;
                    String[] sourceParameterNames = sourceMethod.getParameterNames();
                    String[] targetParameterTypes = targetMethod.getParameterTypes();
                    targetMethod.setParameters(targetParameterTypes, sourceParameterNames);
                    continue;
                }
                ArrayList<String> additionalStrings = new ArrayList<String>();
                String[] sourceStrings = (String[])value;
                if (sourceStrings != null) {
                    additionalStrings.addAll(Arrays.asList(sourceStrings));
                }
                if (targetPutMethod.getName().equals("addSuperInterface")) {
                    Pattern sourceTransfer = pullRule.getSourceTransfer();
                    if (sourceTransfer != null) {
                        String comment = ((JMember)targetNode).getComment();
                        Matcher matcher = sourceTransfer.matcher(comment);
                        while (matcher.find() && matcher.groupCount() >= 1) {
                            String clientStrings = comment.substring(matcher.start(matcher.groupCount()), matcher.end(matcher.groupCount()));
                            StringTokenizer stringTokenizer = new StringTokenizer(clientStrings, ", \t\n\r\f");
                            while (stringTokenizer.hasMoreTokens()) {
                                String token = stringTokenizer.nextToken();
                                if (additionalStrings.contains(token)) continue;
                                additionalStrings.add(token);
                            }
                        }
                    }
                    JType type = (JType)targetNode;
                    Object[] superInterfaces = additionalStrings.toArray(new String[additionalStrings.size()]);
                    if (!(type.getSuperInterfaces() == null ? superInterfaces.length != 0 : !Arrays.equals(type.getSuperInterfaces(), superInterfaces))) continue;
                    type.setSuperInterfaces(additionalStrings.toArray(new String[additionalStrings.size()]));
                    continue;
                }
                String[] oldStringValues = (String[])sourceGetMethod.invoke((Object)targetNode, noArguments);
                List<String> old = oldStringValues == null ? Collections.EMPTY_LIST : Arrays.asList(oldStringValues);
                Iterator i = additionalStrings.iterator();
                while (i.hasNext()) {
                    String string = (String)i.next();
                    if (old.contains(string)) continue;
                    targetPutMethod.invoke((Object)targetNode, string);
                }
            }
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
    }

    protected void pushSourceCompilationUnit() {
        Iterator i = this.sourceCompilationUnit.getChildren().iterator();
        while (i.hasNext()) {
            JNode child = (JNode)i.next();
            if (child instanceof JPackage) {
                this.pushSourcePackage((JPackage)child);
                continue;
            }
            if (child instanceof JImport) {
                this.pushSourceImport((JImport)child);
                continue;
            }
            if (!(child instanceof JType)) continue;
            this.pushSourceType((JType)child);
        }
    }

    protected void pushSourcePackage(JPackage sourcePackage) {
        if (!this.sourceToTargetMap.containsKey(sourcePackage)) {
            this.insertClone(sourcePackage);
        }
    }

    protected void pushSourceImport(JImport sourceImport) {
        if (!this.sourceToTargetMap.containsKey(sourceImport) && !this.targetPatternDictionary.isNoImport(sourceImport)) {
            this.insertClone(sourceImport);
        }
    }

    protected void pushSourceType(JType sourceType) {
        if (!this.sourceToTargetMap.containsKey(sourceType)) {
            this.insertClone(sourceType);
        } else {
            Iterator i = sourceType.getChildren().iterator();
            while (i.hasNext()) {
                JNode child = (JNode)i.next();
                if (child instanceof JInitializer) {
                    this.pushSourceInitializer((JInitializer)child);
                    continue;
                }
                if (child instanceof JField) {
                    this.pushSourceField((JField)child);
                    continue;
                }
                if (child instanceof JMethod) {
                    this.pushSourceMethod((JMethod)child);
                    continue;
                }
                if (!(child instanceof JType)) continue;
                this.pushSourceType((JType)child);
            }
        }
    }

    protected void pushSourceInitializer(JInitializer sourceInitializer) {
        if (!this.sourceToTargetMap.containsKey(sourceInitializer)) {
            this.insertClone(sourceInitializer);
        }
    }

    protected void pushSourceField(JField sourceField) {
        this.applySortRules(sourceField);
        if (!this.sourceToTargetMap.containsKey(sourceField)) {
            this.insertClone(sourceField);
        }
    }

    protected void pushSourceMethod(JMethod sourceMethod) {
        if (!this.sourceToTargetMap.containsKey(sourceMethod)) {
            this.insertClone(sourceMethod);
        }
    }

    public void applySortRules(JNode sourceNode) {
        Iterator sortRules = this.getControlModel().getSortRules().iterator();
        while (sortRules.hasNext()) {
            JControlModel.SortRule sortRule = (JControlModel.SortRule)sortRules.next();
            if (!this.sourcePatternDictionary.isMarkedUp(sortRule.getMarkup(), sourceNode) || !sortRule.getSelector().isInstance(sourceNode)) continue;
            JNode parent = sourceNode.getParent();
            ArrayList<JNode> children = (ArrayList<JNode>)this.orderedSourceChildrenMap.get(parent);
            if (children == null) {
                children = new ArrayList<JNode>();
                this.orderedSourceChildrenMap.put(parent, children);
            }
            children.add(sourceNode);
            break;
        }
    }

    protected void sweepTargetCompilationUnit() {
        Iterator entries = this.targetToSourceMap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            if (entry.getValue() != null) continue;
            this.applySweepRules((JNode)entry.getKey());
        }
    }

    protected void applySweepRules(JNode targetNode) {
        Iterator sweepRules = this.getControlModel().getSweepRules().iterator();
        while (sweepRules.hasNext()) {
            JControlModel.SweepRule sweepRule = (JControlModel.SweepRule)sweepRules.next();
            Class clazz = sweepRule.getSelector();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.emf.codegen.merge.java.facade.JImport");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz2 && targetNode instanceof JImport) {
                if (!sweepRule.getMarkup().matcher(targetNode.getName()).find()) continue;
                this.getControlModel().getFacadeHelper().remove(targetNode);
                break;
            }
            if (!this.targetPatternDictionary.isMarkedUp(sweepRule.getMarkup(), targetNode) || !sweepRule.getSelector().isInstance(targetNode)) continue;
            this.getControlModel().getFacadeHelper().remove(targetNode);
            break;
        }
    }

    protected void sortTargetCompilationUnit() {
        Iterator values = this.orderedSourceChildrenMap.values().iterator();
        while (values.hasNext()) {
            List children = (List)values.next();
            if (children.size() <= 2) continue;
            Iterator i = children.iterator();
            JNode sourceNode = (JNode)i.next();
            JNode previousTargetNode = (JNode)this.sourceToTargetMap.get(sourceNode);
            do {
                sourceNode = (JNode)i.next();
                JNode nextTargetNode = (JNode)this.sourceToTargetMap.get(sourceNode);
                boolean reorder = true;
                JNode domNode = this.getControlModel().getFacadeHelper().getPrevious(nextTargetNode);
                while (domNode != null) {
                    if (domNode == previousTargetNode) {
                        reorder = false;
                        break;
                    }
                    domNode = this.getControlModel().getFacadeHelper().getPrevious(domNode);
                }
                if (reorder) {
                    this.getControlModel().getFacadeHelper().remove(nextTargetNode);
                    if (this.getControlModel().getFacadeHelper().getNext(previousTargetNode) == null) {
                        this.getControlModel().getFacadeHelper().addChild(previousTargetNode.getParent(), nextTargetNode);
                    } else {
                        this.getControlModel().getFacadeHelper().insertSibling(previousTargetNode, nextTargetNode, false);
                    }
                }
                previousTargetNode = nextTargetNode;
            } while (i.hasNext());
        }
    }

    protected JNode insertClone(JNode sourceNode) {
        Object context = this.targetCompilationUnit != null ? this.getControlModel().getFacadeHelper().getContext(this.targetCompilationUnit) : null;
        JNode targetNode = this.getControlModel().getFacadeHelper().cloneNode(context, sourceNode);
        if (targetNode != null) {
            this.map(sourceNode, targetNode);
            this.mapChildren(sourceNode, targetNode);
        }
        JNode previousNode = this.getControlModel().getFacadeHelper().getPrevious(sourceNode);
        while (previousNode != null) {
            JNode targetSibling = (JNode)this.sourceToTargetMap.get(previousNode);
            if (targetSibling != null) {
                JNode targetNextSibling = this.getControlModel().getFacadeHelper().getNext(targetSibling);
                if (targetNextSibling == null) {
                    this.getControlModel().getFacadeHelper().addChild(targetSibling.getParent(), targetNode);
                } else {
                    this.getControlModel().getFacadeHelper().insertSibling(targetNextSibling, targetNode, true);
                }
                return targetNode;
            }
            previousNode = this.getControlModel().getFacadeHelper().getPrevious(previousNode);
        }
        JNode sourceParent = sourceNode.getParent();
        if (sourceParent != null) {
            JNode targetParent = (JNode)this.sourceToTargetMap.get(sourceParent);
            JNode targetSibling = this.getControlModel().getFacadeHelper().getFirstChild(targetParent);
            if (targetSibling == null) {
                this.getControlModel().getFacadeHelper().addChild(targetParent, targetNode);
            } else {
                this.getControlModel().getFacadeHelper().insertSibling(targetSibling, targetNode, true);
            }
        }
        return targetNode;
    }

    protected void mapChildren(JNode sourceNode, JNode targetNode) {
        this.map(sourceNode, targetNode);
        JNode sourceChild = this.getControlModel().getFacadeHelper().getFirstChild(sourceNode);
        JNode targetChild = this.getControlModel().getFacadeHelper().getFirstChild(targetNode);
        while (sourceChild != null) {
            this.mapChildren(sourceChild, targetChild);
            sourceChild = this.getControlModel().getFacadeHelper().getNext(sourceChild);
            targetChild = this.getControlModel().getFacadeHelper().getNext(targetChild);
        }
    }

    protected void map(JNode sourceNode, JNode targetNode) {
        if (sourceNode != null) {
            this.sourceToTargetMap.put(sourceNode, targetNode);
        }
        this.targetToSourceMap.put(targetNode, sourceNode);
    }

    public Object run(Object object) {
        try {
            String contents = this.execute(new BasicMonitor(), (String[])object);
            System.out.println("**********************************************");
            System.out.println(contents);
            return new Integer(0);
        }
        catch (Exception exception) {
            return new Integer(1);
        }
    }

    public String execute(Monitor monitor, String[] arguments) {
        String mergeXML = arguments[0];
        String sourceURI = arguments[1];
        String targetURI = arguments[2];
        String facadeHelperClass = arguments.length > 3 ? arguments[3] : DEFAULT_FACADE_HELPER_CLASS;
        this.controlModel = new JControlModel();
        this.controlModel.initialize(CodeGenUtil.instantiateFacadeHelper(facadeHelperClass), mergeXML);
        this.sourceCompilationUnit = this.createCompilationUnitForURI(sourceURI);
        this.targetCompilationUnit = this.createCompilationUnitForURI(targetURI);
        this.sourcePatternDictionary = new JPatternDictionary(this.sourceCompilationUnit, this.getControlModel());
        this.targetPatternDictionary = new JPatternDictionary(this.targetCompilationUnit, this.getControlModel());
        this.merge();
        return this.targetCompilationUnit.getContents();
    }
}

