/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.taglib;

import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.component.UIParameter;
import javax.faces.component.UISelectBoolean;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.ActionEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.webapp.UIComponentTag;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_impl.el.SimpleActionMethodBinding;

public class UIComponentTagUtils {
    private static final Log log = LogFactory.getLog(UIComponentTagUtils.class);
    private static final Class[] VALIDATOR_ARGS = new Class[]{FacesContext.class, UIComponent.class, Object.class};
    private static final Class[] ACTION_LISTENER_ARGS = new Class[]{ActionEvent.class};
    private static final Class[] VALUE_LISTENER_ARGS = new Class[]{ValueChangeEvent.class};

    private UIComponentTagUtils() {
    }

    public static boolean isValueReference(String v) {
        return UIComponentTag.isValueReference(v);
    }

    public static void setIntegerProperty(FacesContext context, UIComponent component2, String propName, String value) {
        if (value != null) {
            if (UIComponentTagUtils.isValueReference(value)) {
                ValueBinding vb = context.getApplication().createValueBinding(value);
                component2.setValueBinding(propName, vb);
            } else {
                component2.getAttributes().put(propName, Integer.valueOf(value));
            }
        }
    }

    public static void setLongProperty(FacesContext context, UIComponent component2, String propName, String value) {
        if (value != null) {
            if (UIComponentTagUtils.isValueReference(value)) {
                ValueBinding vb = context.getApplication().createValueBinding(value);
                component2.setValueBinding(propName, vb);
            } else {
                component2.getAttributes().put(propName, Long.valueOf(value));
            }
        }
    }

    public static void setStringProperty(FacesContext context, UIComponent component2, String propName, String value) {
        if (value != null) {
            if (UIComponentTagUtils.isValueReference(value)) {
                ValueBinding vb = context.getApplication().createValueBinding(value);
                component2.setValueBinding(propName, vb);
            } else {
                component2.getAttributes().put(propName, value);
            }
        }
    }

    public static void setBooleanProperty(FacesContext context, UIComponent component2, String propName, String value) {
        if (value != null) {
            if (UIComponentTagUtils.isValueReference(value)) {
                ValueBinding vb = context.getApplication().createValueBinding(value);
                component2.setValueBinding(propName, vb);
            } else {
                component2.getAttributes().put(propName, Boolean.valueOf(value));
            }
        }
    }

    public static void setValueProperty(FacesContext context, UIComponent component2, String value) {
        if (value != null) {
            if (UIComponentTagUtils.isValueReference(value)) {
                ValueBinding vb = context.getApplication().createValueBinding(value);
                component2.setValueBinding("value", vb);
            } else if (component2 instanceof UICommand) {
                ((UICommand)component2).setValue(value);
            } else if (component2 instanceof UIParameter) {
                ((UIParameter)component2).setValue(value);
            } else if (component2 instanceof UISelectBoolean) {
                ((UISelectBoolean)component2).setValue(Boolean.valueOf(value));
            } else if (component2 instanceof UIGraphic) {
                ((UIGraphic)component2).setValue(value);
            } else if (component2 instanceof ValueHolder) {
                ((ValueHolder)((Object)component2)).setValue(value);
            } else {
                log.error((Object)("Component " + component2.getClass().getName() + " is no ValueHolder, cannot set value."));
            }
        }
    }

    public static void setConverterProperty(FacesContext context, UIComponent component2, String value) {
        if (value != null) {
            if (component2 instanceof ValueHolder) {
                if (UIComponentTagUtils.isValueReference(value)) {
                    ValueBinding vb = context.getApplication().createValueBinding(value);
                    component2.setValueBinding("converter", vb);
                } else {
                    FacesContext facesContext = FacesContext.getCurrentInstance();
                    Converter converter = facesContext.getApplication().createConverter(value);
                    ((ValueHolder)((Object)component2)).setConverter(converter);
                }
            } else {
                log.error((Object)("Component " + component2.getClass().getName() + " is no ValueHolder, cannot set value."));
            }
        }
    }

    public static void setValidatorProperty(FacesContext context, UIComponent component2, String validator) {
        if (validator != null) {
            if (!(component2 instanceof EditableValueHolder)) {
                throw new IllegalArgumentException("Component " + component2.getClientId(context) + " is no EditableValueHolder");
            }
            if (UIComponentTagUtils.isValueReference(validator)) {
                MethodBinding mb = context.getApplication().createMethodBinding(validator, VALIDATOR_ARGS);
                ((EditableValueHolder)((Object)component2)).setValidator(mb);
            } else {
                log.error((Object)("Component " + component2.getClientId(context) + " has invalid validation expression " + validator));
            }
        }
    }

    public static void setValueBinding(FacesContext context, UIComponent component2, String propName, String value) {
        if (value != null) {
            if (UIComponentTagUtils.isValueReference(value)) {
                ValueBinding vb = context.getApplication().createValueBinding(value);
                component2.setValueBinding(propName, vb);
            } else {
                throw new IllegalArgumentException("Component " + component2.getClientId(context) + " attribute " + propName + " must be a value reference, was " + value);
            }
        }
    }

    public static void setActionProperty(FacesContext context, UIComponent component2, String action) {
        if (action != null) {
            if (!(component2 instanceof ActionSource)) {
                throw new IllegalArgumentException("Component " + component2.getClientId(context) + " is no ActionSource");
            }
            MethodBinding mb = UIComponentTagUtils.isValueReference(action) ? context.getApplication().createMethodBinding(action, null) : new SimpleActionMethodBinding(action);
            ((ActionSource)((Object)component2)).setAction(mb);
        }
    }

    public static void setActionListenerProperty(FacesContext context, UIComponent component2, String actionListener) {
        if (actionListener != null) {
            if (!(component2 instanceof ActionSource)) {
                throw new IllegalArgumentException("Component " + component2.getClientId(context) + " is no ActionSource");
            }
            if (UIComponentTagUtils.isValueReference(actionListener)) {
                MethodBinding mb = context.getApplication().createMethodBinding(actionListener, ACTION_LISTENER_ARGS);
                ((ActionSource)((Object)component2)).setActionListener(mb);
            } else {
                log.error((Object)("Component " + component2.getClientId(context) + " has invalid actionListener value: " + actionListener));
            }
        }
    }

    public static void setValueChangedListenerProperty(FacesContext context, UIComponent component2, String valueChangedListener) {
        if (valueChangedListener != null) {
            if (!(component2 instanceof EditableValueHolder)) {
                throw new IllegalArgumentException("Component " + component2.getClientId(context) + " is no EditableValueHolder");
            }
            if (UIComponentTagUtils.isValueReference(valueChangedListener)) {
                MethodBinding mb = context.getApplication().createMethodBinding(valueChangedListener, VALUE_LISTENER_ARGS);
                ((EditableValueHolder)((Object)component2)).setValueChangeListener(mb);
            } else {
                log.error((Object)("Component " + component2.getClientId(context) + " has invalid valueChangedListener expression " + valueChangedListener));
            }
        }
    }
}

