/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.taglib;

import java.io.IOException;
import java.io.Reader;
import javax.faces.component.UIComponent;
import javax.faces.webapp.UIComponentBodyTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_impl.renderkit.RendererUtils;
import org.apache.myfaces.shared_impl.taglib.UIComponentTagUtils;

public abstract class UIComponentBodyTagBase
extends UIComponentBodyTag {
    private static final Log log = LogFactory.getLog(UIComponentBodyTagBase.class);
    private String _forceId;
    private String _forceIdIndex = "true";
    private String _value;
    private String _converter;

    public int doEndTag() throws JspException {
        UIComponent component2;
        if (log.isWarnEnabled() && (component2 = this.getComponentInstance()) != null && component2.getRendersChildren() && !this.isBodyContentEmpty()) {
            log.warn((Object)("Component with id '" + component2.getClientId(this.getFacesContext()) + "' (" + this.getClass().getName() + " tag) and path : " + RendererUtils.getPathToComponent(component2) + "renders it's children, but has embedded JSP or HTML code. Use the <f:verbatim> tag for nested HTML. For comments use <%/* */%> style JSP comments instead of <!-- --> style HTML comments." + "\n BodyContent:\n" + this.getBodyContent().getString().trim()));
        }
        return super.doEndTag();
    }

    private boolean isBodyContentEmpty() {
        BodyContent bodyContent = this.getBodyContent();
        if (bodyContent == null) {
            return true;
        }
        try {
            int c;
            Reader reader = bodyContent.getReader();
            while ((c = reader.read()) != -1) {
                if (Character.isWhitespace((char)c)) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            log.error((Object)"Error inspecting BodyContent", (Throwable)e);
            return false;
        }
    }

    protected void setProperties(UIComponent component2) {
        super.setProperties(component2);
        this.setBooleanProperty(component2, "forceId", this._forceId);
        this.setBooleanProperty(component2, "forceIdIndex", this._forceIdIndex);
        this.setValueProperty(component2, this._value);
        this.setConverterProperty(component2, this._converter);
    }

    public void setForceId(String aForceId) {
        this._forceId = aForceId;
    }

    public void setForceIdIndex(String aForceIdIndex) {
        this._forceIdIndex = aForceIdIndex;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public void setConverter(String converter) {
        this._converter = converter;
    }

    protected void setIntegerProperty(UIComponent component2, String propName, String value) {
        UIComponentTagUtils.setIntegerProperty(this.getFacesContext(), component2, propName, value);
    }

    protected void setStringProperty(UIComponent component2, String propName, String value) {
        UIComponentTagUtils.setStringProperty(this.getFacesContext(), component2, propName, value);
    }

    protected void setBooleanProperty(UIComponent component2, String propName, String value) {
        UIComponentTagUtils.setBooleanProperty(this.getFacesContext(), component2, propName, value);
    }

    protected void setValueProperty(UIComponent component2, String value) {
        UIComponentTagUtils.setValueProperty(this.getFacesContext(), component2, value);
    }

    private void setConverterProperty(UIComponent component2, String value) {
        UIComponentTagUtils.setConverterProperty(this.getFacesContext(), component2, value);
    }

    protected void setValidatorProperty(UIComponent component2, String value) {
        UIComponentTagUtils.setValidatorProperty(this.getFacesContext(), component2, value);
    }

    protected void setActionProperty(UIComponent component2, String action) {
        UIComponentTagUtils.setActionProperty(this.getFacesContext(), component2, action);
    }

    protected void setActionListenerProperty(UIComponent component2, String actionListener) {
        UIComponentTagUtils.setActionListenerProperty(this.getFacesContext(), component2, actionListener);
    }

    protected void setValueChangedListenerProperty(UIComponent component2, String valueChangedListener) {
        UIComponentTagUtils.setValueChangedListenerProperty(this.getFacesContext(), component2, valueChangedListener);
    }

    protected void setValueBinding(UIComponent component2, String propName, String value) {
        UIComponentTagUtils.setValueBinding(this.getFacesContext(), component2, propName, value);
    }
}

